/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.array;

import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.array.UnnestFunction;
import org.hibernate.dialect.function.json.DB2JsonTableFunction;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.SqlTypedMapping;
import org.hibernate.query.derived.AnonymousTupleTableGroupProducer;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.function.SelfRenderingSqmSetReturningFunction;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.type.BasicPluralType;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;

public class DB2UnnestFunction
extends UnnestFunction {
    private final int maximumArraySize;

    public DB2UnnestFunction(int maximumArraySize) {
        super("v", "i");
        this.maximumArraySize = maximumArraySize;
    }

    @Override
    protected <T> SelfRenderingSqmSetReturningFunction<T> generateSqmSetReturningFunctionExpression(List<? extends SqmTypedNode<?>> arguments, QueryEngine queryEngine) {
        return new SelfRenderingSqmSetReturningFunction<T>(this, this, arguments, this.getArgumentsValidator(), this.getSetReturningTypeResolver(), queryEngine.getCriteriaBuilder(), this.getName()){

            @Override
            public TableGroup convertToSqlAst(NavigablePath navigablePath, String identifierVariable, boolean lateral, boolean canUseInnerJoins, boolean withOrdinality, SqmToSqlAstConverter walker) {
                walker.registerQueryTransformer(new DB2JsonTableFunction.SeriesQueryTransformer(DB2UnnestFunction.this.maximumArraySize));
                return super.convertToSqlAst(navigablePath, identifierVariable, lateral, canUseInnerJoins, withOrdinality, walker);
            }
        };
    }

    @Override
    protected void renderJsonTable(SqlAppender sqlAppender, Expression array, BasicPluralType<?, ?> pluralType, @Nullable SqlTypedMapping sqlTypedMapping, AnonymousTupleTableGroupProducer tupleType, String tableIdentifierVariable, SqlAstTranslator<?> walker) {
        sqlAppender.appendSql("lateral(select ");
        ModelPart elementPart = tupleType.findSubPart(CollectionPart.Nature.ELEMENT.getName(), null);
        if (elementPart == null) {
            sqlAppender.append("t.*");
        } else {
            BasicValuedModelPart elementMapping = elementPart.asBasicValuedModelPart();
            boolean isBoolean = elementMapping.getSingleJdbcMapping().getJdbcType().isBoolean();
            if (isBoolean) {
                sqlAppender.appendSql("decode(");
            }
            sqlAppender.appendSql("json_value('{\"a\":'||");
            array.accept(walker);
            sqlAppender.appendSql("||'}','$.a['||(i.i-1)||']'");
            if (isBoolean) {
                sqlAppender.appendSql(')');
                JdbcMapping type = elementMapping.getSingleJdbcMapping();
                JdbcLiteralFormatter jdbcLiteralFormatter = type.getJdbcLiteralFormatter();
                SessionFactoryImplementor sessionFactory = walker.getSessionFactory();
                Dialect dialect = sessionFactory.getJdbcServices().getDialect();
                WrapperOptions wrapperOptions = sessionFactory.getWrapperOptions();
                Object trueValue = type.convertToRelationalValue(true);
                Object falseValue = type.convertToRelationalValue(false);
                sqlAppender.append(",'true',");
                jdbcLiteralFormatter.appendJdbcLiteral(sqlAppender, trueValue, dialect, wrapperOptions);
                sqlAppender.append(",'false',");
                jdbcLiteralFormatter.appendJdbcLiteral(sqlAppender, falseValue, dialect, wrapperOptions);
                sqlAppender.append(") ");
            } else {
                sqlAppender.appendSql(" returning ");
                sqlAppender.append(this.getDdlType(elementMapping, 3018, walker));
                sqlAppender.append(") ");
            }
            sqlAppender.append(elementMapping.getSelectionExpression());
        }
        ModelPart indexPart = tupleType.findSubPart(CollectionPart.Nature.INDEX.getName(), null);
        if (indexPart != null) {
            sqlAppender.appendSql(",i.i ");
            sqlAppender.append(indexPart.asBasicValuedModelPart().getSelectionExpression());
        }
        sqlAppender.appendSql(" from ");
        sqlAppender.appendSql("max_series");
        sqlAppender.appendSql(" i");
        if (elementPart == null) {
            sqlAppender.appendSql(" join json_table(json_query('{\"a\":'||");
            array.accept(walker);
            sqlAppender.appendSql("||'}','$.a['||(i.i-1)||']'),'strict $' columns(");
            tupleType.forEachSelectable(0, (selectionIndex, selectableMapping) -> {
                if (!CollectionPart.Nature.INDEX.getName().equals(selectableMapping.getSelectableName())) {
                    if (selectionIndex == 0) {
                        sqlAppender.append(' ');
                    } else {
                        sqlAppender.append(',');
                    }
                    sqlAppender.append(selectableMapping.getSelectionExpression());
                    sqlAppender.append(' ');
                    sqlAppender.append(this.getDdlType(selectableMapping, 3018, walker));
                    sqlAppender.appendSql(" path '$.");
                    sqlAppender.append(selectableMapping.getSelectableName());
                    sqlAppender.appendSql("' error on error");
                }
            });
            sqlAppender.appendSql(") error on error) t on json_exists('{\"a\":'||");
            array.accept(walker);
            sqlAppender.appendSql("||'}','$.a['||(i.i-1)||']'))");
        } else {
            sqlAppender.appendSql(" where json_exists('{\"a\":'||");
            array.accept(walker);
            sqlAppender.appendSql("||'}','$.a['||(i.i-1)||']'))");
        }
    }
}

