/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.array;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.dialect.aggregate.AggregateSupport;
import org.hibernate.dialect.function.array.UnnestFunction;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.SqlTypedMapping;
import org.hibernate.query.derived.AnonymousTupleTableGroupProducer;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.type.BasicPluralType;

public class PostgreSQLUnnestFunction
extends UnnestFunction {
    public PostgreSQLUnnestFunction() {
        super(null, "ordinality");
    }

    @Override
    protected void renderJsonTable(SqlAppender sqlAppender, Expression array, BasicPluralType<?, ?> pluralType, @Nullable SqlTypedMapping sqlTypedMapping, AnonymousTupleTableGroupProducer tupleType, String tableIdentifierVariable, SqlAstTranslator<?> walker) {
        AggregateSupport aggregateSupport = walker.getSessionFactory().getJdbcServices().getDialect().getAggregateSupport();
        sqlAppender.appendSql("(select");
        tupleType.forEachSelectable(0, (selectionIndex, selectableMapping) -> {
            if (selectionIndex == 0) {
                sqlAppender.append(' ');
            } else {
                sqlAppender.append(',');
            }
            if (CollectionPart.Nature.INDEX.getName().equals(selectableMapping.getSelectableName())) {
                sqlAppender.appendSql("t.i");
            } else {
                sqlAppender.append(aggregateSupport.aggregateComponentCustomReadExpression("", "", "t.v", selectableMapping.getSelectableName(), 3001, selectableMapping));
            }
            sqlAppender.append(' ');
            sqlAppender.append(selectableMapping.getSelectionExpression());
        });
        sqlAppender.appendSql(" from jsonb_array_elements(");
        array.accept(walker);
        sqlAppender.appendSql(')');
        if (tupleType.findSubPart(CollectionPart.Nature.INDEX.getName(), null) != null) {
            sqlAppender.appendSql(" with ordinality t(v,i))");
        } else {
            sqlAppender.appendSql(" t(v))");
        }
    }
}

