/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.json;

import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.QueryException;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.json.JsonExistsFunction;
import org.hibernate.dialect.function.json.JsonPathHelper;
import org.hibernate.query.ReturnableType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.JsonExistsErrorBehavior;
import org.hibernate.sql.ast.tree.expression.JsonPathPassingClause;
import org.hibernate.type.spi.TypeConfiguration;

public class CockroachDBJsonExistsFunction
extends JsonExistsFunction {
    public CockroachDBJsonExistsFunction(TypeConfiguration typeConfiguration) {
        super(typeConfiguration, true, true);
    }

    @Override
    protected void render(SqlAppender sqlAppender, JsonExistsFunction.JsonExistsArguments arguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        String jsonPath;
        if (arguments.errorBehavior() != null && arguments.errorBehavior() != JsonExistsErrorBehavior.ERROR) {
            throw new QueryException("Can't emulate on error clause on CockroachDB");
        }
        try {
            jsonPath = (String)walker.getLiteralValue(arguments.jsonPath());
        }
        catch (Exception ex) {
            throw new QueryException("CockroachDB json_value only support literal json paths, but got " + arguments.jsonPath());
        }
        CockroachDBJsonExistsFunction.appendJsonExists(sqlAppender, arguments.jsonDocument(), JsonPathHelper.parseJsonPathElements(jsonPath), arguments.isJsonType(), arguments.passingClause(), walker);
    }

    static void appendJsonExists(SqlAppender sqlAppender, Expression jsonDocument, List<JsonPathHelper.JsonPathElement> jsonPathElements, boolean isJsonType, @Nullable JsonPathPassingClause jsonPathPassingClause, SqlAstTranslator<?> walker) {
        boolean needsCast;
        boolean bl = needsCast = !isJsonType && AbstractSqlAstTranslator.isParameter(jsonDocument);
        if (needsCast) {
            sqlAppender.appendSql("cast(");
        } else {
            sqlAppender.appendSql('(');
        }
        jsonDocument.accept(walker);
        if (needsCast) {
            sqlAppender.appendSql(" as jsonb)");
        } else {
            sqlAppender.appendSql(')');
        }
        sqlAppender.appendSql("#>>array");
        int separator = 91;
        Dialect dialect = walker.getSessionFactory().getJdbcServices().getDialect();
        for (JsonPathHelper.JsonPathElement jsonPathElement : jsonPathElements) {
            sqlAppender.appendSql((char)separator);
            if (jsonPathElement instanceof JsonPathHelper.JsonAttribute) {
                JsonPathHelper.JsonAttribute attribute = (JsonPathHelper.JsonAttribute)jsonPathElement;
                dialect.appendLiteral(sqlAppender, attribute.attribute());
            } else if (jsonPathElement instanceof JsonPathHelper.JsonParameterIndexAccess) {
                assert (jsonPathPassingClause != null);
                String parameterName = ((JsonPathHelper.JsonParameterIndexAccess)jsonPathElement).parameterName();
                Expression expression = jsonPathPassingClause.getPassingExpressions().get(parameterName);
                if (expression == null) {
                    throw new QueryException("JSON path [" + JsonPathHelper.toJsonPath(jsonPathElements) + "] uses parameter [" + parameterName + "] that is not passed");
                }
                sqlAppender.appendSql("cast(");
                expression.accept(walker);
                sqlAppender.appendSql(" as text)");
            } else {
                sqlAppender.appendSql('\'');
                sqlAppender.appendSql(((JsonPathHelper.JsonIndexAccess)jsonPathElement).index());
                sqlAppender.appendSql('\'');
            }
            separator = 44;
        }
        sqlAppender.appendSql("] is not null");
    }
}

