/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.json;

import java.util.List;
import org.hibernate.query.ReturnableType;
import org.hibernate.query.sqm.function.AbstractSqmSelfRenderingFunctionDescriptor;
import org.hibernate.query.sqm.function.FunctionKind;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.JsonNullBehavior;
import org.hibernate.type.spi.TypeConfiguration;

public class JsonArrayFunction
extends AbstractSqmSelfRenderingFunctionDescriptor {
    public JsonArrayFunction(TypeConfiguration typeConfiguration) {
        super("json_array", FunctionKind.NORMAL, null, StandardFunctionReturnTypeResolvers.invariant(typeConfiguration.getBasicTypeRegistry().resolve(String.class, 3001)), null);
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        sqlAppender.appendSql("json_array");
        int separator = 40;
        if (sqlAstArguments.isEmpty()) {
            sqlAppender.appendSql((char)separator);
            this.renderReturningClause(sqlAppender, walker);
        } else {
            int argumentsCount;
            JsonNullBehavior nullBehavior;
            SqlAstNode lastArgument = sqlAstArguments.get(sqlAstArguments.size() - 1);
            if (lastArgument instanceof JsonNullBehavior) {
                nullBehavior = (JsonNullBehavior)lastArgument;
                argumentsCount = sqlAstArguments.size() - 1;
            } else {
                nullBehavior = JsonNullBehavior.ABSENT;
                argumentsCount = sqlAstArguments.size();
            }
            for (int i = 0; i < argumentsCount; ++i) {
                sqlAppender.appendSql((char)separator);
                this.renderValue(sqlAppender, sqlAstArguments.get(i), walker);
                separator = 44;
            }
            if (nullBehavior == JsonNullBehavior.NULL) {
                sqlAppender.appendSql(" null on null");
            }
            this.renderReturningClause(sqlAppender, walker);
        }
        sqlAppender.appendSql(')');
    }

    protected void renderValue(SqlAppender sqlAppender, SqlAstNode value, SqlAstTranslator<?> walker) {
        value.accept(walker);
    }

    protected void renderReturningClause(SqlAppender sqlAppender, SqlAstTranslator<?> walker) {
    }
}

