/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.json;

import java.util.List;
import org.hibernate.dialect.function.json.JsonArrayFunction;
import org.hibernate.query.ReturnableType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.JsonNullBehavior;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.type.spi.TypeConfiguration;

public class PostgreSQLJsonArrayFunction
extends JsonArrayFunction {
    public PostgreSQLJsonArrayFunction(TypeConfiguration typeConfiguration) {
        super(typeConfiguration);
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        if (sqlAstArguments.isEmpty()) {
            sqlAppender.appendSql("jsonb_build_array()");
        } else {
            int argumentsCount;
            JsonNullBehavior nullBehavior;
            SqlAstNode lastArgument = sqlAstArguments.get(sqlAstArguments.size() - 1);
            if (lastArgument instanceof JsonNullBehavior) {
                nullBehavior = (JsonNullBehavior)lastArgument;
                argumentsCount = sqlAstArguments.size() - 1;
            } else {
                nullBehavior = null;
                argumentsCount = sqlAstArguments.size();
            }
            if (nullBehavior == JsonNullBehavior.ABSENT) {
                sqlAppender.appendSql("(select jsonb_agg(t.v order by t.i) from (values");
                int separator = 32;
                for (int i = 0; i < argumentsCount; ++i) {
                    SqlAstNode node = sqlAstArguments.get(i);
                    sqlAppender.appendSql((char)separator);
                    sqlAppender.appendSql('(');
                    sqlAppender.appendSql(i);
                    sqlAppender.appendSql(',');
                    if (node instanceof Literal && ((Literal)node).getLiteralValue() == null) {
                        sqlAppender.appendSql("null::jsonb");
                    } else {
                        Literal literal;
                        sqlAppender.appendSql("to_jsonb(");
                        node.accept(walker);
                        if (node instanceof Literal && (literal = (Literal)node).getJdbcMapping().getJdbcType().isString()) {
                            sqlAppender.appendSql("::text");
                        }
                        sqlAppender.appendSql(')');
                    }
                    sqlAppender.appendSql(')');
                    separator = 44;
                }
                sqlAppender.appendSql(") t(i,v) where t.v is not null)");
            } else {
                sqlAppender.appendSql("jsonb_build_array");
                int separator = 40;
                for (int i = 0; i < argumentsCount; ++i) {
                    sqlAppender.appendSql((char)separator);
                    sqlAstArguments.get(i).accept(walker);
                    separator = 44;
                }
                sqlAppender.appendSql(')');
            }
        }
    }
}

