/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.xml;

import java.util.List;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.xml.XmlTableFunction;
import org.hibernate.dialect.function.xml.XmlTableSetReturningFunctionTypeResolver;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.SelectablePath;
import org.hibernate.metamodel.mapping.internal.SelectableMappingImpl;
import org.hibernate.query.derived.AnonymousTupleTableGroupProducer;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.expression.CastTarget;
import org.hibernate.sql.ast.tree.expression.XmlTableValueColumnDefinition;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.spi.TypeConfiguration;

public class DB2XmlTableFunction
extends XmlTableFunction {
    public DB2XmlTableFunction(TypeConfiguration typeConfiguration) {
        super(false, new DB2XmlTableSetReturningFunctionTypeResolver(), typeConfiguration);
    }

    @Override
    protected void renderXmlTable(SqlAppender sqlAppender, XmlTableFunction.XmlTableArguments arguments, AnonymousTupleTableGroupProducer tupleType, String tableIdentifierVariable, SqlAstTranslator<?> walker) {
        sqlAppender.appendSql("xmltable(");
        walker.render(arguments.xpath(), SqlAstNodeRenderingMode.INLINE_PARAMETERS);
        sqlAppender.appendSql(" passing ");
        if (!arguments.isXmlType()) {
            sqlAppender.appendSql("xmlparse(document ");
        }
        walker.render(arguments.xmlDocument(), SqlAstNodeRenderingMode.NO_PLAIN_PARAMETER);
        if (!arguments.isXmlType()) {
            sqlAppender.appendSql(")");
        }
        this.renderColumns(sqlAppender, arguments.columnsClause(), walker);
        sqlAppender.appendSql(')');
    }

    @Override
    protected String determineColumnType(CastTarget castTarget, SqlAstTranslator<?> walker) {
        String typeName = super.determineColumnType(castTarget, walker);
        return DB2XmlTableFunction.isBoolean(castTarget.getJdbcMapping()) ? "varchar(5)" : typeName;
    }

    @Override
    protected void renderXmlValueColumnDefinition(SqlAppender sqlAppender, XmlTableValueColumnDefinition definition, SqlAstTranslator<?> walker) {
        sqlAppender.appendSql(definition.name());
        sqlAppender.appendSql(' ');
        sqlAppender.appendSql(this.determineColumnType(definition.type(), walker));
        this.renderDefaultExpression(definition.defaultExpression(), sqlAppender, walker);
        this.renderColumnPath(definition.name(), definition.xpath(), sqlAppender, walker);
    }

    static boolean isBoolean(JdbcMapping type) {
        return type.getJdbcType().isBoolean();
    }

    private static class DB2XmlTableSetReturningFunctionTypeResolver
    extends XmlTableSetReturningFunctionTypeResolver {
        private DB2XmlTableSetReturningFunctionTypeResolver() {
        }

        @Override
        protected void addSelectableMapping(List<SelectableMapping> selectableMappings, String name, JdbcMapping type, SqmToSqlAstConverter converter) {
            if (DB2XmlTableFunction.isBoolean(type)) {
                JdbcLiteralFormatter jdbcLiteralFormatter = type.getJdbcLiteralFormatter();
                SessionFactoryImplementor sessionFactory = converter.getCreationContext().getSessionFactory();
                Dialect dialect = sessionFactory.getJdbcServices().getDialect();
                WrapperOptions wrapperOptions = sessionFactory.getWrapperOptions();
                Object trueValue = type.convertToRelationalValue(true);
                Object falseValue = type.convertToRelationalValue(false);
                String trueFragment = jdbcLiteralFormatter.toJdbcLiteral(trueValue, dialect, wrapperOptions);
                String falseFragment = jdbcLiteralFormatter.toJdbcLiteral(falseValue, dialect, wrapperOptions);
                selectableMappings.add(new SelectableMappingImpl("", name, new SelectablePath(name), "decode({@}." + name + ",'true'," + trueFragment + ",'false'," + falseFragment + ")", null, "varchar(5)", null, null, null, null, false, false, false, false, false, false, type));
            } else {
                super.addSelectableMapping(selectableMappings, name, type, converter);
            }
        }
    }
}

