/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.xml;

import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.dialect.function.array.DdlTypeHelper;
import org.hibernate.dialect.function.xml.XmlTableSetReturningFunctionTypeResolver;
import org.hibernate.query.derived.AnonymousTupleTableGroupProducer;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.function.AbstractSqmSelfRenderingSetReturningFunctionDescriptor;
import org.hibernate.query.sqm.function.SelfRenderingSqmSetReturningFunction;
import org.hibernate.query.sqm.function.SetReturningFunctionRenderer;
import org.hibernate.query.sqm.function.SqmSetReturningFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.ArgumentTypesValidator;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.query.sqm.produce.function.SetReturningFunctionTypeResolver;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionArgumentTypeResolvers;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmXmlTableFunction;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.CastTarget;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.XmlTableColumnDefinition;
import org.hibernate.sql.ast.tree.expression.XmlTableColumnsClause;
import org.hibernate.sql.ast.tree.expression.XmlTableOrdinalityColumnDefinition;
import org.hibernate.sql.ast.tree.expression.XmlTableQueryColumnDefinition;
import org.hibernate.sql.ast.tree.expression.XmlTableValueColumnDefinition;
import org.hibernate.type.spi.TypeConfiguration;

public class XmlTableFunction
extends AbstractSqmSelfRenderingSetReturningFunctionDescriptor {
    protected final boolean supportsParametersInDefault;

    public XmlTableFunction(boolean supportsParametersInDefault, TypeConfiguration typeConfiguration) {
        this(supportsParametersInDefault, new XmlTableSetReturningFunctionTypeResolver(), typeConfiguration);
    }

    protected XmlTableFunction(boolean supportsParametersInDefault, SetReturningFunctionTypeResolver setReturningFunctionTypeResolver, TypeConfiguration typeConfiguration) {
        super("xmltable", new ArgumentTypesValidator(StandardArgumentsValidators.exactly(2), FunctionParameterType.STRING, FunctionParameterType.IMPLICIT_XML), setReturningFunctionTypeResolver, StandardFunctionArgumentTypeResolvers.invariant(typeConfiguration, FunctionParameterType.STRING, FunctionParameterType.XML));
        this.supportsParametersInDefault = supportsParametersInDefault;
    }

    @Override
    protected <T> SelfRenderingSqmSetReturningFunction<T> generateSqmSetReturningFunctionExpression(List<? extends SqmTypedNode<?>> arguments, QueryEngine queryEngine) {
        return new SqmXmlTableFunction((SqmSetReturningFunctionDescriptor)this, (SetReturningFunctionRenderer)this, this.getArgumentsValidator(), this.getSetReturningTypeResolver(), queryEngine.getCriteriaBuilder(), (SqmExpression)arguments.get(0), (SqmExpression)arguments.get(1));
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, AnonymousTupleTableGroupProducer tupleType, String tableIdentifierVariable, SqlAstTranslator<?> walker) {
        this.renderXmlTable(sqlAppender, XmlTableArguments.extract(sqlAstArguments), tupleType, tableIdentifierVariable, walker);
    }

    protected void renderXmlTable(SqlAppender sqlAppender, XmlTableArguments arguments, AnonymousTupleTableGroupProducer tupleType, String tableIdentifierVariable, SqlAstTranslator<?> walker) {
        sqlAppender.appendSql("xmltable(");
        arguments.xpath().accept(walker);
        sqlAppender.appendSql(" passing ");
        if (!arguments.isXmlType()) {
            sqlAppender.appendSql("xmlparse(document ");
        }
        arguments.xmlDocument().accept(walker);
        if (!arguments.isXmlType()) {
            sqlAppender.appendSql(')');
        }
        this.renderColumns(sqlAppender, arguments.columnsClause(), walker);
        sqlAppender.appendSql(')');
    }

    protected String determineColumnType(CastTarget castTarget, SqlAstTranslator<?> walker) {
        return XmlTableFunction.determineColumnType(castTarget, walker.getSessionFactory().getTypeConfiguration());
    }

    protected static String determineColumnType(CastTarget castTarget, TypeConfiguration typeConfiguration) {
        String columnDefinition = castTarget.getColumnDefinition();
        if (columnDefinition != null) {
            return columnDefinition;
        }
        String typeName = DdlTypeHelper.getTypeName(castTarget.getJdbcMapping(), castTarget.toSize(), typeConfiguration);
        int parenthesisIndex = typeName.indexOf(40);
        if (parenthesisIndex != -1 && typeName.charAt(parenthesisIndex + 1) == '$') {
            return typeName.substring(0, parenthesisIndex);
        }
        return typeName;
    }

    protected void renderColumns(SqlAppender sqlAppender, XmlTableColumnsClause xmlTableColumnsClause, SqlAstTranslator<?> walker) {
        sqlAppender.appendSql(" columns");
        int separator = 32;
        for (XmlTableColumnDefinition columnDefinition : xmlTableColumnsClause.getColumnDefinitions()) {
            sqlAppender.appendSql((char)separator);
            if (columnDefinition instanceof XmlTableQueryColumnDefinition) {
                XmlTableQueryColumnDefinition definition = (XmlTableQueryColumnDefinition)columnDefinition;
                this.renderXmlQueryColumnDefinition(sqlAppender, definition, walker);
            } else if (columnDefinition instanceof XmlTableValueColumnDefinition) {
                XmlTableValueColumnDefinition definition = (XmlTableValueColumnDefinition)columnDefinition;
                this.renderXmlValueColumnDefinition(sqlAppender, definition, walker);
            } else {
                this.renderXmlOrdinalityColumnDefinition(sqlAppender, (XmlTableOrdinalityColumnDefinition)columnDefinition, walker);
            }
            separator = 44;
        }
    }

    protected void renderXmlOrdinalityColumnDefinition(SqlAppender sqlAppender, XmlTableOrdinalityColumnDefinition definition, SqlAstTranslator<?> walker) {
        sqlAppender.appendSql(definition.name());
        sqlAppender.appendSql(" for ordinality");
    }

    protected void renderXmlValueColumnDefinition(SqlAppender sqlAppender, XmlTableValueColumnDefinition definition, SqlAstTranslator<?> walker) {
        sqlAppender.appendSql(definition.name());
        sqlAppender.appendSql(' ');
        sqlAppender.appendSql(this.determineColumnType(definition.type(), walker));
        this.renderColumnPath(definition.name(), definition.xpath(), sqlAppender, walker);
        this.renderDefaultExpression(definition.defaultExpression(), sqlAppender, walker);
    }

    protected void renderColumnPath(String name, @Nullable String xpath, SqlAppender sqlAppender, SqlAstTranslator<?> walker) {
        if (xpath != null) {
            sqlAppender.appendSql(" path ");
            sqlAppender.appendSingleQuoteEscapedString(xpath);
        } else {
            sqlAppender.appendSql(" path ");
            sqlAppender.appendSingleQuoteEscapedString(name);
        }
    }

    protected void renderDefaultExpression(@Nullable Expression expression, SqlAppender sqlAppender, SqlAstTranslator<?> walker) {
        if (expression != null) {
            sqlAppender.appendSql(" default ");
            if (this.supportsParametersInDefault) {
                expression.accept(walker);
            } else {
                walker.render(expression, SqlAstNodeRenderingMode.INLINE_PARAMETERS);
            }
        }
    }

    protected void renderXmlQueryColumnDefinition(SqlAppender sqlAppender, XmlTableQueryColumnDefinition definition, SqlAstTranslator<?> walker) {
        sqlAppender.appendSql(definition.name());
        sqlAppender.appendSql(' ');
        sqlAppender.appendSql(this.determineColumnType(new CastTarget(definition.type()), walker));
        this.renderColumnPath(definition.name(), definition.xpath(), sqlAppender, walker);
        this.renderDefaultExpression(definition.defaultExpression(), sqlAppender, walker);
    }

    protected record XmlTableArguments(Expression xpath, Expression xmlDocument, boolean isXmlType, XmlTableColumnsClause columnsClause) {
        public static XmlTableArguments extract(List<? extends SqlAstNode> sqlAstArguments) {
            SqlAstNode node;
            Expression xpath = (Expression)sqlAstArguments.get(0);
            Expression xmlDocument = (Expression)sqlAstArguments.get(1);
            XmlTableColumnsClause columnsClause = null;
            int nextIndex = 2;
            if (nextIndex < sqlAstArguments.size() && (node = sqlAstArguments.get(nextIndex)) instanceof XmlTableColumnsClause) {
                columnsClause = (XmlTableColumnsClause)node;
            }
            return new XmlTableArguments(xpath, xmlDocument, xmlDocument.getExpressionType() != null && xmlDocument.getExpressionType().getSingleJdbcMapping().getJdbcType().isXml(), columnsClause);
        }
    }
}

