/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.lock;

import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.action.internal.EntityIncrementVersionProcess;
import org.hibernate.dialect.lock.LockingStrategy;
import org.hibernate.event.spi.EventSource;
import org.hibernate.persister.entity.EntityPersister;

public class OptimisticForceIncrementLockingStrategy
implements LockingStrategy {
    private final EntityPersister lockable;
    private final LockMode lockMode;

    public OptimisticForceIncrementLockingStrategy(EntityPersister lockable, LockMode lockMode) {
        this.lockable = lockable;
        this.lockMode = lockMode;
        if (lockMode.lessThan(LockMode.OPTIMISTIC_FORCE_INCREMENT)) {
            throw new HibernateException("[" + lockMode + "] not valid for [" + lockable.getEntityName() + "]");
        }
    }

    @Override
    public void lock(Object id, Object version, Object object, int timeout, EventSource session) {
        if (!this.lockable.isVersioned()) {
            throw new HibernateException("[" + this.lockMode + "] not supported for non-versioned entities [" + this.lockable.getEntityName() + "]");
        }
        session.getActionQueue().registerProcess(new EntityIncrementVersionProcess(object));
    }

    protected LockMode getLockMode() {
        return this.lockMode;
    }
}

