/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.connections.spi;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Context;
import javax.sql.DataSource;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.jdbc.connections.internal.DatabaseConnectionInfoImpl;
import org.hibernate.engine.jdbc.connections.spi.AbstractDataSourceBasedMultiTenantConnectionProviderImpl;
import org.hibernate.engine.jdbc.connections.spi.DatabaseConnectionInfo;
import org.hibernate.engine.jndi.spi.JndiService;
import org.hibernate.service.spi.ServiceRegistryAwareService;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.Stoppable;

public class DataSourceBasedMultiTenantConnectionProviderImpl<T>
extends AbstractDataSourceBasedMultiTenantConnectionProviderImpl<T>
implements ServiceRegistryAwareService,
Stoppable {
    private final Map<T, DataSource> dataSourceMap = new ConcurrentHashMap<T, DataSource>();
    private JndiService jndiService;
    private T tenantIdentifierForAny;
    private String baseJndiNamespace;
    private String jndiName;

    @Override
    protected DataSource selectAnyDataSource() {
        return this.selectDataSource(this.tenantIdentifierForAny);
    }

    @Override
    protected DataSource selectDataSource(T tenantIdentifier) {
        DataSource dataSource = this.dataSourceMap().get(tenantIdentifier);
        if (dataSource == null) {
            dataSource = (DataSource)this.jndiService.locate(this.baseJndiNamespace + "/" + tenantIdentifier);
            this.dataSourceMap().put(tenantIdentifier, dataSource);
        }
        return dataSource;
    }

    private Map<T, DataSource> dataSourceMap() {
        return this.dataSourceMap;
    }

    @Override
    public void injectServices(ServiceRegistryImplementor serviceRegistry) {
        ConfigurationService configurationService = serviceRegistry.requireService(ConfigurationService.class);
        Object dataSourceConfigValue = configurationService.getSettings().get("hibernate.connection.datasource");
        if (!(dataSourceConfigValue instanceof String)) {
            throw new HibernateException("illegal value for configuration setting 'hibernate.connection.datasource'");
        }
        this.jndiName = (String)dataSourceConfigValue;
        this.jndiService = serviceRegistry.getService(JndiService.class);
        if (this.jndiService == null) {
            throw new HibernateException("Could not locate JndiService from DataSourceBasedMultiTenantConnectionProviderImpl");
        }
        Object namedObject = this.jndiService.locate(this.jndiName);
        if (namedObject == null) {
            throw new HibernateException("JNDI name [" + this.jndiName + "] could not be resolved");
        }
        if (namedObject instanceof DataSource) {
            DataSource datasource = (DataSource)namedObject;
            int loc = this.jndiName.lastIndexOf(47);
            this.baseJndiNamespace = this.jndiName.substring(0, loc);
            String prefix = this.jndiName.substring(loc + 1);
            this.tenantIdentifierForAny = prefix;
            this.dataSourceMap().put(this.tenantIdentifierForAny, datasource);
        } else if (namedObject instanceof Context) {
            this.baseJndiNamespace = this.jndiName;
            Object configuredTenantId = configurationService.getSettings().get("hibernate.multi_tenant.datasource.identifier_for_any");
            this.tenantIdentifierForAny = configuredTenantId;
            if (this.tenantIdentifierForAny == null) {
                throw new HibernateException("JNDI name named a Context, but tenant identifier to use for ANY was not specified");
            }
        } else {
            throw new HibernateException("Unknown object type [" + namedObject.getClass().getName() + "] found in JNDI location [" + this.jndiName + "]");
        }
    }

    @Override
    public void stop() {
        this.dataSourceMap.clear();
    }

    @Override
    public DatabaseConnectionInfo getDatabaseConnectionInfo(Dialect dialect) {
        return new DatabaseConnectionInfoImpl(null, null, dialect.getVersion(), null, null, null, null){

            @Override
            public String toInfoString() {
                return "\tMulti-tenant datasource JNDI name [" + DataSourceBasedMultiTenantConnectionProviderImpl.this.jndiName + "]";
            }
        };
    }
}

