/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import org.hibernate.HibernateException;
import org.hibernate.bytecode.enhance.spi.interceptor.EnhancementAsProxyLazinessInterceptor;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.internal.ManagedTypeHelper;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.event.internal.AbstractVisitor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.type.CollectionType;

public class DirtyCollectionSearchVisitor
extends AbstractVisitor {
    private final EnhancementAsProxyLazinessInterceptor interceptor;
    private final boolean[] propertyVersionability;
    private boolean dirty;

    public DirtyCollectionSearchVisitor(Object entity, EventSource session, boolean[] propertyVersionability) {
        super(session);
        PersistentAttributeInterceptor attributeInterceptor;
        EnhancementAsProxyLazinessInterceptor interceptor = null;
        if (ManagedTypeHelper.isPersistentAttributeInterceptable(entity) && (attributeInterceptor = ManagedTypeHelper.asPersistentAttributeInterceptable(entity).$$_hibernate_getInterceptor()) instanceof EnhancementAsProxyLazinessInterceptor) {
            interceptor = (EnhancementAsProxyLazinessInterceptor)attributeInterceptor;
        }
        this.interceptor = interceptor;
        this.propertyVersionability = propertyVersionability;
    }

    public boolean wasDirtyCollectionFound() {
        return this.dirty;
    }

    @Override
    Object processCollection(Object collection, CollectionType type) throws HibernateException {
        if (collection != null) {
            EventSource session = this.getSession();
            if (type.isArrayType()) {
                if (session.getPersistenceContextInternal().getCollectionHolder(collection).isDirty()) {
                    this.dirty = true;
                }
            } else if ((this.interceptor == null || this.interceptor.isAttributeLoaded(type.getName())) && ((PersistentCollection)collection).isDirty()) {
                this.dirty = true;
            }
        }
        return null;
    }

    @Override
    boolean includeEntityProperty(Object[] values, int i) {
        return this.propertyVersionability[i] && super.includeEntityProperty(values, i);
    }
}

