/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.exception.internal;

import java.sql.SQLException;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.JDBCException;
import org.hibernate.PessimisticLockException;
import org.hibernate.QueryTimeoutException;
import org.hibernate.exception.AuthException;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.DataException;
import org.hibernate.exception.JDBCConnectionException;
import org.hibernate.exception.LockAcquisitionException;
import org.hibernate.exception.SQLGrammarException;
import org.hibernate.exception.spi.AbstractSQLExceptionConversionDelegate;
import org.hibernate.exception.spi.ConversionContext;
import org.hibernate.internal.util.JdbcExceptionHelper;

public class SQLStateConversionDelegate
extends AbstractSQLExceptionConversionDelegate {
    public SQLStateConversionDelegate(@UnknownKeyFor @NonNull @Initialized ConversionContext conversionContext) {
        super(conversionContext);
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized JDBCException convert(@UnknownKeyFor @NonNull @Initialized SQLException sqlException, @UnknownKeyFor @NonNull @Initialized String message, @UnknownKeyFor @NonNull @Initialized String sql) {
        String sqlState = JdbcExceptionHelper.extractSqlState(sqlException);
        if (sqlState != null) {
            switch (sqlState) {
                case "42501": {
                    return new AuthException(message, sqlException, sql);
                }
                case "40001": {
                    return new LockAcquisitionException(message, sqlException, sql);
                }
                case "40XL1": 
                case "40XL2": {
                    return new PessimisticLockException(message, sqlException, sql);
                }
                case "70100": {
                    return new QueryTimeoutException(message, sqlException, sql);
                }
                case "72000": {
                    if (JdbcExceptionHelper.extractErrorCode(sqlException) != 1013) break;
                    return new QueryTimeoutException(message, sqlException, sql);
                }
            }
            switch (JdbcExceptionHelper.determineSqlStateClassCode(sqlState)) {
                case "07": 
                case "20": 
                case "2A": 
                case "37": 
                case "42": 
                case "65": 
                case "S0": {
                    return new SQLGrammarException(message, sqlException, sql);
                }
                case "23": 
                case "27": 
                case "44": {
                    String constraintName = this.getConversionContext().getViolatedConstraintNameExtractor().extractConstraintName(sqlException);
                    return new ConstraintViolationException(message, sqlException, sql, constraintName);
                }
                case "08": {
                    return new JDBCConnectionException(message, sqlException, sql);
                }
                case "21": 
                case "22": {
                    return new DataException(message, sqlException, sql);
                }
                case "28": {
                    return new AuthException(message, sqlException, sql);
                }
            }
        }
        return null;
    }
}

