/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.uuid;

import java.security.SecureRandom;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.hibernate.Internal;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.id.UUIDGenerationStrategy;
import org.hibernate.id.uuid.UuidValueGenerator;

public class UuidVersion7Strategy
implements UUIDGenerationStrategy,
UuidValueGenerator {
    public static final UuidVersion7Strategy INSTANCE = new UuidVersion7Strategy();
    private final AtomicReference<State> lastState;

    @Internal
    public UuidVersion7Strategy() {
        this(Instant.EPOCH, Integer.MIN_VALUE);
    }

    @Internal
    public UuidVersion7Strategy(Instant initialTimestamp, int initialSequence) {
        this.lastState = new AtomicReference<State>(new State(initialTimestamp, initialSequence));
    }

    @Override
    public int getGeneratedVersion() {
        return 7;
    }

    @Override
    public UUID generateUUID(SharedSessionContractImplementor session) {
        return this.generateUuid(session);
    }

    @Override
    public UUID generateUuid(SharedSessionContractImplementor session) {
        State state = this.lastState.updateAndGet(State::getNextState);
        return new UUID(state.millis() << 16 & 0xFFFFFFFFFFFF0000L | 0x7000L | state.nanos() & 0xFFFL, Long.MIN_VALUE | (long)state.lastSequence << 48 | UuidVersion7Strategy.randomNode());
    }

    private static long randomNode() {
        return Holder.numberGenerator.nextLong(0x1000000000000L) | 0x100000000000L;
    }

    public record State(Instant lastTimestamp, int lastSequence) {
        public long millis() {
            return this.lastTimestamp.toEpochMilli();
        }

        public long nanos() {
            return (long)((double)((long)this.lastTimestamp.getNano() % 1000000L) * 0.004096);
        }

        public State getNextState() {
            Instant now = Instant.now();
            if (this.lastTimestamp.toEpochMilli() < now.toEpochMilli()) {
                return new State(now.truncatedTo(ChronoUnit.MILLIS), State.randomSequence());
            }
            if (this.lastSequence == 16383) {
                return new State(this.lastTimestamp.plusMillis(1L), Holder.numberGenerator.nextInt(16384));
            }
            return new State(this.lastTimestamp, this.lastSequence + 1);
        }

        private static int randomSequence() {
            return Holder.numberGenerator.nextInt(16384);
        }
    }

    private static class Holder {
        private static final SecureRandom numberGenerator = new SecureRandom();

        private Holder() {
        }
    }
}

