/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal.log;

import java.lang.invoke.MethodHandles;
import java.sql.SQLException;
import org.hibernate.internal.log.SubSystemLogging;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ValidIdRange;

@SubSystemLogging(name="org.hibernate.orm.connections.pooling", description="Logging related to connection pooling")
@MessageLogger(projectCode="HHH")
@ValidIdRange(min=10001001, max=10001500)
public interface ConnectionInfoLogger
extends BasicLogger {
    public static final String LOGGER_NAME = "org.hibernate.orm.connections.pooling";
    public static final ConnectionInfoLogger INSTANCE = (ConnectionInfoLogger)Logger.getMessageLogger((MethodHandles.Lookup)MethodHandles.lookup(), ConnectionInfoLogger.class, (String)"org.hibernate.orm.connections.pooling");

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Using built-in connection pool (not intended for production use)", id=10001002)
    public void usingHibernateBuiltInConnectionPool();

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Database info:\n%s", id=10001005)
    public void logConnectionInfoDetails(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10001006, value="No JDBC Driver class was specified by property 'jakarta.persistence.jdbc.driver', 'javax.persistence.jdbc.driver', or 'hibernate.connection.driver_class'")
    public void jdbcDriverNotSpecified();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Cleaning up connection pool [%s]", id=10001008)
    public void cleaningUpConnectionPool(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Problem closing pooled connection", id=10001009)
    public void unableToClosePooledConnection(@Cause SQLException var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Could not destroy connection pool", id=10001010)
    public void unableToDestroyConnectionPool(@Cause Exception var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Could not instantiate connection pool", id=10001011)
    public void unableToInstantiateConnectionPool(@Cause Exception var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Configuring connection pool [%s]", id=10001012)
    public void configureConnectionPool(String var1);
}

