/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.boot.internal;

import jakarta.persistence.AttributeConverter;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.PersistenceUnitTransactionType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.sql.DataSource;
import org.hibernate.Internal;
import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.boot.CacheRegionDefinition;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.SessionFactoryBuilder;
import org.hibernate.boot.archive.scan.internal.StandardScanOptions;
import org.hibernate.boot.beanvalidation.BeanValidationIntegrator;
import org.hibernate.boot.cfgxml.spi.CfgXmlAccessService;
import org.hibernate.boot.cfgxml.spi.LoadedConfig;
import org.hibernate.boot.cfgxml.spi.MappingReference;
import org.hibernate.boot.internal.ClassmateContext;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmHibernateMapping;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmRootEntityType;
import org.hibernate.boot.jaxb.spi.Binding;
import org.hibernate.boot.model.TypeContributor;
import org.hibernate.boot.model.convert.internal.ClassBasedConverterDescriptor;
import org.hibernate.boot.model.convert.spi.ConverterDescriptor;
import org.hibernate.boot.model.process.spi.ManagedResources;
import org.hibernate.boot.model.process.spi.MetadataBuildingProcess;
import org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.hibernate.boot.registry.BootstrapServiceRegistryBuilder;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.boot.registry.classloading.internal.TcclLookupPrecedence;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.selector.StrategyRegistrationProvider;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.boot.spi.MetadataBuilderContributor;
import org.hibernate.boot.spi.MetadataBuilderImplementor;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.boot.spi.SessionFactoryBuilderImplementor;
import org.hibernate.bytecode.enhance.spi.DefaultEnhancementContext;
import org.hibernate.bytecode.enhance.spi.EnhancementContext;
import org.hibernate.bytecode.enhance.spi.EnhancementException;
import org.hibernate.bytecode.enhance.spi.UnloadedClass;
import org.hibernate.bytecode.enhance.spi.UnloadedField;
import org.hibernate.bytecode.spi.ClassTransformer;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.log.DeprecationLogger;
import org.hibernate.internal.util.NullnessHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.jpa.boot.internal.MergedSettings;
import org.hibernate.jpa.boot.internal.ServiceRegistryCloser;
import org.hibernate.jpa.boot.internal.StandardJpaScanEnvironmentImpl;
import org.hibernate.jpa.boot.spi.EntityManagerFactoryBuilder;
import org.hibernate.jpa.boot.spi.IntegratorProvider;
import org.hibernate.jpa.boot.spi.PersistenceUnitDescriptor;
import org.hibernate.jpa.boot.spi.StrategyRegistrationProviderList;
import org.hibernate.jpa.boot.spi.TypeContributorList;
import org.hibernate.jpa.internal.JpaEntityNotFoundDelegate;
import org.hibernate.jpa.internal.util.LogHelper;
import org.hibernate.jpa.internal.util.PersistenceUnitTransactionTypeHelper;
import org.hibernate.resource.transaction.backend.jdbc.internal.JdbcResourceLocalTransactionCoordinatorBuilderImpl;
import org.hibernate.resource.transaction.backend.jta.internal.JtaTransactionCoordinatorBuilderImpl;
import org.hibernate.resource.transaction.spi.TransactionCoordinatorBuilder;
import org.hibernate.service.spi.ServiceBinding;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.Stoppable;
import org.hibernate.tool.schema.spi.DelayedDropRegistryNotAvailableImpl;
import org.hibernate.tool.schema.spi.SchemaManagementToolCoordinator;

public class EntityManagerFactoryBuilderImpl
implements EntityManagerFactoryBuilder {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(EntityManagerFactoryBuilderImpl.class);
    public static final String INTEGRATOR_PROVIDER = "hibernate.integrator_provider";
    public static final String STRATEGY_REGISTRATION_PROVIDERS = "hibernate.strategy_registration_provider";
    public static final String TYPE_CONTRIBUTORS = "hibernate.type_contributors";
    public static final String METADATA_BUILDER_CONTRIBUTOR = "hibernate.metadata_builder_contributor";
    private final PersistenceUnitDescriptor persistenceUnit;
    private final Map<String, Object> configurationValues;
    private final StandardServiceRegistry standardServiceRegistry;
    private final ManagedResources managedResources;
    private final MetadataBuilderImplementor metamodelBuilder;
    private static final String IS_JTA_TXN_COORD = "local.setting.IS_JTA_TXN_COORD";
    private Object validatorFactory;
    private DataSource dataSource;
    private MetadataImplementor metadata;

    public EntityManagerFactoryBuilderImpl(PersistenceUnitDescriptor persistenceUnit, Map<String, Object> integrationSettings) {
        this(persistenceUnit, integrationSettings, null, null, null);
    }

    public EntityManagerFactoryBuilderImpl(PersistenceUnitDescriptor persistenceUnit, Map<String, Object> integrationSettings, ClassLoader providedClassLoader) {
        this(persistenceUnit, integrationSettings, providedClassLoader, null, null);
    }

    public EntityManagerFactoryBuilderImpl(PersistenceUnitDescriptor persistenceUnit, Map<String, Object> integrationSettings, ClassLoaderService providedClassLoaderService) {
        this(persistenceUnit, integrationSettings, null, providedClassLoaderService, null);
    }

    @Internal
    public EntityManagerFactoryBuilderImpl(PersistenceUnitDescriptor persistenceUnitDescriptor, Map<String, Object> integration, Consumer<MergedSettings> mergedSettingsBaseline) {
        this(persistenceUnitDescriptor, integration, null, null, mergedSettingsBaseline);
    }

    private EntityManagerFactoryBuilderImpl(PersistenceUnitDescriptor persistenceUnit, Map<String, Object> integrationSettings, ClassLoader providedClassLoader, ClassLoaderService providedClassLoaderService, Consumer<MergedSettings> mergedSettingsBaseline) {
        if (integrationSettings == null) {
            integrationSettings = new HashMap<String, Object>();
        }
        LogHelper.logPersistenceUnitInformation(persistenceUnit);
        this.persistenceUnit = persistenceUnit;
        BootstrapServiceRegistry bootstrapServiceRegistry = this.buildBootstrapServiceRegistry(EntityManagerFactoryBuilderImpl.mergedIntegrationSettings(persistenceUnit, integrationSettings), providedClassLoader, providedClassLoaderService);
        try {
            StandardServiceRegistryBuilder registryBuilder = this.getStandardServiceRegistryBuilder(bootstrapServiceRegistry);
            MergedSettings mergedSettings = this.mergeSettings(persistenceUnit, integrationSettings, registryBuilder, mergedSettingsBaseline);
            EntityManagerFactoryBuilderImpl.ignoreFlushBeforeCompletion(mergedSettings);
            this.configurationValues = mergedSettings.getConfigurationValues();
            registryBuilder.applySettings(this.configurationValues);
            this.standardServiceRegistry = registryBuilder.build();
            MetadataSources metadataSources = new MetadataSources(this.standardServiceRegistry);
            this.metamodelBuilder = (MetadataBuilderImplementor)metadataSources.getMetadataBuilder(this.standardServiceRegistry);
            this.applyMetamodelBuilderSettings(mergedSettings, this.applyMappingResources(metadataSources));
            this.applyMetadataBuilderContributor();
            this.setupMappingReferences(metadataSources);
            this.managedResources = MetadataBuildingProcess.prepare(metadataSources, this.metamodelBuilder.getBootstrapContext());
            this.setupValidation();
            this.setupEnhancement(persistenceUnit, metadataSources);
            this.metamodelBuilder.applyTempClassLoader(null);
        }
        catch (Throwable throwable) {
            bootstrapServiceRegistry.close();
            this.cleanup();
            throw throwable;
        }
    }

    private static Map<String, Object> mergedIntegrationSettings(PersistenceUnitDescriptor persistenceUnit, Map<String, Object> integrationSettings) {
        Properties properties = persistenceUnit.getProperties();
        if (properties != null) {
            HashMap<String, Object> mergedIntegrationSettings = new HashMap<String, Object>(properties.size() + integrationSettings.size());
            properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
                if (key instanceof String) {
                    String name = (String)key;
                    mergedIntegrationSettings.put(name, value);
                }
            }));
            mergedIntegrationSettings.putAll(integrationSettings);
            return mergedIntegrationSettings;
        }
        return integrationSettings;
    }

    private static void ignoreFlushBeforeCompletion(MergedSettings mergedSettings) {
        if ("true".equals(mergedSettings.getConfigurationValues().get("hibernate.transaction.flush_before_completion"))) {
            log.definingFlushBeforeCompletionIgnoredInHem("hibernate.transaction.flush_before_completion");
            mergedSettings.getConfigurationValues().put("hibernate.transaction.flush_before_completion", "false");
        }
    }

    private void setupMappingReferences(MetadataSources metadataSources) {
        List<MappingReference> mappingReferences;
        LoadedConfig aggregatedConfig = this.standardServiceRegistry.requireService(CfgXmlAccessService.class).getAggregatedConfig();
        if (aggregatedConfig != null && (mappingReferences = aggregatedConfig.getMappingReferences()) != null) {
            for (MappingReference mappingReference : mappingReferences) {
                mappingReference.apply(metadataSources);
            }
        }
    }

    private void setupValidation() {
        Object validatorFactory = this.configurationValues.get("jakarta.persistence.validation.factory");
        if (validatorFactory == null) {
            Object legacyValidatorFactory = this.configurationValues.get("javax.persistence.validation.factory");
            if (legacyValidatorFactory != null) {
                DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.validation.factory", "jakarta.persistence.validation.factory");
            }
            this.withValidatorFactory(legacyValidatorFactory);
        } else {
            this.withValidatorFactory(validatorFactory);
        }
    }

    private void setupEnhancement(PersistenceUnitDescriptor persistenceUnit, MetadataSources metadataSources) {
        boolean dirtyTrackingEnabled = this.readBooleanConfigurationValueDefaultTrue("hibernate.enhancer.enableDirtyTracking");
        boolean lazyInitializationEnabled = this.readBooleanConfigurationValueDefaultTrue("hibernate.enhancer.enableLazyInitialization");
        boolean associationManagementEnabled = this.readBooleanConfigurationValue("hibernate.enhancer.enableAssociationManagement");
        if (!lazyInitializationEnabled) {
            DeprecationLogger.DEPRECATION_LOGGER.deprecatedSettingForRemoval("hibernate.enhancer.enableLazyInitialization", "true");
        }
        if (!dirtyTrackingEnabled) {
            DeprecationLogger.DEPRECATION_LOGGER.deprecatedSettingForRemoval("hibernate.enhancer.enableDirtyTracking", "true");
        }
        if (dirtyTrackingEnabled || lazyInitializationEnabled || associationManagementEnabled) {
            EnhancementContext enhancementContext = this.getEnhancementContext(dirtyTrackingEnabled, lazyInitializationEnabled, associationManagementEnabled);
            persistenceUnit.pushClassTransformer(enhancementContext);
            ClassTransformer classTransformer = persistenceUnit.getClassTransformer();
            if (classTransformer != null) {
                ClassLoader classLoader = persistenceUnit.getTempClassLoader();
                if (classLoader == null) {
                    throw new PersistenceException("Enhancement requires a temp class loader, but none was given" + this.exceptionHeader());
                }
                EntityManagerFactoryBuilderImpl.discoverTypesToTransform(metadataSources, classTransformer, classLoader);
            }
        }
    }

    private static void discoverTypesToTransform(MetadataSources metadataSources, ClassTransformer classTransformer, ClassLoader classLoader) {
        for (Binding<JaxbHbmHibernateMapping> binding : metadataSources.getHbmXmlBindings()) {
            JaxbHbmHibernateMapping hibernateMapping = binding.getRoot();
            String packageName = hibernateMapping.getPackage();
            for (JaxbHbmRootEntityType clazz : hibernateMapping.getClazz()) {
                String className = packageName == null || packageName.isEmpty() ? clazz.getName() : packageName + "." + clazz.getName();
                try {
                    classTransformer.discoverTypes(classLoader, className);
                }
                catch (EnhancementException ex) {
                    log.enhancementDiscoveryFailed(className, (Throwable)((Object)ex));
                }
            }
        }
        for (String string : metadataSources.getAnnotatedClassNames()) {
            classTransformer.discoverTypes(classLoader, string);
        }
        for (Class clazz : metadataSources.getAnnotatedClasses()) {
            classTransformer.discoverTypes(classLoader, clazz.getName());
        }
    }

    private boolean readBooleanConfigurationValueDefaultTrue(String propertyName) {
        Object propertyValue = this.configurationValues.remove(propertyName);
        return propertyValue == null || Boolean.parseBoolean(propertyValue.toString());
    }

    protected StandardServiceRegistryBuilder getStandardServiceRegistryBuilder(BootstrapServiceRegistry bsr) {
        return StandardServiceRegistryBuilder.forJpa(bsr);
    }

    private void applyMetadataBuilderContributor() {
        MetadataBuilderContributor metadataBuilderContributor;
        Object metadataBuilderContributorSetting = this.configurationValues.get(METADATA_BUILDER_CONTRIBUTOR);
        if (metadataBuilderContributorSetting != null && (metadataBuilderContributor = this.loadSettingInstance(METADATA_BUILDER_CONTRIBUTOR, metadataBuilderContributorSetting, MetadataBuilderContributor.class)) != null) {
            metadataBuilderContributor.contribute(this.metamodelBuilder);
        }
        this.metamodelBuilder.getBootstrapContext().getServiceRegistry().requireService(ClassLoaderService.class).loadJavaServices(MetadataBuilderContributor.class).forEach(contributor -> contributor.contribute(this.metamodelBuilder));
    }

    public Map<Object, Object> getConfigurationValues() {
        return Collections.unmodifiableMap(this.configurationValues);
    }

    private boolean readBooleanConfigurationValue(String propertyName) {
        Object propertyValue = this.configurationValues.remove(propertyName);
        return propertyValue != null && Boolean.parseBoolean(propertyValue.toString());
    }

    protected EnhancementContext getEnhancementContext(final boolean dirtyTrackingEnabled, final boolean lazyInitializationEnabled, final boolean associationManagementEnabled) {
        return new DefaultEnhancementContext(){

            @Override
            public boolean isEntityClass(UnloadedClass classDescriptor) {
                return EntityManagerFactoryBuilderImpl.this.managedResources.getAnnotatedClassNames().contains(classDescriptor.getName()) && super.isEntityClass(classDescriptor);
            }

            @Override
            public boolean isCompositeClass(UnloadedClass classDescriptor) {
                return EntityManagerFactoryBuilderImpl.this.managedResources.getAnnotatedClassNames().contains(classDescriptor.getName()) && super.isCompositeClass(classDescriptor);
            }

            @Override
            public boolean doBiDirectionalAssociationManagement(UnloadedField field) {
                return associationManagementEnabled;
            }

            @Override
            public boolean doDirtyCheckingInline(UnloadedClass classDescriptor) {
                return dirtyTrackingEnabled;
            }

            @Override
            public boolean hasLazyLoadableAttributes(UnloadedClass classDescriptor) {
                return lazyInitializationEnabled;
            }

            @Override
            public boolean isLazyLoadable(UnloadedField field) {
                return lazyInitializationEnabled;
            }

            @Override
            public boolean doExtendedEnhancement(UnloadedClass classDescriptor) {
                return false;
            }
        };
    }

    private BootstrapServiceRegistry buildBootstrapServiceRegistry(Map<?, ?> integrationSettings, ClassLoader providedClassLoader, ClassLoaderService providedClassLoaderService) {
        BootstrapServiceRegistryBuilder builder = new BootstrapServiceRegistryBuilder();
        this.applyIntegrationProvider(integrationSettings, builder);
        StrategyRegistrationProviderList strategyRegistrationProviderList = (StrategyRegistrationProviderList)integrationSettings.get(STRATEGY_REGISTRATION_PROVIDERS);
        if (strategyRegistrationProviderList != null) {
            for (StrategyRegistrationProvider strategyRegistrationProvider : strategyRegistrationProviderList.getStrategyRegistrationProviders()) {
                builder.applyStrategySelectors(strategyRegistrationProvider);
            }
        }
        this.configureClassLoading(integrationSettings, providedClassLoader, providedClassLoaderService, builder);
        return builder.build();
    }

    private void configureClassLoading(Map<?, ?> integrationSettings, ClassLoader providedClassLoader, ClassLoaderService providedClassLoaderService, BootstrapServiceRegistryBuilder registryBuilder) {
        if (providedClassLoaderService != null) {
            registryBuilder.applyClassLoaderService(providedClassLoaderService);
        } else {
            TcclLookupPrecedence tcclLookupPrecedence;
            if (this.persistenceUnit.getClassLoader() != null) {
                registryBuilder.applyClassLoader(this.persistenceUnit.getClassLoader());
            }
            if (providedClassLoader != null) {
                registryBuilder.applyClassLoader(providedClassLoader);
            }
            EntityManagerFactoryBuilderImpl.applyConfiguredClassLoaders(integrationSettings, registryBuilder);
            Properties puProperties = this.persistenceUnit.getProperties();
            if (puProperties != null && (tcclLookupPrecedence = TcclLookupPrecedence.from(puProperties)) != null) {
                registryBuilder.applyTcclLookupPrecedence(tcclLookupPrecedence);
            }
        }
    }

    private static void applyConfiguredClassLoaders(Map<?, ?> integrationSettings, BootstrapServiceRegistryBuilder registryBuilder) {
        Object classLoadersSetting = integrationSettings.get("hibernate.classLoaders");
        if (classLoadersSetting != null) {
            if (classLoadersSetting instanceof Collection) {
                Collection classLoaders = (Collection)classLoadersSetting;
                for (ClassLoader classLoader : classLoaders) {
                    registryBuilder.applyClassLoader(classLoader);
                }
            } else if (classLoadersSetting.getClass().isArray()) {
                for (ClassLoader classLoader : (ClassLoader[])classLoadersSetting) {
                    registryBuilder.applyClassLoader(classLoader);
                }
            } else if (classLoadersSetting instanceof ClassLoader) {
                ClassLoader classLoader = (ClassLoader)classLoadersSetting;
                registryBuilder.applyClassLoader(classLoader);
            }
        }
    }

    private void applyIntegrationProvider(Map<?, ?> integrationSettings, BootstrapServiceRegistryBuilder registryBuilder) {
        IntegratorProvider integratorProvider;
        Object integrationSetting = integrationSettings.get(INTEGRATOR_PROVIDER);
        if (integrationSetting != null && (integratorProvider = this.loadSettingInstance(INTEGRATOR_PROVIDER, integrationSetting, IntegratorProvider.class)) != null) {
            for (Integrator integrator : integratorProvider.getIntegrators()) {
                registryBuilder.applyIntegrator(integrator);
            }
        }
    }

    private MergedSettings mergeSettings(PersistenceUnitDescriptor persistenceUnit, Map<String, Object> integrationSettings, StandardServiceRegistryBuilder registryBuilder, Consumer<MergedSettings> mergedSettingsBaseline) {
        MergedSettings mergedSettings = new MergedSettings();
        if (mergedSettingsBaseline != null) {
            mergedSettingsBaseline.accept(mergedSettings);
        }
        mergedSettings.processPersistenceUnitDescriptorProperties(persistenceUnit);
        String cfgXmlResourceName = EntityManagerFactoryBuilderImpl.getCfgXmlResourceName(integrationSettings, mergedSettings);
        if (StringHelper.isNotEmpty(cfgXmlResourceName)) {
            this.processHibernateConfigXmlResources(registryBuilder, mergedSettings, cfgXmlResourceName);
        }
        this.normalizeSettings(persistenceUnit, integrationSettings, mergedSettings);
        Iterator<Map.Entry<String, Object>> iterator = mergedSettings.getConfigurationValues().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            if (entry.getValue() == null) {
                iterator.remove();
                break;
            }
            Object object = entry.getValue();
            if (!(object instanceof String)) continue;
            String valueString = (String)object;
            this.handleCacheRegionDefinition(valueString, entry.getKey(), mergedSettings);
        }
        return mergedSettings;
    }

    private void handleCacheRegionDefinition(String valueString, String keyString, MergedSettings mergedSettings) {
        if (keyString.startsWith("hibernate.classcache")) {
            mergedSettings.addCacheRegionDefinition(this.parseCacheRegionDefinitionEntry(keyString.substring("hibernate.classcache".length() + 1), valueString, CacheRegionDefinition.CacheRegionType.ENTITY));
        } else if (keyString.startsWith("hibernate.collectioncache")) {
            mergedSettings.addCacheRegionDefinition(this.parseCacheRegionDefinitionEntry(keyString.substring("hibernate.collectioncache".length() + 1), valueString, CacheRegionDefinition.CacheRegionType.COLLECTION));
        }
    }

    private static String getCfgXmlResourceName(Map<String, Object> integrationSettings, MergedSettings mergedSettings) {
        String cfgXmlResourceName = (String)mergedSettings.getConfigurationValues().remove("hibernate.cfg_xml_file");
        if (StringHelper.isEmpty(cfgXmlResourceName)) {
            return (String)integrationSettings.get("hibernate.cfg_xml_file");
        }
        return cfgXmlResourceName;
    }

    private void normalizeSettings(PersistenceUnitDescriptor persistenceUnit, Map<String, Object> integrationSettings, MergedSettings mergedSettings) {
        HashMap<String, Object> integrationSettingsCopy = new HashMap<String, Object>(integrationSettings);
        this.normalizeConnectionAccessUserAndPass(integrationSettingsCopy, mergedSettings);
        this.normalizeTransactionCoordinator(persistenceUnit, integrationSettingsCopy, mergedSettings);
        this.normalizeDataAccess(integrationSettingsCopy, mergedSettings, persistenceUnit);
        EntityManagerFactoryBuilderImpl.normalizeValidationMode(persistenceUnit, integrationSettingsCopy, mergedSettings);
        EntityManagerFactoryBuilderImpl.normalizeSharedCacheMode(persistenceUnit, integrationSettingsCopy, mergedSettings);
        for (Map.Entry entry : integrationSettingsCopy.entrySet()) {
            String key = (String)entry.getKey();
            if (key == null) continue;
            Object value = entry.getValue();
            if (value == null) {
                mergedSettings.getConfigurationValues().remove(key);
                continue;
            }
            mergedSettings.getConfigurationValues().put(key, value);
        }
    }

    private static void normalizeSharedCacheMode(PersistenceUnitDescriptor persistenceUnit, Map<String, Object> integrationSettingsCopy, MergedSettings mergedSettings) {
        Map<String, Object> configurationSettings = mergedSettings.getConfigurationValues();
        Object intgCacheMode = integrationSettingsCopy.remove("javax.persistence.sharedCache.mode");
        Object jakartaIntgCacheMode = integrationSettingsCopy.remove("jakarta.persistence.sharedCache.mode");
        if (jakartaIntgCacheMode != null) {
            configurationSettings.put("jakarta.persistence.sharedCache.mode", jakartaIntgCacheMode);
        } else if (intgCacheMode != null) {
            DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.sharedCache.mode", "jakarta.persistence.sharedCache.mode");
            configurationSettings.put("javax.persistence.sharedCache.mode", intgCacheMode);
        } else if (persistenceUnit.getSharedCacheMode() != null) {
            configurationSettings.put("jakarta.persistence.sharedCache.mode", persistenceUnit.getSharedCacheMode());
        }
    }

    private static void normalizeValidationMode(PersistenceUnitDescriptor persistenceUnit, Map<String, Object> integrationSettingsCopy, MergedSettings mergedSettings) {
        Map<String, Object> configurationSettings = mergedSettings.getConfigurationValues();
        Object intgValidationMode = integrationSettingsCopy.remove("javax.persistence.validation.mode");
        Object jakartaIntgValidationMode = integrationSettingsCopy.remove("jakarta.persistence.validation.mode");
        if (jakartaIntgValidationMode != null) {
            configurationSettings.put("jakarta.persistence.validation.mode", jakartaIntgValidationMode);
        } else if (intgValidationMode != null) {
            DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.validation.mode", "jakarta.persistence.validation.mode");
            configurationSettings.put("javax.persistence.validation.mode", intgValidationMode);
        } else if (persistenceUnit.getValidationMode() != null) {
            configurationSettings.put("jakarta.persistence.validation.mode", persistenceUnit.getValidationMode());
        }
    }

    private void normalizeConnectionAccessUserAndPass(Map<?, ?> integrationSettingsCopy, MergedSettings mergedSettings) {
        Object effectiveUser = NullnessHelper.coalesceSuppliedValues(() -> integrationSettingsCopy.remove("hibernate.connection.username"), () -> integrationSettingsCopy.remove("jakarta.persistence.jdbc.user"), () -> {
            Object setting = integrationSettingsCopy.remove("javax.persistence.jdbc.user");
            if (setting != null) {
                DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.jdbc.user", "jakarta.persistence.jdbc.user");
            }
            return setting;
        }, () -> this.extractPuProperty(this.persistenceUnit, "hibernate.connection.username"), () -> this.extractPuProperty(this.persistenceUnit, "jakarta.persistence.jdbc.user"), () -> {
            Object setting = this.extractPuProperty(this.persistenceUnit, "javax.persistence.jdbc.user");
            if (setting != null) {
                DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.jdbc.user", "jakarta.persistence.jdbc.user");
            }
            return setting;
        });
        Object effectivePass = NullnessHelper.coalesceSuppliedValues(() -> integrationSettingsCopy.remove("hibernate.connection.password"), () -> integrationSettingsCopy.remove("jakarta.persistence.jdbc.password"), () -> {
            Object setting = integrationSettingsCopy.remove("javax.persistence.jdbc.password");
            if (setting != null) {
                DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.jdbc.password", "jakarta.persistence.jdbc.password");
            }
            return setting;
        }, () -> this.extractPuProperty(this.persistenceUnit, "hibernate.connection.password"), () -> this.extractPuProperty(this.persistenceUnit, "jakarta.persistence.jdbc.password"), () -> {
            Object setting = this.extractPuProperty(this.persistenceUnit, "javax.persistence.jdbc.password");
            if (setting != null) {
                DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.jdbc.password", "jakarta.persistence.jdbc.password");
            }
            return setting;
        });
        if (effectiveUser != null || effectivePass != null) {
            this.applyUserAndPass(effectiveUser, effectivePass, mergedSettings);
        }
    }

    private <T> T extractPuProperty(PersistenceUnitDescriptor persistenceUnit, String propertyName) {
        Properties properties = persistenceUnit.getProperties();
        return (T)(properties == null ? null : properties.get(propertyName));
    }

    private void applyUserAndPass(Object effectiveUser, Object effectivePass, MergedSettings mergedSettings) {
        Map<String, Object> configuration = mergedSettings.getConfigurationValues();
        if (effectiveUser != null) {
            configuration.put("hibernate.connection.username", effectiveUser);
            configuration.put("jakarta.persistence.jdbc.user", effectiveUser);
            configuration.put("javax.persistence.jdbc.user", effectiveUser);
        }
        if (effectivePass != null) {
            configuration.put("hibernate.connection.password", effectivePass);
            configuration.put("jakarta.persistence.jdbc.password", effectivePass);
            configuration.put("javax.persistence.jdbc.password", effectivePass);
        }
    }

    private void normalizeTransactionCoordinator(PersistenceUnitDescriptor persistenceUnit, Map<?, ?> integrationSettingsCopy, MergedSettings mergedSettings) {
        PersistenceUnitTransactionType txnType = EntityManagerFactoryBuilderImpl.determineTransactionType(persistenceUnit, integrationSettingsCopy, mergedSettings);
        boolean definiteJtaCoordinator = mergedSettings.getConfigurationValues().containsKey("hibernate.transaction.coordinator_class") ? EntityManagerFactoryBuilderImpl.handeTransactionCoordinatorStrategy(mergedSettings) : EntityManagerFactoryBuilderImpl.handleTransactionType(mergedSettings, txnType);
        mergedSettings.getConfigurationValues().put(IS_JTA_TXN_COORD, definiteJtaCoordinator);
    }

    private static boolean handeTransactionCoordinatorStrategy(MergedSettings mergedSettings) {
        TransactionCoordinatorBuilder transactionCoordinatorBuilder;
        log.overridingTransactionStrategyDangerous("hibernate.transaction.coordinator_class");
        Object strategy = mergedSettings.getConfigurationValues().get("hibernate.transaction.coordinator_class");
        boolean definiteJtaCoordinator = strategy instanceof TransactionCoordinatorBuilder && (transactionCoordinatorBuilder = (TransactionCoordinatorBuilder)strategy).isJta();
        return definiteJtaCoordinator;
    }

    private static boolean handleTransactionType(MergedSettings mergedSettings, PersistenceUnitTransactionType txnType) {
        switch (txnType) {
            case JTA: {
                mergedSettings.getConfigurationValues().put("hibernate.transaction.coordinator_class", JtaTransactionCoordinatorBuilderImpl.class);
                return true;
            }
            case RESOURCE_LOCAL: {
                mergedSettings.getConfigurationValues().put("hibernate.transaction.coordinator_class", JdbcResourceLocalTransactionCoordinatorBuilderImpl.class);
                return false;
            }
        }
        throw new IllegalStateException("Could not determine TransactionCoordinator strategy to use");
    }

    private static PersistenceUnitTransactionType determineTransactionType(PersistenceUnitDescriptor persistenceUnit, Map<?, ?> integrationSettingsCopy, MergedSettings mergedSettings) {
        Object intgTxnType = integrationSettingsCopy.remove("jakarta.persistence.transactionType");
        if (intgTxnType == null && (intgTxnType = integrationSettingsCopy.remove("javax.persistence.transactionType")) != null) {
            DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.transactionType", "jakarta.persistence.transactionType");
        }
        PersistenceUnitTransactionType txnType = null;
        if (intgTxnType != null) {
            txnType = PersistenceUnitTransactionTypeHelper.interpretTransactionType(intgTxnType);
        } else if (persistenceUnit.getPersistenceUnitTransactionType() != null) {
            txnType = persistenceUnit.getPersistenceUnitTransactionType();
        } else {
            Object puPropTxnType = mergedSettings.getConfigurationValues().get("jakarta.persistence.transactionType");
            if (puPropTxnType == null && (puPropTxnType = mergedSettings.getConfigurationValues().get("javax.persistence.transactionType")) != null) {
                DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.transactionType", "jakarta.persistence.transactionType");
            }
            if (puPropTxnType != null) {
                txnType = PersistenceUnitTransactionTypeHelper.interpretTransactionType(puPropTxnType);
            }
        }
        if (txnType == null) {
            log.debug("PersistenceUnitTransactionType not specified - falling back to RESOURCE_LOCAL");
            txnType = PersistenceUnitTransactionType.RESOURCE_LOCAL;
        }
        return txnType;
    }

    private void normalizeDataAccess(Map<?, ?> integrationSettingsCopy, MergedSettings mergedSettings, PersistenceUnitDescriptor persistenceUnit) {
        String stringUrl;
        Object url;
        Object integrationJdbcUrl;
        Object dataSourceRef;
        if (this.dataSource != null) {
            this.applyDataSource(this.dataSource, null, integrationSettingsCopy, mergedSettings);
            return;
        }
        if (integrationSettingsCopy.containsKey("hibernate.connection.datasource") && (dataSourceRef = integrationSettingsCopy.remove("hibernate.connection.datasource")) != null) {
            this.applyDataSource(dataSourceRef, null, integrationSettingsCopy, mergedSettings);
            return;
        }
        if (integrationSettingsCopy.containsKey("jakarta.persistence.jtaDataSource") && (dataSourceRef = integrationSettingsCopy.remove("jakarta.persistence.jtaDataSource")) != null) {
            this.applyDataSource(dataSourceRef, true, integrationSettingsCopy, mergedSettings);
            return;
        }
        if (integrationSettingsCopy.containsKey("javax.persistence.jtaDataSource")) {
            DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.jtaDataSource", "jakarta.persistence.jtaDataSource");
            dataSourceRef = integrationSettingsCopy.remove("javax.persistence.jtaDataSource");
            if (dataSourceRef != null) {
                this.applyDataSource(dataSourceRef, true, integrationSettingsCopy, mergedSettings);
                return;
            }
        }
        if (integrationSettingsCopy.containsKey("jakarta.persistence.nonJtaDataSource")) {
            dataSourceRef = integrationSettingsCopy.remove("jakarta.persistence.nonJtaDataSource");
            this.applyDataSource(dataSourceRef, false, integrationSettingsCopy, mergedSettings);
            return;
        }
        if (integrationSettingsCopy.containsKey("javax.persistence.nonJtaDataSource")) {
            DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.nonJtaDataSource", "jakarta.persistence.nonJtaDataSource");
            dataSourceRef = integrationSettingsCopy.remove("javax.persistence.nonJtaDataSource");
            this.applyDataSource(dataSourceRef, false, integrationSettingsCopy, mergedSettings);
            return;
        }
        if (integrationSettingsCopy.containsKey("hibernate.connection.url") && (integrationJdbcUrl = integrationSettingsCopy.get("hibernate.connection.url")) != null) {
            this.applyJdbcSettings(integrationJdbcUrl, (String)NullnessHelper.coalesceSuppliedValues(() -> ConfigurationHelper.getString("hibernate.connection.driver_class", integrationSettingsCopy), () -> ConfigurationHelper.getString("jakarta.persistence.jdbc.driver", integrationSettingsCopy), () -> {
                String driver = ConfigurationHelper.getString("javax.persistence.jdbc.driver", integrationSettingsCopy);
                if (driver != null) {
                    DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.jdbc.driver", "jakarta.persistence.jdbc.driver");
                }
                return driver;
            }, () -> ConfigurationHelper.getString("hibernate.connection.driver_class", mergedSettings.getConfigurationValues()), () -> ConfigurationHelper.getString("jakarta.persistence.jdbc.driver", mergedSettings.getConfigurationValues()), () -> {
                String driver = ConfigurationHelper.getString("javax.persistence.jdbc.driver", mergedSettings.getConfigurationValues());
                if (driver != null) {
                    DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.jdbc.driver", "jakarta.persistence.jdbc.driver");
                }
                return driver;
            }), integrationSettingsCopy, mergedSettings);
            return;
        }
        if (integrationSettingsCopy.containsKey("jakarta.persistence.jdbc.url") && (integrationJdbcUrl = integrationSettingsCopy.get("jakarta.persistence.jdbc.url")) != null) {
            this.applyJdbcSettings(integrationJdbcUrl, (String)NullnessHelper.coalesceSuppliedValues(() -> ConfigurationHelper.getString("jakarta.persistence.jdbc.driver", integrationSettingsCopy), () -> ConfigurationHelper.getString("jakarta.persistence.jdbc.driver", mergedSettings.getConfigurationValues())), integrationSettingsCopy, mergedSettings);
            return;
        }
        if (integrationSettingsCopy.containsKey("javax.persistence.jdbc.url")) {
            DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.jdbc.url", "jakarta.persistence.jdbc.url");
            integrationJdbcUrl = integrationSettingsCopy.get("javax.persistence.jdbc.url");
            if (integrationJdbcUrl != null) {
                this.applyJdbcSettings(integrationJdbcUrl, (String)NullnessHelper.coalesceSuppliedValues(() -> {
                    String driver = ConfigurationHelper.getString("javax.persistence.jdbc.driver", integrationSettingsCopy);
                    if (driver != null) {
                        DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.jdbc.driver", "jakarta.persistence.jdbc.driver");
                    }
                    return driver;
                }, () -> {
                    String driver = ConfigurationHelper.getString("javax.persistence.jdbc.driver", mergedSettings.getConfigurationValues());
                    if (driver != null) {
                        DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.jdbc.driver", "jakarta.persistence.jdbc.driver");
                    }
                    return driver;
                }), integrationSettingsCopy, mergedSettings);
                return;
            }
        }
        if (persistenceUnit.getJtaDataSource() != null) {
            this.applyDataSource(persistenceUnit.getJtaDataSource(), true, integrationSettingsCopy, mergedSettings);
            return;
        }
        if (persistenceUnit.getNonJtaDataSource() != null) {
            this.applyDataSource(persistenceUnit.getNonJtaDataSource(), false, integrationSettingsCopy, mergedSettings);
            return;
        }
        if (mergedSettings.getConfigurationValues().containsKey("hibernate.connection.url") && (url = mergedSettings.getConfigurationValues().get("hibernate.connection.url")) != null && (!(url instanceof String) || StringHelper.isNotEmpty(stringUrl = (String)url))) {
            this.applyJdbcSettings(url, ConfigurationHelper.getString("hibernate.connection.driver_class", mergedSettings.getConfigurationValues()), integrationSettingsCopy, mergedSettings);
            return;
        }
        if (mergedSettings.getConfigurationValues().containsKey("jakarta.persistence.jdbc.url") && (url = mergedSettings.getConfigurationValues().get("jakarta.persistence.jdbc.url")) != null && (!(url instanceof String) || StringHelper.isNotEmpty(stringUrl = (String)url))) {
            this.applyJdbcSettings(url, ConfigurationHelper.getString("jakarta.persistence.jdbc.driver", mergedSettings.getConfigurationValues()), integrationSettingsCopy, mergedSettings);
            return;
        }
        if (mergedSettings.getConfigurationValues().containsKey("javax.persistence.jdbc.url")) {
            DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.jdbc.url", "jakarta.persistence.jdbc.url");
            url = mergedSettings.getConfigurationValues().get("javax.persistence.jdbc.url");
            if (url != null && (!(url instanceof String) || StringHelper.isNotEmpty(stringUrl = (String)url))) {
                String driver = ConfigurationHelper.getString("javax.persistence.jdbc.driver", mergedSettings.getConfigurationValues());
                if (driver != null) {
                    DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.jdbc.driver", "jakarta.persistence.jdbc.driver");
                }
                this.applyJdbcSettings(url, driver, integrationSettingsCopy, mergedSettings);
                return;
            }
        }
    }

    private void applyDataSource(Object dataSourceRef, Boolean useJtaDataSource, Map<?, ?> integrationSettingsCopy, MergedSettings mergedSettings) {
        String jakartaInverseEmfKey;
        String inverseEmfKey;
        String jakartaEmfKey;
        String emfKey;
        boolean isJta;
        boolean isJtaTransactionCoordinator = (Boolean)mergedSettings.getConfigurationValues().remove(IS_JTA_TXN_COORD);
        boolean bl = isJta = useJtaDataSource == null ? isJtaTransactionCoordinator : useJtaDataSource;
        if (isJta) {
            emfKey = "javax.persistence.jtaDataSource";
            jakartaEmfKey = "jakarta.persistence.jtaDataSource";
            inverseEmfKey = "javax.persistence.nonJtaDataSource";
            jakartaInverseEmfKey = "jakarta.persistence.nonJtaDataSource";
        } else {
            emfKey = "javax.persistence.nonJtaDataSource";
            jakartaEmfKey = "jakarta.persistence.nonJtaDataSource";
            inverseEmfKey = "javax.persistence.jtaDataSource";
            jakartaInverseEmfKey = "jakarta.persistence.jtaDataSource";
        }
        mergedSettings.getConfigurationValues().put(emfKey, dataSourceRef);
        mergedSettings.getConfigurationValues().put(jakartaEmfKey, dataSourceRef);
        this.cleanUpConfigKeys(integrationSettingsCopy, mergedSettings, inverseEmfKey, jakartaInverseEmfKey, "javax.persistence.jdbc.driver", "jakarta.persistence.jdbc.driver", "hibernate.connection.driver_class", "javax.persistence.jdbc.url", "jakarta.persistence.jdbc.url", "hibernate.connection.url");
        this.cleanUpConfigKeys(integrationSettingsCopy, "hibernate.connection.datasource", "javax.persistence.jtaDataSource", "jakarta.persistence.jtaDataSource", "javax.persistence.nonJtaDataSource", "jakarta.persistence.nonJtaDataSource");
        mergedSettings.getConfigurationValues().put("hibernate.connection.datasource", dataSourceRef);
    }

    private void cleanUpConfigKeys(Map<?, ?> integrationSettingsCopy, MergedSettings mergedSettings, String ... keys) {
        for (String key : keys) {
            Object removedMergedSetting;
            Object removedSetting = integrationSettingsCopy.remove(key);
            if (removedSetting != null) {
                log.debugf("Removed integration override setting [%s] due to normalization", key);
            }
            if ((removedMergedSetting = mergedSettings.getConfigurationValues().remove(key)) == null) continue;
            log.debugf("Removed merged setting [%s] due to normalization", key);
        }
    }

    private void cleanUpConfigKeys(Map<?, ?> settings, String ... keys) {
        for (String key : keys) {
            settings.remove(key);
        }
    }

    private void applyJdbcSettings(Object url, String driver, Map<?, ?> integrationSettingsCopy, MergedSettings mergedSettings) {
        mergedSettings.getConfigurationValues().put("hibernate.connection.url", url);
        mergedSettings.getConfigurationValues().put("javax.persistence.jdbc.url", url);
        mergedSettings.getConfigurationValues().put("jakarta.persistence.jdbc.url", url);
        if (driver != null) {
            mergedSettings.getConfigurationValues().put("hibernate.connection.driver_class", driver);
            mergedSettings.getConfigurationValues().put("javax.persistence.jdbc.driver", driver);
            mergedSettings.getConfigurationValues().put("jakarta.persistence.jdbc.driver", driver);
        } else {
            mergedSettings.getConfigurationValues().remove("hibernate.connection.driver_class");
            mergedSettings.getConfigurationValues().remove("javax.persistence.jdbc.driver");
            mergedSettings.getConfigurationValues().remove("jakarta.persistence.jdbc.driver");
        }
        this.cleanUpConfigKeys(integrationSettingsCopy, "hibernate.connection.driver_class", "javax.persistence.jdbc.driver", "jakarta.persistence.jdbc.driver", "hibernate.connection.url", "javax.persistence.jdbc.url", "jakarta.persistence.jdbc.url", "hibernate.connection.username", "javax.persistence.jdbc.user", "jakarta.persistence.jdbc.user", "hibernate.connection.password", "javax.persistence.jdbc.password", "jakarta.persistence.jdbc.password");
        this.cleanUpConfigKeys(integrationSettingsCopy, mergedSettings, "hibernate.connection.datasource", "javax.persistence.jtaDataSource", "jakarta.persistence.jtaDataSource", "javax.persistence.nonJtaDataSource", "jakarta.persistence.nonJtaDataSource");
    }

    private void processHibernateConfigXmlResources(StandardServiceRegistryBuilder serviceRegistryBuilder, MergedSettings mergedSettings, String cfgXmlResourceName) {
        LoadedConfig loadedConfig = serviceRegistryBuilder.getConfigLoader().loadConfigXmlResource(cfgXmlResourceName);
        mergedSettings.processHibernateConfigXmlResources(loadedConfig);
        serviceRegistryBuilder.getAggregatedCfgXml().merge(loadedConfig);
    }

    private CacheRegionDefinition parseCacheRegionDefinitionEntry(String role, String value, CacheRegionDefinition.CacheRegionType cacheType) {
        StringTokenizer params = new StringTokenizer(value, ";, ");
        if (!params.hasMoreTokens()) {
            throw this.illegalCacheRegionDefinitionException(role, value, cacheType);
        }
        String usage = params.nextToken();
        String region = params.hasMoreTokens() ? params.nextToken() : null;
        boolean lazyProperty = cacheType == CacheRegionDefinition.CacheRegionType.ENTITY && (!params.hasMoreTokens() || "all".equalsIgnoreCase(params.nextToken()));
        return new CacheRegionDefinition(cacheType, role, usage, region, lazyProperty);
    }

    private PersistenceException illegalCacheRegionDefinitionException(String role, String value, CacheRegionDefinition.CacheRegionType cacheType) {
        StringBuilder message = new StringBuilder("Cache region configuration '").append(cacheType == CacheRegionDefinition.CacheRegionType.ENTITY ? "hibernate.classcache" : "hibernate.collectioncache").append('.').append(role).append(' ').append(value).append("' not of form 'usage[,region[,lazy]]' ").append(this.exceptionHeader());
        return new PersistenceException(message.toString());
    }

    private List<ConverterDescriptor> applyMappingResources(MetadataSources metadataSources) {
        List explicitOrmXmlList;
        String explicitHbmXmls;
        ArrayList<ClassBasedConverterDescriptor> converterDescriptors = null;
        List loadedAnnotatedClasses = (List)this.configurationValues.remove("hibernate.loaded_classes");
        if (loadedAnnotatedClasses != null) {
            for (String[] cls : loadedAnnotatedClasses) {
                if (AttributeConverter.class.isAssignableFrom((Class<?>)cls)) {
                    if (converterDescriptors == null) {
                        converterDescriptors = new ArrayList<ClassBasedConverterDescriptor>();
                    }
                    ClassmateContext classmateContext = this.metamodelBuilder.getBootstrapContext().getClassmateContext();
                    converterDescriptors.add(new ClassBasedConverterDescriptor((Class<? extends AttributeConverter<?, ?>>)cls, classmateContext));
                    continue;
                }
                metadataSources.addAnnotatedClass((Class<?>)cls);
            }
        }
        if ((explicitHbmXmls = (String)this.configurationValues.remove("hibernate.hbm_xml_files")) != null) {
            for (String hbmXml : StringHelper.split(", ", explicitHbmXmls)) {
                metadataSources.addResource(hbmXml);
            }
        }
        if ((explicitOrmXmlList = (List)this.configurationValues.remove("hibernate.orm_xml_files")) != null) {
            explicitOrmXmlList.forEach(metadataSources::addResource);
        }
        return converterDescriptors;
    }

    private void applyMetamodelBuilderSettings(MergedSettings mergedSettings, List<ConverterDescriptor> converterDescriptors) {
        this.metamodelBuilder.getBootstrapContext().markAsJpaBootstrap();
        if (this.persistenceUnit.getTempClassLoader() != null) {
            this.metamodelBuilder.applyTempClassLoader(this.persistenceUnit.getTempClassLoader());
        }
        this.metamodelBuilder.applyScanEnvironment(new StandardJpaScanEnvironmentImpl(this.persistenceUnit));
        this.metamodelBuilder.applyScanOptions(new StandardScanOptions((String)this.configurationValues.get("hibernate.archive.autodetection"), this.persistenceUnit.isExcludeUnlistedClasses()));
        List<CacheRegionDefinition> cacheRegionDefinitions = mergedSettings.getCacheRegionDefinitions();
        if (cacheRegionDefinitions != null) {
            cacheRegionDefinitions.forEach(this.metamodelBuilder::applyCacheRegionDefinition);
        }
        this.applyTypeContributors();
        if (converterDescriptors != null) {
            converterDescriptors.forEach(this.metamodelBuilder::applyAttributeConverter);
        }
    }

    private void applyTypeContributors() {
        TypeContributorList typeContributorList = (TypeContributorList)this.configurationValues.remove(TYPE_CONTRIBUTORS);
        if (typeContributorList != null) {
            typeContributorList.getTypeContributors().forEach(this.metamodelBuilder::applyTypes);
        }
        this.metamodelBuilder.getBootstrapContext().getServiceRegistry().requireService(ClassLoaderService.class).loadJavaServices(TypeContributor.class).forEach(this.metamodelBuilder::applyTypes);
    }

    public MetadataImplementor getMetadata() {
        return this.metadata;
    }

    @Override
    public ManagedResources getManagedResources() {
        return this.managedResources;
    }

    @Override
    public MetadataImplementor metadata() {
        if (this.metadata == null) {
            this.metadata = MetadataBuildingProcess.complete(this.managedResources, this.metamodelBuilder.getBootstrapContext(), this.metamodelBuilder.getMetadataBuildingOptions());
        }
        return this.metadata;
    }

    @Override
    public EntityManagerFactoryBuilder withValidatorFactory(Object validatorFactory) {
        this.validatorFactory = validatorFactory;
        if (validatorFactory != null) {
            BeanValidationIntegrator.validateFactory(validatorFactory);
        }
        return this;
    }

    @Override
    public EntityManagerFactoryBuilder withDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    @Override
    public void cancel() {
        this.cleanup();
    }

    private void cleanup() {
        StandardServiceRegistry standardServiceRegistry = this.standardServiceRegistry;
        if (standardServiceRegistry instanceof ServiceRegistryImplementor) {
            ServiceRegistryImplementor serviceRegistry = (ServiceRegistryImplementor)((Object)standardServiceRegistry);
            standardServiceRegistry = this.standardServiceRegistry;
            if (standardServiceRegistry instanceof ServiceBinding.ServiceLifecycleOwner) {
                ServiceBinding.ServiceLifecycleOwner lifecycleOwner = (ServiceBinding.ServiceLifecycleOwner)((Object)standardServiceRegistry);
                ServiceBinding<ConnectionProvider> binding = serviceRegistry.locateServiceBinding(ConnectionProvider.class);
                if (binding != null && binding.getService() instanceof Stoppable) {
                    lifecycleOwner.stopService(binding);
                    binding.setService(null);
                }
            }
        }
    }

    @Override
    public void generateSchema() {
        try {
            this.populateSessionFactoryBuilder();
            SchemaManagementToolCoordinator.process(this.metadata, this.standardServiceRegistry, this.configurationValues, DelayedDropRegistryNotAvailableImpl.INSTANCE);
        }
        catch (Exception e) {
            throw new PersistenceException("Error performing schema management " + this.exceptionHeader(), (Throwable)e);
        }
        finally {
            this.cancel();
        }
    }

    @Override
    public EntityManagerFactory build() {
        boolean success = false;
        try {
            SessionFactoryBuilder sessionFactoryBuilder = this.populateSessionFactoryBuilder();
            try {
                SessionFactory entityManagerFactory = sessionFactoryBuilder.build();
                success = true;
                SessionFactory sessionFactory = entityManagerFactory;
                return sessionFactory;
            }
            catch (Exception e) {
                throw new PersistenceException("Unable to build Hibernate SessionFactory " + this.exceptionHeader(), (Throwable)e);
            }
        }
        finally {
            if (!success) {
                this.cleanup();
            }
        }
    }

    protected SessionFactoryBuilder populateSessionFactoryBuilder() {
        SessionFactoryBuilder builder = this.metadata().getSessionFactoryBuilder();
        this.handleAllowJtaTransactionAccess(builder);
        this.addConfiguredSessionFactoryObserver(builder);
        builder.addSessionFactoryObservers(ServiceRegistryCloser.INSTANCE);
        builder.applyEntityNotFoundDelegate(JpaEntityNotFoundDelegate.INSTANCE);
        if (this.validatorFactory != null) {
            builder.applyValidatorFactory(this.validatorFactory);
        }
        return builder;
    }

    private void addConfiguredSessionFactoryObserver(SessionFactoryBuilder builder) {
        Object sessionFactoryObserverSetting = this.configurationValues.remove("hibernate.session_factory_observer");
        if (sessionFactoryObserverSetting != null) {
            SessionFactoryObserver suppliedSessionFactoryObserver = this.standardServiceRegistry.requireService(StrategySelector.class).resolveStrategy(SessionFactoryObserver.class, sessionFactoryObserverSetting);
            builder.addSessionFactoryObservers(suppliedSessionFactoryObserver);
        }
    }

    private void handleAllowJtaTransactionAccess(SessionFactoryBuilder builder) {
        boolean jtaTransactionAccessEnabled = this.readBooleanConfigurationValue("hibernate.jta.allowTransactionAccess");
        if (!jtaTransactionAccessEnabled && builder instanceof SessionFactoryBuilderImplementor) {
            SessionFactoryBuilderImplementor implementor = (SessionFactoryBuilderImplementor)builder;
            implementor.disableJtaTransactionAccess();
        }
    }

    private String exceptionHeader() {
        return " [persistence unit: " + this.persistenceUnit.getName() + "] ";
    }

    private <T> T loadSettingInstance(String settingName, Object settingValue, Class<T> clazz) {
        Class<Object> instanceClass;
        if (clazz.isAssignableFrom(settingValue.getClass())) {
            return (T)settingValue;
        }
        if (settingValue instanceof Class) {
            instanceClass = (Class<?>)settingValue;
        } else if (settingValue instanceof String) {
            String className = (String)settingValue;
            if (this.standardServiceRegistry != null) {
                instanceClass = this.standardServiceRegistry.requireService(ClassLoaderService.class).classForName(className);
            } else {
                try {
                    instanceClass = Class.forName(className);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("Can't load class: " + className, e);
                }
            }
        } else {
            throw new IllegalArgumentException("The provided " + settingName + " setting value [" + settingValue + "] is not supported");
        }
        if (instanceClass != null) {
            try {
                return instanceClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalArgumentException("The " + clazz.getSimpleName() + " class [" + instanceClass + "] could not be instantiated", e);
            }
        }
        return null;
    }

    protected StandardServiceRegistry getStandardServiceRegistry() {
        return this.standardServiceRegistry;
    }
}

