/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.hibernate.HibernateException;
import org.hibernate.Internal;
import org.hibernate.MappingException;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.engine.spi.CascadeStyles;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.generator.Generator;
import org.hibernate.generator.GeneratorCreationContext;
import org.hibernate.jpa.event.spi.CallbackDefinition;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.GeneratorCreator;
import org.hibernate.mapping.MetaAttributable;
import org.hibernate.mapping.MetaAttribute;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.SyntheticProperty;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.Value;
import org.hibernate.metamodel.RepresentationMode;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.property.access.spi.PropertyAccessStrategy;
import org.hibernate.property.access.spi.PropertyAccessStrategyResolver;
import org.hibernate.property.access.spi.Setter;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.AnyType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.ComponentType;
import org.hibernate.type.MappingContext;
import org.hibernate.type.Type;
import org.hibernate.type.WrapperArrayHandling;

public class Property
implements Serializable,
MetaAttributable {
    private String name;
    private Value value;
    private String cascade;
    private boolean updateable = true;
    private boolean insertable = true;
    private boolean selectable = true;
    private boolean optimisticLocked = true;
    private GeneratorCreator generatorCreator;
    private String propertyAccessorName;
    private PropertyAccessStrategy propertyAccessStrategy;
    private boolean lazy;
    private String lazyGroup;
    private boolean optional;
    private Map<String, MetaAttribute> metaAttributes;
    private PersistentClass persistentClass;
    private boolean naturalIdentifier;
    private boolean isGeneric;
    private boolean lob;
    private List<CallbackDefinition> callbackDefinitions;
    private String returnedClassName;

    public boolean isBackRef() {
        return false;
    }

    public boolean isSynthetic() {
        return false;
    }

    public Type getType() throws MappingException {
        return this.value.getType();
    }

    public int getColumnSpan() {
        return this.value.getColumnSpan();
    }

    public List<Selectable> getSelectables() {
        return this.value.getSelectables();
    }

    public List<Column> getColumns() {
        return this.value.getColumns();
    }

    public String getName() {
        return this.name;
    }

    public boolean isComposite() {
        return this.value instanceof Component;
    }

    public Value getValue() {
        return this.value;
    }

    public void resetUpdateable(boolean updateable) {
        this.setUpdateable(updateable);
        boolean[] columnUpdateability = this.getValue().getColumnUpdateability();
        for (int i = 0; i < this.getColumnSpan(); ++i) {
            columnUpdateability[i] = updateable;
        }
    }

    public void resetOptional(boolean optional) {
        this.setOptional(optional);
        for (Selectable selectable : this.getValue().getSelectables()) {
            if (!(selectable instanceof Column)) continue;
            Column column = (Column)selectable;
            column.setNullable(optional);
        }
    }

    public CascadeStyle getCascadeStyle() throws MappingException {
        Type type = this.value.getType();
        if (type instanceof AnyType) {
            return Property.getCascadeStyle(this.cascade);
        }
        if (type instanceof ComponentType) {
            return Property.getCompositeCascadeStyle((ComponentType)type, this.cascade);
        }
        if (type instanceof CollectionType) {
            Collection collection = (Collection)this.value;
            return Property.getCollectionCascadeStyle(collection.getElement().getType(), this.cascade);
        }
        return Property.getCascadeStyle(this.cascade);
    }

    private static CascadeStyle getCompositeCascadeStyle(ComponentType compositeType, String cascade) {
        int length = compositeType.getSubtypes().length;
        for (int i = 0; i < length; ++i) {
            if (compositeType.getCascadeStyle(i) == CascadeStyles.NONE) continue;
            return CascadeStyles.ALL;
        }
        return Property.getCascadeStyle(cascade);
    }

    private static CascadeStyle getCollectionCascadeStyle(Type elementType, String cascade) {
        if (elementType instanceof AnyType) {
            return Property.getCascadeStyle(cascade);
        }
        if (elementType instanceof ComponentType) {
            return Property.getCompositeCascadeStyle((ComponentType)elementType, cascade);
        }
        return Property.getCascadeStyle(cascade);
    }

    private static CascadeStyle getCascadeStyle(String cascade) {
        if (cascade == null || cascade.equals("none")) {
            return CascadeStyles.NONE;
        }
        StringTokenizer tokens = new StringTokenizer(cascade, ", ");
        CascadeStyle[] styles = new CascadeStyle[tokens.countTokens()];
        int i = 0;
        while (tokens.hasMoreTokens()) {
            styles[i++] = CascadeStyles.getCascadeStyle(tokens.nextToken());
        }
        return new CascadeStyles.MultipleCascadeStyle(styles);
    }

    public String getCascade() {
        return this.cascade;
    }

    public void setCascade(String cascade) {
        this.cascade = cascade;
    }

    public void setName(String name) {
        this.name = name == null ? null : name.intern();
    }

    public void setValue(Value value) {
        this.value = value;
    }

    public boolean isUpdateable() {
        return this.updateable && this.value.hasAnyUpdatableColumns();
    }

    public boolean isInsertable() {
        return this.insertable && this.value.hasAnyInsertableColumns();
    }

    @Internal
    public GeneratorCreator getValueGeneratorCreator() {
        return this.generatorCreator;
    }

    @Internal
    public void setValueGeneratorCreator(GeneratorCreator generator) {
        this.generatorCreator = generator;
    }

    public void setUpdateable(boolean mutable) {
        this.updateable = mutable;
    }

    public void setInsertable(boolean insertable) {
        this.insertable = insertable;
    }

    public String getPropertyAccessorName() {
        return this.propertyAccessorName;
    }

    public void setPropertyAccessorName(String string) {
        this.propertyAccessorName = string;
    }

    public PropertyAccessStrategy getPropertyAccessStrategy() {
        return this.propertyAccessStrategy;
    }

    public void setPropertyAccessStrategy(PropertyAccessStrategy propertyAccessStrategy) {
        this.propertyAccessStrategy = propertyAccessStrategy;
    }

    public boolean isBasicPropertyAccessor() {
        return this.propertyAccessorName == null || "property".equals(this.propertyAccessorName);
    }

    @Override
    public Map<String, MetaAttribute> getMetaAttributes() {
        return this.metaAttributes;
    }

    @Override
    public MetaAttribute getMetaAttribute(String attributeName) {
        return this.metaAttributes == null ? null : this.metaAttributes.get(attributeName);
    }

    @Override
    public void setMetaAttributes(Map<String, MetaAttribute> metas) {
        this.metaAttributes = metas;
    }

    @Deprecated(since="7.0")
    public boolean isValid(Mapping mapping) throws MappingException {
        return this.isValid((MappingContext)mapping);
    }

    public boolean isValid(MappingContext mappingContext) throws MappingException {
        Value value = this.getValue();
        if (value instanceof BasicValue && ((BasicValue)value).isDisallowedWrapperArray()) {
            throw new MappingException("The property " + this.persistentClass.getEntityName() + "#" + this.name + " uses a wrapper type Byte[]/Character[] which indicates an issue in your domain model. These types have been treated like byte[]/char[] until Hibernate 6.2 which meant that null elements were not allowed, but on JDBC were processed like VARBINARY or VARCHAR. If you don't use nulls in your arrays, change the type of the property to byte[]/char[]. To allow explicit uses of the wrapper types Byte[]/Character[] which allows null element but has a different serialization format than before Hibernate 6.2, configure the setting hibernate.type.wrapper_array_handling to the value " + WrapperArrayHandling.ALLOW + ". To revert to the legacy treatment of these types, configure the value to " + WrapperArrayHandling.LEGACY + ". For more information on this matter, consult the migration guide of Hibernate 6.2 and the Javadoc of the org.hibernate.cfg.AvailableSettings.WRAPPER_ARRAY_HANDLING field.");
        }
        return value.isValid(mappingContext);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.name + ")";
    }

    public void setLazy(boolean lazy) {
        this.lazy = lazy;
    }

    public boolean isLazy() {
        if (this.value instanceof ToOne) {
            return false;
        }
        return this.lazy;
    }

    public String getLazyGroup() {
        return this.lazyGroup;
    }

    public void setLazyGroup(String lazyGroup) {
        this.lazyGroup = lazyGroup;
    }

    public boolean isOptimisticLocked() {
        return this.optimisticLocked;
    }

    public void setOptimisticLocked(boolean optimisticLocked) {
        this.optimisticLocked = optimisticLocked;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public PersistentClass getPersistentClass() {
        return this.persistentClass;
    }

    public void setPersistentClass(PersistentClass persistentClass) {
        this.persistentClass = persistentClass;
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public void setSelectable(boolean selectable) {
        this.selectable = selectable;
    }

    @Internal
    public Getter getGetter(Class clazz) throws MappingException {
        return this.getPropertyAccessStrategy(clazz).buildPropertyAccess(clazz, this.name, true).getGetter();
    }

    @Internal
    public Setter getSetter(Class clazz) throws MappingException {
        return this.getPropertyAccessStrategy(clazz).buildPropertyAccess(clazz, this.name, true).getSetter();
    }

    @Internal
    public PropertyAccessStrategy getPropertyAccessStrategy(Class clazz) throws MappingException {
        PropertyAccessStrategy propertyAccessStrategy = this.getPropertyAccessStrategy();
        if (propertyAccessStrategy != null) {
            return propertyAccessStrategy;
        }
        String accessName = this.getPropertyAccessorName();
        if (accessName == null) {
            accessName = clazz == null || Map.class.equals((Object)clazz) ? "map" : "property";
        }
        RepresentationMode representationMode = clazz == null || Map.class.equals((Object)clazz) ? RepresentationMode.MAP : RepresentationMode.POJO;
        return this.resolveServiceRegistry().requireService(PropertyAccessStrategyResolver.class).resolvePropertyAccessStrategy(clazz, accessName, representationMode);
    }

    ServiceRegistry resolveServiceRegistry() {
        if (this.getPersistentClass() != null) {
            return this.getPersistentClass().getServiceRegistry();
        }
        if (this.getValue() != null) {
            return this.getValue().getServiceRegistry();
        }
        throw new HibernateException("Could not resolve ServiceRegistry");
    }

    public boolean isNaturalIdentifier() {
        return this.naturalIdentifier;
    }

    public void setNaturalIdentifier(boolean naturalIdentifier) {
        this.naturalIdentifier = naturalIdentifier;
    }

    public boolean isGeneric() {
        return this.isGeneric;
    }

    public void setGeneric(boolean generic) {
        this.isGeneric = generic;
    }

    public boolean isLob() {
        return this.lob;
    }

    public void setLob(boolean lob) {
        this.lob = lob;
    }

    public void addCallbackDefinitions(List<CallbackDefinition> callbackDefinitions) {
        if (callbackDefinitions != null && !callbackDefinitions.isEmpty()) {
            if (this.callbackDefinitions == null) {
                this.callbackDefinitions = new ArrayList<CallbackDefinition>();
            }
            this.callbackDefinitions.addAll(callbackDefinitions);
        }
    }

    public List<CallbackDefinition> getCallbackDefinitions() {
        return this.callbackDefinitions == null ? Collections.emptyList() : Collections.unmodifiableList(this.callbackDefinitions);
    }

    public String getReturnedClassName() {
        return this.returnedClassName;
    }

    public void setReturnedClassName(String returnedClassName) {
        this.returnedClassName = returnedClassName;
    }

    public Generator createGenerator(RuntimeModelCreationContext context) {
        return this.generatorCreator == null ? null : this.generatorCreator.createGenerator(new PropertyGeneratorCreationContext(context));
    }

    public Property copy() {
        Property property = this instanceof SyntheticProperty ? new SyntheticProperty() : new Property();
        property.setName(this.getName());
        property.setValue(this.getValue());
        property.setCascade(this.getCascade());
        property.setUpdateable(this.isUpdateable());
        property.setInsertable(this.isInsertable());
        property.setSelectable(this.isSelectable());
        property.setOptimisticLocked(this.isOptimisticLocked());
        property.setValueGeneratorCreator(this.getValueGeneratorCreator());
        property.setPropertyAccessorName(this.getPropertyAccessorName());
        property.setPropertyAccessStrategy(this.getPropertyAccessStrategy());
        property.setLazy(this.isLazy());
        property.setLazyGroup(this.getLazyGroup());
        property.setOptional(this.isOptional());
        property.setMetaAttributes(this.getMetaAttributes());
        property.setPersistentClass(this.getPersistentClass());
        property.setNaturalIdentifier(this.isNaturalIdentifier());
        property.setGeneric(this.isGeneric());
        property.setLob(this.isLob());
        property.addCallbackDefinitions(this.getCallbackDefinitions());
        property.setReturnedClassName(this.getReturnedClassName());
        return property;
    }

    private class PropertyGeneratorCreationContext
    implements GeneratorCreationContext {
        private final RuntimeModelCreationContext context;

        public PropertyGeneratorCreationContext(RuntimeModelCreationContext context) {
            this.context = context;
        }

        @Override
        public Database getDatabase() {
            return this.context.getMetadata().getDatabase();
        }

        @Override
        public ServiceRegistry getServiceRegistry() {
            return this.context.getBootstrapContext().getServiceRegistry();
        }

        @Override
        public String getDefaultCatalog() {
            return this.context.getSessionFactoryOptions().getDefaultCatalog();
        }

        @Override
        public String getDefaultSchema() {
            return this.context.getSessionFactoryOptions().getDefaultSchema();
        }

        @Override
        public PersistentClass getPersistentClass() {
            return Property.this.persistentClass;
        }

        @Override
        public RootClass getRootClass() {
            return Property.this.persistentClass.getRootClass();
        }

        @Override
        public Property getProperty() {
            return Property.this;
        }

        @Override
        public SqlStringGenerationContext getSqlStringGenerationContext() {
            return this.context.getSqlStringGenerationContext();
        }
    }
}

