/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.function.Supplier;
import org.hibernate.MappingException;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.PrimaryKey;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.ValueVisitor;
import org.hibernate.resource.beans.spi.ManagedBean;
import org.hibernate.type.CollectionType;
import org.hibernate.type.MappingContext;
import org.hibernate.type.OrderedSetType;
import org.hibernate.type.SetType;
import org.hibernate.type.SortedSetType;
import org.hibernate.usertype.UserCollectionType;

public class Set
extends Collection {
    public Set(MetadataBuildingContext buildingContext, PersistentClass owner) {
        super(buildingContext, owner);
    }

    public Set(Supplier<ManagedBean<? extends UserCollectionType>> customTypeBeanResolver, PersistentClass persistentClass, MetadataBuildingContext buildingContext) {
        super(customTypeBeanResolver, persistentClass, buildingContext);
    }

    private Set(Collection original) {
        super(original);
    }

    @Override
    public Set copy() {
        return new Set(this);
    }

    @Override
    public void validate(Mapping mapping) throws MappingException {
        this.validate((MappingContext)mapping);
    }

    @Override
    public void validate(MappingContext mappingContext) throws MappingException {
        super.validate(mappingContext);
    }

    @Override
    public boolean isSet() {
        return true;
    }

    @Override
    public CollectionType getDefaultCollectionType() {
        if (this.isSorted()) {
            return new SortedSetType(this.getRole(), this.getReferencedPropertyName(), this.getComparator());
        }
        if (this.hasOrder()) {
            return new OrderedSetType(this.getRole(), this.getReferencedPropertyName());
        }
        return new SetType(this.getRole(), this.getReferencedPropertyName());
    }

    @Override
    void createPrimaryKey() {
        Table collectionTable;
        PrimaryKey pk;
        if (!this.isOneToMany() && (pk = (collectionTable = this.getCollectionTable()).getPrimaryKey()) == null) {
            pk = new PrimaryKey(this.getCollectionTable());
            pk.addColumns(this.getKey());
            for (Selectable selectable : this.getElement().getSelectables()) {
                if (!(selectable instanceof Column)) continue;
                Column col = (Column)selectable;
                if (!col.isNullable()) {
                    pk.addColumn(col);
                    continue;
                }
                return;
            }
            if (pk.getColumnSpan() != this.getKey().getColumnSpan()) {
                collectionTable.setPrimaryKey(pk);
            }
        }
    }

    @Override
    public Object accept(ValueVisitor visitor) {
        return visitor.accept(this);
    }
}

