/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.metamodel.mapping.DiscriminatorConverter;
import org.hibernate.metamodel.mapping.DiscriminatorValueDetails;
import org.hibernate.metamodel.mapping.internal.EmbeddableDiscriminatorValueDetailsImpl;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.JavaType;

public class EmbeddableDiscriminatorConverter<O, R>
extends DiscriminatorConverter<O, R> {
    private final Map<Object, EmbeddableDiscriminatorValueDetailsImpl> discriminatorValueToDetailsMap;
    private final Map<String, EmbeddableDiscriminatorValueDetailsImpl> embeddableClassNameToDetailsMap;

    public static <O, R> EmbeddableDiscriminatorConverter<O, R> fromValueMappings(String discriminatedType, JavaType<O> domainJavaType, BasicType<R> underlyingJdbcMapping, Map<Object, String> valueMappings, ServiceRegistry serviceRegistry) {
        ArrayList<EmbeddableDiscriminatorValueDetailsImpl> valueDetailsList = new ArrayList<EmbeddableDiscriminatorValueDetailsImpl>(valueMappings.size());
        ClassLoaderService cls = serviceRegistry.requireService(ClassLoaderService.class);
        valueMappings.forEach((value, embeddableClassName) -> valueDetailsList.add(new EmbeddableDiscriminatorValueDetailsImpl(value, cls.classForName((String)embeddableClassName))));
        return new EmbeddableDiscriminatorConverter<O, R>(discriminatedType, domainJavaType, underlyingJdbcMapping.getJavaTypeDescriptor(), valueDetailsList);
    }

    public EmbeddableDiscriminatorConverter(String discriminatorName, JavaType<O> domainJavaType, JavaType<R> relationalJavaType, List<EmbeddableDiscriminatorValueDetailsImpl> valueMappings) {
        super(discriminatorName, domainJavaType, relationalJavaType);
        this.discriminatorValueToDetailsMap = new HashMap<Object, EmbeddableDiscriminatorValueDetailsImpl>(valueMappings.size());
        this.embeddableClassNameToDetailsMap = new HashMap<String, EmbeddableDiscriminatorValueDetailsImpl>(valueMappings.size());
        valueMappings.forEach(valueDetails -> {
            this.discriminatorValueToDetailsMap.put(valueDetails.getValue(), (EmbeddableDiscriminatorValueDetailsImpl)valueDetails);
            this.embeddableClassNameToDetailsMap.put(valueDetails.getIndicatedEntityName(), (EmbeddableDiscriminatorValueDetailsImpl)valueDetails);
        });
    }

    @Override
    public O toDomainValue(R relationalForm) {
        assert (relationalForm == null || this.getRelationalJavaType().isInstance(relationalForm));
        EmbeddableDiscriminatorValueDetailsImpl matchingValueDetails = this.getDetailsForDiscriminatorValue(relationalForm);
        if (matchingValueDetails == null) {
            throw new IllegalStateException("Could not resolve discriminator value");
        }
        return (O)matchingValueDetails.getEmbeddableClass();
    }

    @Override
    public EmbeddableDiscriminatorValueDetailsImpl getDetailsForDiscriminatorValue(Object relationalValue) {
        EmbeddableDiscriminatorValueDetailsImpl valueMatch = this.discriminatorValueToDetailsMap.get(relationalValue);
        if (valueMatch != null) {
            return valueMatch;
        }
        throw new HibernateException("Unrecognized discriminator value: " + relationalValue);
    }

    @Override
    public DiscriminatorValueDetails getDetailsForEntityName(String embeddableClassName) {
        DiscriminatorValueDetails valueDetails = this.embeddableClassNameToDetailsMap.get(embeddableClassName);
        if (valueDetails != null) {
            return valueDetails;
        }
        throw new AssertionFailure("Unrecognized embeddable class: " + embeddableClassName);
    }

    @Override
    public void forEachValueDetail(Consumer<DiscriminatorValueDetails> consumer) {
        this.discriminatorValueToDetailsMap.forEach((value, detail) -> consumer.accept((DiscriminatorValueDetails)detail));
    }

    @Override
    public <X> X fromValueDetails(Function<DiscriminatorValueDetails, X> handler) {
        for (DiscriminatorValueDetails discriminatorValueDetails : this.discriminatorValueToDetailsMap.values()) {
            X result = handler.apply(discriminatorValueDetails);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

