/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.MappingModelCreationLogging;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.NonTransientException;
import org.hibernate.metamodel.mapping.internal.InFlightCollectionMapping;
import org.hibernate.metamodel.mapping.internal.InFlightEntityMappingType;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.metamodel.model.domain.internal.EntityPersisterConcurrentMap;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.sqm.function.SqmFunctionRegistry;

public class MappingModelCreationProcess {
    private final String EOL = System.lineSeparator();
    private final EntityPersisterConcurrentMap entityPersisterMap;
    private final Map<String, CollectionPersister> collectionPersisterMap;
    private final RuntimeModelCreationContext creationContext;
    private String currentlyProcessingRole;
    private List<PostInitCallbackEntry> postInitCallbacks;
    private final Map<NavigableRole, ForeignKeyDescriptor> keyDescriptorMap = new HashMap<NavigableRole, ForeignKeyDescriptor>();
    private final Map<NavigableRole, List<Consumer<ForeignKeyDescriptor>>> keyDescriptorWaitingConsumerMap = new HashMap<NavigableRole, List<Consumer<ForeignKeyDescriptor>>>();

    public static void process(EntityPersisterConcurrentMap entityPersisterMap, Map<String, CollectionPersister> collectionPersisterMap, RuntimeModelCreationContext creationContext) {
        MappingModelCreationProcess process = new MappingModelCreationProcess(entityPersisterMap, collectionPersisterMap, creationContext);
        process.execute();
    }

    private MappingModelCreationProcess(EntityPersisterConcurrentMap entityPersisterMap, Map<String, CollectionPersister> collectionPersisterMap, RuntimeModelCreationContext creationContext) {
        this.entityPersisterMap = entityPersisterMap;
        this.collectionPersisterMap = collectionPersisterMap;
        this.creationContext = creationContext;
    }

    public RuntimeModelCreationContext getCreationContext() {
        return this.creationContext;
    }

    public EntityPersister getEntityPersister(String name) {
        return this.entityPersisterMap.get(name);
    }

    public SqmFunctionRegistry getSqmFunctionRegistry() {
        return this.creationContext.getFunctionRegistry();
    }

    private void execute() {
        for (EntityPersister entityPersister : this.entityPersisterMap.values()) {
            if (!(entityPersister instanceof InFlightEntityMappingType)) continue;
            ((InFlightEntityMappingType)((Object)entityPersister)).linkWithSuperType(this);
        }
        for (EntityPersister entityPersister : this.entityPersisterMap.values()) {
            this.currentlyProcessingRole = entityPersister.getEntityName();
            if (!(entityPersister instanceof InFlightEntityMappingType)) continue;
            ((InFlightEntityMappingType)((Object)entityPersister)).prepareMappingModel(this);
        }
        for (CollectionPersister collectionPersister : this.collectionPersisterMap.values()) {
            if (!(collectionPersister instanceof InFlightCollectionMapping)) continue;
            ((InFlightCollectionMapping)((Object)collectionPersister)).prepareMappingModel(this);
        }
        this.executePostInitCallbacks();
    }

    private void executePostInitCallbacks() {
        MappingModelCreationLogging.MAPPING_MODEL_CREATION_MESSAGE_LOGGER.debugf("Starting post-init callbacks", new Object[0]);
        HashMap<PostInitCallbackEntry, Exception> exceptions = new HashMap<PostInitCallbackEntry, Exception>();
        while (this.postInitCallbacks != null && !this.postInitCallbacks.isEmpty()) {
            ArrayList<PostInitCallbackEntry> copy = new ArrayList<PostInitCallbackEntry>(this.postInitCallbacks);
            boolean anyCompleted = false;
            for (int i = 0; i < copy.size(); ++i) {
                PostInitCallbackEntry callbackEntry2 = copy.get(i);
                try {
                    boolean completed = callbackEntry2.process();
                    if (!completed) continue;
                    anyCompleted = true;
                    this.postInitCallbacks.remove(callbackEntry2);
                    exceptions.remove(callbackEntry2);
                    continue;
                }
                catch (Exception e) {
                    if (e instanceof NonTransientException) {
                        MappingModelCreationLogging.MAPPING_MODEL_CREATION_MESSAGE_LOGGER.debugf("Mapping-model creation encountered non-transient error : %s", e);
                        throw e;
                    }
                    exceptions.put(callbackEntry2, e);
                    String format = "Mapping-model creation encountered (possibly) transient error : %s";
                    if (MappingModelCreationLogging.MAPPING_MODEL_CREATION_MESSAGE_LOGGER.isTraceEnabled()) {
                        MappingModelCreationLogging.MAPPING_MODEL_CREATION_MESSAGE_LOGGER.tracef(e, "Mapping-model creation encountered (possibly) transient error : %s", e);
                        continue;
                    }
                    MappingModelCreationLogging.MAPPING_MODEL_CREATION_MESSAGE_LOGGER.debugf("Mapping-model creation encountered (possibly) transient error : %s", e);
                }
            }
            if (anyCompleted) continue;
            StringBuilder buff = new StringBuilder("PostInitCallback queue could not be processed...");
            this.postInitCallbacks.forEach(callbackEntry -> buff.append(this.EOL).append("        - ").append(callbackEntry));
            buff.append(this.EOL);
            IllegalStateException illegalStateException = new IllegalStateException(buff.toString());
            for (Map.Entry entry : exceptions.entrySet()) {
                illegalStateException.addSuppressed((Throwable)entry.getValue());
            }
            throw illegalStateException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends ModelPart> T processSubPart(String localName, SubPartMappingProducer<T> subPartMappingProducer) {
        assert (this.currentlyProcessingRole != null);
        String initialRole = this.currentlyProcessingRole;
        this.currentlyProcessingRole = this.currentlyProcessingRole + "#" + localName;
        try {
            ModelPart modelPart = (ModelPart)subPartMappingProducer.produceSubMapping(this.currentlyProcessingRole, this);
            return (T)modelPart;
        }
        finally {
            this.currentlyProcessingRole = initialRole;
        }
    }

    public void registerInitializationCallback(String description, PostInitCallback callback) {
        if (this.postInitCallbacks == null) {
            this.postInitCallbacks = new ArrayList<PostInitCallbackEntry>();
        }
        this.postInitCallbacks.add(new PostInitCallbackEntry(description, callback));
    }

    public void registerForeignKeyPostInitCallbacks(String description, PostInitCallback callback) {
        this.registerInitializationCallback(description, callback);
    }

    public void withForeignKey(ModelPart keyOwner, Consumer<ForeignKeyDescriptor> consumer) {
        this.withForeignKey(keyOwner.getNavigableRole(), consumer);
    }

    private void withForeignKey(NavigableRole navigableRole, Consumer<ForeignKeyDescriptor> consumer) {
        ForeignKeyDescriptor keyDescriptor = this.keyDescriptorMap.get(navigableRole);
        if (keyDescriptor != null) {
            consumer.accept(keyDescriptor);
        } else {
            List<Consumer<ForeignKeyDescriptor>> consumers;
            List<Consumer<ForeignKeyDescriptor>> existingConsumers = this.keyDescriptorWaitingConsumerMap.get(navigableRole);
            if (existingConsumers != null) {
                consumers = existingConsumers;
            } else {
                consumers = new ArrayList<Consumer<ForeignKeyDescriptor>>();
                this.keyDescriptorWaitingConsumerMap.put(navigableRole, consumers);
            }
            consumers.add(consumer);
        }
    }

    public void registerForeignKey(ModelPart keyOwner, ForeignKeyDescriptor keyDescriptor) {
        NavigableRole navigableRole = keyOwner.getNavigableRole();
        this.keyDescriptorMap.put(navigableRole, keyDescriptor);
        List<Consumer<ForeignKeyDescriptor>> waitingConsumers = this.keyDescriptorWaitingConsumerMap.remove(navigableRole);
        if (waitingConsumers != null) {
            for (int i = 0; i < waitingConsumers.size(); ++i) {
                waitingConsumers.get(i).accept(keyDescriptor);
            }
        }
    }

    private static class PostInitCallbackEntry {
        private final String description;
        private final PostInitCallback callback;

        public PostInitCallbackEntry(String description, PostInitCallback callback) {
            this.description = description;
            this.callback = callback;
        }

        private boolean process() {
            MappingModelCreationLogging.MAPPING_MODEL_CREATION_MESSAGE_LOGGER.debugf("Starting PostInitCallbackEntry : %s", this.description);
            return this.callback.process();
        }

        public String toString() {
            return "PostInitCallbackEntry - " + this.description;
        }
    }

    @FunctionalInterface
    public static interface SubPartMappingProducer<T> {
        public T produceSubMapping(String var1, MappingModelCreationProcess var2);
    }

    @FunctionalInterface
    public static interface PostInitCallback {
        public boolean process();
    }
}

