/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal;

import jakarta.persistence.metamodel.Type;
import java.util.List;
import org.hibernate.mapping.Any;
import org.hibernate.mapping.Column;
import org.hibernate.metamodel.mapping.internal.AnyDiscriminatorPart;
import org.hibernate.metamodel.model.domain.AnyMappingDomainType;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.metamodel.model.domain.SimpleDomainType;
import org.hibernate.metamodel.spi.MappingMetamodelImplementor;
import org.hibernate.type.AnyType;
import org.hibernate.type.BasicType;
import org.hibernate.type.MetaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.internal.ConvertedBasicTypeImpl;

public class AnyMappingDomainTypeImpl<T>
implements AnyMappingDomainType<T> {
    private final AnyType anyType;
    private final JavaType<T> baseJtd;
    private final BasicType<Class<?>> anyDiscriminatorType;

    public AnyMappingDomainTypeImpl(Any bootAnyMapping, AnyType anyType, JavaType<T> baseJtd, MappingMetamodelImplementor mappingMetamodel) {
        this.anyType = anyType;
        this.baseJtd = baseJtd;
        MetaType discriminatorType = (MetaType)anyType.getDiscriminatorType();
        BasicType discriminatorBaseType = (BasicType)discriminatorType.getBaseType();
        NavigableRole navigableRole = this.resolveNavigableRole(bootAnyMapping);
        this.anyDiscriminatorType = new ConvertedBasicTypeImpl(navigableRole.getFullPath(), discriminatorBaseType.getJdbcType(), AnyDiscriminatorPart.determineDiscriminatorConverter(navigableRole, discriminatorBaseType, bootAnyMapping.getMetaValues(), discriminatorType.getImplicitValueStrategy(), mappingMetamodel));
    }

    private NavigableRole resolveNavigableRole(Any bootAnyMapping) {
        StringBuilder buffer = new StringBuilder();
        if (bootAnyMapping.getTable() != null) {
            buffer.append(bootAnyMapping.getTable().getName());
        }
        buffer.append("(");
        List<Column> columns = bootAnyMapping.getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            buffer.append(columns.get(i).getName());
            if (i + 1 >= columns.size()) continue;
            buffer.append(",");
        }
        buffer.append(")");
        return new NavigableRole(buffer.toString());
    }

    public Type.PersistenceType getPersistenceType() {
        return Type.PersistenceType.ENTITY;
    }

    public Class<T> getJavaType() {
        return this.baseJtd.getJavaTypeClass();
    }

    @Override
    public JavaType<T> getExpressibleJavaType() {
        return this.baseJtd;
    }

    @Override
    public BasicType<Class<?>> getDiscriminatorType() {
        return this.anyDiscriminatorType;
    }

    @Override
    public SimpleDomainType<?> getKeyType() {
        return (BasicType)this.anyType.getIdentifierType();
    }
}

