/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.derived;

import jakarta.persistence.metamodel.Bindable;
import jakarta.persistence.metamodel.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.Incubating;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.UnsupportedMappingException;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.metamodel.mapping.SqlTypedMapping;
import org.hibernate.metamodel.mapping.internal.SqlTypedMappingImpl;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.metamodel.model.domain.PluralPersistentAttribute;
import org.hibernate.metamodel.model.domain.SimpleDomainType;
import org.hibernate.metamodel.model.domain.TupleType;
import org.hibernate.query.ReturnableType;
import org.hibernate.query.SemanticException;
import org.hibernate.query.derived.AnonymousTupleSimpleSqmPathSource;
import org.hibernate.query.derived.AnonymousTupleSqmAssociationPathSourceNew;
import org.hibernate.query.derived.AnonymousTupleTableGroupProducer;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelectClause;
import org.hibernate.query.sqm.tree.select.SqmSelectableNode;
import org.hibernate.query.sqm.tree.select.SqmSubQuery;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.ObjectArrayJavaType;

@Incubating
public class AnonymousTupleType<T>
implements TupleType<T>,
DomainType<T>,
ReturnableType<T>,
SqmPathSource<T> {
    private final JavaType<T> javaTypeDescriptor;
    private final @Nullable NavigablePath[] componentSourcePaths;
    private final SqmExpressible<?>[] expressibles;
    private final String[] componentNames;
    private final Map<String, Integer> componentIndexMap;

    public AnonymousTupleType(SqmSubQuery<T> subQuery) {
        this(AnonymousTupleType.extractSqmExpressibles(subQuery));
    }

    public AnonymousTupleType(SqmSelectableNode<?>[] components) {
        SqmExpressible[] expressibles = new SqmExpressible[components.length];
        NavigablePath[] componentSourcePaths = new NavigablePath[components.length];
        for (int i = 0; i < components.length; ++i) {
            expressibles[i] = components[i].getNodeType();
            SqmSelectableNode<?> sqmSelectableNode = components[i];
            if (!(sqmSelectableNode instanceof SqmPath)) continue;
            SqmPath path = (SqmPath)sqmSelectableNode;
            componentSourcePaths[i] = path.getNavigablePath();
        }
        this.expressibles = expressibles;
        this.componentSourcePaths = componentSourcePaths;
        this.componentNames = new String[components.length];
        this.javaTypeDescriptor = new ObjectArrayJavaType(AnonymousTupleType.getTypeDescriptors(components));
        LinkedHashMap<String, Integer> map = CollectionHelper.linkedMapOfSize(components.length);
        for (int i = 0; i < components.length; ++i) {
            SqmSelectableNode<?> component = components[i];
            String alias = component.getAlias();
            if (alias == null) {
                throw new SemanticException("Select item at position " + (i + 1) + " in select list has no alias (aliases are required in CTEs and in subqueries occurring in from clause)");
            }
            map.put(alias, i);
            this.componentNames[i] = alias;
        }
        this.componentIndexMap = map;
    }

    public AnonymousTupleType(SqmExpressible<?>[] expressibles, String[] componentNames) {
        this.componentSourcePaths = new NavigablePath[componentNames.length];
        this.expressibles = expressibles;
        this.componentNames = componentNames;
        LinkedHashMap<String, Integer> map = CollectionHelper.linkedMapOfSize(expressibles.length);
        int elementIndex = -1;
        for (int i = 0; i < componentNames.length; ++i) {
            if (CollectionPart.Nature.ELEMENT.getName().equals(componentNames[i])) {
                elementIndex = i;
            }
            map.put(componentNames[i], i);
        }
        this.javaTypeDescriptor = elementIndex == -1 ? new ObjectArrayJavaType(AnonymousTupleType.getTypeDescriptors(expressibles)) : expressibles[elementIndex].getExpressibleJavaType();
        this.componentIndexMap = map;
    }

    private static SqmSelectableNode<?>[] extractSqmExpressibles(SqmSubQuery<?> subQuery) {
        SqmSelectClause selectClause = ((SqmQuerySpec)subQuery.getQuerySpec()).getSelectClause();
        if (selectClause == null || selectClause.getSelectionItems().isEmpty()) {
            throw new IllegalArgumentException("subquery has no selection items");
        }
        return (SqmSelectableNode[])selectClause.getSelectionItems().toArray(SqmSelectableNode[]::new);
    }

    private static JavaType<?>[] getTypeDescriptors(SqmSelectableNode<?>[] components) {
        JavaType[] typeDescriptors = new JavaType[components.length];
        for (int i = 0; i < components.length; ++i) {
            typeDescriptors[i] = components[i].getExpressible().getExpressibleJavaType();
        }
        return typeDescriptors;
    }

    private static JavaType<?>[] getTypeDescriptors(SqmExpressible<?>[] components) {
        JavaType[] typeDescriptors = new JavaType[components.length];
        for (int i = 0; i < components.length; ++i) {
            typeDescriptors[i] = components[i].getExpressibleJavaType();
        }
        return typeDescriptors;
    }

    public static SqlTypedMapping[] toSqlTypedMappings(List<SqlSelection> sqlSelections) {
        SqlTypedMapping[] jdbcMappings = new SqlTypedMapping[sqlSelections.size()];
        for (int i = 0; i < sqlSelections.size(); ++i) {
            SqlTypedMapping sqlTypedMapping;
            JdbcMappingContainer expressionType = sqlSelections.get(i).getExpressionType();
            jdbcMappings[i] = expressionType instanceof SqlTypedMapping ? (sqlTypedMapping = (SqlTypedMapping)((Object)expressionType)) : new SqlTypedMappingImpl(expressionType.getSingleJdbcMapping());
        }
        return jdbcMappings;
    }

    public AnonymousTupleTableGroupProducer resolveTableGroupProducer(String aliasStem, List<SqlSelection> sqlSelections, FromClauseAccess fromClauseAccess) {
        return this.resolveTableGroupProducer(aliasStem, AnonymousTupleType.toSqlTypedMappings(sqlSelections), fromClauseAccess);
    }

    public AnonymousTupleTableGroupProducer resolveTableGroupProducer(String aliasStem, SqlTypedMapping[] jdbcMappings, FromClauseAccess fromClauseAccess) {
        return new AnonymousTupleTableGroupProducer(this, aliasStem, jdbcMappings, fromClauseAccess);
    }

    @Override
    public int componentCount() {
        return this.expressibles.length;
    }

    @Override
    public String getComponentName(int index) {
        return this.componentNames[index];
    }

    @Override
    public List<String> getComponentNames() {
        return new ArrayList<String>(this.componentIndexMap.keySet());
    }

    @Override
    public SqmExpressible<?> get(int index) {
        return this.expressibles[index];
    }

    @Override
    public SqmExpressible<?> get(String componentName) {
        Integer index = this.componentIndexMap.get(componentName);
        return index == null ? null : this.expressibles[index];
    }

    protected Integer getIndex(String componentName) {
        return this.componentIndexMap.get(componentName);
    }

    public @Nullable NavigablePath getComponentSourcePath(int index) {
        return this.componentSourcePaths[index];
    }

    @Override
    public SqmPathSource<?> findSubPathSource(String name) {
        Integer index = this.componentIndexMap.get(name);
        if (index == null) {
            return null;
        }
        SqmExpressible<?> expressible = this.expressibles[index];
        DomainType<?> sqmType = expressible.getSqmType();
        if (expressible instanceof PluralPersistentAttribute) {
            PluralPersistentAttribute pluralAttribute = (PluralPersistentAttribute)expressible;
            return new AnonymousTupleSqmAssociationPathSourceNew(name, pluralAttribute, sqmType, (SimpleDomainType<?>)pluralAttribute.getElementType());
        }
        if (sqmType instanceof BasicType) {
            return new AnonymousTupleSimpleSqmPathSource(name, sqmType, Bindable.BindableType.SINGULAR_ATTRIBUTE);
        }
        return new AnonymousTupleSqmAssociationPathSourceNew(name, (SqmPathSource)expressible, sqmType, (SimpleDomainType)sqmType);
    }

    @Override
    public JavaType<T> getExpressibleJavaType() {
        return this.javaTypeDescriptor;
    }

    public Bindable.BindableType getBindableType() {
        return Bindable.BindableType.ENTITY_TYPE;
    }

    public Type.PersistenceType getPersistenceType() {
        return Type.PersistenceType.ENTITY;
    }

    @Override
    public String getPathName() {
        return "tuple" + System.identityHashCode(this);
    }

    @Override
    public DomainType<T> getSqmPathType() {
        return this;
    }

    @Override
    public DomainType<T> getSqmType() {
        return this;
    }

    @Override
    public SqmPath<T> createSqmPath(SqmPath<?> lhs, SqmPathSource<?> intermediatePathSource) {
        throw new UnsupportedMappingException("AnonymousTupleType cannot be used to create an SqmPath - that would be an SqmFrom which are created directly");
    }

    @Override
    public Class<T> getBindableJavaType() {
        return (Class)this.javaTypeDescriptor.getJavaType();
    }

    public Class<T> getJavaType() {
        return this.getBindableJavaType();
    }

    public String toString() {
        return "AnonymousTupleType" + Arrays.toString(this.expressibles);
    }
}

