/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.hql.internal;

import java.util.Locale;
import java.util.Set;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.hibernate.grammars.hql.HqlParser;
import org.hibernate.query.hql.internal.SemanticQueryBuilder;
import org.hibernate.query.hql.spi.SqmCreationProcessingState;
import org.hibernate.query.hql.spi.SqmPathRegistry;
import org.hibernate.query.sqm.SqmTreeCreationLogger;
import org.hibernate.query.sqm.StrictJpaComplianceViolation;
import org.hibernate.query.sqm.tree.SqmJoinType;
import org.hibernate.query.sqm.tree.from.SqmEntityJoin;
import org.hibernate.query.sqm.tree.from.SqmRoot;

public class SqmTreeCreationHelper {
    private static final Set<String> RESERVED_WORDS = Set.of("abs", "all", "and", "any", "as", "asc", "avg", "between", "bit_length", "both", "by", "case", "ceiling", "char_length", "character_length", "class", "coalesce", "concat", "count", "current_date", "current_time", "current_timestamp", "delete", "desc", "distinct", "else", "empty", "end", "entry", "escape", "exists", "exp", "extract", "false", "fetch", "first", "floor", "from", "function", "group", "having", "in", "index", "inner", "is", "join", "key", "leading", "last", "left", "length", "like", "local", "ln", "locate", "lower", "max", "member", "min", "mod", "new", "not", "null", "nulls", "nullif", "object", "of", "on", "or", "order", "outer", "position", "power", "replace", "right", "round", "select", "set", "sign", "size", "some", "sqrt", "substring", "sum", "then", "trailing", "treat", "trim", "true", "type", "unknown", "update", "upper", "value", "when", "where");

    public static <E> void handleRootAsCrossJoin(HqlParser.EntityWithJoinsContext entityWithJoinsContext, SqmRoot<?> sqmPrimaryRoot, SemanticQueryBuilder<?> sqmBuilder) {
        HqlParser.RootEntityContext fromRootContext = (HqlParser.RootEntityContext)entityWithJoinsContext.fromRoot();
        SqmRoot sqmRoot = (SqmRoot)fromRootContext.accept(sqmBuilder);
        SqmTreeCreationLogger.LOGGER.debugf("Handling secondary root path as cross-join - %s", (Object)sqmRoot.getEntityName());
        String alias = SqmTreeCreationHelper.extractAlias(fromRootContext.variable(), sqmBuilder);
        SqmEntityJoin pseudoCrossJoin = new SqmEntityJoin(sqmRoot.getManagedType(), alias, SqmJoinType.CROSS, sqmPrimaryRoot);
        sqmPrimaryRoot.addSqmJoin(pseudoCrossJoin);
        SqmCreationProcessingState processingState = sqmBuilder.getProcessingStateStack().getCurrent();
        SqmPathRegistry pathRegistry = processingState.getPathRegistry();
        pathRegistry.replace(pseudoCrossJoin, sqmRoot);
        int size = entityWithJoinsContext.getChildCount();
        for (int i = 1; i < size; ++i) {
            ParseTree parseTree = entityWithJoinsContext.getChild(i);
            if (parseTree instanceof HqlParser.CrossJoinContext) {
                sqmBuilder.consumeCrossJoin((HqlParser.CrossJoinContext)parseTree, sqmPrimaryRoot);
                continue;
            }
            if (parseTree instanceof HqlParser.JoinContext) {
                sqmBuilder.consumeJoin((HqlParser.JoinContext)parseTree, sqmPrimaryRoot);
                continue;
            }
            if (!(parseTree instanceof HqlParser.JpaCollectionJoinContext)) continue;
            sqmBuilder.consumeJpaCollectionJoin((HqlParser.JpaCollectionJoinContext)parseTree, sqmPrimaryRoot);
        }
    }

    public static String extractAlias(HqlParser.VariableContext ctx, SemanticQueryBuilder<?> sqmBuilder) {
        return SqmTreeCreationHelper.extractVariable(ctx, sqmBuilder);
    }

    public static String extractJpaCompliantAlias(HqlParser.VariableContext ctx, SemanticQueryBuilder<?> sqmBuilder) {
        return SqmTreeCreationHelper.applyJpaCompliance(SqmTreeCreationHelper.extractVariable(ctx, sqmBuilder), sqmBuilder);
    }

    public static String extractVariable(HqlParser.VariableContext ctx, SemanticQueryBuilder<?> sqmBuilder) {
        Token identificationVariableToken;
        if (ctx == null) {
            return null;
        }
        ParseTree lastChild = ctx.getChild(ctx.getChildCount() - 1);
        if (lastChild instanceof HqlParser.IdentifierContext) {
            Token identificationVariableToken2;
            HqlParser.IdentifierContext identifierContext = (HqlParser.IdentifierContext)lastChild;
            if (sqmBuilder.getCreationOptions().useStrictJpaCompliance() && RESERVED_WORDS.contains((identificationVariableToken2 = identifierContext.getStart()).getText().toLowerCase(Locale.ENGLISH))) {
                throw new StrictJpaComplianceViolation(String.format(Locale.ROOT, "Strict JPQL compliance was violated : %s [%s]", StrictJpaComplianceViolation.Type.RESERVED_WORD_USED_AS_ALIAS.description(), identificationVariableToken2.getText()), StrictJpaComplianceViolation.Type.RESERVED_WORD_USED_AS_ALIAS);
            }
            return sqmBuilder.visitIdentifier(identifierContext);
        }
        HqlParser.NakedIdentifierContext identifierContext = (HqlParser.NakedIdentifierContext)lastChild;
        if (sqmBuilder.getCreationOptions().useStrictJpaCompliance() && RESERVED_WORDS.contains((identificationVariableToken = identifierContext.getStart()).getText().toLowerCase(Locale.ENGLISH))) {
            throw new StrictJpaComplianceViolation(String.format(Locale.ROOT, "Strict JPQL compliance was violated : %s [%s]", StrictJpaComplianceViolation.Type.RESERVED_WORD_USED_AS_ALIAS.description(), identificationVariableToken.getText()), StrictJpaComplianceViolation.Type.RESERVED_WORD_USED_AS_ALIAS);
        }
        return sqmBuilder.visitNakedIdentifier(identifierContext);
    }

    public static String applyJpaCompliance(String text, SemanticQueryBuilder<?> sqmBuilder) {
        if (text == null) {
            return null;
        }
        if (sqmBuilder.getCreationOptions().useStrictJpaCompliance()) {
            return text.toLowerCase(Locale.getDefault());
        }
        return text;
    }
}

