/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.boot.model.FunctionContributor;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.query.spi.NativeQueryInterpreter;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.query.BindingContext;
import org.hibernate.query.hql.HqlTranslator;
import org.hibernate.query.hql.internal.StandardHqlTranslator;
import org.hibernate.query.hql.spi.SqmCreationOptions;
import org.hibernate.query.internal.QueryInterpretationCacheDisabledImpl;
import org.hibernate.query.internal.QueryInterpretationCacheStandardImpl;
import org.hibernate.query.named.NamedObjectRepository;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.spi.QueryEngineOptions;
import org.hibernate.query.spi.QueryInterpretationCache;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.function.SqmFunctionRegistry;
import org.hibernate.query.sqm.internal.SqmCreationOptionsStandard;
import org.hibernate.query.sqm.internal.SqmCriteriaNodeBuilder;
import org.hibernate.query.sqm.spi.SqmCreationContext;
import org.hibernate.query.sqm.sql.SqmTranslatorFactory;
import org.hibernate.query.sqm.sql.StandardSqmTranslatorFactory;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.type.spi.TypeConfiguration;
import org.jboss.logging.Logger;

public class QueryEngineImpl
implements QueryEngine {
    private static final Logger LOG_HQL_FUNCTIONS = CoreLogging.logger("org.hibernate.HQL_FUNCTIONS");
    private final TypeConfiguration typeConfiguration;
    private final NamedObjectRepository namedObjectRepository;
    private final NativeQueryInterpreter nativeQueryInterpreter;
    private final QueryInterpretationCache interpretationCache;
    private final NodeBuilder criteriaBuilder;
    private final HqlTranslator hqlTranslator;
    private final SqmTranslatorFactory sqmTranslatorFactory;
    private final SqmFunctionRegistry sqmFunctionRegistry;

    public static QueryEngineImpl from(MetadataImplementor metadata, QueryEngineOptions options, SqmCreationContext sqmCreationContext, ServiceRegistryImplementor serviceRegistry, Map<String, Object> properties, String name) {
        Dialect dialect = serviceRegistry.requireService(JdbcServices.class).getDialect();
        return new QueryEngineImpl(metadata.getTypeConfiguration(), QueryEngineImpl.resolveHqlTranslator(options, dialect, sqmCreationContext, new SqmCreationOptionsStandard(options)), QueryEngineImpl.resolveSqmTranslatorFactory(options, dialect), QueryEngineImpl.createFunctionRegistry(serviceRegistry, metadata, options, dialect), metadata.buildNamedQueryRepository(), QueryEngineImpl.buildInterpretationCache(serviceRegistry, properties), serviceRegistry.getService(NativeQueryInterpreter.class), sqmCreationContext, options, options.getUuid(), name);
    }

    private static SqmFunctionRegistry createFunctionRegistry(ServiceRegistry serviceRegistry, MetadataImplementor metadata, QueryEngineOptions queryEngineOptions, Dialect dialect) {
        SqmFunctionRegistry sqmFunctionRegistry = metadata.getFunctionRegistry();
        queryEngineOptions.getCustomSqlFunctionMap().forEach(sqmFunctionRegistry::register);
        SqmFunctionRegistry customSqmFunctionRegistry = queryEngineOptions.getCustomSqmFunctionRegistry();
        if (customSqmFunctionRegistry != null) {
            customSqmFunctionRegistry.overlay(sqmFunctionRegistry);
        }
        FunctionContributionsImpl functionContributions = new FunctionContributionsImpl(serviceRegistry, metadata.getTypeConfiguration(), sqmFunctionRegistry);
        for (FunctionContributor contributor : QueryEngineImpl.sortedFunctionContributors(serviceRegistry)) {
            contributor.contributeFunctions(functionContributions);
        }
        dialect.initializeFunctionRegistry(functionContributions);
        if (LOG_HQL_FUNCTIONS.isDebugEnabled()) {
            sqmFunctionRegistry.getFunctionsByName().forEach(entry -> LOG_HQL_FUNCTIONS.debug((Object)((SqmFunctionDescriptor)entry.getValue()).getSignature((String)entry.getKey())));
        }
        return sqmFunctionRegistry;
    }

    private QueryEngineImpl(TypeConfiguration typeConfiguration, HqlTranslator hqlTranslator, SqmTranslatorFactory sqmTranslatorFactory, SqmFunctionRegistry functionRegistry, NamedObjectRepository namedObjectRepository, QueryInterpretationCache interpretationCache, NativeQueryInterpreter nativeQueryInterpreter, BindingContext context, QueryEngineOptions options, String uuid, String name) {
        this.typeConfiguration = typeConfiguration;
        this.sqmFunctionRegistry = functionRegistry;
        this.sqmTranslatorFactory = sqmTranslatorFactory;
        this.hqlTranslator = hqlTranslator;
        this.namedObjectRepository = namedObjectRepository;
        this.interpretationCache = interpretationCache;
        this.nativeQueryInterpreter = nativeQueryInterpreter;
        this.criteriaBuilder = this.createCriteriaBuilder(context, options, uuid, name);
    }

    private SqmCriteriaNodeBuilder createCriteriaBuilder(BindingContext context, QueryEngineOptions options, String uuid, String name) {
        return new SqmCriteriaNodeBuilder(uuid, name, this, options, context);
    }

    private static HqlTranslator resolveHqlTranslator(QueryEngineOptions runtimeOptions, Dialect dialect, SqmCreationContext sqmCreationContext, SqmCreationOptions sqmCreationOptions) {
        if (runtimeOptions.getCustomHqlTranslator() != null) {
            return runtimeOptions.getCustomHqlTranslator();
        }
        if (dialect.getHqlTranslator() != null) {
            return dialect.getHqlTranslator();
        }
        return new StandardHqlTranslator(sqmCreationContext, sqmCreationOptions);
    }

    private static SqmTranslatorFactory resolveSqmTranslatorFactory(QueryEngineOptions runtimeOptions, Dialect dialect) {
        if (runtimeOptions.getCustomSqmTranslatorFactory() != null) {
            return runtimeOptions.getCustomSqmTranslatorFactory();
        }
        if (dialect.getSqmTranslatorFactory() != null) {
            return dialect.getSqmTranslatorFactory();
        }
        return new StandardSqmTranslatorFactory();
    }

    private static List<FunctionContributor> sortedFunctionContributors(ServiceRegistry serviceRegistry) {
        Collection<FunctionContributor> functionContributors = serviceRegistry.requireService(ClassLoaderService.class).loadJavaServices(FunctionContributor.class);
        ArrayList<FunctionContributor> contributors = new ArrayList<FunctionContributor>(functionContributors);
        contributors.sort(Comparator.comparingInt(FunctionContributor::ordinal).thenComparing(a -> a.getClass().getCanonicalName()));
        return contributors;
    }

    private static QueryInterpretationCache buildInterpretationCache(ServiceRegistry serviceRegistry, Map<String, Object> properties) {
        boolean explicitUseCache = ConfigurationHelper.getBoolean("hibernate.query.plan_cache_enabled", properties, true);
        Integer explicitMaxPlanSize = ConfigurationHelper.getInteger("hibernate.query.plan_cache_max_size", properties);
        if (explicitUseCache || explicitMaxPlanSize != null && explicitMaxPlanSize > 0) {
            int size = explicitMaxPlanSize != null ? explicitMaxPlanSize : 2048;
            return new QueryInterpretationCacheStandardImpl(size, serviceRegistry);
        }
        return new QueryInterpretationCacheDisabledImpl(serviceRegistry);
    }

    @Override
    public void validateNamedQueries() {
        this.namedObjectRepository.validateNamedQueries(this);
    }

    @Override
    public NamedObjectRepository getNamedObjectRepository() {
        return this.namedObjectRepository;
    }

    @Override
    public TypeConfiguration getTypeConfiguration() {
        return this.typeConfiguration;
    }

    @Override
    public NodeBuilder getCriteriaBuilder() {
        return this.criteriaBuilder;
    }

    @Override
    public HqlTranslator getHqlTranslator() {
        return this.hqlTranslator;
    }

    @Override
    public SqmTranslatorFactory getSqmTranslatorFactory() {
        return this.sqmTranslatorFactory;
    }

    @Override
    public NativeQueryInterpreter getNativeQueryInterpreter() {
        return this.nativeQueryInterpreter;
    }

    @Override
    public QueryInterpretationCache getInterpretationCache() {
        return this.interpretationCache;
    }

    @Override
    public SqmFunctionRegistry getSqmFunctionRegistry() {
        return this.sqmFunctionRegistry;
    }

    @Override
    public void close() {
        if (this.namedObjectRepository != null) {
            this.namedObjectRepository.close();
        }
        if (this.interpretationCache != null) {
            this.interpretationCache.close();
        }
        if (this.sqmFunctionRegistry != null) {
            this.sqmFunctionRegistry.close();
        }
    }

    private static class FunctionContributionsImpl
    implements FunctionContributions {
        private final ServiceRegistry serviceRegistry;
        private final TypeConfiguration typeConfiguration;
        private final SqmFunctionRegistry functionRegistry;

        public FunctionContributionsImpl(ServiceRegistry serviceRegistry, TypeConfiguration typeConfiguration, SqmFunctionRegistry functionRegistry) {
            this.serviceRegistry = serviceRegistry;
            this.typeConfiguration = typeConfiguration;
            this.functionRegistry = functionRegistry;
        }

        @Override
        public TypeConfiguration getTypeConfiguration() {
            return this.typeConfiguration;
        }

        @Override
        public SqmFunctionRegistry getFunctionRegistry() {
            return this.functionRegistry;
        }

        @Override
        public ServiceRegistry getServiceRegistry() {
            return this.serviceRegistry;
        }
    }
}

