/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal.temptable;

import java.util.function.Function;
import org.hibernate.dialect.temptable.TemporaryTable;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.mutation.internal.MultiTableSqmMutationConverter;
import org.hibernate.query.sqm.mutation.internal.temptable.TableBasedDeleteHandler;
import org.hibernate.query.sqm.mutation.spi.AfterUseAction;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.from.SqmRoot;

public abstract class AbstractDeleteExecutionDelegate
implements TableBasedDeleteHandler.ExecutionDelegate {
    private final EntityMappingType entityDescriptor;
    private final TemporaryTable idTable;
    private final AfterUseAction afterUseAction;
    private final SqmDeleteStatement<?> sqmDelete;
    private final DomainParameterXref domainParameterXref;
    private final SessionFactoryImplementor sessionFactory;
    private final Function<SharedSessionContractImplementor, String> sessionUidAccess;
    private final MultiTableSqmMutationConverter converter;

    public AbstractDeleteExecutionDelegate(EntityMappingType entityDescriptor, TemporaryTable idTable, AfterUseAction afterUseAction, SqmDeleteStatement<?> sqmDelete, DomainParameterXref domainParameterXref, QueryOptions queryOptions, LoadQueryInfluencers loadQueryInfluencers, QueryParameterBindings queryParameterBindings, Function<SharedSessionContractImplementor, String> sessionUidAccess, SessionFactoryImplementor sessionFactory) {
        this.entityDescriptor = entityDescriptor;
        this.idTable = idTable;
        this.afterUseAction = afterUseAction;
        this.sqmDelete = sqmDelete;
        this.domainParameterXref = domainParameterXref;
        this.sessionFactory = sessionFactory;
        this.sessionUidAccess = sessionUidAccess;
        this.converter = new MultiTableSqmMutationConverter(entityDescriptor, (SqmStatement<?>)this.getSqmDelete(), (SqmRoot<?>)this.getSqmDelete().getTarget(), this.getDomainParameterXref(), queryOptions, loadQueryInfluencers, queryParameterBindings, this.getSessionFactory());
    }

    public EntityMappingType getEntityDescriptor() {
        return this.entityDescriptor;
    }

    public TemporaryTable getIdTable() {
        return this.idTable;
    }

    public AfterUseAction getAfterUseAction() {
        return this.afterUseAction;
    }

    public SqmDeleteStatement<?> getSqmDelete() {
        return this.sqmDelete;
    }

    public DomainParameterXref getDomainParameterXref() {
        return this.domainParameterXref;
    }

    public SessionFactoryImplementor getSessionFactory() {
        return this.sessionFactory;
    }

    public Function<SharedSessionContractImplementor, String> getSessionUidAccess() {
        return this.sessionUidAccess;
    }

    public MultiTableSqmMutationConverter getConverter() {
        return this.converter;
    }
}

