/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal.temptable;

import java.sql.Connection;
import java.sql.SQLException;
import org.hibernate.dialect.temptable.TemporaryTable;
import org.hibernate.dialect.temptable.TemporaryTableHelper;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.config.spi.StandardConverters;
import org.hibernate.engine.jdbc.connections.spi.JdbcConnectionAccess;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.query.sqm.mutation.spi.AfterUseAction;
import org.jboss.logging.Logger;

public class GlobalTemporaryTableStrategy {
    private static final Logger log = Logger.getLogger(GlobalTemporaryTableStrategy.class);
    public static final String SHORT_NAME = "global_temporary";
    public static final String CREATE_ID_TABLES = "hibernate.query.mutation_strategy.global_temporary.create_tables";
    public static final String DROP_ID_TABLES = "hibernate.query.mutation_strategy.global_temporary.drop_tables";
    private final TemporaryTable temporaryTable;
    private final SessionFactoryImplementor sessionFactory;
    private boolean prepared;
    private boolean dropIdTables;

    public GlobalTemporaryTableStrategy(TemporaryTable temporaryTable, SessionFactoryImplementor sessionFactory) {
        this.temporaryTable = temporaryTable;
        this.sessionFactory = sessionFactory;
        if (sessionFactory.getJdbcServices().getDialect().getTemporaryTableAfterUseAction() == AfterUseAction.DROP) {
            throw new IllegalArgumentException("Global-temp ID tables cannot use AfterUseAction.DROP : " + temporaryTable.getTableExpression());
        }
    }

    public EntityMappingType getEntityDescriptor() {
        return this.temporaryTable.getEntityDescriptor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare(MappingModelCreationProcess mappingModelCreationProcess, JdbcConnectionAccess connectionAccess) {
        Connection connection;
        if (this.prepared) {
            return;
        }
        this.prepared = true;
        ConfigurationService configService = mappingModelCreationProcess.getCreationContext().getBootstrapContext().getServiceRegistry().requireService(ConfigurationService.class);
        boolean createIdTables = configService.getSetting(CREATE_ID_TABLES, StandardConverters.BOOLEAN, Boolean.valueOf(true));
        if (!createIdTables) {
            return;
        }
        log.debugf("Creating global-temp ID table : %s", (Object)this.getTemporaryTable().getTableExpression());
        TemporaryTableHelper.TemporaryTableCreationWork temporaryTableCreationWork = new TemporaryTableHelper.TemporaryTableCreationWork(this.getTemporaryTable(), this.sessionFactory);
        try {
            connection = connectionAccess.obtainConnection();
        }
        catch (UnsupportedOperationException e) {
            log.debug((Object)"Unable to obtain JDBC connection; assuming ID tables already exist or wont be needed");
            return;
        }
        catch (SQLException e) {
            log.error((Object)"Unable obtain JDBC Connection", (Throwable)e);
            return;
        }
        try {
            temporaryTableCreationWork.execute(connection);
            this.dropIdTables = configService.getSetting(DROP_ID_TABLES, StandardConverters.BOOLEAN, Boolean.valueOf(false));
        }
        finally {
            try {
                connectionAccess.releaseConnection(connection);
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(SessionFactoryImplementor sessionFactory, JdbcConnectionAccess connectionAccess) {
        Connection connection;
        if (!this.dropIdTables) {
            return;
        }
        this.dropIdTables = false;
        log.debugf("Dropping global-temp ID table : %s", (Object)this.getTemporaryTable().getTableExpression());
        TemporaryTableHelper.TemporaryTableDropWork temporaryTableDropWork = new TemporaryTableHelper.TemporaryTableDropWork(this.getTemporaryTable(), sessionFactory);
        try {
            connection = connectionAccess.obtainConnection();
        }
        catch (UnsupportedOperationException e) {
            log.debugf("Unable to obtain JDBC connection; unable to drop global-temp ID table : %s", (Object)this.getTemporaryTable().getTableExpression());
            return;
        }
        catch (SQLException e) {
            log.error((Object)"Unable obtain JDBC Connection", (Throwable)e);
            return;
        }
        try {
            temporaryTableDropWork.execute(connection);
        }
        finally {
            try {
                connectionAccess.releaseConnection(connection);
            }
            catch (SQLException sQLException) {}
        }
    }

    public TemporaryTable getTemporaryTable() {
        return this.temporaryTable;
    }

    public SessionFactoryImplementor getSessionFactory() {
        return this.sessionFactory;
    }
}

