/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal.temptable;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.hibernate.dialect.temptable.TemporaryTable;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.spi.MappingMetamodelImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.SqmJdbcExecutionContextAdapter;
import org.hibernate.query.sqm.mutation.internal.MultiTableSqmMutationConverter;
import org.hibernate.query.sqm.mutation.internal.UpdateHandler;
import org.hibernate.query.sqm.mutation.internal.temptable.UpdateExecutionDelegate;
import org.hibernate.query.sqm.mutation.spi.AbstractMutationHandler;
import org.hibernate.query.sqm.mutation.spi.AfterUseAction;
import org.hibernate.query.sqm.tree.AbstractSqmDmlStatement;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.update.SqmUpdateStatement;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.predicate.PredicateCollector;
import org.hibernate.sql.ast.tree.update.Assignment;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.jboss.logging.Logger;

public class TableBasedUpdateHandler
extends AbstractMutationHandler
implements UpdateHandler {
    private static final Logger log = Logger.getLogger(TableBasedUpdateHandler.class);
    private final TemporaryTable idTable;
    private final AfterUseAction afterUseAction;
    private final Function<SharedSessionContractImplementor, String> sessionUidAccess;
    private final DomainParameterXref domainParameterXref;

    public TableBasedUpdateHandler(SqmUpdateStatement<?> sqmUpdate, DomainParameterXref domainParameterXref, TemporaryTable idTable, AfterUseAction afterUseAction, Function<SharedSessionContractImplementor, String> sessionUidAccess, SessionFactoryImplementor sessionFactory) {
        super(sqmUpdate, sessionFactory);
        this.idTable = idTable;
        this.afterUseAction = afterUseAction;
        this.sessionUidAccess = sessionUidAccess;
        this.domainParameterXref = domainParameterXref;
    }

    protected SqmUpdateStatement<?> getSqmUpdate() {
        return this.getSqmDeleteOrUpdateStatement();
    }

    public SqmUpdateStatement<?> getSqmDeleteOrUpdateStatement() {
        return (SqmUpdateStatement)super.getSqmDeleteOrUpdateStatement();
    }

    @Override
    public int execute(DomainQueryExecutionContext executionContext) {
        if (log.isTraceEnabled()) {
            log.tracef("Starting multi-table update execution - %s", (Object)((SqmRoot)((SqmUpdateStatement)this.getSqmDeleteOrUpdateStatement()).getRoot()).getModel().getName());
        }
        SqmJdbcExecutionContextAdapter executionContextAdapter = SqmJdbcExecutionContextAdapter.omittingLockingAndPaging(executionContext);
        return this.resolveDelegate(executionContext).execute(executionContextAdapter);
    }

    protected ExecutionDelegate resolveDelegate(DomainQueryExecutionContext executionContext) {
        SessionFactoryImplementor sessionFactory = this.getSessionFactory();
        MappingMetamodelImplementor domainModel = sessionFactory.getRuntimeMetamodels().getMappingMetamodel();
        EntityPersister entityDescriptor = domainModel.getEntityDescriptor(((SqmRoot)((AbstractSqmDmlStatement)((Object)this.getSqmDeleteOrUpdateStatement())).getTarget()).getEntityName());
        String rootEntityName = entityDescriptor.getRootEntityName();
        EntityPersister rootEntityDescriptor = domainModel.getEntityDescriptor(rootEntityName);
        String hierarchyRootTableName = rootEntityDescriptor.getTableName();
        MultiTableSqmMutationConverter converterDelegate = new MultiTableSqmMutationConverter(entityDescriptor, this.getSqmDeleteOrUpdateStatement(), (SqmRoot<?>)((AbstractSqmDmlStatement)((Object)this.getSqmDeleteOrUpdateStatement())).getTarget(), this.domainParameterXref, executionContext.getQueryOptions(), executionContext.getSession().getLoadQueryInfluencers(), executionContext.getQueryParameterBindings(), sessionFactory);
        TableGroup updatingTableGroup = converterDelegate.getMutatingTableGroup();
        TableReference hierarchyRootTableReference = updatingTableGroup.resolveTableReference(updatingTableGroup.getNavigablePath(), hierarchyRootTableName);
        assert (hierarchyRootTableReference != null);
        Object assignments = converterDelegate.visitSetClause(((SqmUpdateStatement)this.getSqmDeleteOrUpdateStatement()).getSetClause());
        converterDelegate.addVersionedAssignment(((List)assignments)::add, (SqmUpdateStatement<?>)this.getSqmDeleteOrUpdateStatement());
        PredicateCollector predicateCollector = new PredicateCollector(converterDelegate.visitWhereClause(this.getSqmUpdate().getWhereClause()));
        entityDescriptor.applyBaseRestrictions(predicateCollector::applyPredicate, updatingTableGroup, true, executionContext.getSession().getLoadQueryInfluencers().getEnabledFilters(), false, null, converterDelegate);
        converterDelegate.pruneTableGroupJoins();
        HashMap<String, TableReference> tableReferenceByAlias = CollectionHelper.mapOfSize(updatingTableGroup.getTableReferenceJoins().size() + 1);
        this.collectTableReference(updatingTableGroup.getPrimaryTableReference(), tableReferenceByAlias::put);
        for (int i = 0; i < updatingTableGroup.getTableReferenceJoins().size(); ++i) {
            this.collectTableReference(updatingTableGroup.getTableReferenceJoins().get(i), tableReferenceByAlias::put);
        }
        return this.buildExecutionDelegate(converterDelegate, this.idTable, this.afterUseAction, this.sessionUidAccess, this.domainParameterXref, updatingTableGroup, tableReferenceByAlias, (List<Assignment>)assignments, predicateCollector.getPredicate(), executionContext);
    }

    protected UpdateExecutionDelegate buildExecutionDelegate(MultiTableSqmMutationConverter sqmConverter, TemporaryTable idTable, AfterUseAction afterUseAction, Function<SharedSessionContractImplementor, String> sessionUidAccess, DomainParameterXref domainParameterXref, TableGroup updatingTableGroup, Map<String, TableReference> tableReferenceByAlias, List<Assignment> assignments, Predicate suppliedPredicate, DomainQueryExecutionContext executionContext) {
        return new UpdateExecutionDelegate(sqmConverter, idTable, afterUseAction, sessionUidAccess, domainParameterXref, updatingTableGroup, tableReferenceByAlias, assignments, suppliedPredicate, executionContext);
    }

    protected void collectTableReference(TableReference tableReference, BiConsumer<String, TableReference> consumer) {
        consumer.accept(tableReference.getIdentificationVariable(), tableReference);
    }

    protected void collectTableReference(TableReferenceJoin tableReferenceJoin, BiConsumer<String, TableReference> consumer) {
        this.collectTableReference(tableReferenceJoin.getJoinedTableReference(), consumer);
    }

    public static interface ExecutionDelegate {
        public int execute(ExecutionContext var1);
    }
}

