/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.model.domain.TreatableDomainType;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.criteria.JpaPredicate;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.domain.SqmBagJoin;
import org.hibernate.query.sqm.tree.from.SqmTreatedAttributeJoin;
import org.hibernate.spi.NavigablePath;

public class SqmTreatedBagJoin<L, R, R1 extends R>
extends SqmBagJoin<L, R1>
implements SqmTreatedAttributeJoin<L, R, R1> {
    private final SqmBagJoin<L, R> wrappedPath;
    private final TreatableDomainType<R1> treatTarget;

    public SqmTreatedBagJoin(SqmBagJoin<L, R> wrappedPath, TreatableDomainType<R1> treatTarget, String alias) {
        this(wrappedPath, treatTarget, alias, false);
    }

    public SqmTreatedBagJoin(SqmBagJoin<L, R> wrappedPath, TreatableDomainType<R1> treatTarget, String alias, boolean fetched) {
        super(wrappedPath.getLhs(), wrappedPath.getNavigablePath().append(CollectionPart.Nature.ELEMENT.getName()).treatAs(treatTarget.getTypeName(), alias), wrappedPath.getAttribute(), alias, wrappedPath.getSqmJoinType(), fetched, (NodeBuilder)wrappedPath.nodeBuilder());
        this.treatTarget = treatTarget;
        this.wrappedPath = wrappedPath;
    }

    private SqmTreatedBagJoin(NavigablePath navigablePath, SqmBagJoin<L, R> wrappedPath, TreatableDomainType<R1> treatTarget, String alias, boolean fetched) {
        super(wrappedPath.getLhs(), navigablePath, wrappedPath.getAttribute(), alias, wrappedPath.getSqmJoinType(), wrappedPath.isFetched(), (NodeBuilder)wrappedPath.nodeBuilder());
        this.treatTarget = treatTarget;
        this.wrappedPath = wrappedPath;
    }

    @Override
    public SqmTreatedBagJoin<L, R, R1> copy(SqmCopyContext context) {
        SqmTreatedBagJoin existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmTreatedBagJoin<L, R, R1> path = context.registerCopy(this, new SqmTreatedBagJoin<L, R, R1>(this.getNavigablePath(), this.wrappedPath.copy(context), this.treatTarget, this.getExplicitAlias(), this.isFetched()));
        this.copyTo(path, context);
        return path;
    }

    public SqmBagJoin<L, R> getWrappedPath() {
        return this.wrappedPath;
    }

    @Override
    public TreatableDomainType<R1> getTreatTarget() {
        return this.treatTarget;
    }

    @Override
    public SqmPathSource<R1> getNodeType() {
        return this.treatTarget;
    }

    @Override
    public TreatableDomainType<R1> getReferencedPathSource() {
        return this.treatTarget;
    }

    @Override
    public SqmPathSource<?> getResolvedModel() {
        return this.treatTarget;
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        sb.append("treat(");
        this.wrappedPath.appendHqlString(sb);
        sb.append(" as ");
        sb.append(this.treatTarget.getTypeName());
        sb.append(')');
    }

    @Override
    public SqmTreatedBagJoin<L, R, R1> on(JpaExpression<Boolean> restriction) {
        return (SqmTreatedBagJoin)super.on((JpaExpression)restriction);
    }

    @Override
    public SqmTreatedBagJoin<L, R, R1> on(Expression<Boolean> restriction) {
        return (SqmTreatedBagJoin)super.on((Expression)restriction);
    }

    @Override
    public SqmTreatedBagJoin<L, R, R1> on(JpaPredicate ... restrictions) {
        return (SqmTreatedBagJoin)super.on(restrictions);
    }

    @Override
    public SqmTreatedBagJoin<L, R, R1> on(Predicate ... restrictions) {
        return (SqmTreatedBagJoin)super.on(restrictions);
    }
}

