/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import jakarta.persistence.criteria.Expression;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.internal.util.NullnessUtil;
import org.hibernate.internal.util.QuotingHelper;
import org.hibernate.query.criteria.JpaCastTarget;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.criteria.JpaJsonExistsNode;
import org.hibernate.query.criteria.JpaJsonQueryNode;
import org.hibernate.query.criteria.JpaJsonTableColumnsNode;
import org.hibernate.query.criteria.JpaJsonTableFunction;
import org.hibernate.query.criteria.JpaJsonValueNode;
import org.hibernate.query.derived.AnonymousTupleType;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.function.SelfRenderingSqmSetReturningFunction;
import org.hibernate.query.sqm.function.SetReturningFunctionRenderer;
import org.hibernate.query.sqm.function.SqmSetReturningFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.ArgumentsValidator;
import org.hibernate.query.sqm.produce.function.SetReturningFunctionTypeResolver;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.expression.SqmCastTarget;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.CastTarget;
import org.hibernate.sql.ast.tree.expression.JsonExistsErrorBehavior;
import org.hibernate.sql.ast.tree.expression.JsonPathPassingClause;
import org.hibernate.sql.ast.tree.expression.JsonQueryEmptyBehavior;
import org.hibernate.sql.ast.tree.expression.JsonQueryErrorBehavior;
import org.hibernate.sql.ast.tree.expression.JsonQueryWrapMode;
import org.hibernate.sql.ast.tree.expression.JsonTableColumnDefinition;
import org.hibernate.sql.ast.tree.expression.JsonTableColumnsClause;
import org.hibernate.sql.ast.tree.expression.JsonTableErrorBehavior;
import org.hibernate.sql.ast.tree.expression.JsonTableExistsColumnDefinition;
import org.hibernate.sql.ast.tree.expression.JsonTableNestedColumnDefinition;
import org.hibernate.sql.ast.tree.expression.JsonTableOrdinalityColumnDefinition;
import org.hibernate.sql.ast.tree.expression.JsonTableQueryColumnDefinition;
import org.hibernate.sql.ast.tree.expression.JsonTableValueColumnDefinition;
import org.hibernate.sql.ast.tree.expression.JsonValueEmptyBehavior;
import org.hibernate.sql.ast.tree.expression.JsonValueErrorBehavior;
import org.hibernate.type.BasicType;

public class SqmJsonTableFunction<T>
extends SelfRenderingSqmSetReturningFunction<T>
implements JpaJsonTableFunction {
    private final Set<String> columnNames = new HashSet<String>();
    private final Columns columns = new Columns(this);
    private @Nullable Map<String, SqmExpression<?>> passingExpressions;
    private JpaJsonTableFunction.ErrorBehavior errorBehavior;

    public SqmJsonTableFunction(SqmSetReturningFunctionDescriptor descriptor, SetReturningFunctionRenderer renderer, @Nullable ArgumentsValidator argumentsValidator, SetReturningFunctionTypeResolver setReturningTypeResolver, NodeBuilder nodeBuilder, SqmExpression<?> document, @Nullable SqmExpression<String> jsonPath) {
        this(descriptor, renderer, jsonPath == null ? Arrays.asList(document, null) : Arrays.asList(document, jsonPath, null), argumentsValidator, setReturningTypeResolver, nodeBuilder, null, JpaJsonTableFunction.ErrorBehavior.UNSPECIFIED);
    }

    private SqmJsonTableFunction(SqmSetReturningFunctionDescriptor descriptor, SetReturningFunctionRenderer renderer, List<SqmTypedNode<?>> arguments, @Nullable ArgumentsValidator argumentsValidator, SetReturningFunctionTypeResolver setReturningTypeResolver, NodeBuilder nodeBuilder, @Nullable Map<String, SqmExpression<?>> passingExpressions, JpaJsonTableFunction.ErrorBehavior errorBehavior) {
        super(descriptor, renderer, arguments, argumentsValidator, setReturningTypeResolver, nodeBuilder, "json_table");
        this.passingExpressions = passingExpressions;
        this.errorBehavior = errorBehavior;
        arguments.set(arguments.size() - 1, this.columns);
    }

    public Map<String, SqmExpression<?>> getPassingExpressions() {
        return this.passingExpressions == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.passingExpressions);
    }

    @Override
    public JpaJsonTableFunction passing(String parameterName, Expression<?> expression) {
        if (this.columns.jsonPath == null) {
            throw new IllegalStateException("Can't pass parameter '" + parameterName + "', because json_table has no JSON path");
        }
        if (this.passingExpressions == null) {
            this.passingExpressions = new HashMap();
        }
        this.passingExpressions.put(parameterName, (SqmExpression)expression);
        return this;
    }

    @Override
    public SqmJsonTableFunction<T> copy(SqmCopyContext context) {
        HashMap passingExpressions;
        SqmJsonTableFunction existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        List<SqmTypedNode<?>> arguments = this.getArguments();
        ArrayList argumentsCopy = new ArrayList(arguments.size());
        for (int i = 0; i < arguments.size() - 1; ++i) {
            argumentsCopy.add((SqmTypedNode<?>)arguments.get(i).copy(context));
        }
        if (this.passingExpressions == null) {
            passingExpressions = null;
        } else {
            passingExpressions = new HashMap(this.passingExpressions.size());
            for (Map.Entry<String, SqmExpression<?>> entry : this.passingExpressions.entrySet()) {
                passingExpressions.put(entry.getKey(), (SqmExpression<?>)entry.getValue().copy(context));
            }
        }
        SqmJsonTableFunction<T> tableFunction = new SqmJsonTableFunction<T>(this.getFunctionDescriptor(), this.getFunctionRenderer(), argumentsCopy, this.getArgumentsValidator(), this.getSetReturningTypeResolver(), this.nodeBuilder(), passingExpressions, this.errorBehavior);
        context.registerCopy(this, tableFunction);
        tableFunction.columnNames.addAll(this.columnNames);
        tableFunction.columns.columnDefinitions.ensureCapacity(this.columns.columnDefinitions.size());
        for (ColumnDefinition columnDefinition : this.columns.columnDefinitions) {
            tableFunction.columns.columnDefinitions.add(columnDefinition.copy(context));
        }
        return tableFunction;
    }

    @Override
    protected List<SqlAstNode> resolveSqlAstArguments(List<? extends SqmTypedNode<?>> sqmArguments, SqmToSqlAstConverter walker) {
        List<SqlAstNode> sqlAstNodes = super.resolveSqlAstArguments(sqmArguments, walker);
        sqlAstNodes.remove(sqlAstNodes.size() - 1);
        JsonPathPassingClause jsonPathPassingClause = this.createJsonPathPassingClause(walker);
        if (jsonPathPassingClause != null) {
            sqlAstNodes.add(jsonPathPassingClause);
        }
        switch (this.errorBehavior) {
            case NULL: {
                sqlAstNodes.add(JsonTableErrorBehavior.NULL);
                break;
            }
            case ERROR: {
                sqlAstNodes.add(JsonTableErrorBehavior.ERROR);
                break;
            }
        }
        ArrayList<JsonTableColumnDefinition> definitions = new ArrayList<JsonTableColumnDefinition>(this.columns.columnDefinitions.size());
        for (ColumnDefinition columnDefinition : this.columns.columnDefinitions) {
            definitions.add(columnDefinition.convertToSqlAst(walker));
        }
        sqlAstNodes.add(new JsonTableColumnsClause(definitions));
        return sqlAstNodes;
    }

    protected @Nullable JsonPathPassingClause createJsonPathPassingClause(SqmToSqlAstConverter walker) {
        if (this.passingExpressions == null || this.passingExpressions.isEmpty()) {
            return null;
        }
        HashMap<String, org.hibernate.sql.ast.tree.expression.Expression> converted = new HashMap<String, org.hibernate.sql.ast.tree.expression.Expression>(this.passingExpressions.size());
        for (Map.Entry<String, SqmExpression<?>> entry : this.passingExpressions.entrySet()) {
            converted.put(entry.getKey(), (org.hibernate.sql.ast.tree.expression.Expression)entry.getValue().accept(walker));
        }
        return new JsonPathPassingClause(converted);
    }

    @Override
    public JpaJsonTableFunction.ErrorBehavior getErrorBehavior() {
        return this.errorBehavior;
    }

    @Override
    public JpaJsonTableFunction unspecifiedOnError() {
        this.checkTypeResolved();
        this.errorBehavior = JpaJsonTableFunction.ErrorBehavior.UNSPECIFIED;
        return this;
    }

    @Override
    public SqmJsonTableFunction<T> nullOnError() {
        this.checkTypeResolved();
        this.errorBehavior = JpaJsonTableFunction.ErrorBehavior.NULL;
        return this;
    }

    @Override
    public SqmJsonTableFunction<T> errorOnError() {
        this.checkTypeResolved();
        this.errorBehavior = JpaJsonTableFunction.ErrorBehavior.ERROR;
        return this;
    }

    @Override
    public JpaJsonExistsNode existsColumn(String columnName) {
        return this.existsColumn(columnName, null);
    }

    @Override
    public JpaJsonExistsNode existsColumn(String columnName, @Nullable String jsonPath) {
        return this.columns.existsColumn(columnName, jsonPath);
    }

    @Override
    public JpaJsonQueryNode queryColumn(String columnName) {
        return this.queryColumn(columnName, null);
    }

    @Override
    public JpaJsonQueryNode queryColumn(String columnName, @Nullable String jsonPath) {
        return this.columns.queryColumn(columnName, jsonPath);
    }

    public <X> JpaJsonValueNode<X> valueColumn(String columnName, Class<X> type) {
        return this.valueColumn(columnName, type, (String)null);
    }

    public <X> JpaJsonValueNode<X> valueColumn(String columnName, Class<X> type, String jsonPath) {
        return this.columns.valueColumn(columnName, (Class)type, jsonPath);
    }

    public <X> JpaJsonValueNode<X> valueColumn(String columnName, JpaCastTarget<X> type, String jsonPath) {
        return this.columns.valueColumn(columnName, (JpaCastTarget)type, jsonPath);
    }

    public <X> JpaJsonValueNode<X> valueColumn(String columnName, JpaCastTarget<X> type) {
        return this.columns.valueColumn(columnName, (JpaCastTarget)type);
    }

    @Override
    public JpaJsonTableColumnsNode nested(String jsonPath) {
        return this.columns.nested(jsonPath);
    }

    @Override
    public JpaJsonTableFunction ordinalityColumn(String columnName) {
        this.columns.ordinalityColumn(columnName);
        return this;
    }

    private void addColumn(String columnName) {
        this.checkTypeResolved();
        if (!this.columnNames.add(columnName)) {
            throw new IllegalStateException("Duplicate column: " + columnName);
        }
    }

    private void checkTypeResolved() {
        if (this.isTypeResolved()) {
            throw new IllegalStateException("Type for json_table function is already resolved. Mutation is not allowed anymore");
        }
    }

    public static final class Columns
    extends NestedColumns
    implements SqmTypedNode<Object> {
        public Columns(SqmJsonTableFunction<?> table) {
            super("", table);
        }

        private Columns(SqmJsonTableFunction<?> table, ArrayList<ColumnDefinition> columnDefinitions) {
            super("", table, columnDefinitions);
        }

        public AnonymousTupleType<?> createTupleType() {
            if (this.table.columnNames.isEmpty()) {
                throw new IllegalArgumentException("Couldn't determine types of columns of function 'json_table'");
            }
            SqmExpressible[] componentTypes = new SqmExpressible[this.table.columnNames.size()];
            String[] componentNames = new String[this.table.columnNames.size()];
            int result = this.populateTupleType(0, componentNames, componentTypes);
            assert (result == componentTypes.length);
            return new AnonymousTupleType(componentTypes, componentNames);
        }

        @Override
        public Columns copy(SqmCopyContext context) {
            ArrayList<ColumnDefinition> definitions = new ArrayList<ColumnDefinition>(this.columnDefinitions.size());
            for (ColumnDefinition columnDefinition : this.columnDefinitions) {
                definitions.add(columnDefinition.copy(context));
            }
            return new Columns(context.getCopy(this.table), definitions);
        }

        @Override
        public @Nullable SqmExpressible<Object> getNodeType() {
            return null;
        }

        @Override
        public NodeBuilder nodeBuilder() {
            return this.table.nodeBuilder();
        }

        @Override
        public void appendHqlString(StringBuilder sb) {
            this.appendColumnsToHqlString(sb);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static interface ColumnDefinition {
        public ColumnDefinition copy(SqmCopyContext var1);

        public JsonTableColumnDefinition convertToSqlAst(SqmToSqlAstConverter var1);

        public void appendHqlString(StringBuilder var1);

        public int populateTupleType(int var1, String[] var2, SqmExpressible<?>[] var3);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static class NestedColumns
    implements ColumnDefinition,
    JpaJsonTableColumnsNode {
        protected final String jsonPath;
        protected final SqmJsonTableFunction<?> table;
        protected final ArrayList<ColumnDefinition> columnDefinitions;

        NestedColumns(String jsonPath, SqmJsonTableFunction<?> table) {
            this(jsonPath, table, new ArrayList<ColumnDefinition>());
        }

        private NestedColumns(String jsonPath, SqmJsonTableFunction<?> table, ArrayList<ColumnDefinition> columnDefinitions) {
            this.jsonPath = jsonPath;
            this.table = table;
            this.columnDefinitions = columnDefinitions;
        }

        @Override
        public int populateTupleType(int offset, String[] componentNames, SqmExpressible<?>[] componentTypes) {
            int i = 0;
            for (ColumnDefinition columnDefinition : this.columnDefinitions) {
                i += columnDefinition.populateTupleType(offset + i, componentNames, componentTypes);
            }
            return i;
        }

        @Override
        public NestedColumns copy(SqmCopyContext context) {
            ArrayList<ColumnDefinition> definitions = new ArrayList<ColumnDefinition>(this.columnDefinitions.size());
            for (ColumnDefinition columnDefinition : this.columnDefinitions) {
                definitions.add(columnDefinition.copy(context));
            }
            return new NestedColumns(this.jsonPath, context.getCopy(this.table), definitions);
        }

        @Override
        public JsonTableColumnDefinition convertToSqlAst(SqmToSqlAstConverter walker) {
            ArrayList<JsonTableColumnDefinition> nestedColumns = new ArrayList<JsonTableColumnDefinition>(this.columnDefinitions.size());
            for (ColumnDefinition column : this.columnDefinitions) {
                nestedColumns.add(column.convertToSqlAst(walker));
            }
            return new JsonTableNestedColumnDefinition(this.jsonPath, new JsonTableColumnsClause(nestedColumns));
        }

        @Override
        public void appendHqlString(StringBuilder sb) {
            sb.append("nested ");
            QuotingHelper.appendSingleQuoteEscapedString(sb, this.jsonPath);
            this.appendColumnsToHqlString(sb);
        }

        void appendColumnsToHqlString(StringBuilder sb) {
            String separator = " columns (";
            for (ColumnDefinition columnDefinition : this.columnDefinitions) {
                sb.append(separator);
                columnDefinition.appendHqlString(sb);
                separator = ", ";
            }
            sb.append(')');
        }

        @Override
        public JpaJsonExistsNode existsColumn(String columnName) {
            return this.existsColumn(columnName, null);
        }

        @Override
        public JpaJsonExistsNode existsColumn(String columnName, @Nullable String jsonPath) {
            BasicType<Boolean> type = this.table.nodeBuilder().getBooleanType();
            this.table.addColumn(columnName);
            ExistsColumnDefinition existsColumnDefinition = new ExistsColumnDefinition(columnName, type, jsonPath);
            this.columnDefinitions.add(existsColumnDefinition);
            return existsColumnDefinition;
        }

        @Override
        public JpaJsonQueryNode queryColumn(String columnName) {
            return this.queryColumn(columnName, null);
        }

        @Override
        public JpaJsonQueryNode queryColumn(String columnName, @Nullable String jsonPath) {
            BasicType<String> type = this.table.nodeBuilder().getTypeConfiguration().getBasicTypeRegistry().resolve(String.class, 3001);
            this.table.addColumn(columnName);
            QueryColumnDefinition queryColumnDefinition = new QueryColumnDefinition(columnName, type, jsonPath);
            this.columnDefinitions.add(queryColumnDefinition);
            return queryColumnDefinition;
        }

        public <X> JpaJsonValueNode<X> valueColumn(String columnName, Class<X> type) {
            return this.valueColumn(columnName, type, (String)null);
        }

        public <X> JpaJsonValueNode<X> valueColumn(String columnName, Class<X> type, String jsonPath) {
            return this.valueColumn(columnName, this.table.nodeBuilder().castTarget((Class)type), jsonPath);
        }

        public <X> JpaJsonValueNode<X> valueColumn(String columnName, JpaCastTarget<X> type) {
            return this.valueColumn(columnName, type, (String)null);
        }

        public <X> JpaJsonValueNode<X> valueColumn(String columnName, JpaCastTarget<X> type, String jsonPath) {
            SqmCastTarget sqmCastTarget = (SqmCastTarget)type;
            this.table.addColumn(columnName);
            ValueColumnDefinition valueColumnDefinition = new ValueColumnDefinition(columnName, sqmCastTarget, jsonPath);
            this.columnDefinitions.add(valueColumnDefinition);
            return valueColumnDefinition;
        }

        @Override
        public JpaJsonTableColumnsNode nested(String jsonPath) {
            this.table.checkTypeResolved();
            NestedColumns nestedColumnDefinition = new NestedColumns(jsonPath, this.table);
            this.columnDefinitions.add(nestedColumnDefinition);
            return nestedColumnDefinition;
        }

        @Override
        public JpaJsonTableColumnsNode ordinalityColumn(String columnName) {
            BasicType<Long> type = this.table.nodeBuilder().getLongType();
            this.table.addColumn(columnName);
            this.columnDefinitions.add(new OrdinalityColumnDefinition(columnName, type));
            return this;
        }

        public <X> X accept(SemanticQueryWalker<X> walker) {
            for (ColumnDefinition columnDefinition : this.columnDefinitions) {
                if (columnDefinition instanceof ValueColumnDefinition) {
                    ValueColumnDefinition definition = (ValueColumnDefinition)columnDefinition;
                    if (definition.emptyDefaultExpression != null) {
                        definition.emptyDefaultExpression.accept(walker);
                    }
                    if (definition.errorDefaultExpression == null) continue;
                    definition.errorDefaultExpression.accept(walker);
                    continue;
                }
                if (!(columnDefinition instanceof NestedColumns)) continue;
                NestedColumns nestedColumns = (NestedColumns)columnDefinition;
                nestedColumns.accept(walker);
            }
            return null;
        }
    }

    record OrdinalityColumnDefinition(String name, BasicType<Long> type) implements ColumnDefinition
    {
        @Override
        public ColumnDefinition copy(SqmCopyContext context) {
            return this;
        }

        @Override
        public JsonTableColumnDefinition convertToSqlAst(SqmToSqlAstConverter walker) {
            return new JsonTableOrdinalityColumnDefinition(this.name);
        }

        @Override
        public void appendHqlString(StringBuilder sb) {
            sb.append(this.name);
            sb.append(" for ordinality");
        }

        @Override
        public int populateTupleType(int offset, String[] componentNames, SqmExpressible<?>[] componentTypes) {
            componentNames[offset] = this.name;
            componentTypes[offset] = this.type;
            return 1;
        }
    }

    static final class ValueColumnDefinition<X>
    implements ColumnDefinition,
    JpaJsonValueNode<X> {
        private final String name;
        private final SqmCastTarget<?> type;
        private final @Nullable String jsonPath;
        private JpaJsonValueNode.ErrorBehavior errorBehavior = JpaJsonValueNode.ErrorBehavior.UNSPECIFIED;
        private JpaJsonValueNode.EmptyBehavior emptyBehavior = JpaJsonValueNode.EmptyBehavior.UNSPECIFIED;
        private @Nullable SqmExpression<X> errorDefaultExpression;
        private @Nullable SqmExpression<X> emptyDefaultExpression;

        ValueColumnDefinition(String name, SqmCastTarget<?> type, @Nullable String jsonPath) {
            this.name = name;
            this.type = type;
            this.jsonPath = jsonPath;
        }

        private ValueColumnDefinition(String name, SqmCastTarget<?> type, @Nullable String jsonPath, JpaJsonValueNode.ErrorBehavior errorBehavior, JpaJsonValueNode.EmptyBehavior emptyBehavior, @Nullable SqmExpression<X> errorDefaultExpression, @Nullable SqmExpression<X> emptyDefaultExpression) {
            this.name = name;
            this.type = type;
            this.jsonPath = jsonPath;
            this.errorBehavior = errorBehavior;
            this.emptyBehavior = emptyBehavior;
            this.errorDefaultExpression = errorDefaultExpression;
            this.emptyDefaultExpression = emptyDefaultExpression;
        }

        @Override
        public ColumnDefinition copy(SqmCopyContext context) {
            return new ValueColumnDefinition<X>(this.name, this.type, this.jsonPath, this.errorBehavior, this.emptyBehavior, this.errorDefaultExpression == null ? null : this.errorDefaultExpression.copy(context), this.emptyDefaultExpression == null ? null : this.emptyDefaultExpression.copy(context));
        }

        @Override
        public JsonTableColumnDefinition convertToSqlAst(SqmToSqlAstConverter walker) {
            CastTarget castTarget = (CastTarget)this.type.accept(walker);
            return new JsonTableValueColumnDefinition(this.name, castTarget, this.jsonPath, switch (this.errorBehavior) {
                default -> throw new IncompatibleClassChangeError();
                case JpaJsonValueNode.ErrorBehavior.UNSPECIFIED -> null;
                case JpaJsonValueNode.ErrorBehavior.NULL -> JsonValueErrorBehavior.NULL;
                case JpaJsonValueNode.ErrorBehavior.ERROR -> JsonValueErrorBehavior.ERROR;
                case JpaJsonValueNode.ErrorBehavior.DEFAULT -> JsonValueErrorBehavior.defaultOnError((org.hibernate.sql.ast.tree.expression.Expression)NullnessUtil.castNonNull(this.errorDefaultExpression).accept(walker));
            }, switch (this.emptyBehavior) {
                default -> throw new IncompatibleClassChangeError();
                case JpaJsonValueNode.EmptyBehavior.UNSPECIFIED -> null;
                case JpaJsonValueNode.EmptyBehavior.NULL -> JsonValueEmptyBehavior.NULL;
                case JpaJsonValueNode.EmptyBehavior.ERROR -> JsonValueEmptyBehavior.ERROR;
                case JpaJsonValueNode.EmptyBehavior.DEFAULT -> JsonValueEmptyBehavior.defaultOnEmpty((org.hibernate.sql.ast.tree.expression.Expression)NullnessUtil.castNonNull(this.emptyDefaultExpression).accept(walker));
            });
        }

        @Override
        public void appendHqlString(StringBuilder sb) {
            sb.append(this.name);
            sb.append(' ');
            this.type.appendHqlString(sb);
            if (this.jsonPath != null) {
                sb.append(" path ");
                QuotingHelper.appendSingleQuoteEscapedString(sb, this.jsonPath);
            }
            switch (this.errorBehavior) {
                case NULL: {
                    sb.append(" null on error");
                    break;
                }
                case ERROR: {
                    sb.append(" error on error");
                    break;
                }
                case DEFAULT: {
                    assert (this.errorDefaultExpression != null);
                    sb.append(" default ");
                    this.errorDefaultExpression.appendHqlString(sb);
                    sb.append(" on error");
                }
            }
            switch (this.emptyBehavior) {
                case NULL: {
                    sb.append(" null on empty");
                    break;
                }
                case ERROR: {
                    sb.append(" error on empty");
                    break;
                }
                case DEFAULT: {
                    assert (this.emptyDefaultExpression != null);
                    sb.append(" default ");
                    this.emptyDefaultExpression.appendHqlString(sb);
                    sb.append(" on empty");
                }
            }
        }

        @Override
        public int populateTupleType(int offset, String[] componentNames, SqmExpressible<?>[] componentTypes) {
            componentNames[offset] = this.name;
            componentTypes[offset] = this.type.getNodeType();
            return 1;
        }

        @Override
        public JpaJsonValueNode.ErrorBehavior getErrorBehavior() {
            return this.errorBehavior;
        }

        @Override
        public JpaJsonValueNode.EmptyBehavior getEmptyBehavior() {
            return this.emptyBehavior;
        }

        @Override
        public @Nullable JpaExpression<X> getErrorDefault() {
            return this.errorDefaultExpression;
        }

        @Override
        public @Nullable JpaExpression<X> getEmptyDefault() {
            return this.emptyDefaultExpression;
        }

        @Override
        public JpaJsonValueNode<X> unspecifiedOnError() {
            this.errorDefaultExpression = null;
            this.errorBehavior = JpaJsonValueNode.ErrorBehavior.UNSPECIFIED;
            return this;
        }

        @Override
        public JpaJsonValueNode<X> errorOnError() {
            this.errorDefaultExpression = null;
            this.errorBehavior = JpaJsonValueNode.ErrorBehavior.ERROR;
            return this;
        }

        @Override
        public JpaJsonValueNode<X> nullOnError() {
            this.errorDefaultExpression = null;
            this.errorBehavior = JpaJsonValueNode.ErrorBehavior.NULL;
            return this;
        }

        @Override
        public JpaJsonValueNode<X> defaultOnError(Expression<?> expression) {
            this.errorDefaultExpression = (SqmExpression)expression;
            this.errorBehavior = JpaJsonValueNode.ErrorBehavior.DEFAULT;
            return this;
        }

        @Override
        public JpaJsonValueNode<X> unspecifiedOnEmpty() {
            this.emptyDefaultExpression = null;
            this.emptyBehavior = JpaJsonValueNode.EmptyBehavior.UNSPECIFIED;
            return this;
        }

        @Override
        public JpaJsonValueNode<X> errorOnEmpty() {
            this.emptyDefaultExpression = null;
            this.emptyBehavior = JpaJsonValueNode.EmptyBehavior.ERROR;
            return this;
        }

        @Override
        public JpaJsonValueNode<X> nullOnEmpty() {
            this.emptyDefaultExpression = null;
            this.emptyBehavior = JpaJsonValueNode.EmptyBehavior.NULL;
            return this;
        }

        @Override
        public JpaJsonValueNode<X> defaultOnEmpty(Expression<?> expression) {
            this.emptyDefaultExpression = (SqmExpression)expression;
            this.emptyBehavior = JpaJsonValueNode.EmptyBehavior.DEFAULT;
            return this;
        }
    }

    static final class QueryColumnDefinition
    implements ColumnDefinition,
    JpaJsonQueryNode {
        private final String name;
        private final BasicType<String> type;
        private final @Nullable String jsonPath;
        private JpaJsonQueryNode.WrapMode wrapMode = JpaJsonQueryNode.WrapMode.UNSPECIFIED;
        private JpaJsonQueryNode.ErrorBehavior errorBehavior = JpaJsonQueryNode.ErrorBehavior.UNSPECIFIED;
        private JpaJsonQueryNode.EmptyBehavior emptyBehavior = JpaJsonQueryNode.EmptyBehavior.UNSPECIFIED;

        QueryColumnDefinition(String name, BasicType<String> type, @Nullable String jsonPath) {
            this.name = name;
            this.type = type;
            this.jsonPath = jsonPath;
        }

        private QueryColumnDefinition(String name, BasicType<String> type, @Nullable String jsonPath, JpaJsonQueryNode.WrapMode wrapMode, JpaJsonQueryNode.ErrorBehavior errorBehavior, JpaJsonQueryNode.EmptyBehavior emptyBehavior) {
            this.name = name;
            this.type = type;
            this.jsonPath = jsonPath;
            this.wrapMode = wrapMode;
            this.errorBehavior = errorBehavior;
            this.emptyBehavior = emptyBehavior;
        }

        @Override
        public ColumnDefinition copy(SqmCopyContext context) {
            return new QueryColumnDefinition(this.name, this.type, this.jsonPath, this.wrapMode, this.errorBehavior, this.emptyBehavior);
        }

        @Override
        public JsonTableColumnDefinition convertToSqlAst(SqmToSqlAstConverter walker) {
            return new JsonTableQueryColumnDefinition(this.name, this.type, this.jsonPath, switch (this.wrapMode) {
                default -> throw new IncompatibleClassChangeError();
                case JpaJsonQueryNode.WrapMode.WITH_WRAPPER -> JsonQueryWrapMode.WITH_WRAPPER;
                case JpaJsonQueryNode.WrapMode.WITHOUT_WRAPPER -> JsonQueryWrapMode.WITHOUT_WRAPPER;
                case JpaJsonQueryNode.WrapMode.WITH_CONDITIONAL_WRAPPER -> JsonQueryWrapMode.WITH_CONDITIONAL_WRAPPER;
                case JpaJsonQueryNode.WrapMode.UNSPECIFIED -> null;
            }, switch (this.errorBehavior) {
                default -> throw new IncompatibleClassChangeError();
                case JpaJsonQueryNode.ErrorBehavior.ERROR -> JsonQueryErrorBehavior.ERROR;
                case JpaJsonQueryNode.ErrorBehavior.NULL -> JsonQueryErrorBehavior.NULL;
                case JpaJsonQueryNode.ErrorBehavior.EMPTY_ARRAY -> JsonQueryErrorBehavior.EMPTY_ARRAY;
                case JpaJsonQueryNode.ErrorBehavior.EMPTY_OBJECT -> JsonQueryErrorBehavior.EMPTY_OBJECT;
                case JpaJsonQueryNode.ErrorBehavior.UNSPECIFIED -> null;
            }, switch (this.emptyBehavior) {
                default -> throw new IncompatibleClassChangeError();
                case JpaJsonQueryNode.EmptyBehavior.ERROR -> JsonQueryEmptyBehavior.ERROR;
                case JpaJsonQueryNode.EmptyBehavior.NULL -> JsonQueryEmptyBehavior.NULL;
                case JpaJsonQueryNode.EmptyBehavior.EMPTY_ARRAY -> JsonQueryEmptyBehavior.EMPTY_ARRAY;
                case JpaJsonQueryNode.EmptyBehavior.EMPTY_OBJECT -> JsonQueryEmptyBehavior.EMPTY_OBJECT;
                case JpaJsonQueryNode.EmptyBehavior.UNSPECIFIED -> null;
            });
        }

        @Override
        public void appendHqlString(StringBuilder sb) {
            sb.append(this.name);
            sb.append(" json");
            switch (this.wrapMode) {
                case WITH_WRAPPER: {
                    sb.append(" with wrapper");
                    break;
                }
                case WITHOUT_WRAPPER: {
                    sb.append(" without wrapper");
                    break;
                }
                case WITH_CONDITIONAL_WRAPPER: {
                    sb.append(" with conditional wrapper");
                }
            }
            if (this.jsonPath != null) {
                sb.append(" path ");
                QuotingHelper.appendSingleQuoteEscapedString(sb, this.jsonPath);
            }
            switch (this.errorBehavior) {
                case NULL: {
                    sb.append(" null on error");
                    break;
                }
                case ERROR: {
                    sb.append(" error on error");
                    break;
                }
                case EMPTY_ARRAY: {
                    sb.append(" empty array on error");
                    break;
                }
                case EMPTY_OBJECT: {
                    sb.append(" empty object on error");
                }
            }
            switch (this.emptyBehavior) {
                case NULL: {
                    sb.append(" null on empty");
                    break;
                }
                case ERROR: {
                    sb.append(" error on empty");
                    break;
                }
                case EMPTY_ARRAY: {
                    sb.append(" empty array on empty");
                    break;
                }
                case EMPTY_OBJECT: {
                    sb.append(" empty object on empty");
                }
            }
        }

        @Override
        public int populateTupleType(int offset, String[] componentNames, SqmExpressible<?>[] componentTypes) {
            componentNames[offset] = this.name;
            componentTypes[offset] = this.type;
            return 1;
        }

        @Override
        public JpaJsonQueryNode.WrapMode getWrapMode() {
            return this.wrapMode;
        }

        @Override
        public JpaJsonQueryNode.ErrorBehavior getErrorBehavior() {
            return this.errorBehavior;
        }

        @Override
        public JpaJsonQueryNode.EmptyBehavior getEmptyBehavior() {
            return this.emptyBehavior;
        }

        @Override
        public JpaJsonQueryNode withoutWrapper() {
            this.wrapMode = JpaJsonQueryNode.WrapMode.WITHOUT_WRAPPER;
            return this;
        }

        @Override
        public JpaJsonQueryNode withWrapper() {
            this.wrapMode = JpaJsonQueryNode.WrapMode.WITH_WRAPPER;
            return this;
        }

        @Override
        public JpaJsonQueryNode withConditionalWrapper() {
            this.wrapMode = JpaJsonQueryNode.WrapMode.WITH_CONDITIONAL_WRAPPER;
            return this;
        }

        @Override
        public JpaJsonQueryNode unspecifiedWrapper() {
            this.wrapMode = JpaJsonQueryNode.WrapMode.UNSPECIFIED;
            return this;
        }

        @Override
        public JpaJsonQueryNode unspecifiedOnError() {
            this.errorBehavior = JpaJsonQueryNode.ErrorBehavior.UNSPECIFIED;
            return this;
        }

        @Override
        public JpaJsonQueryNode errorOnError() {
            this.errorBehavior = JpaJsonQueryNode.ErrorBehavior.ERROR;
            return this;
        }

        @Override
        public JpaJsonQueryNode nullOnError() {
            this.errorBehavior = JpaJsonQueryNode.ErrorBehavior.NULL;
            return this;
        }

        @Override
        public JpaJsonQueryNode emptyArrayOnError() {
            this.errorBehavior = JpaJsonQueryNode.ErrorBehavior.EMPTY_ARRAY;
            return this;
        }

        @Override
        public JpaJsonQueryNode emptyObjectOnError() {
            this.errorBehavior = JpaJsonQueryNode.ErrorBehavior.EMPTY_OBJECT;
            return this;
        }

        @Override
        public JpaJsonQueryNode unspecifiedOnEmpty() {
            this.emptyBehavior = JpaJsonQueryNode.EmptyBehavior.UNSPECIFIED;
            return this;
        }

        @Override
        public JpaJsonQueryNode errorOnEmpty() {
            this.emptyBehavior = JpaJsonQueryNode.EmptyBehavior.ERROR;
            return this;
        }

        @Override
        public JpaJsonQueryNode nullOnEmpty() {
            this.emptyBehavior = JpaJsonQueryNode.EmptyBehavior.NULL;
            return this;
        }

        @Override
        public JpaJsonQueryNode emptyArrayOnEmpty() {
            this.emptyBehavior = JpaJsonQueryNode.EmptyBehavior.EMPTY_ARRAY;
            return this;
        }

        @Override
        public JpaJsonQueryNode emptyObjectOnEmpty() {
            this.emptyBehavior = JpaJsonQueryNode.EmptyBehavior.EMPTY_OBJECT;
            return this;
        }
    }

    static final class ExistsColumnDefinition
    implements ColumnDefinition,
    JpaJsonExistsNode {
        private final String name;
        private final BasicType<Boolean> type;
        private final @Nullable String jsonPath;
        private JpaJsonExistsNode.ErrorBehavior errorBehavior = JpaJsonExistsNode.ErrorBehavior.UNSPECIFIED;

        ExistsColumnDefinition(String name, BasicType<Boolean> type, @Nullable String jsonPath) {
            this.name = name;
            this.type = type;
            this.jsonPath = jsonPath;
        }

        private ExistsColumnDefinition(String name, BasicType<Boolean> type, @Nullable String jsonPath, JpaJsonExistsNode.ErrorBehavior errorBehavior) {
            this.name = name;
            this.type = type;
            this.jsonPath = jsonPath;
            this.errorBehavior = errorBehavior;
        }

        @Override
        public ColumnDefinition copy(SqmCopyContext context) {
            return new ExistsColumnDefinition(this.name, this.type, this.jsonPath, this.errorBehavior);
        }

        @Override
        public JsonTableColumnDefinition convertToSqlAst(SqmToSqlAstConverter walker) {
            return new JsonTableExistsColumnDefinition(this.name, this.type, this.jsonPath, switch (this.errorBehavior) {
                default -> throw new IncompatibleClassChangeError();
                case JpaJsonExistsNode.ErrorBehavior.ERROR -> JsonExistsErrorBehavior.ERROR;
                case JpaJsonExistsNode.ErrorBehavior.FALSE -> JsonExistsErrorBehavior.FALSE;
                case JpaJsonExistsNode.ErrorBehavior.TRUE -> JsonExistsErrorBehavior.TRUE;
                case JpaJsonExistsNode.ErrorBehavior.UNSPECIFIED -> null;
            });
        }

        @Override
        public void appendHqlString(StringBuilder sb) {
            sb.append(this.name);
            sb.append(" exists");
            if (this.jsonPath != null) {
                sb.append(" path ");
                QuotingHelper.appendSingleQuoteEscapedString(sb, this.jsonPath);
            }
            switch (this.errorBehavior) {
                case ERROR: {
                    sb.append(" error on error");
                    break;
                }
                case TRUE: {
                    sb.append(" true on error");
                    break;
                }
                case FALSE: {
                    sb.append(" false on error");
                }
            }
            sb.append(')');
        }

        @Override
        public int populateTupleType(int offset, String[] componentNames, SqmExpressible<?>[] componentTypes) {
            componentNames[offset] = this.name;
            componentTypes[offset] = this.type;
            return 1;
        }

        @Override
        public JpaJsonExistsNode.ErrorBehavior getErrorBehavior() {
            return this.errorBehavior;
        }

        @Override
        public JpaJsonExistsNode unspecifiedOnError() {
            this.errorBehavior = JpaJsonExistsNode.ErrorBehavior.UNSPECIFIED;
            return this;
        }

        @Override
        public JpaJsonExistsNode errorOnError() {
            this.errorBehavior = JpaJsonExistsNode.ErrorBehavior.ERROR;
            return this;
        }

        @Override
        public JpaJsonExistsNode trueOnError() {
            this.errorBehavior = JpaJsonExistsNode.ErrorBehavior.TRUE;
            return this;
        }

        @Override
        public JpaJsonExistsNode falseOnError() {
            this.errorBehavior = JpaJsonExistsNode.ErrorBehavior.FALSE;
            return this;
        }
    }
}

