/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.from;

import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Predicate;
import org.hibernate.Incubating;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.PersistentAttribute;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.criteria.JpaFunctionJoin;
import org.hibernate.query.criteria.JpaPredicate;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.spi.SqmCreationHelper;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmJoinType;
import org.hibernate.query.sqm.tree.domain.AbstractSqmJoin;
import org.hibernate.query.sqm.tree.domain.SqmCorrelation;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmTreatedJoin;
import org.hibernate.query.sqm.tree.expression.SqmSetReturningFunction;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.spi.NavigablePath;

@Incubating
public class SqmFunctionJoin<E>
extends AbstractSqmJoin<Object, E>
implements JpaFunctionJoin<E> {
    private final SqmSetReturningFunction<E> function;
    private final boolean lateral;

    public SqmFunctionJoin(SqmSetReturningFunction<E> function, String alias, SqmJoinType joinType, boolean lateral, SqmRoot<Object> sqmRoot) {
        this(SqmCreationHelper.buildRootNavigablePath("<<derived>>", alias), function, lateral, function.getType(), alias, SqmFunctionJoin.validateJoinType(joinType, lateral), sqmRoot);
    }

    public SqmFunctionJoin(NavigablePath navigablePath, SqmSetReturningFunction<E> function, boolean lateral, SqmPathSource<E> pathSource, String alias, SqmJoinType joinType, SqmRoot<Object> sqmRoot) {
        super(navigablePath, pathSource, sqmRoot, alias, joinType, sqmRoot.nodeBuilder());
        this.function = function;
        this.lateral = lateral;
    }

    private static SqmJoinType validateJoinType(SqmJoinType joinType, boolean lateral) {
        if (lateral) {
            switch (joinType) {
                case LEFT: 
                case INNER: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Lateral joins can only be left or inner. Illegal join type: " + joinType);
                }
            }
        }
        return joinType;
    }

    @Override
    public boolean isImplicitlySelectable() {
        return false;
    }

    @Override
    public SqmFunctionJoin<E> copy(SqmCopyContext context) {
        SqmFunctionJoin existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmFunctionJoin<E> path = context.registerCopy(this, new SqmFunctionJoin<E>(this.getNavigablePath(), this.function, this.lateral, this.getReferencedPathSource(), this.getExplicitAlias(), this.getSqmJoinType(), (SqmRoot<Object>)this.findRoot().copy(context)));
        this.copyTo(path, context);
        return path;
    }

    public SqmRoot<?> getRoot() {
        return (SqmRoot)super.getLhs();
    }

    @Override
    public SqmRoot<?> findRoot() {
        return this.getRoot();
    }

    @Override
    public SqmSetReturningFunction<E> getFunction() {
        return this.function;
    }

    public SqmPath<Long> index() {
        SqmPathSource indexPathSource = this.function.getType().getSubPathSource(CollectionPart.Nature.INDEX.getName());
        return this.resolvePath(indexPathSource.getPathName(), indexPathSource);
    }

    @Override
    public boolean isLateral() {
        return this.lateral;
    }

    @Override
    public SqmFrom<?, Object> getLhs() {
        return null;
    }

    @Override
    public SqmFunctionJoin<E> on(JpaExpression<Boolean> restriction) {
        return (SqmFunctionJoin)super.on((JpaExpression)restriction);
    }

    @Override
    public SqmFunctionJoin<E> on(Expression<Boolean> restriction) {
        return (SqmFunctionJoin)super.on((Expression)restriction);
    }

    @Override
    public SqmFunctionJoin<E> on(JpaPredicate ... restrictions) {
        return (SqmFunctionJoin)super.on(restrictions);
    }

    @Override
    public SqmFunctionJoin<E> on(Predicate ... restrictions) {
        return (SqmFunctionJoin)super.on(restrictions);
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitQualifiedFunctionJoin(this);
    }

    @Override
    public SqmCorrelation<Object, E> createCorrelation() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <S extends E> SqmTreatedJoin<Object, E, S> treatAs(Class<S> treatTarget) {
        throw new UnsupportedOperationException("Function joins can not be treated");
    }

    @Override
    public <S extends E> SqmTreatedJoin<Object, E, S> treatAs(EntityDomainType<S> treatTarget) {
        throw new UnsupportedOperationException("Function joins can not be treated");
    }

    @Override
    public <S extends E> SqmTreatedJoin<Object, E, S> treatAs(Class<S> treatJavaType, String alias) {
        throw new UnsupportedOperationException("Function joins can not be treated");
    }

    @Override
    public <S extends E> SqmTreatedJoin<Object, E, S> treatAs(EntityDomainType<S> treatTarget, String alias) {
        throw new UnsupportedOperationException("Function joins can not be treated");
    }

    @Override
    public <S extends E> SqmTreatedJoin<Object, E, S> treatAs(Class<S> treatJavaType, String alias, boolean fetched) {
        throw new UnsupportedOperationException("Function joins can not be treated");
    }

    @Override
    public <S extends E> SqmTreatedJoin<Object, E, S> treatAs(EntityDomainType<S> treatTarget, String alias, boolean fetched) {
        throw new UnsupportedOperationException("Function joins can not be treated");
    }

    @Override
    public PersistentAttribute<? super Object, ?> getAttribute() {
        return null;
    }

    @Override
    public SqmFrom<?, Object> getParent() {
        return super.getLhs();
    }

    @Override
    public JoinType getJoinType() {
        return this.getSqmJoinType().getCorrespondingJpaJoinType();
    }
}

