/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.expression;

import java.util.List;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.query.common.FrameExclusion;
import org.hibernate.query.common.FrameKind;
import org.hibernate.query.common.FrameMode;
import org.hibernate.query.sqm.sql.internal.DomainResultProducer;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.select.SortSpecification;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.basic.BasicResult;

public class Over<T>
implements Expression,
DomainResultProducer<T> {
    private final Expression expression;
    private final List<Expression> partitions;
    private final List<SortSpecification> orderList;
    private final FrameMode mode;
    private final FrameKind startKind;
    private final Expression startExpression;
    private final FrameKind endKind;
    private final Expression endExpression;
    private final FrameExclusion exclusion;

    public Over(Expression expression, List<Expression> partitions, List<SortSpecification> orderList) {
        this.expression = expression;
        this.partitions = partitions;
        this.orderList = orderList;
        this.mode = FrameMode.RANGE;
        this.startKind = FrameKind.UNBOUNDED_PRECEDING;
        this.startExpression = null;
        this.endKind = FrameKind.CURRENT_ROW;
        this.endExpression = null;
        this.exclusion = FrameExclusion.NO_OTHERS;
    }

    public Over(Expression expression, List<Expression> partitions, List<SortSpecification> orderList, FrameMode mode, FrameKind startKind, Expression startExpression, FrameKind endKind, Expression endExpression, FrameExclusion exclusion) {
        this.expression = expression;
        this.partitions = partitions;
        this.orderList = orderList;
        this.mode = mode;
        this.startKind = startKind;
        this.startExpression = startExpression;
        this.endKind = endKind;
        this.endExpression = endExpression;
        this.exclusion = exclusion;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public List<Expression> getPartitions() {
        return this.partitions;
    }

    public List<SortSpecification> getOrderList() {
        return this.orderList;
    }

    public FrameMode getMode() {
        return this.mode;
    }

    public FrameKind getStartKind() {
        return this.startKind;
    }

    public Expression getStartExpression() {
        return this.startExpression;
    }

    public FrameKind getEndKind() {
        return this.endKind;
    }

    public Expression getEndExpression() {
        return this.endExpression;
    }

    public FrameExclusion getExclusion() {
        return this.exclusion;
    }

    @Override
    public JdbcMappingContainer getExpressionType() {
        return this.expression.getExpressionType();
    }

    @Override
    public void accept(SqlAstWalker walker) {
        walker.visitOver(this);
    }

    @Override
    public DomainResult<T> createDomainResult(String resultVariable, DomainResultCreationState creationState) {
        SqlSelection sqlSelection = this.createSelection(creationState.getSqlAstCreationState());
        return new BasicResult(sqlSelection.getValuesArrayPosition(), resultVariable, this.expression.getExpressionType().getSingleJdbcMapping());
    }

    @Override
    public void applySqlSelections(DomainResultCreationState creationState) {
        this.createSelection(creationState.getSqlAstCreationState());
    }

    private SqlSelection createSelection(SqlAstCreationState creationState) {
        return creationState.getSqlExpressionResolver().resolveSqlSelection(this, this.expression.getExpressionType().getSingleJdbcMapping().getJdbcJavaType(), null, creationState.getCreationContext().getSessionFactory().getTypeConfiguration());
    }
}

