/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal;

import jakarta.persistence.TupleElement;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.stream.Collectors;
import org.hibernate.InstantiationException;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.tree.SqmExpressibleAccessor;
import org.hibernate.sql.results.graph.instantiation.internal.InstantiationHelper;
import org.hibernate.sql.results.internal.TupleMetadata;
import org.hibernate.sql.results.spi.RowTransformer;
import org.hibernate.type.spi.TypeConfiguration;

public class RowTransformerConstructorImpl<T>
implements RowTransformer<T> {
    private final Class<T> type;
    private final Constructor<T> constructor;

    public RowTransformerConstructorImpl(Class<T> type, TupleMetadata tupleMetadata, TypeConfiguration typeConfiguration) {
        this.type = type;
        List<TupleElement<?>> elements = tupleMetadata.getList();
        List<Class<?>> argumentTypes = elements.stream().map(RowTransformerConstructorImpl::resolveElementJavaType).collect(Collectors.toList());
        if (argumentTypes.size() == 1 && argumentTypes.get(0) == null) {
            throw new InstantiationException("Cannot instantiate query result type, argument types are unknown ", type);
        }
        this.constructor = InstantiationHelper.findMatchingConstructor(type, argumentTypes, typeConfiguration);
        if (this.constructor == null) {
            throw new InstantiationException("Cannot instantiate query result type, found no matching constructor", type);
        }
        this.constructor.setAccessible(true);
    }

    private static Class<?> resolveElementJavaType(TupleElement<?> element) {
        SqmExpressible expressible;
        if (element instanceof SqmExpressibleAccessor && (expressible = ((SqmExpressibleAccessor)element).getExpressible()) != null && expressible.getExpressibleJavaType() != null) {
            return expressible.getExpressibleJavaType().getJavaTypeClass();
        }
        return element.getJavaType();
    }

    @Override
    public T transformRow(Object[] row) {
        try {
            return this.constructor.newInstance(row);
        }
        catch (Exception e) {
            throw new InstantiationException("Cannot instantiate query result type", this.type, e);
        }
    }

    @Override
    public int determineNumberOfResultElements(int rawElementCount) {
        return 1;
    }
}

