/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.Internal;
import org.hibernate.MappingException;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.metamodel.spi.ImplicitDiscriminatorStrategy;
import org.hibernate.type.AbstractType;
import org.hibernate.type.MappingContext;
import org.hibernate.type.Type;

@Internal
public class MetaType
extends AbstractType {
    public static final String[] REGISTRATION_KEYS = ArrayHelper.EMPTY_STRING_ARRAY;
    private final Type valueType;
    private final ImplicitDiscriminatorStrategy implicitValueStrategy;
    private final Map<Object, String> discriminatorValuesToEntityNameMap;
    private final Map<String, Object> entityNameToDiscriminatorValueMap;

    public MetaType(Type valueType, ImplicitDiscriminatorStrategy implicitValueStrategy, Map<Object, String> explicitValueMappings) {
        this.valueType = valueType;
        this.implicitValueStrategy = implicitValueStrategy;
        if (explicitValueMappings == null || explicitValueMappings.isEmpty()) {
            this.discriminatorValuesToEntityNameMap = new HashMap<Object, String>();
            this.entityNameToDiscriminatorValueMap = new HashMap<String, Object>();
        } else {
            this.discriminatorValuesToEntityNameMap = explicitValueMappings;
            this.entityNameToDiscriminatorValueMap = new HashMap<String, Object>();
            for (Map.Entry<Object, String> entry : this.discriminatorValuesToEntityNameMap.entrySet()) {
                this.entityNameToDiscriminatorValueMap.put(entry.getValue(), entry.getKey());
            }
        }
    }

    public Type getBaseType() {
        return this.valueType;
    }

    public ImplicitDiscriminatorStrategy getImplicitValueStrategy() {
        return this.implicitValueStrategy;
    }

    public String[] getRegistrationKeys() {
        return REGISTRATION_KEYS;
    }

    public Map<Object, String> getDiscriminatorValuesToEntityNameMap() {
        return this.discriminatorValuesToEntityNameMap;
    }

    public Map<String, Object> getEntityNameToDiscriminatorValueMap() {
        return this.entityNameToDiscriminatorValueMap;
    }

    @Override
    public int[] getSqlTypeCodes(MappingContext mappingContext) throws MappingException {
        return this.valueType.getSqlTypeCodes(mappingContext);
    }

    @Override
    public int getColumnSpan(MappingContext mapping) throws MappingException {
        return this.valueType.getColumnSpan(mapping);
    }

    @Override
    public Class<?> getReturnedClass() {
        return String.class;
    }

    @Override
    public int compare(Object x, Object y, SessionFactoryImplementor sessionFactory) {
        return this.compare(x, y);
    }

    @Override
    public void nullSafeSet(PreparedStatement st, Object value, int index, SharedSessionContractImplementor session) throws HibernateException, SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void nullSafeSet(PreparedStatement st, Object value, int index, boolean[] settable, SharedSessionContractImplementor session) throws HibernateException, SQLException {
        if (settable[0]) {
            this.nullSafeSet(st, value, index, session);
        }
    }

    @Override
    public String toLoggableString(Object value, SessionFactoryImplementor factory) throws HibernateException {
        return this.toXMLString(value, factory);
    }

    public String toXMLString(Object value, SessionFactoryImplementor factory) throws HibernateException {
        return (String)value;
    }

    @Deprecated(since="7.0")
    public Object fromXMLString(String xml, Mapping factory) throws HibernateException {
        return this.fromXMLString(xml, (MappingContext)factory);
    }

    public Object fromXMLString(String xml, MappingContext mappingContext) throws HibernateException {
        return xml;
    }

    @Override
    public String getName() {
        return this.valueType.getName();
    }

    @Override
    public Object deepCopy(Object value, SessionFactoryImplementor factory) throws HibernateException {
        return value;
    }

    @Override
    public Object replace(Object original, Object target, SharedSessionContractImplementor session, Object owner, Map<Object, Object> copyCache) {
        return original;
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public boolean[] toColumnNullness(Object value, MappingContext mapping) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isDirty(Object old, Object current, boolean[] checkable, SharedSessionContractImplementor session) throws HibernateException {
        return checkable[0] && this.isDirty(old, current, session);
    }
}

