/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Locale;
import org.hibernate.dialect.Dialect;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractClassJavaType;
import org.hibernate.type.descriptor.java.CoercionException;
import org.hibernate.type.descriptor.java.CoercionHelper;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public class BigIntegerJavaType
extends AbstractClassJavaType<BigInteger> {
    public static final BigIntegerJavaType INSTANCE = new BigIntegerJavaType();

    public BigIntegerJavaType() {
        super(BigInteger.class);
    }

    @Override
    public String toString(BigInteger value) {
        return value.toString();
    }

    @Override
    public BigInteger fromString(CharSequence string) {
        return new BigInteger(string.toString());
    }

    @Override
    public int extractHashCode(BigInteger value) {
        return value.intValue();
    }

    @Override
    public <X> X unwrap(BigInteger value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (BigInteger.class.isAssignableFrom(type)) {
            return (X)value;
        }
        if (BigDecimal.class.isAssignableFrom(type)) {
            return (X)new BigDecimal(value);
        }
        if (Byte.class.isAssignableFrom(type)) {
            return (X)Byte.valueOf(value.byteValue());
        }
        if (Short.class.isAssignableFrom(type)) {
            return (X)Short.valueOf(value.shortValue());
        }
        if (Integer.class.isAssignableFrom(type)) {
            return (X)Integer.valueOf(value.intValue());
        }
        if (Long.class.isAssignableFrom(type)) {
            return (X)Long.valueOf(value.longValue());
        }
        if (Double.class.isAssignableFrom(type)) {
            return (X)Double.valueOf(value.doubleValue());
        }
        if (Float.class.isAssignableFrom(type)) {
            return (X)Float.valueOf(value.floatValue());
        }
        if (String.class.isAssignableFrom(type)) {
            return (X)value.toString();
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> BigInteger wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (value instanceof BigInteger) {
            BigInteger bigInteger = (BigInteger)value;
            return bigInteger;
        }
        if (value instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)value;
            return bigDecimal.toBigIntegerExact();
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return BigInteger.valueOf(number.longValue());
        }
        if (value instanceof String) {
            String string = (String)value;
            return new BigInteger(string);
        }
        throw this.unknownWrap(value.getClass());
    }

    @Override
    public boolean isWider(JavaType<?> javaType) {
        return switch (javaType.getTypeName()) {
            case "byte", "java.lang.Byte", "short", "java.lang.Short", "int", "java.lang.Integer", "long", "java.lang.Long" -> true;
            default -> false;
        };
    }

    @Override
    public long getDefaultSqlLength(Dialect dialect, JdbcType jdbcType) {
        return this.getDefaultSqlPrecision(dialect, jdbcType) + 1;
    }

    @Override
    public int getDefaultSqlPrecision(Dialect dialect, JdbcType jdbcType) {
        return dialect.getDefaultDecimalPrecision();
    }

    @Override
    public int getDefaultSqlScale(Dialect dialect, JdbcType jdbcType) {
        return 0;
    }

    @Override
    public <X> BigInteger coerce(X value, JavaType.CoercionContext coercionContext) {
        if (value == null) {
            return null;
        }
        if (value instanceof BigInteger) {
            BigInteger bigInteger = (BigInteger)value;
            return bigInteger;
        }
        if (value instanceof Byte) {
            Byte byteValue = (Byte)value;
            return BigInteger.valueOf(byteValue.byteValue());
        }
        if (value instanceof Short) {
            Short shortValue = (Short)value;
            return BigInteger.valueOf(shortValue.shortValue());
        }
        if (value instanceof Integer) {
            Integer integerValue = (Integer)value;
            return BigInteger.valueOf(integerValue.intValue());
        }
        if (value instanceof Long) {
            Long longValue = (Long)value;
            return BigInteger.valueOf(longValue);
        }
        if (value instanceof Double) {
            Double doubleValue = (Double)value;
            return CoercionHelper.toBigInteger(doubleValue);
        }
        if (value instanceof Float) {
            Float floatValue = (Float)value;
            return CoercionHelper.toBigInteger(floatValue);
        }
        if (value instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)value;
            return CoercionHelper.toBigInteger(bigDecimal);
        }
        if (value instanceof String) {
            String string = (String)value;
            return CoercionHelper.coerceWrappingError(() -> BigInteger.valueOf(Long.parseLong(string)));
        }
        throw new CoercionException(String.format(Locale.ROOT, "Unable to coerce value [%s (%s)] to BigInteger", value, value.getClass().getName()));
    }
}

