/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.io.Reader;
import java.io.Serializable;
import java.sql.NClob;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.SharedSessionContract;
import org.hibernate.engine.jdbc.CharacterStream;
import org.hibernate.engine.jdbc.LobCreator;
import org.hibernate.engine.jdbc.NClobImplementer;
import org.hibernate.engine.jdbc.proxy.NClobProxy;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractClassJavaType;
import org.hibernate.type.descriptor.java.DataHelper;
import org.hibernate.type.descriptor.java.IncomparableComparator;
import org.hibernate.type.descriptor.java.MutabilityPlan;

public class NClobJavaType
extends AbstractClassJavaType<NClob> {
    public static final NClobJavaType INSTANCE = new NClobJavaType();

    public NClobJavaType() {
        super(NClob.class, NClobMutabilityPlan.INSTANCE, IncomparableComparator.INSTANCE);
    }

    @Override
    public String extractLoggableRepresentation(NClob value) {
        return value == null ? "null" : "{nclob}";
    }

    @Override
    public String toString(NClob value) {
        return DataHelper.extractString(value);
    }

    @Override
    public NClob fromString(CharSequence string) {
        return NClobProxy.generateProxy(string.toString());
    }

    @Override
    public int extractHashCode(NClob value) {
        return System.identityHashCode(value);
    }

    @Override
    public boolean areEqual(NClob one, NClob another) {
        return one == another;
    }

    @Override
    public NClob getReplacement(NClob original, NClob target, SharedSessionContractImplementor session) {
        return session.getJdbcServices().getJdbcEnvironment().getDialect().getLobMergeStrategy().mergeNClob(original, target, session);
    }

    @Override
    public <X> X unwrap(NClob value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        try {
            if (NClob.class.isAssignableFrom(type)) {
                return (X)options.getLobCreator().toJdbcNClob(value);
            }
            if (String.class.isAssignableFrom(type)) {
                if (value instanceof NClobImplementer) {
                    NClobImplementer clobImplementer = (NClobImplementer)((Object)value);
                    return (X)clobImplementer.getUnderlyingStream().asString();
                }
                return (X)DataHelper.extractString(value.getCharacterStream());
            }
            if (Reader.class.isAssignableFrom(type)) {
                if (value instanceof NClobImplementer) {
                    NClobImplementer clobImplementer = (NClobImplementer)((Object)value);
                    return (X)clobImplementer.getUnderlyingStream().asReader();
                }
                return (X)value.getCharacterStream();
            }
            if (CharacterStream.class.isAssignableFrom(type)) {
                if (value instanceof NClobImplementer) {
                    NClobImplementer clobImplementer = (NClobImplementer)((Object)value);
                    return (X)clobImplementer.getUnderlyingStream();
                }
                return (X)value.getCharacterStream();
            }
        }
        catch (SQLException e) {
            throw new HibernateException("Unable to access nclob stream", e);
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> NClob wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        LobCreator lobCreator = options.getLobCreator();
        if (value instanceof NClob) {
            NClob clob = (NClob)value;
            return lobCreator.wrap(clob);
        }
        if (value instanceof String) {
            String string = (String)value;
            return lobCreator.createNClob(string);
        }
        if (value instanceof Reader) {
            Reader reader = (Reader)value;
            return lobCreator.createNClob(DataHelper.extractString(reader));
        }
        if (value instanceof CharacterStream) {
            CharacterStream stream = (CharacterStream)value;
            return lobCreator.createNClob(stream.asReader(), stream.getLength());
        }
        throw this.unknownWrap(value.getClass());
    }

    public static class NClobMutabilityPlan
    implements MutabilityPlan<NClob> {
        public static final NClobMutabilityPlan INSTANCE = new NClobMutabilityPlan();

        @Override
        public boolean isMutable() {
            return false;
        }

        @Override
        public NClob deepCopy(NClob value) {
            return value;
        }

        @Override
        public Serializable disassemble(NClob value, SharedSessionContract session) {
            throw new UnsupportedOperationException("Clobs are not cacheable");
        }

        @Override
        public NClob assemble(Serializable cached, SharedSessionContract session) {
            throw new UnsupportedOperationException("Clobs are not cacheable");
        }
    }
}

