/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.time.ZoneOffset;
import java.util.Comparator;
import org.hibernate.dialect.Dialect;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractClassJavaType;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.StringJavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;

public class ZoneOffsetJavaType
extends AbstractClassJavaType<ZoneOffset> {
    public static final ZoneOffsetJavaType INSTANCE = new ZoneOffsetJavaType();

    public ZoneOffsetJavaType() {
        super(ZoneOffset.class, ImmutableMutabilityPlan.instance(), ZoneOffsetComparator.INSTANCE);
    }

    @Override
    public boolean useObjectEqualsHashCode() {
        return true;
    }

    @Override
    public String toString(ZoneOffset value) {
        return value.getId();
    }

    @Override
    public ZoneOffset fromString(CharSequence string) {
        return ZoneOffset.of(string.toString());
    }

    @Override
    public JdbcType getRecommendedJdbcType(JdbcTypeIndicators context) {
        return StringJavaType.INSTANCE.getRecommendedJdbcType(context);
    }

    @Override
    public <X> X unwrap(ZoneOffset value, Class<X> type, WrapperOptions wrapperOptions) {
        if (value == null) {
            return null;
        }
        if (ZoneOffset.class.isAssignableFrom(type)) {
            return (X)value;
        }
        if (String.class.isAssignableFrom(type)) {
            return (X)this.toString(value);
        }
        if (Integer.class.isAssignableFrom(type)) {
            return (X)Integer.valueOf(value.getTotalSeconds());
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> ZoneOffset wrap(X value, WrapperOptions wrapperOptions) {
        if (value == null) {
            return null;
        }
        if (value instanceof ZoneOffset) {
            ZoneOffset zoneOffset = (ZoneOffset)value;
            return zoneOffset;
        }
        if (value instanceof CharSequence) {
            CharSequence charSequence = (CharSequence)value;
            return this.fromString(charSequence);
        }
        if (value instanceof Integer) {
            Integer integer = (Integer)value;
            return ZoneOffset.ofTotalSeconds(integer);
        }
        throw this.unknownWrap(value.getClass());
    }

    @Override
    public long getDefaultSqlLength(Dialect dialect, JdbcType jdbcType) {
        return 6L;
    }

    public static class ZoneOffsetComparator
    implements Comparator<ZoneOffset> {
        public static final ZoneOffsetComparator INSTANCE = new ZoneOffsetComparator();

        @Override
        public int compare(ZoneOffset o1, ZoneOffset o2) {
            return o1.getId().compareTo(o2.getId());
        }
    }
}

