/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.sql.internal;

import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.metamodel.mapping.SqlExpressible;
import org.hibernate.type.BasicPluralType;
import org.hibernate.type.BasicType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.converter.spi.BasicValueConverter;
import org.hibernate.type.descriptor.converter.spi.JpaAttributeConverter;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.spi.EmbeddableAggregateJavaType;
import org.hibernate.type.descriptor.sql.internal.DdlTypeImpl;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;

public class ArrayDdlTypeImpl
extends DdlTypeImpl {
    private final boolean castRawElementType;

    public ArrayDdlTypeImpl(Dialect dialect, boolean castRawElementType) {
        super(2003, "array", dialect);
        this.castRawElementType = castRawElementType;
    }

    @Override
    public String getCastTypeName(Size columnSize, SqlExpressible type, DdlTypeRegistry ddlTypeRegistry) {
        int paren;
        BasicPluralType pluralType = (BasicPluralType)type;
        BasicType elementType = pluralType.getElementType();
        String arrayElementTypeName = elementType.getJavaTypeDescriptor() instanceof EmbeddableAggregateJavaType ? ((EmbeddableAggregateJavaType)elementType.getJavaTypeDescriptor()).getStructName() : ddlTypeRegistry.getDescriptor(elementType.getJdbcType().getDdlTypeCode()).getCastTypeName(this.dialect.getSizeStrategy().resolveSize(elementType.getJdbcMapping().getJdbcType(), elementType.getJavaTypeDescriptor(), columnSize), elementType, ddlTypeRegistry);
        if (this.castRawElementType && (paren = arrayElementTypeName.indexOf(40)) > 0) {
            int parenEnd = arrayElementTypeName.lastIndexOf(41);
            arrayElementTypeName = parenEnd + 1 == arrayElementTypeName.length() ? arrayElementTypeName.substring(0, paren) : arrayElementTypeName.substring(0, paren) + arrayElementTypeName.substring(parenEnd + 1);
        }
        return this.dialect.getArrayTypeName(ArrayDdlTypeImpl.getElementTypeSimpleName(pluralType.getElementType(), this.dialect), arrayElementTypeName, columnSize.getArrayLength());
    }

    @Override
    public String getTypeName(Size columnSize, Type type, DdlTypeRegistry ddlTypeRegistry) {
        BasicPluralType pluralType = (BasicPluralType)type;
        BasicType elementType = pluralType.getElementType();
        String arrayElementTypeName = ddlTypeRegistry.getTypeName(elementType.getJdbcType().getDdlTypeCode(), this.dialect.getSizeStrategy().resolveSize(elementType.getJdbcMapping().getJdbcType(), elementType.getJavaTypeDescriptor(), columnSize), elementType);
        return this.dialect.getArrayTypeName(ArrayDdlTypeImpl.getElementTypeSimpleName(pluralType.getElementType(), this.dialect), arrayElementTypeName, columnSize.getArrayLength());
    }

    private static String getElementTypeSimpleName(BasicType<?> elementType, Dialect dialect) {
        BasicValueConverter<?, ?> converter = elementType.getValueConverter();
        if (converter != null) {
            if (converter instanceof JpaAttributeConverter) {
                return ((JpaAttributeConverter)converter).getConverterJavaType().getJavaTypeClass().getSimpleName();
            }
            return converter.getClass().getSimpleName();
        }
        JavaType<?> elementJavaType = elementType.getJavaTypeDescriptor();
        if (elementJavaType.getJavaTypeClass().isArray()) {
            return dialect.getArrayTypeName(elementJavaType.getJavaTypeClass().getComponentType().getSimpleName(), null, null);
        }
        Class<?> preferredJavaTypeClass = elementType.getJdbcType().getPreferredJavaTypeClass(null);
        if (preferredJavaTypeClass == null || preferredJavaTypeClass == elementJavaType.getJavaTypeClass()) {
            return elementJavaType.getJavaTypeClass().getSimpleName();
        }
        if (preferredJavaTypeClass.isArray()) {
            return elementJavaType.getJavaTypeClass().getSimpleName() + dialect.getArrayTypeName(preferredJavaTypeClass.getComponentType().getSimpleName(), null, null);
        }
        return elementJavaType.getJavaTypeClass().getSimpleName() + preferredJavaTypeClass.getSimpleName();
    }
}

