/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.beanvalidation;

import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;

public enum ValidationMode {
    AUTO,
    CALLBACK,
    NONE,
    DDL;


    private String externalForm() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case AUTO -> "auto";
            case CALLBACK -> "callback";
            case NONE -> "none";
            case DDL -> "ddl";
        };
    }

    public static Set<ValidationMode> getModes(Object modeProperty) {
        HashSet<ValidationMode> modes = CollectionHelper.setOfSize(3);
        if (modeProperty == null) {
            modes.add(AUTO);
        } else {
            for (String modeInString : StringHelper.split(",", modeProperty.toString())) {
                modes.add(ValidationMode.getMode(modeInString));
            }
        }
        if (modes.size() > 1 && (modes.contains((Object)AUTO) || modes.contains((Object)NONE))) {
            throw new HibernateException("Incompatible validation modes mixed: " + ValidationMode.loggable(modes));
        }
        return modes;
    }

    private static ValidationMode getMode(String modeProperty) {
        if (modeProperty == null || modeProperty.isEmpty()) {
            return AUTO;
        }
        try {
            return ValidationMode.valueOf(modeProperty.trim().toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            throw new HibernateException("Unknown validation mode in jakarta.persistence.validation.mode: " + modeProperty);
        }
    }

    public static String loggable(Set<ValidationMode> modes) {
        if (modes == null || modes.isEmpty()) {
            return "[<empty>]";
        }
        StringBuilder result = new StringBuilder("[");
        String sep = "";
        for (ValidationMode mode : modes) {
            result.append(sep).append(mode.externalForm());
            sep = ", ";
        }
        return result.append("]").toString();
    }
}

