/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.internal;

import jakarta.persistence.AttributeConverter;
import jakarta.persistence.Embeddable;
import jakarta.persistence.Entity;
import jakarta.persistence.MapsId;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.DuplicateMappingException;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.annotations.CollectionTypeRegistration;
import org.hibernate.annotations.Imported;
import org.hibernate.annotations.Parameter;
import org.hibernate.boot.CacheRegionDefinition;
import org.hibernate.boot.MappingException;
import org.hibernate.boot.SessionFactoryBuilder;
import org.hibernate.boot.internal.FailedSecondPassException;
import org.hibernate.boot.internal.ForeignKeyNameSource;
import org.hibernate.boot.internal.MetadataImpl;
import org.hibernate.boot.internal.NamedProcedureCallDefinitionImpl;
import org.hibernate.boot.model.IdentifierGeneratorDefinition;
import org.hibernate.boot.model.NamedEntityGraphDefinition;
import org.hibernate.boot.model.TypeDefinition;
import org.hibernate.boot.model.TypeDefinitionRegistry;
import org.hibernate.boot.model.TypeDefinitionRegistryStandardImpl;
import org.hibernate.boot.model.convert.internal.AttributeConverterManager;
import org.hibernate.boot.model.convert.internal.ClassBasedConverterDescriptor;
import org.hibernate.boot.model.convert.spi.ConverterAutoApplyHandler;
import org.hibernate.boot.model.convert.spi.ConverterDescriptor;
import org.hibernate.boot.model.convert.spi.ConverterRegistry;
import org.hibernate.boot.model.convert.spi.RegisteredConversion;
import org.hibernate.boot.model.internal.AggregateComponentSecondPass;
import org.hibernate.boot.model.internal.AnnotatedClassType;
import org.hibernate.boot.model.internal.CreateKeySecondPass;
import org.hibernate.boot.model.internal.FkSecondPass;
import org.hibernate.boot.model.internal.IdGeneratorResolver;
import org.hibernate.boot.model.internal.ImplicitToOneJoinTableSecondPass;
import org.hibernate.boot.model.internal.OptionalDeterminationSecondPass;
import org.hibernate.boot.model.internal.QuerySecondPass;
import org.hibernate.boot.model.internal.SecondaryTableFromAnnotationSecondPass;
import org.hibernate.boot.model.internal.SecondaryTableSecondPass;
import org.hibernate.boot.model.internal.SetBasicValueTypeSecondPass;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.AuxiliaryDatabaseObject;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.Namespace;
import org.hibernate.boot.model.relational.QualifiedTableName;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.boot.model.relational.internal.SqlStringGenerationContextImpl;
import org.hibernate.boot.model.source.internal.ImplicitColumnNamingSecondPass;
import org.hibernate.boot.model.source.spi.LocalMetadataBuildingContext;
import org.hibernate.boot.models.internal.ClassLoaderServiceLoading;
import org.hibernate.boot.models.internal.GlobalRegistrationsImpl;
import org.hibernate.boot.models.internal.ModelsHelper;
import org.hibernate.boot.models.spi.GlobalRegistrations;
import org.hibernate.boot.models.xml.internal.PersistenceUnitMetadataImpl;
import org.hibernate.boot.models.xml.spi.PersistenceUnitMetadata;
import org.hibernate.boot.query.NamedHqlQueryDefinition;
import org.hibernate.boot.query.NamedNativeQueryDefinition;
import org.hibernate.boot.query.NamedProcedureCallDefinition;
import org.hibernate.boot.query.NamedResultSetMappingDescriptor;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.MetadataBuildingOptions;
import org.hibernate.boot.spi.NaturalIdUniqueKeyBinder;
import org.hibernate.boot.spi.PropertyData;
import org.hibernate.boot.spi.SecondPass;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.config.spi.StandardConverters;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.DenormalizedTable;
import org.hibernate.mapping.FetchProfile;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.GeneratorSettings;
import org.hibernate.mapping.IdentifierCollection;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.MappedSuperclass;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.metamodel.CollectionClassification;
import org.hibernate.metamodel.mapping.DiscriminatorType;
import org.hibernate.metamodel.spi.EmbeddableInstantiator;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.ClassLoading;
import org.hibernate.models.spi.ModelsConfiguration;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.hibernate.query.named.NamedObjectRepository;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.function.SqmFunctionRegistry;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.usertype.CompositeUserType;
import org.hibernate.usertype.UserType;

public class InFlightMetadataCollectorImpl
implements InFlightMetadataCollector,
ConverterRegistry,
GeneratorSettings {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(InFlightMetadataCollectorImpl.class);
    private final BootstrapContext bootstrapContext;
    private final MetadataBuildingOptions options;
    private final GlobalRegistrations globalRegistrations;
    private final PersistenceUnitMetadata persistenceUnitMetadata;
    private final AttributeConverterManager attributeConverterManager = new AttributeConverterManager();
    private final UUID uuid;
    private final Map<String, PersistentClass> entityBindingMap = new HashMap<String, PersistentClass>();
    private final List<Component> composites = new ArrayList<Component>();
    private final Map<Class<?>, Component> genericComponentsMap = new HashMap();
    private final Map<ClassDetails, List<ClassDetails>> embeddableSubtypes = new HashMap<ClassDetails, List<ClassDetails>>();
    private final Map<Class<?>, DiscriminatorType<?>> embeddableDiscriminatorTypesMap = new HashMap();
    private final Map<String, org.hibernate.mapping.Collection> collectionBindingMap = new HashMap<String, org.hibernate.mapping.Collection>();
    private final Map<String, FilterDefinition> filterDefinitionMap = new HashMap<String, FilterDefinition>();
    private final Map<String, String> imports = new HashMap<String, String>();
    private final TypeDefinitionRegistry typeDefRegistry = new TypeDefinitionRegistryStandardImpl();
    private Database database;
    private final Map<String, NamedHqlQueryDefinition<?>> namedQueryMap = new HashMap();
    private final Map<String, NamedNativeQueryDefinition<?>> namedNativeQueryMap = new HashMap();
    private final Map<String, NamedProcedureCallDefinition> namedProcedureCallMap = new HashMap<String, NamedProcedureCallDefinition>();
    private final Map<String, NamedResultSetMappingDescriptor> sqlResultSetMappingMap = new HashMap<String, NamedResultSetMappingDescriptor>();
    private final Map<String, NamedEntityGraphDefinition> namedEntityGraphMap = new HashMap<String, NamedEntityGraphDefinition>();
    private final Map<String, FetchProfile> fetchProfileMap = new HashMap<String, FetchProfile>();
    private final Map<String, IdentifierGeneratorDefinition> idGeneratorDefinitionMap = new HashMap<String, IdentifierGeneratorDefinition>();
    private Map<String, SqmFunctionDescriptor> sqlFunctionMap;
    final ConfigurationService configurationService;
    private final Set<String> defaultIdentifierGeneratorNames = new HashSet<String>();
    private final Set<String> defaultNamedQueryNames = new HashSet<String>();
    private final Set<String> defaultNamedNativeQueryNames = new HashSet<String>();
    private final Set<String> defaultSqlResultSetMappingNames = new HashSet<String>();
    private final Set<String> defaultNamedProcedureNames = new HashSet<String>();
    private Map<Class<?>, MappedSuperclass> mappedSuperClasses;
    private Map<ClassDetails, Map<String, PropertyData>> propertiesAnnotatedWithMapsId;
    private Map<ClassDetails, Map<String, PropertyData>> propertiesAnnotatedWithIdAndToOne;
    private Map<String, String> mappedByResolver;
    private Map<String, String> propertyRefResolver;
    private Set<InFlightMetadataCollector.DelayedPropertyReferenceHandler> delayedPropertyReferenceHandlers;
    private List<Function<MetadataBuildingContext, Boolean>> valueResolvers;
    private final SourceModelBuildingContext sourceModelBuildingContext;
    private Map<Class<?>, Class<? extends EmbeddableInstantiator>> registeredInstantiators;
    private Map<Class<?>, Class<? extends CompositeUserType<?>>> registeredCompositeUserTypes;
    private Map<Class<?>, Class<? extends UserType<?>>> registeredUserTypes;
    private Map<CollectionClassification, InFlightMetadataCollector.CollectionTypeRegistrationDescriptor> collectionTypeRegistrations;
    private final Map<Identifier, Identifier> logicalToPhysicalTableNameMap = new HashMap<Identifier, Identifier>();
    private final Map<Identifier, Identifier> physicalToLogicalTableNameMap = new HashMap<Identifier, Identifier>();
    private Map<Table, TableColumnNameBinding> columnNameBindingByTableMap;
    private final Map<String, AnnotatedClassType> annotatedClassTypeMap = new HashMap<String, AnnotatedClassType>();
    private final Map<String, EntityTableXrefImpl> entityTableXrefMap = new HashMap<String, EntityTableXrefImpl>();
    private ArrayList<IdGeneratorResolver> idGeneratorResolverSecondPassList;
    private ArrayList<SetBasicValueTypeSecondPass> setBasicValueTypeSecondPassList;
    private ArrayList<AggregateComponentSecondPass> aggregateComponentSecondPassList;
    private ArrayList<FkSecondPass> fkSecondPassList;
    private ArrayList<CreateKeySecondPass> createKeySecondPassList;
    private ArrayList<ImplicitToOneJoinTableSecondPass> toOneJoinTableSecondPassList;
    private ArrayList<SecondaryTableSecondPass> secondaryTableSecondPassList;
    private ArrayList<SecondaryTableFromAnnotationSecondPass> secondaryTableFromAnnotationSecondPassesList;
    private ArrayList<QuerySecondPass> querySecondPassList;
    private ArrayList<ImplicitColumnNamingSecondPass> implicitColumnNamingSecondPassList;
    private ArrayList<SecondPass> generalSecondPassList;
    private ArrayList<OptionalDeterminationSecondPass> optionalDeterminationSecondPassList;
    private boolean inSecondPass = false;
    private Map<String, NaturalIdUniqueKeyBinder> naturalIdUniqueKeyBinderMap;

    public InFlightMetadataCollectorImpl(BootstrapContext bootstrapContext, SourceModelBuildingContext sourceModelBuildingContext, MetadataBuildingOptions options) {
        this.bootstrapContext = bootstrapContext;
        this.sourceModelBuildingContext = sourceModelBuildingContext;
        this.options = options;
        this.uuid = UUID.randomUUID();
        this.globalRegistrations = new GlobalRegistrationsImpl(sourceModelBuildingContext, bootstrapContext);
        this.persistenceUnitMetadata = new PersistenceUnitMetadataImpl();
        for (Map.Entry<String, SqmFunctionDescriptor> sqlFunctionEntry : bootstrapContext.getSqlFunctions().entrySet()) {
            if (this.sqlFunctionMap == null) {
                this.sqlFunctionMap = new ConcurrentHashMap<String, SqmFunctionDescriptor>(16, 0.75f, 1);
            }
            this.sqlFunctionMap.put(sqlFunctionEntry.getKey(), sqlFunctionEntry.getValue());
        }
        bootstrapContext.getAuxiliaryDatabaseObjectList().forEach(this.getDatabase()::addAuxiliaryDatabaseObject);
        this.configurationService = bootstrapContext.getServiceRegistry().requireService(ConfigurationService.class);
    }

    public InFlightMetadataCollectorImpl(BootstrapContext bootstrapContext, MetadataBuildingOptions options) {
        this(bootstrapContext, InFlightMetadataCollectorImpl.createModelBuildingContext(bootstrapContext), options);
    }

    private static SourceModelBuildingContext createModelBuildingContext(BootstrapContext bootstrapContext) {
        ClassLoaderService classLoaderService = bootstrapContext.getServiceRegistry().getService(ClassLoaderService.class);
        ClassLoaderServiceLoading classLoading = new ClassLoaderServiceLoading(classLoaderService);
        ModelsConfiguration modelsConfiguration = new ModelsConfiguration();
        modelsConfiguration.setClassLoading((ClassLoading)classLoading);
        modelsConfiguration.configValue((Object)"hibernate.models.jandex.index", bootstrapContext.getJandexView());
        modelsConfiguration.setRegistryPrimer(ModelsHelper::preFillRegistries);
        return modelsConfiguration.bootstrap();
    }

    @Override
    public UUID getUUID() {
        return null;
    }

    @Override
    public MetadataBuildingOptions getMetadataBuildingOptions() {
        return this.options;
    }

    @Override
    public BootstrapContext getBootstrapContext() {
        return this.bootstrapContext;
    }

    @Override
    public SourceModelBuildingContext getSourceModelBuildingContext() {
        return this.sourceModelBuildingContext;
    }

    @Override
    public GlobalRegistrations getGlobalRegistrations() {
        return this.globalRegistrations;
    }

    @Override
    public PersistenceUnitMetadata getPersistenceUnitMetadata() {
        return this.persistenceUnitMetadata;
    }

    @Override
    public TypeConfiguration getTypeConfiguration() {
        return this.bootstrapContext.getTypeConfiguration();
    }

    @Override
    public SqmFunctionRegistry getFunctionRegistry() {
        return this.bootstrapContext.getFunctionRegistry();
    }

    @Override
    public Database getDatabase() {
        if (this.database == null) {
            this.database = new Database(this.options);
        }
        return this.database;
    }

    @Override
    public NamedObjectRepository buildNamedQueryRepository() {
        throw new UnsupportedOperationException("#buildNamedQueryRepository should not be called on InFlightMetadataCollector");
    }

    @Override
    public Map<String, SqmFunctionDescriptor> getSqlFunctionMap() {
        return this.sqlFunctionMap;
    }

    @Override
    public Set<String> getContributors() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void orderColumns(boolean forceOrdering) {
    }

    @Override
    public void validate() throws org.hibernate.MappingException {
    }

    @Override
    public Set<MappedSuperclass> getMappedSuperclassMappingsCopy() {
        return new HashSet<MappedSuperclass>(this.mappedSuperClasses.values());
    }

    @Override
    public void initSessionFactory(SessionFactoryImplementor sessionFactory) {
        throw new UnsupportedOperationException("You should not be building a SessionFactory from an in-flight metadata collector; and of course we should better segment this in the API :)");
    }

    @Override
    public void registerComponent(Component component) {
        this.composites.add(component);
    }

    @Override
    public void visitRegisteredComponents(Consumer<Component> consumer) {
        this.composites.forEach(consumer);
    }

    @Override
    public void registerGenericComponent(Component component) {
        this.genericComponentsMap.put(component.getComponentClass(), component);
    }

    @Override
    public Component getGenericComponent(Class<?> componentClass) {
        return this.genericComponentsMap.get(componentClass);
    }

    @Override
    public void registerEmbeddableSubclass(ClassDetails superclass, ClassDetails subclass) {
        this.embeddableSubtypes.computeIfAbsent(superclass, c -> new ArrayList()).add(subclass);
    }

    @Override
    public List<ClassDetails> getEmbeddableSubclasses(ClassDetails superclass) {
        List<ClassDetails> subclasses = this.embeddableSubtypes.get(superclass);
        return subclasses != null ? subclasses : List.of();
    }

    @Override
    public DiscriminatorType<?> resolveEmbeddableDiscriminatorType(Class<?> embeddableClass, Supplier<DiscriminatorType<?>> supplier) {
        return this.embeddableDiscriminatorTypesMap.computeIfAbsent(embeddableClass, k -> (DiscriminatorType)supplier.get());
    }

    @Override
    public SessionFactoryBuilder getSessionFactoryBuilder() {
        throw new UnsupportedOperationException("You should not be building a SessionFactory from an in-flight metadata collector; and of course we should better segment this in the API :)");
    }

    @Override
    public SessionFactory buildSessionFactory() {
        throw new UnsupportedOperationException("You should not be building a SessionFactory from an in-flight metadata collector; and of course we should better segment this in the API :)");
    }

    @Override
    public Collection<PersistentClass> getEntityBindings() {
        return this.entityBindingMap.values();
    }

    @Override
    public Map<String, PersistentClass> getEntityBindingMap() {
        return this.entityBindingMap;
    }

    @Override
    public PersistentClass getEntityBinding(String entityName) {
        return this.entityBindingMap.get(entityName);
    }

    @Override
    public void addEntityBinding(PersistentClass persistentClass) throws DuplicateMappingException {
        String entityName = persistentClass.getEntityName();
        String jpaEntityName = persistentClass.getJpaEntityName();
        if (this.entityBindingMap.containsKey(entityName)) {
            throw new DuplicateMappingException(DuplicateMappingException.Type.ENTITY, entityName);
        }
        PersistentClass matchingPersistentClass = this.entityBindingMap.values().stream().filter(existingPersistentClass -> existingPersistentClass.getJpaEntityName().equals(jpaEntityName)).findFirst().orElse(null);
        if (matchingPersistentClass != null) {
            throw new DuplicateMappingException(String.format("Entity classes [%s] and [%s] share the entity name '%s' (entity names must be distinct)", matchingPersistentClass.getClassName(), persistentClass.getClassName(), jpaEntityName), DuplicateMappingException.Type.ENTITY, jpaEntityName);
        }
        this.entityBindingMap.put(entityName, persistentClass);
    }

    @Override
    public Collection<org.hibernate.mapping.Collection> getCollectionBindings() {
        return this.collectionBindingMap.values();
    }

    @Override
    public org.hibernate.mapping.Collection getCollectionBinding(String role) {
        return this.collectionBindingMap.get(role);
    }

    @Override
    public void addCollectionBinding(org.hibernate.mapping.Collection collection) throws DuplicateMappingException {
        String collectionRole = collection.getRole();
        if (this.collectionBindingMap.containsKey(collectionRole)) {
            throw new DuplicateMappingException(DuplicateMappingException.Type.COLLECTION, collectionRole);
        }
        this.collectionBindingMap.put(collectionRole, collection);
    }

    @Override
    public TypeDefinitionRegistry getTypeDefinitionRegistry() {
        return this.typeDefRegistry;
    }

    @Override
    public TypeDefinition getTypeDefinition(String registrationKey) {
        return this.typeDefRegistry.resolve(registrationKey);
    }

    @Override
    public void addTypeDefinition(TypeDefinition typeDefinition) {
        this.typeDefRegistry.register(typeDefinition);
    }

    @Override
    public void registerValueMappingResolver(Function<MetadataBuildingContext, Boolean> resolver) {
        if (this.valueResolvers == null) {
            this.valueResolvers = new ArrayList<Function<MetadataBuildingContext, Boolean>>();
        }
        this.valueResolvers.add(resolver);
    }

    @Override
    public void addJavaTypeRegistration(Class<?> javaType, JavaType<?> jtd) {
        this.getTypeConfiguration().getJavaTypeRegistry().addBaselineDescriptor(javaType, jtd);
    }

    @Override
    public void addJdbcTypeRegistration(int typeCode, JdbcType jdbcType) {
        this.getTypeConfiguration().getJdbcTypeRegistry().addDescriptor(typeCode, jdbcType);
    }

    @Override
    public void registerEmbeddableInstantiator(Class<?> embeddableType, Class<? extends EmbeddableInstantiator> instantiator) {
        if (this.registeredInstantiators == null) {
            this.registeredInstantiators = new HashMap();
        }
        this.registeredInstantiators.put(embeddableType, instantiator);
    }

    @Override
    public Class<? extends EmbeddableInstantiator> findRegisteredEmbeddableInstantiator(Class<?> embeddableType) {
        return this.registeredInstantiators == null ? null : this.registeredInstantiators.get(embeddableType);
    }

    @Override
    public void registerCompositeUserType(Class<?> embeddableType, Class<? extends CompositeUserType<?>> userType) {
        if (this.registeredCompositeUserTypes == null) {
            this.registeredCompositeUserTypes = new HashMap();
        }
        this.registeredCompositeUserTypes.put(embeddableType, userType);
    }

    @Override
    public Class<? extends CompositeUserType<?>> findRegisteredCompositeUserType(Class<?> embeddableType) {
        return this.registeredCompositeUserTypes == null ? null : this.registeredCompositeUserTypes.get(embeddableType);
    }

    @Override
    public void registerUserType(Class<?> basicType, Class<? extends UserType<?>> userType) {
        if (this.registeredUserTypes == null) {
            this.registeredUserTypes = new HashMap();
        }
        this.registeredUserTypes.put(basicType, userType);
    }

    @Override
    public Class<? extends UserType<?>> findRegisteredUserType(Class<?> basicType) {
        return this.registeredUserTypes == null ? null : this.registeredUserTypes.get(basicType);
    }

    @Override
    public void addCollectionTypeRegistration(CollectionTypeRegistration registrationAnnotation) {
        this.addCollectionTypeRegistration(registrationAnnotation.classification(), this.toDescriptor(registrationAnnotation));
    }

    @Override
    public void addCollectionTypeRegistration(CollectionClassification classification, InFlightMetadataCollector.CollectionTypeRegistrationDescriptor descriptor) {
        if (this.collectionTypeRegistrations == null) {
            this.collectionTypeRegistrations = new HashMap<CollectionClassification, InFlightMetadataCollector.CollectionTypeRegistrationDescriptor>();
        }
        this.collectionTypeRegistrations.put(classification, descriptor);
    }

    @Override
    public InFlightMetadataCollector.CollectionTypeRegistrationDescriptor findCollectionTypeRegistration(CollectionClassification classification) {
        return this.collectionTypeRegistrations == null ? null : this.collectionTypeRegistrations.get((Object)classification);
    }

    private InFlightMetadataCollector.CollectionTypeRegistrationDescriptor toDescriptor(CollectionTypeRegistration registrationAnnotation) {
        return new InFlightMetadataCollector.CollectionTypeRegistrationDescriptor(registrationAnnotation.type(), this.extractParameters(registrationAnnotation.parameters()));
    }

    private Map<String, String> extractParameters(Parameter[] annotationUsages) {
        if (CollectionHelper.isEmpty(annotationUsages)) {
            return null;
        }
        HashMap<String, String> result = CollectionHelper.mapOfSize(annotationUsages.length);
        for (Parameter parameter : annotationUsages) {
            result.put(parameter.name(), parameter.value());
        }
        return result;
    }

    @Override
    public ConverterRegistry getConverterRegistry() {
        return this;
    }

    public AttributeConverterManager getAttributeConverterManager() {
        return this.attributeConverterManager;
    }

    @Override
    public void addAttributeConverter(Class<? extends AttributeConverter<?, ?>> converterClass) {
        this.attributeConverterManager.addConverter(new ClassBasedConverterDescriptor(converterClass, this.getBootstrapContext().getClassmateContext()));
    }

    @Override
    public void addOverridableConverter(Class<? extends AttributeConverter<?, ?>> converterClass) {
        this.attributeConverterManager.addConverter(new ClassBasedConverterDescriptor(converterClass, this.getBootstrapContext().getClassmateContext()){

            @Override
            public boolean overrideable() {
                return true;
            }
        });
    }

    @Override
    public void addAttributeConverter(ConverterDescriptor descriptor) {
        this.attributeConverterManager.addConverter(descriptor);
    }

    @Override
    public void addRegisteredConversion(RegisteredConversion conversion) {
        this.attributeConverterManager.addRegistration(conversion, this.bootstrapContext);
    }

    @Override
    public ConverterAutoApplyHandler getAttributeConverterAutoApplyHandler() {
        return this.attributeConverterManager;
    }

    @Override
    public Map<String, FilterDefinition> getFilterDefinitions() {
        return this.filterDefinitionMap;
    }

    @Override
    public FilterDefinition getFilterDefinition(String name) {
        return this.filterDefinitionMap.get(name);
    }

    @Override
    public void addFilterDefinition(FilterDefinition filterDefinition) {
        if (filterDefinition == null || filterDefinition.getFilterName() == null) {
            throw new IllegalArgumentException("Filter definition object or name is null: " + filterDefinition);
        }
        this.filterDefinitionMap.put(filterDefinition.getFilterName(), filterDefinition);
    }

    @Override
    public Collection<FetchProfile> getFetchProfiles() {
        return this.fetchProfileMap.values();
    }

    @Override
    public FetchProfile getFetchProfile(String name) {
        return this.fetchProfileMap.get(name);
    }

    @Override
    public void addFetchProfile(FetchProfile profile) {
        if (profile == null || profile.getName() == null) {
            throw new IllegalArgumentException("Fetch profile object or name is null: " + profile);
        }
        FetchProfile old = this.fetchProfileMap.put(profile.getName(), profile);
        if (old != null) {
            log.warn("Duplicated fetch profile with same name [" + profile.getName() + "] found.");
        }
    }

    @Override
    public IdentifierGeneratorDefinition getIdentifierGenerator(String name) {
        if (name == null) {
            throw new IllegalArgumentException("null is not a valid generator name");
        }
        return this.idGeneratorDefinitionMap.get(name);
    }

    @Override
    public Collection<Table> collectTableMappings() {
        ArrayList<Table> tables = new ArrayList<Table>();
        for (Namespace namespace : this.getDatabase().getNamespaces()) {
            tables.addAll(namespace.getTables());
        }
        return tables;
    }

    @Override
    public void addIdentifierGenerator(IdentifierGeneratorDefinition generator) {
        IdentifierGeneratorDefinition old;
        if (generator == null || generator.getName() == null) {
            throw new IllegalArgumentException("ID generator object or name is null.");
        }
        if (!(generator.getName().isEmpty() || this.defaultIdentifierGeneratorNames.contains(generator.getName()) || (old = this.idGeneratorDefinitionMap.put(generator.getName(), generator)) == null || old.equals(generator))) {
            if (this.bootstrapContext.getJpaCompliance().isGlobalGeneratorScopeEnabled()) {
                throw new IllegalArgumentException("Duplicate generator name " + old.getName() + "; you will likely want to set the property hibernate.jpa.compliance.global_id_generators to false ");
            }
            log.duplicateGeneratorName(old.getName());
        }
    }

    @Override
    public void addDefaultIdentifierGenerator(IdentifierGeneratorDefinition generator) {
        this.addIdentifierGenerator(generator);
        this.defaultIdentifierGeneratorNames.add(generator.getName());
    }

    @Override
    public NamedEntityGraphDefinition getNamedEntityGraph(String name) {
        return this.namedEntityGraphMap.get(name);
    }

    @Override
    public Map<String, NamedEntityGraphDefinition> getNamedEntityGraphs() {
        return this.namedEntityGraphMap;
    }

    @Override
    public void addNamedEntityGraph(NamedEntityGraphDefinition definition) {
        String name = definition.getRegisteredName();
        NamedEntityGraphDefinition previous = this.namedEntityGraphMap.put(name, definition);
        if (previous != null) {
            throw new DuplicateMappingException(DuplicateMappingException.Type.NAMED_ENTITY_GRAPH, name);
        }
    }

    @Override
    public NamedHqlQueryDefinition<?> getNamedHqlQueryMapping(String name) {
        if (name == null) {
            throw new IllegalArgumentException("null is not a valid query name");
        }
        return this.namedQueryMap.get(name);
    }

    @Override
    public void visitNamedHqlQueryDefinitions(Consumer<NamedHqlQueryDefinition<?>> definitionConsumer) {
        this.namedQueryMap.values().forEach(definitionConsumer);
    }

    @Override
    public void addNamedQuery(NamedHqlQueryDefinition<?> def) {
        if (def == null) {
            throw new IllegalArgumentException("Named query definition is null");
        }
        if (def.getRegistrationName() == null) {
            throw new IllegalArgumentException("Named query definition name is null: " + def.getHqlString());
        }
        if (!this.defaultNamedQueryNames.contains(def.getRegistrationName())) {
            this.applyNamedQuery(def.getRegistrationName(), def);
        }
    }

    private void applyNamedQuery(String name, NamedHqlQueryDefinition<?> query) {
        this.checkQueryName(name);
        this.namedQueryMap.put(name.intern(), query);
    }

    private void checkQueryName(String name) throws DuplicateMappingException {
        if (this.namedQueryMap.containsKey(name) || this.namedNativeQueryMap.containsKey(name)) {
            throw new DuplicateMappingException(DuplicateMappingException.Type.QUERY, name);
        }
    }

    @Override
    public void addDefaultQuery(NamedHqlQueryDefinition<?> queryDefinition) {
        this.applyNamedQuery(queryDefinition.getRegistrationName(), queryDefinition);
        this.defaultNamedQueryNames.add(queryDefinition.getRegistrationName());
    }

    @Override
    public NamedNativeQueryDefinition<?> getNamedNativeQueryMapping(String name) {
        return this.namedNativeQueryMap.get(name);
    }

    @Override
    public void visitNamedNativeQueryDefinitions(Consumer<NamedNativeQueryDefinition<?>> definitionConsumer) {
        this.namedNativeQueryMap.values().forEach(definitionConsumer);
    }

    @Override
    public void addNamedNativeQuery(NamedNativeQueryDefinition<?> def) {
        if (def == null) {
            throw new IllegalArgumentException("Named native query definition object is null");
        }
        if (def.getRegistrationName() == null) {
            throw new IllegalArgumentException("Named native query definition name is null: " + def.getSqlQueryString());
        }
        if (!this.defaultNamedNativeQueryNames.contains(def.getRegistrationName())) {
            this.applyNamedNativeQuery(def.getRegistrationName(), def);
        }
    }

    private void applyNamedNativeQuery(String name, NamedNativeQueryDefinition<?> query) {
        this.checkQueryName(name);
        this.namedNativeQueryMap.put(name.intern(), query);
    }

    @Override
    public void addDefaultNamedNativeQuery(NamedNativeQueryDefinition<?> query) {
        this.applyNamedNativeQuery(query.getRegistrationName(), query);
        this.defaultNamedNativeQueryNames.add(query.getRegistrationName());
    }

    @Override
    public NamedProcedureCallDefinition getNamedProcedureCallMapping(String name) {
        return this.namedProcedureCallMap.get(name);
    }

    @Override
    public void visitNamedProcedureCallDefinition(Consumer<NamedProcedureCallDefinition> definitionConsumer) {
        this.namedProcedureCallMap.values().forEach(definitionConsumer);
    }

    @Override
    public void addNamedProcedureCallDefinition(NamedProcedureCallDefinition definition) {
        NamedProcedureCallDefinition previous;
        if (definition == null) {
            throw new IllegalArgumentException("Named query definition is null");
        }
        String name = definition.getRegistrationName();
        if (!this.defaultNamedProcedureNames.contains(name) && (previous = this.namedProcedureCallMap.put(name, definition)) != null) {
            throw new DuplicateMappingException(DuplicateMappingException.Type.PROCEDURE, name);
        }
    }

    @Override
    public void addDefaultNamedProcedureCall(NamedProcedureCallDefinitionImpl definition) {
        this.addNamedProcedureCallDefinition(definition);
        this.defaultNamedProcedureNames.add(definition.getRegistrationName());
    }

    @Override
    public NamedResultSetMappingDescriptor getResultSetMapping(String name) {
        return this.sqlResultSetMappingMap.get(name);
    }

    @Override
    public void visitNamedResultSetMappingDefinition(Consumer<NamedResultSetMappingDescriptor> definitionConsumer) {
        this.sqlResultSetMappingMap.values().forEach(definitionConsumer);
    }

    @Override
    public void addResultSetMapping(NamedResultSetMappingDescriptor resultSetMappingDescriptor) {
        if (resultSetMappingDescriptor == null) {
            throw new IllegalArgumentException("Result-set mapping was null");
        }
        String name = resultSetMappingDescriptor.getRegistrationName();
        if (name == null) {
            throw new IllegalArgumentException("Result-set mapping name is null: " + resultSetMappingDescriptor);
        }
        if (!this.defaultSqlResultSetMappingNames.contains(name)) {
            this.applyResultSetMapping(resultSetMappingDescriptor);
        }
    }

    public void applyResultSetMapping(NamedResultSetMappingDescriptor resultSetMappingDescriptor) {
        NamedResultSetMappingDescriptor old = this.sqlResultSetMappingMap.put(resultSetMappingDescriptor.getRegistrationName(), resultSetMappingDescriptor);
        if (old != null) {
            throw new DuplicateMappingException(DuplicateMappingException.Type.RESULT_SET_MAPPING, resultSetMappingDescriptor.getRegistrationName());
        }
    }

    @Override
    public void addDefaultResultSetMapping(NamedResultSetMappingDescriptor definition) {
        String name = definition.getRegistrationName();
        if (!this.defaultSqlResultSetMappingNames.contains(name)) {
            this.sqlResultSetMappingMap.remove(name);
        }
        this.applyResultSetMapping(definition);
        this.defaultSqlResultSetMappingNames.add(name);
    }

    @Override
    public Map<String, String> getImports() {
        return this.imports;
    }

    @Override
    public void addImport(String importName, String className) {
        if (importName == null || className == null) {
            throw new IllegalArgumentException("Import name or entity name is null");
        }
        log.tracev("Import: {0} -> {1}", importName, className);
        String old = this.imports.put(importName, className);
        if (old != null) {
            log.debugf("import name [%s] overrode previous [{%s}]", importName, old);
        }
    }

    @Override
    public Table addTable(String schemaName, String catalogName, String name, String subselectFragment, boolean isAbstract, MetadataBuildingContext buildingContext) {
        Identifier logicalName;
        Namespace namespace = this.getDatabase().locateNamespace(this.getDatabase().toIdentifier(catalogName), this.getDatabase().toIdentifier(schemaName));
        Identifier identifier = logicalName = name != null ? this.getDatabase().toIdentifier(name) : null;
        if (subselectFragment != null) {
            return new Table(buildingContext.getCurrentContributorName(), namespace, logicalName, subselectFragment, isAbstract);
        }
        Table existing = namespace.locateTable(logicalName);
        if (existing != null) {
            if (!isAbstract) {
                existing.setAbstract(false);
            }
            return existing;
        }
        return namespace.createTable(logicalName, physicalName -> new Table(buildingContext.getCurrentContributorName(), namespace, (Identifier)physicalName, isAbstract));
    }

    @Override
    public Table addDenormalizedTable(String schemaName, String catalogName, String name, boolean isAbstract, String subselectFragment, Table includedTable, MetadataBuildingContext buildingContext) throws DuplicateMappingException {
        Identifier logicalName;
        Database db = this.getDatabase();
        Namespace namespace = db.locateNamespace(db.toIdentifier(catalogName), db.toIdentifier(schemaName));
        Identifier identifier = logicalName = name != null ? db.toIdentifier(name) : null;
        if (subselectFragment != null) {
            return namespace.createDenormalizedTable(logicalName, physicalName -> new DenormalizedTable(buildingContext.getCurrentContributorName(), namespace, logicalName, subselectFragment, isAbstract, includedTable));
        }
        if (namespace.locateTable(logicalName) != null) {
            assert (logicalName != null);
            throw new DuplicateMappingException(DuplicateMappingException.Type.TABLE, logicalName.toString());
        }
        return namespace.createDenormalizedTable(logicalName, physicalTableName -> new DenormalizedTable(buildingContext.getCurrentContributorName(), namespace, (Identifier)physicalTableName, isAbstract, includedTable));
    }

    @Override
    public Type getIdentifierType(String entityName) throws org.hibernate.MappingException {
        PersistentClass pc = this.entityBindingMap.get(entityName);
        if (pc == null) {
            throw new org.hibernate.MappingException("persistent class not known: " + entityName);
        }
        return pc.getIdentifier().getType();
    }

    @Override
    public String getIdentifierPropertyName(String entityName) throws org.hibernate.MappingException {
        PersistentClass persistentClass = this.entityBindingMap.get(entityName);
        if (persistentClass == null) {
            throw new org.hibernate.MappingException("persistent class not known: " + entityName);
        }
        if (!persistentClass.hasIdentifierProperty()) {
            return null;
        }
        return persistentClass.getIdentifierProperty().getName();
    }

    @Override
    public Type getReferencedPropertyType(String entityName, String propertyName) throws org.hibernate.MappingException {
        PersistentClass persistentClass = this.entityBindingMap.get(entityName);
        if (persistentClass == null) {
            throw new org.hibernate.MappingException("persistent class not known: " + entityName);
        }
        Property prop = persistentClass.getReferencedProperty(propertyName);
        if (prop == null) {
            throw new org.hibernate.MappingException("property not known: " + entityName + "." + propertyName);
        }
        return prop.getType();
    }

    @Override
    public void addTableNameBinding(Identifier logicalName, Table table) {
        this.logicalToPhysicalTableNameMap.put(logicalName, table.getNameIdentifier());
        this.physicalToLogicalTableNameMap.put(table.getNameIdentifier(), logicalName);
    }

    @Override
    public void addTableNameBinding(String schema, String catalog, String logicalName, String realTableName, Table denormalizedSuperTable) {
        Identifier logicalNameIdentifier = this.getDatabase().toIdentifier(logicalName);
        Identifier physicalNameIdentifier = this.getDatabase().toIdentifier(realTableName);
        this.logicalToPhysicalTableNameMap.put(logicalNameIdentifier, physicalNameIdentifier);
        this.physicalToLogicalTableNameMap.put(physicalNameIdentifier, logicalNameIdentifier);
    }

    @Override
    public String getLogicalTableName(Table ownerTable) {
        Identifier logicalName = this.physicalToLogicalTableNameMap.get(ownerTable.getNameIdentifier());
        if (logicalName == null) {
            throw new org.hibernate.MappingException("Unable to find physical table: " + ownerTable.getName());
        }
        return logicalName.render();
    }

    @Override
    public String getPhysicalTableName(Identifier logicalName) {
        Identifier physicalName = this.logicalToPhysicalTableNameMap.get(logicalName);
        return physicalName == null ? null : physicalName.render();
    }

    @Override
    public String getPhysicalTableName(String logicalName) {
        return this.getPhysicalTableName(this.getDatabase().toIdentifier(logicalName));
    }

    @Override
    public void addColumnNameBinding(Table table, String logicalName, Column column) throws DuplicateMappingException {
        this.addColumnNameBinding(table, this.getDatabase().toIdentifier(logicalName), column);
    }

    @Override
    public void addColumnNameBinding(Table table, Identifier logicalName, Column column) throws DuplicateMappingException {
        TableColumnNameBinding binding = null;
        if (this.columnNameBindingByTableMap == null) {
            this.columnNameBindingByTableMap = new HashMap<Table, TableColumnNameBinding>();
        } else {
            binding = this.columnNameBindingByTableMap.get(table);
        }
        if (binding == null) {
            binding = new TableColumnNameBinding(table.getName());
            this.columnNameBindingByTableMap.put(table, binding);
        }
        binding.addBinding(logicalName, column);
    }

    @Override
    public String getPhysicalColumnName(Table table, String logicalName) throws org.hibernate.MappingException {
        Identifier identifier = this.getDatabase().toIdentifier(logicalName);
        if (identifier == null) {
            throw new org.hibernate.MappingException(String.format(Locale.ENGLISH, "Column with logical name '%s' in table '%s' cannot be mapped to column identifier", logicalName, table.getName()));
        }
        return this.getPhysicalColumnName(table, identifier);
    }

    @Override
    public String getPhysicalColumnName(Table table, Identifier logicalName) throws org.hibernate.MappingException {
        if (logicalName == null) {
            throw new org.hibernate.MappingException("Logical column name cannot be null");
        }
        Table currentTable = table;
        while (currentTable != null) {
            String physicalName;
            TableColumnNameBinding binding = this.columnNameBindingByTableMap.get(currentTable);
            if (binding != null && (physicalName = binding.logicalToPhysical.get(logicalName)) != null) {
                return physicalName;
            }
            if (currentTable instanceof DenormalizedTable) {
                currentTable = ((DenormalizedTable)currentTable).getIncludedTable();
                continue;
            }
            currentTable = null;
        }
        assert (table != null);
        throw new org.hibernate.MappingException("Unable to find column with logical name " + logicalName.render() + " in table " + table.getName());
    }

    @Override
    public String getLogicalColumnName(Table table, String physicalName) throws org.hibernate.MappingException {
        return this.getLogicalColumnName(table, this.getDatabase().toIdentifier(physicalName));
    }

    @Override
    public String getLogicalColumnName(Table table, Identifier physicalName) throws org.hibernate.MappingException {
        TableColumnNameBinding binding;
        String physicalNameString = physicalName.render(this.getDatabase().getJdbcEnvironment().getDialect());
        Identifier logicalName = null;
        Table currentTable = table;
        while (currentTable != null && ((binding = this.columnNameBindingByTableMap.get(currentTable)) == null || (logicalName = binding.physicalToLogical.get(physicalNameString)) == null)) {
            if (currentTable instanceof DenormalizedTable) {
                currentTable = ((DenormalizedTable)currentTable).getIncludedTable();
                continue;
            }
            currentTable = null;
        }
        if (logicalName == null) {
            assert (table != null);
            throw new org.hibernate.MappingException("Unable to find column with physical name '" + physicalNameString + "' in table '" + table.getName() + "'");
        }
        return logicalName.render();
    }

    @Override
    public void addAuxiliaryDatabaseObject(AuxiliaryDatabaseObject auxiliaryDatabaseObject) {
        this.getDatabase().addAuxiliaryDatabaseObject(auxiliaryDatabaseObject);
    }

    @Override
    public AnnotatedClassType getClassType(ClassDetails clazz) {
        AnnotatedClassType type = this.annotatedClassTypeMap.get(clazz.getName());
        if (type == null) {
            return this.addClassType(clazz);
        }
        return type;
    }

    @Override
    public AnnotatedClassType addClassType(ClassDetails clazz) {
        AnnotatedClassType type = InFlightMetadataCollectorImpl.getAnnotatedClassType(clazz);
        this.annotatedClassTypeMap.put(clazz.getName(), type);
        return type;
    }

    private static AnnotatedClassType getAnnotatedClassType(ClassDetails clazz) {
        if (clazz.hasDirectAnnotationUsage(Entity.class)) {
            if (clazz.hasDirectAnnotationUsage(Embeddable.class)) {
                throw new AnnotationException("Invalid class annotated both '@Entity' and '@Embeddable': '" + clazz.getName() + "'");
            }
            if (clazz.hasDirectAnnotationUsage(jakarta.persistence.MappedSuperclass.class)) {
                throw new AnnotationException("Invalid class annotated both '@Entity' and '@MappedSuperclass': '" + clazz.getName() + "'");
            }
            return AnnotatedClassType.ENTITY;
        }
        if (clazz.hasDirectAnnotationUsage(Embeddable.class)) {
            if (clazz.hasDirectAnnotationUsage(jakarta.persistence.MappedSuperclass.class)) {
                throw new AnnotationException("Invalid class annotated both '@Embeddable' and '@MappedSuperclass': '" + clazz.getName() + "'");
            }
            return AnnotatedClassType.EMBEDDABLE;
        }
        if (clazz.hasDirectAnnotationUsage(jakarta.persistence.MappedSuperclass.class)) {
            return AnnotatedClassType.MAPPED_SUPERCLASS;
        }
        if (clazz.hasDirectAnnotationUsage(Imported.class)) {
            return AnnotatedClassType.IMPORTED;
        }
        return AnnotatedClassType.NONE;
    }

    @Override
    public void addMappedSuperclass(Class<?> type, MappedSuperclass mappedSuperclass) {
        if (this.mappedSuperClasses == null) {
            this.mappedSuperClasses = new HashMap();
        }
        this.mappedSuperClasses.put(type, mappedSuperclass);
    }

    @Override
    public MappedSuperclass getMappedSuperclass(Class<?> type) {
        if (this.mappedSuperClasses == null) {
            return null;
        }
        return this.mappedSuperClasses.get(type);
    }

    @Override
    public PropertyData getPropertyAnnotatedWithMapsId(ClassDetails entityType, String propertyName) {
        if (this.propertiesAnnotatedWithMapsId == null) {
            return null;
        }
        Map<String, PropertyData> map = this.propertiesAnnotatedWithMapsId.get(entityType);
        return map == null ? null : map.get(propertyName);
    }

    @Override
    public void addPropertyAnnotatedWithMapsId(ClassDetails entityType, PropertyData property) {
        if (this.propertiesAnnotatedWithMapsId == null) {
            this.propertiesAnnotatedWithMapsId = new HashMap<ClassDetails, Map<String, PropertyData>>();
        }
        this.propertiesAnnotatedWithMapsId.computeIfAbsent(entityType, k -> new HashMap()).put(((MapsId)property.getAttributeMember().getDirectAnnotationUsage(MapsId.class)).value(), property);
    }

    @Override
    public void addPropertyAnnotatedWithMapsIdSpecj(ClassDetails entityType, PropertyData property, String mapsIdValue) {
        if (this.propertiesAnnotatedWithMapsId == null) {
            this.propertiesAnnotatedWithMapsId = new HashMap<ClassDetails, Map<String, PropertyData>>();
        }
        this.propertiesAnnotatedWithMapsId.computeIfAbsent(entityType, k -> new HashMap()).put(mapsIdValue, property);
    }

    @Override
    public PropertyData getPropertyAnnotatedWithIdAndToOne(ClassDetails entityType, String propertyName) {
        if (this.propertiesAnnotatedWithIdAndToOne == null) {
            return null;
        }
        Map<String, PropertyData> map = this.propertiesAnnotatedWithIdAndToOne.get(entityType);
        return map == null ? null : map.get(propertyName);
    }

    @Override
    public void addToOneAndIdProperty(ClassDetails entityType, PropertyData property) {
        if (this.propertiesAnnotatedWithIdAndToOne == null) {
            this.propertiesAnnotatedWithIdAndToOne = new HashMap<ClassDetails, Map<String, PropertyData>>();
        }
        this.propertiesAnnotatedWithIdAndToOne.computeIfAbsent(entityType, k -> new HashMap()).put(property.getPropertyName(), property);
    }

    @Override
    public void addMappedBy(String entityName, String propertyName, String inversePropertyName) {
        if (this.mappedByResolver == null) {
            this.mappedByResolver = new HashMap<String, String>();
        }
        this.mappedByResolver.put(entityName + "." + propertyName, inversePropertyName);
    }

    @Override
    public String getFromMappedBy(String entityName, String propertyName) {
        return this.mappedByResolver == null ? null : this.mappedByResolver.get(entityName + "." + propertyName);
    }

    @Override
    public void addPropertyReferencedAssociation(String entityName, String propertyName, String propertyRef) {
        if (this.propertyRefResolver == null) {
            this.propertyRefResolver = new HashMap<String, String>();
        }
        this.propertyRefResolver.put(entityName + "." + propertyName, propertyRef);
    }

    @Override
    public String getPropertyReferencedAssociation(String entityName, String propertyName) {
        return this.propertyRefResolver == null ? null : this.propertyRefResolver.get(entityName + "." + propertyName);
    }

    @Override
    public void addPropertyReference(String referencedClass, String propertyName) {
        this.addDelayedPropertyReferenceHandler(new DelayedPropertyReferenceHandlerAnnotationImpl(referencedClass, propertyName, false));
    }

    @Override
    public void addDelayedPropertyReferenceHandler(InFlightMetadataCollector.DelayedPropertyReferenceHandler handler) {
        if (this.delayedPropertyReferenceHandlers == null) {
            this.delayedPropertyReferenceHandlers = new HashSet<InFlightMetadataCollector.DelayedPropertyReferenceHandler>();
        }
        this.delayedPropertyReferenceHandlers.add(handler);
    }

    @Override
    public void addUniquePropertyReference(String referencedClass, String propertyName) {
        this.addDelayedPropertyReferenceHandler(new DelayedPropertyReferenceHandlerAnnotationImpl(referencedClass, propertyName, true));
    }

    @Override
    public InFlightMetadataCollector.EntityTableXref getEntityTableXref(String entityName) {
        return this.entityTableXrefMap.get(entityName);
    }

    @Override
    public InFlightMetadataCollector.EntityTableXref addEntityTableXref(String entityName, Identifier primaryTableLogicalName, Table primaryTable, InFlightMetadataCollector.EntityTableXref superEntityTableXref) {
        EntityTableXrefImpl entry = new EntityTableXrefImpl(primaryTableLogicalName, primaryTable, (EntityTableXrefImpl)superEntityTableXref);
        this.entityTableXrefMap.put(entityName, entry);
        return entry;
    }

    @Override
    public Map<String, Join> getJoins(String entityName) {
        EntityTableXrefImpl xrefEntry = this.entityTableXrefMap.get(entityName);
        return xrefEntry == null ? null : xrefEntry.secondaryTableJoinMap;
    }

    @Override
    public void addSecondPass(SecondPass secondPass) {
        this.addSecondPass(secondPass, false);
    }

    @Override
    public void addSecondPass(SecondPass secondPass, boolean onTopOfTheQueue) {
        if (secondPass instanceof IdGeneratorResolver) {
            IdGeneratorResolver generatorResolver = (IdGeneratorResolver)secondPass;
            this.addIdGeneratorResolverSecondPass(generatorResolver, onTopOfTheQueue);
        } else if (secondPass instanceof SetBasicValueTypeSecondPass) {
            SetBasicValueTypeSecondPass setBasicValueTypeSecondPass = (SetBasicValueTypeSecondPass)secondPass;
            this.addSetBasicValueTypeSecondPass(setBasicValueTypeSecondPass, onTopOfTheQueue);
        } else if (secondPass instanceof AggregateComponentSecondPass) {
            AggregateComponentSecondPass aggregateComponentSecondPass = (AggregateComponentSecondPass)secondPass;
            this.addAggregateComponentSecondPass(aggregateComponentSecondPass, onTopOfTheQueue);
        } else if (secondPass instanceof FkSecondPass) {
            FkSecondPass fkSecondPass = (FkSecondPass)secondPass;
            this.addFkSecondPass(fkSecondPass, onTopOfTheQueue);
        } else if (secondPass instanceof CreateKeySecondPass) {
            CreateKeySecondPass createKeySecondPass = (CreateKeySecondPass)secondPass;
            this.addCreateKeySecondPass(createKeySecondPass, onTopOfTheQueue);
        } else if (secondPass instanceof ImplicitToOneJoinTableSecondPass) {
            ImplicitToOneJoinTableSecondPass implicitToOneJoinTableSecondPass = (ImplicitToOneJoinTableSecondPass)secondPass;
            this.addImplicitToOneJoinTableSecondPass(implicitToOneJoinTableSecondPass);
        } else if (secondPass instanceof SecondaryTableSecondPass) {
            SecondaryTableSecondPass secondaryTableSecondPass = (SecondaryTableSecondPass)secondPass;
            this.addSecondaryTableSecondPass(secondaryTableSecondPass, onTopOfTheQueue);
        } else if (secondPass instanceof SecondaryTableFromAnnotationSecondPass) {
            SecondaryTableFromAnnotationSecondPass secondaryTableFromAnnotationSecondPass = (SecondaryTableFromAnnotationSecondPass)secondPass;
            this.addSecondaryTableFromAnnotationSecondPass(secondaryTableFromAnnotationSecondPass, onTopOfTheQueue);
        } else if (secondPass instanceof QuerySecondPass) {
            QuerySecondPass querySecondPass = (QuerySecondPass)secondPass;
            this.addQuerySecondPass(querySecondPass, onTopOfTheQueue);
        } else if (secondPass instanceof ImplicitColumnNamingSecondPass) {
            ImplicitColumnNamingSecondPass implicitColumnNamingSecondPass = (ImplicitColumnNamingSecondPass)secondPass;
            this.addImplicitColumnNamingSecondPass(implicitColumnNamingSecondPass);
        } else if (secondPass instanceof OptionalDeterminationSecondPass) {
            OptionalDeterminationSecondPass optionalDeterminationSecondPass = (OptionalDeterminationSecondPass)secondPass;
            this.addOptionalDeterminationSecondPass(optionalDeterminationSecondPass);
        } else {
            if (this.generalSecondPassList == null) {
                this.generalSecondPassList = new ArrayList();
            }
            this.addSecondPass(secondPass, this.generalSecondPassList, onTopOfTheQueue);
        }
    }

    private <T extends SecondPass> void addSecondPass(T secondPass, ArrayList<T> secondPassList, boolean onTopOfTheQueue) {
        if (onTopOfTheQueue) {
            secondPassList.add(0, secondPass);
        } else {
            secondPassList.add(secondPass);
        }
    }

    private void addSetBasicValueTypeSecondPass(SetBasicValueTypeSecondPass secondPass, boolean onTopOfTheQueue) {
        if (this.setBasicValueTypeSecondPassList == null) {
            this.setBasicValueTypeSecondPassList = new ArrayList();
        }
        this.addSecondPass(secondPass, this.setBasicValueTypeSecondPassList, onTopOfTheQueue);
    }

    private void addAggregateComponentSecondPass(AggregateComponentSecondPass secondPass, boolean onTopOfTheQueue) {
        if (this.aggregateComponentSecondPassList == null) {
            this.aggregateComponentSecondPassList = new ArrayList();
        }
        this.addSecondPass(secondPass, this.aggregateComponentSecondPassList, onTopOfTheQueue);
    }

    private void addIdGeneratorResolverSecondPass(IdGeneratorResolver secondPass, boolean onTopOfTheQueue) {
        if (this.idGeneratorResolverSecondPassList == null) {
            this.idGeneratorResolverSecondPassList = new ArrayList();
        }
        this.addSecondPass(secondPass, this.idGeneratorResolverSecondPassList, onTopOfTheQueue);
    }

    private void addFkSecondPass(FkSecondPass secondPass, boolean onTopOfTheQueue) {
        if (this.fkSecondPassList == null) {
            this.fkSecondPassList = new ArrayList();
        }
        this.addSecondPass(secondPass, this.fkSecondPassList, onTopOfTheQueue);
    }

    private void addCreateKeySecondPass(CreateKeySecondPass secondPass, boolean onTopOfTheQueue) {
        if (this.createKeySecondPassList == null) {
            this.createKeySecondPassList = new ArrayList();
        }
        this.addSecondPass(secondPass, this.createKeySecondPassList, onTopOfTheQueue);
    }

    private void addImplicitToOneJoinTableSecondPass(ImplicitToOneJoinTableSecondPass secondPass) {
        if (this.toOneJoinTableSecondPassList == null) {
            this.toOneJoinTableSecondPassList = new ArrayList();
        }
        this.toOneJoinTableSecondPassList.add(secondPass);
    }

    private void addSecondaryTableSecondPass(SecondaryTableSecondPass secondPass, boolean onTopOfTheQueue) {
        if (this.secondaryTableSecondPassList == null) {
            this.secondaryTableSecondPassList = new ArrayList();
        }
        this.addSecondPass(secondPass, this.secondaryTableSecondPassList, onTopOfTheQueue);
    }

    private void addSecondaryTableFromAnnotationSecondPass(SecondaryTableFromAnnotationSecondPass secondPass, boolean onTopOfTheQueue) {
        if (this.secondaryTableFromAnnotationSecondPassesList == null) {
            this.secondaryTableFromAnnotationSecondPassesList = new ArrayList();
        }
        this.addSecondPass(secondPass, this.secondaryTableFromAnnotationSecondPassesList, onTopOfTheQueue);
    }

    private void addQuerySecondPass(QuerySecondPass secondPass, boolean onTopOfTheQueue) {
        if (this.querySecondPassList == null) {
            this.querySecondPassList = new ArrayList();
        }
        this.addSecondPass(secondPass, this.querySecondPassList, onTopOfTheQueue);
    }

    private void addImplicitColumnNamingSecondPass(ImplicitColumnNamingSecondPass secondPass) {
        if (this.implicitColumnNamingSecondPassList == null) {
            this.implicitColumnNamingSecondPassList = new ArrayList();
        }
        this.implicitColumnNamingSecondPassList.add(secondPass);
    }

    private void addOptionalDeterminationSecondPass(OptionalDeterminationSecondPass secondPass) {
        if (this.optionalDeterminationSecondPassList == null) {
            this.optionalDeterminationSecondPassList = new ArrayList();
        }
        this.optionalDeterminationSecondPassList.add(secondPass);
    }

    public void processSecondPasses(MetadataBuildingContext buildingContext) {
        assert (!this.inSecondPass);
        this.inSecondPass = true;
        try {
            this.processSecondPasses(this.idGeneratorResolverSecondPassList);
            this.processSecondPasses(this.implicitColumnNamingSecondPassList);
            this.processSecondPasses(this.setBasicValueTypeSecondPassList);
            this.processSecondPasses(this.toOneJoinTableSecondPassList);
            this.composites.forEach(Component::sortProperties);
            this.processFkSecondPassesInOrder();
            this.processSecondPasses(this.createKeySecondPassList);
            this.processSecondPasses(this.secondaryTableSecondPassList);
            this.processSecondPasses(this.querySecondPassList);
            this.processSecondPasses(this.generalSecondPassList);
            this.processSecondPasses(this.optionalDeterminationSecondPassList);
            this.processPropertyReferences();
            this.processSecondPasses(this.aggregateComponentSecondPassList);
            this.secondPassCompileForeignKeys(buildingContext);
            this.processNaturalIdUniqueKeyBinders();
            this.processCachingOverrides();
            this.processValueResolvers(buildingContext);
        }
        finally {
            this.inSecondPass = false;
        }
    }

    private void processValueResolvers(MetadataBuildingContext buildingContext) {
        if (this.valueResolvers != null) {
            while (!this.valueResolvers.isEmpty()) {
                boolean anyRemoved = this.valueResolvers.removeIf(resolver -> (Boolean)resolver.apply(buildingContext));
                if (anyRemoved) continue;
                throw new org.hibernate.MappingException("Unable to complete initialization of boot meta-model");
            }
        }
    }

    private void processSecondPasses(ArrayList<? extends SecondPass> secondPasses) {
        if (secondPasses != null) {
            for (SecondPass secondPass : secondPasses) {
                secondPass.doSecondPass(this.getEntityBindingMap());
            }
            secondPasses.clear();
        }
    }

    private void processFkSecondPassesInOrder() {
        if (this.fkSecondPassList == null || this.fkSecondPassList.isEmpty()) {
            this.processSecondPasses(this.secondaryTableFromAnnotationSecondPassesList);
            return;
        }
        HashMap<String, Set<FkSecondPass>> isADependencyOf = new HashMap<String, Set<FkSecondPass>>();
        ArrayList<FkSecondPass> endOfQueueFkSecondPasses = new ArrayList<FkSecondPass>(this.fkSecondPassList.size());
        for (FkSecondPass sp : this.fkSecondPassList) {
            if (sp.isInPrimaryKey()) {
                String referenceEntityName = sp.getReferencedEntityName();
                PersistentClass classMapping = this.getEntityBinding(referenceEntityName);
                String dependentTable = classMapping.getTable().getQualifiedTableName().render();
                if (!isADependencyOf.containsKey(dependentTable)) {
                    isADependencyOf.put(dependentTable, new HashSet());
                }
                ((Set)isADependencyOf.get(dependentTable)).add(sp);
                continue;
            }
            endOfQueueFkSecondPasses.add(sp);
        }
        ArrayList<FkSecondPass> orderedFkSecondPasses = new ArrayList<FkSecondPass>(this.fkSecondPassList.size());
        for (String tableName : isADependencyOf.keySet()) {
            this.buildRecursiveOrderedFkSecondPasses(orderedFkSecondPasses, isADependencyOf, tableName, tableName);
        }
        for (FkSecondPass sp : orderedFkSecondPasses) {
            sp.doSecondPass(this.getEntityBindingMap());
        }
        this.processSecondPasses(this.secondaryTableFromAnnotationSecondPassesList);
        this.processEndOfQueue(endOfQueueFkSecondPasses);
        this.fkSecondPassList.clear();
    }

    private void buildRecursiveOrderedFkSecondPasses(List<FkSecondPass> orderedFkSecondPasses, Map<String, Set<FkSecondPass>> isADependencyOf, String startTable, String currentTable) {
        Set<FkSecondPass> dependencies = isADependencyOf.get(currentTable);
        if (dependencies != null) {
            for (FkSecondPass pass : dependencies) {
                String dependentTable = pass.getValue().getTable().getQualifiedTableName().render();
                if (dependentTable.compareTo(startTable) != 0) {
                    this.buildRecursiveOrderedFkSecondPasses(orderedFkSecondPasses, isADependencyOf, startTable, dependentTable);
                }
                if (orderedFkSecondPasses.contains(pass)) continue;
                orderedFkSecondPasses.add(0, pass);
            }
        }
    }

    private void processEndOfQueue(List<FkSecondPass> endOfQueueFkSecondPasses) {
        boolean stopProcess = false;
        RuntimeException originalException = null;
        while (!stopProcess) {
            ArrayList<FkSecondPass> failingSecondPasses = new ArrayList<FkSecondPass>();
            for (FkSecondPass pass : endOfQueueFkSecondPasses) {
                try {
                    pass.doSecondPass(this.getEntityBindingMap());
                }
                catch (FailedSecondPassException e) {
                    failingSecondPasses.add(pass);
                    if (originalException != null) continue;
                    originalException = (RuntimeException)e.getCause();
                }
            }
            stopProcess = failingSecondPasses.isEmpty() || failingSecondPasses.size() == endOfQueueFkSecondPasses.size();
            endOfQueueFkSecondPasses = failingSecondPasses;
        }
        if (!endOfQueueFkSecondPasses.isEmpty()) {
            assert (originalException != null);
            throw originalException;
        }
    }

    private void secondPassCompileForeignKeys(MetadataBuildingContext buildingContext) {
        int uniqueInteger = 0;
        HashSet<ForeignKey> done = new HashSet<ForeignKey>();
        for (Table table : this.collectTableMappings()) {
            table.setUniqueInteger(uniqueInteger++);
            this.secondPassCompileForeignKeys(table, done, buildingContext);
        }
    }

    protected void secondPassCompileForeignKeys(Table table, Set<ForeignKey> done, MetadataBuildingContext buildingContext) throws org.hibernate.MappingException {
        table.createForeignKeys(buildingContext);
        Dialect dialect = this.getDatabase().getJdbcEnvironment().getDialect();
        for (ForeignKey foreignKey : table.getForeignKeys().values()) {
            if (done.contains(foreignKey)) continue;
            done.add(foreignKey);
            PersistentClass referencedClass = foreignKey.resolveReferencedClass(this);
            if (referencedClass.isJoinedSubclass()) {
                this.secondPassCompileForeignKeys(referencedClass.getSuperclass().getTable(), done, buildingContext);
            }
            if (foreignKey.getReferencedTable() == null) {
                foreignKey.setReferencedTable(referencedClass.getTable());
            }
            Identifier nameIdentifier = this.getMetadataBuildingOptions().getImplicitNamingStrategy().determineForeignKeyName(new ForeignKeyNameSource(foreignKey, table, buildingContext));
            foreignKey.setName(nameIdentifier.render(dialect));
            foreignKey.alignColumns();
        }
    }

    private void processPropertyReferences() {
        if (this.delayedPropertyReferenceHandlers != null) {
            log.debug("Processing association property references");
            for (InFlightMetadataCollector.DelayedPropertyReferenceHandler delayedPropertyReferenceHandler : this.delayedPropertyReferenceHandlers) {
                delayedPropertyReferenceHandler.process(this);
            }
            this.delayedPropertyReferenceHandlers.clear();
        }
    }

    @Override
    public NaturalIdUniqueKeyBinder locateNaturalIdUniqueKeyBinder(String entityName) {
        return this.naturalIdUniqueKeyBinderMap == null ? null : this.naturalIdUniqueKeyBinderMap.get(entityName);
    }

    @Override
    public void registerNaturalIdUniqueKeyBinder(String entityName, NaturalIdUniqueKeyBinder ukBinder) {
        NaturalIdUniqueKeyBinder previous;
        if (this.naturalIdUniqueKeyBinderMap == null) {
            this.naturalIdUniqueKeyBinderMap = new HashMap<String, NaturalIdUniqueKeyBinder>();
        }
        if ((previous = this.naturalIdUniqueKeyBinderMap.put(entityName, ukBinder)) != null) {
            throw new AssertionFailure("Previous NaturalIdUniqueKeyBinder already registered for entity name : " + entityName);
        }
    }

    private void processNaturalIdUniqueKeyBinders() {
        if (this.naturalIdUniqueKeyBinderMap != null) {
            for (NaturalIdUniqueKeyBinder naturalIdUniqueKeyBinder : this.naturalIdUniqueKeyBinderMap.values()) {
                naturalIdUniqueKeyBinder.process();
            }
            this.naturalIdUniqueKeyBinderMap.clear();
        }
    }

    private void processCachingOverrides() {
        if (this.bootstrapContext.getCacheRegionDefinitions() == null) {
            return;
        }
        for (CacheRegionDefinition cacheRegionDefinition : this.bootstrapContext.getCacheRegionDefinitions()) {
            if (cacheRegionDefinition.getRegionType() == CacheRegionDefinition.CacheRegionType.ENTITY) {
                PersistentClass entityBinding = this.getEntityBinding(cacheRegionDefinition.getRole());
                if (entityBinding == null) {
                    throw new HibernateException("Cache override referenced an unknown entity : " + cacheRegionDefinition.getRole());
                }
                if (!(entityBinding instanceof RootClass)) {
                    throw new HibernateException("Cache override referenced a non-root entity : " + cacheRegionDefinition.getRole());
                }
                RootClass rootClass = (RootClass)entityBinding;
                entityBinding.setCached(true);
                rootClass.setCacheRegionName(cacheRegionDefinition.getRegion());
                rootClass.setCacheConcurrencyStrategy(cacheRegionDefinition.getUsage());
                rootClass.setLazyPropertiesCacheable(cacheRegionDefinition.isCacheLazy());
                continue;
            }
            if (cacheRegionDefinition.getRegionType() != CacheRegionDefinition.CacheRegionType.COLLECTION) continue;
            org.hibernate.mapping.Collection collectionBinding = this.getCollectionBinding(cacheRegionDefinition.getRole());
            if (collectionBinding == null) {
                throw new HibernateException("Cache override referenced an unknown collection role : " + cacheRegionDefinition.getRole());
            }
            collectionBinding.setCacheRegionName(cacheRegionDefinition.getRegion());
            collectionBinding.setCacheConcurrencyStrategy(cacheRegionDefinition.getUsage());
        }
    }

    @Override
    public boolean isInSecondPass() {
        return this.inSecondPass;
    }

    public MetadataImpl buildMetadataInstance(MetadataBuildingContext buildingContext) {
        this.processSecondPasses(buildingContext);
        this.processExportableProducers();
        try {
            MetadataImpl metadataImpl = new MetadataImpl(this.uuid, this.options, this.entityBindingMap, this.composites, this.genericComponentsMap, this.embeddableDiscriminatorTypesMap, this.mappedSuperClasses, this.collectionBindingMap, this.typeDefRegistry.copyRegistrationMap(), this.filterDefinitionMap, this.fetchProfileMap, this.imports, this.idGeneratorDefinitionMap, this.namedQueryMap, this.namedNativeQueryMap, this.namedProcedureCallMap, this.sqlResultSetMappingMap, this.namedEntityGraphMap, this.sqlFunctionMap, this.getDatabase(), this.bootstrapContext);
            return metadataImpl;
        }
        finally {
            this.getBootstrapContext().release();
        }
    }

    private void processExportableProducers() {
        Dialect dialect = this.getDatabase().getJdbcEnvironment().getDialect();
        for (PersistentClass entityBinding : this.entityBindingMap.values()) {
            entityBinding.assignCheckConstraintsToTable(dialect, this.bootstrapContext.getTypeConfiguration());
            if (!(entityBinding instanceof RootClass)) continue;
            RootClass rootClass = (RootClass)entityBinding;
            this.handleIdentifierValueBinding(entityBinding.getIdentifier(), dialect, rootClass, entityBinding.getIdentifierProperty());
        }
        for (org.hibernate.mapping.Collection collection : this.collectionBindingMap.values()) {
            if (!(collection instanceof IdentifierCollection)) continue;
            IdentifierCollection identifierCollection = (IdentifierCollection)collection;
            this.handleIdentifierValueBinding(identifierCollection.getIdentifier(), dialect, null, null);
        }
    }

    private void handleIdentifierValueBinding(KeyValue identifierValueBinding, Dialect dialect, RootClass entityBinding, Property identifierProperty) {
        try {
            identifierValueBinding.createGenerator(dialect, entityBinding, identifierProperty, this);
        }
        catch (org.hibernate.MappingException e) {
            log.debugf("Ignoring exception thrown when trying to build IdentifierGenerator as part of Metadata building", (Object)e);
        }
    }

    @Override
    public String getDefaultCatalog() {
        String defaultCatalog = this.configurationService.getSetting("hibernate.default_catalog", StandardConverters.STRING);
        return defaultCatalog == null ? this.persistenceUnitMetadata.getDefaultCatalog() : defaultCatalog;
    }

    @Override
    public String getDefaultSchema() {
        String defaultSchema = this.configurationService.getSetting("hibernate.default_schema", StandardConverters.STRING);
        return defaultSchema == null ? this.persistenceUnitMetadata.getDefaultSchema() : defaultSchema;
    }

    @Override
    public SqlStringGenerationContext getSqlStringGenerationContext() {
        return SqlStringGenerationContextImpl.fromExplicit(this.database.getJdbcEnvironment(), this.database, this.getDefaultCatalog(), this.getDefaultSchema());
    }

    private class TableColumnNameBinding
    implements Serializable {
        private final String tableName;
        private final Map<Identifier, String> logicalToPhysical = new HashMap<Identifier, String>();
        private final Map<String, Identifier> physicalToLogical = new HashMap<String, Identifier>();

        private TableColumnNameBinding(String tableName) {
            this.tableName = tableName;
        }

        public void addBinding(Identifier logicalName, Column physicalColumn) {
            String physicalNameString = physicalColumn.getQuotedName(InFlightMetadataCollectorImpl.this.getDatabase().getJdbcEnvironment().getDialect());
            this.bindLogicalToPhysical(logicalName, physicalNameString);
            this.bindPhysicalToLogical(logicalName, physicalNameString);
        }

        private void bindLogicalToPhysical(Identifier logicalName, String physicalName) throws DuplicateMappingException {
            String existingPhysicalNameMapping = this.logicalToPhysical.put(logicalName, physicalName);
            if (existingPhysicalNameMapping != null) {
                boolean areSame;
                boolean bl = areSame = logicalName.isQuoted() ? physicalName.equals(existingPhysicalNameMapping) : physicalName.equalsIgnoreCase(existingPhysicalNameMapping);
                if (!areSame) {
                    throw new DuplicateMappingException(String.format(Locale.ENGLISH, "Table [%s] contains logical column name [%s] referring to multiple physical column names: [%s], [%s]", this.tableName, logicalName, existingPhysicalNameMapping, physicalName), DuplicateMappingException.Type.COLUMN_BINDING, this.tableName + "." + logicalName);
                }
            }
        }

        private void bindPhysicalToLogical(Identifier logicalName, String physicalName) throws DuplicateMappingException {
            Identifier existingLogicalName = this.physicalToLogical.put(physicalName, logicalName);
            if (existingLogicalName != null && !existingLogicalName.equals(logicalName)) {
                throw new DuplicateMappingException(String.format(Locale.ENGLISH, "Table [%s] contains physical column name [%s] referred to by multiple logical column names: [%s], [%s]", this.tableName, physicalName, logicalName, existingLogicalName), DuplicateMappingException.Type.COLUMN_BINDING, this.tableName + "." + physicalName);
            }
        }
    }

    private static class DelayedPropertyReferenceHandlerAnnotationImpl
    implements InFlightMetadataCollector.DelayedPropertyReferenceHandler {
        public final String referencedClass;
        public final String propertyName;
        public final boolean unique;

        public DelayedPropertyReferenceHandlerAnnotationImpl(String referencedClass, String propertyName, boolean unique) {
            this.referencedClass = referencedClass;
            this.propertyName = propertyName;
            this.unique = unique;
        }

        @Override
        public void process(InFlightMetadataCollector metadataCollector) {
            PersistentClass clazz = metadataCollector.getEntityBinding(this.referencedClass);
            if (clazz == null) {
                throw new org.hibernate.MappingException("property-ref to unmapped class: " + this.referencedClass);
            }
            Property prop = clazz.getReferencedProperty(this.propertyName);
            if (this.unique) {
                ((SimpleValue)prop.getValue()).setAlternateUniqueKey(true);
            }
        }
    }

    private static final class EntityTableXrefImpl
    implements InFlightMetadataCollector.EntityTableXref {
        private final Identifier primaryTableLogicalName;
        private final Table primaryTable;
        private final EntityTableXrefImpl superEntityTableXref;
        private Map<String, Join> secondaryTableJoinMap;

        public EntityTableXrefImpl(Identifier primaryTableLogicalName, Table primaryTable, EntityTableXrefImpl superEntityTableXref) {
            this.primaryTableLogicalName = primaryTableLogicalName;
            this.primaryTable = primaryTable;
            this.superEntityTableXref = superEntityTableXref;
        }

        @Override
        public void addSecondaryTable(LocalMetadataBuildingContext buildingContext, Identifier logicalName, Join secondaryTableJoin) {
            if (Identifier.areEqual(this.primaryTableLogicalName, logicalName)) {
                throw new MappingException(String.format(Locale.ENGLISH, "Attempt to add secondary table with same name as primary table [%s]", this.primaryTableLogicalName), buildingContext.getOrigin());
            }
            if (this.secondaryTableJoinMap == null) {
                this.secondaryTableJoinMap = new HashMap<String, Join>();
                this.secondaryTableJoinMap.put(logicalName.getCanonicalName(), secondaryTableJoin);
            } else {
                Join existing = this.secondaryTableJoinMap.put(logicalName.getCanonicalName(), secondaryTableJoin);
                if (existing != null) {
                    throw new MappingException(String.format(Locale.ENGLISH, "Added secondary table with same name [%s]", logicalName), buildingContext.getOrigin());
                }
            }
        }

        @Override
        public void addSecondaryTable(QualifiedTableName logicalQualifiedTableName, Join secondaryTableJoin) {
            Identifier tableName = logicalQualifiedTableName.getTableName();
            if (Identifier.areEqual(Identifier.toIdentifier(new QualifiedTableName(Identifier.toIdentifier(this.primaryTable.getCatalog()), Identifier.toIdentifier(this.primaryTable.getSchema()), this.primaryTableLogicalName).render()), Identifier.toIdentifier(logicalQualifiedTableName.render()))) {
                throw new InFlightMetadataCollector.DuplicateSecondaryTableException(tableName);
            }
            if (this.secondaryTableJoinMap == null) {
                this.secondaryTableJoinMap = new HashMap<String, Join>();
                this.secondaryTableJoinMap.put(tableName.getCanonicalName(), secondaryTableJoin);
            } else {
                Join existing = this.secondaryTableJoinMap.put(tableName.getCanonicalName(), secondaryTableJoin);
                if (existing != null) {
                    throw new InFlightMetadataCollector.DuplicateSecondaryTableException(tableName);
                }
            }
        }

        @Override
        public Table getPrimaryTable() {
            return this.primaryTable;
        }

        @Override
        public Table resolveTable(Identifier tableName) {
            if (tableName == null) {
                return this.primaryTable;
            }
            if (Identifier.areEqual(this.primaryTableLogicalName, tableName)) {
                return this.primaryTable;
            }
            Join secondaryTableJoin = null;
            if (this.secondaryTableJoinMap != null) {
                secondaryTableJoin = this.secondaryTableJoinMap.get(tableName.getCanonicalName());
            }
            if (secondaryTableJoin != null) {
                return secondaryTableJoin.getTable();
            }
            if (this.superEntityTableXref != null) {
                return this.superEntityTableXref.resolveTable(tableName);
            }
            return null;
        }

        @Override
        public Join locateJoin(Identifier tableName) {
            if (tableName == null) {
                return null;
            }
            Join join = null;
            if (this.secondaryTableJoinMap != null) {
                join = this.secondaryTableJoinMap.get(tableName.getCanonicalName());
            }
            if (join != null) {
                return join;
            }
            if (this.superEntityTableXref != null) {
                return this.superEntityTableXref.locateJoin(tableName);
            }
            return null;
        }
    }
}

