/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.jaxb.hbm.transform;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.hibernate.MappingException;
import org.hibernate.boot.jaxb.hbm.transform.ComponentTypeInfo;
import org.hibernate.boot.jaxb.hbm.transform.EntityTypeInfo;
import org.hibernate.boot.jaxb.hbm.transform.PropertyInfo;
import org.hibernate.boot.jaxb.hbm.transform.TransformationHelper;
import org.hibernate.boot.jaxb.hbm.transform.TransformationState;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.IndexedCollection;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.Value;

public class BootModelPreprocessor {
    private static final Map<String, String> entityByNameMap = new HashMap<String, String>();

    static void preprocessBooModel(MetadataImplementor bootModel, TransformationState transformationState) {
        entityByNameMap.clear();
        bootModel.getEntityBindings().forEach(persistentClass -> {
            Table table = TransformationHelper.determineEntityTable(persistentClass);
            EntityTypeInfo entityTypeInfo = new EntityTypeInfo(table, (PersistentClass)persistentClass);
            transformationState.getEntityInfoByName().put(persistentClass.getEntityName(), entityTypeInfo);
            BootModelPreprocessor.buildPersistentClassPropertyInfos(persistentClass, entityTypeInfo, transformationState);
        });
    }

    private static void buildPersistentClassPropertyInfos(PersistentClass persistentClass, EntityTypeInfo entityTypeInfo, TransformationState transformationState) {
        String previous;
        if (persistentClass.getClassName() != null && (previous = entityByNameMap.put(persistentClass.getClassName(), persistentClass.getEntityName())) != null) {
            throw new MappingException(String.format(Locale.ROOT, "Entity class [%s] mapped multiple times with different entity-names [%s, %s]; while this was supported in legacy hbm.xml, it is no longer supported in mapping.xml", persistentClass.getClassName(), previous, persistentClass.getEntityName()));
        }
        if (persistentClass instanceof RootClass) {
            RootClass rootClass = (RootClass)persistentClass;
            if (persistentClass.getIdentifierProperty() != null) {
                Value value = persistentClass.getIdentifierProperty().getValue();
                if (value instanceof Component) {
                    Component component = (Component)value;
                    String componentRole = rootClass.getEntityName() + "." + persistentClass.getIdentifierProperty().getName();
                    BootModelPreprocessor.buildComponentEntries(componentRole, component, transformationState);
                }
            } else {
                assert (rootClass.getIdentifier() instanceof Component);
                String componentRole = rootClass.getEntityName() + ".id";
                BootModelPreprocessor.buildComponentEntries(componentRole, (Component)rootClass.getIdentifier(), transformationState);
            }
        }
        persistentClass.getProperties().forEach(property -> BootModelPreprocessor.processProperty(entityTypeInfo.propertyInfoMap(), property, persistentClass.getEntityName(), transformationState));
        persistentClass.getJoins().forEach(join -> join.getProperties().forEach(property -> BootModelPreprocessor.processProperty(entityTypeInfo.propertyInfoMap(), property, persistentClass.getEntityName(), transformationState)));
    }

    private static void processProperty(Map<String, PropertyInfo> entityTypeInfo, Property property, String entityName, TransformationState transformationState) {
        entityTypeInfo.put(property.getName(), new PropertyInfo(property));
        Value value = property.getValue();
        if (value instanceof Component) {
            Component component = (Component)value;
            componentRole = entityName + "." + property.getName();
            BootModelPreprocessor.buildComponentEntries((String)componentRole, component, transformationState);
        } else {
            componentRole = property.getValue();
            if (componentRole instanceof IndexedCollection) {
                Object componentRole;
                IndexedCollection indexedCollection = (IndexedCollection)componentRole;
                Value value2 = indexedCollection.getIndex();
                if (value2 instanceof Component) {
                    Component index = (Component)value2;
                    componentRole = entityName + "." + property.getName() + ".key";
                    BootModelPreprocessor.buildComponentEntries((String)componentRole, index, transformationState);
                }
                if ((componentRole = indexedCollection.getElement()) instanceof Component) {
                    element = (Component)componentRole;
                    componentRole = entityName + "." + property.getName() + ".value";
                    BootModelPreprocessor.buildComponentEntries((String)componentRole, (Component)element, transformationState);
                }
            } else {
                element = property.getValue();
                if (element instanceof Collection) {
                    Collection collection = (Collection)element;
                    Object componentRole = collection.getElement();
                    if (componentRole instanceof Component) {
                        element = (Component)componentRole;
                        componentRole = entityName + "." + property.getName() + ".value";
                        BootModelPreprocessor.buildComponentEntries((String)componentRole, (Component)element, transformationState);
                    }
                } else {
                    value = property.getValue();
                    if (value instanceof ToOne) {
                        ToOne toOne = (ToOne)value;
                        transformationState.registerMappableAttributesByColumns(entityName, property.getName(), toOne.getSelectables());
                    }
                }
            }
        }
    }

    private static void buildComponentEntries(String role, Component component, TransformationState transformationState) {
        ComponentTypeInfo componentTypeInfo = new ComponentTypeInfo(component);
        transformationState.getEmbeddableInfoByRole().put(role, componentTypeInfo);
        BootModelPreprocessor.buildComponentPropertyInfos(role, component, componentTypeInfo, transformationState);
    }

    private static void buildComponentPropertyInfos(String componentRole, Component component, ComponentTypeInfo componentTypeInfo, TransformationState transformationState) {
        component.getProperties().forEach(property -> BootModelPreprocessor.processProperty(componentTypeInfo.propertyInfoMap(), property, componentRole, transformationState));
    }
}

