/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.jaxb.hbm.transform;

import jakarta.persistence.AccessType;
import jakarta.persistence.AttributeConverter;
import jakarta.persistence.ConstraintMode;
import jakarta.persistence.DiscriminatorType;
import jakarta.persistence.EnumType;
import jakarta.persistence.FetchType;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.TemporalType;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import org.hibernate.AssertionFailure;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.annotations.OnDeleteAction;
import org.hibernate.boot.MappingException;
import org.hibernate.boot.internal.LimitedCollectionClassification;
import org.hibernate.boot.jaxb.Origin;
import org.hibernate.boot.jaxb.hbm.spi.Discriminatable;
import org.hibernate.boot.jaxb.hbm.spi.EntityInfo;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmAnyAssociationType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmArrayType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmAuxiliaryDatabaseObjectType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmBagCollectionType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmBasicAttributeType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmBasicCollectionElementType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmCacheInclusionEnum;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmClassRenameType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmColumnType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmCompositeAttributeType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmCompositeCollectionElementType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmCompositeIdType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmCompositeKeyBasicAttributeType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmCompositeKeyManyToOneType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmConfigParameterContainer;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmConfigParameterType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmCustomSqlDmlType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmDiscriminatorSubclassEntityType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmDynamicComponentType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmEntityBaseDefinition;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmFetchProfileType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmFetchStyleEnum;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmFetchStyleWithSubselectEnum;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmFilterAliasMappingType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmFilterDefinitionType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmFilterParameterType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmFilterType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmGeneratorSpecificationType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmHibernateMapping;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmIdBagCollectionType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmIndexType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmJoinedSubclassEntityType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmKeyType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmLazyEnum;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmLazyWithExtraEnum;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmLazyWithNoProxyEnum;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmListIndexType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmListType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmManyToAnyCollectionElementType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmManyToManyCollectionElementType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmManyToOneType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmMapKeyBasicType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmMapType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmNamedNativeQueryType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmNamedQueryType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmNativeQueryCollectionLoadReturnType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmNativeQueryJoinReturnType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmNativeQueryPropertyReturnType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmNativeQueryReturnType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmNativeQueryScalarReturnType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmNotFoundEnum;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmOnDeleteEnum;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmOneToManyCollectionElementType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmOneToOneType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmOuterJoinEnum;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmPrimitiveArrayType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmPropertiesType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmQueryParamType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmResultSetMappingType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmRootEntityType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmSecondaryTableType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmSetType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmSimpleIdType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmSynchronizeType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmTimestampAttributeType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmTypeDefinitionType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmTypeSpecificationType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmUnionSubclassEntityType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmVersionAttributeType;
import org.hibernate.boot.jaxb.hbm.spi.PluralAttributeInfo;
import org.hibernate.boot.jaxb.hbm.spi.ResultSetMappingContainer;
import org.hibernate.boot.jaxb.hbm.spi.ToolingHintContainer;
import org.hibernate.boot.jaxb.hbm.transform.BootModelPreprocessor;
import org.hibernate.boot.jaxb.hbm.transform.ColumnAndFormulaSource;
import org.hibernate.boot.jaxb.hbm.transform.ColumnAndFormulaTarget;
import org.hibernate.boot.jaxb.hbm.transform.ColumnDefaults;
import org.hibernate.boot.jaxb.hbm.transform.ColumnDefaultsBasicImpl;
import org.hibernate.boot.jaxb.hbm.transform.ColumnDefaultsInsertableNonUpdateableImpl;
import org.hibernate.boot.jaxb.hbm.transform.ColumnDefaultsProperty;
import org.hibernate.boot.jaxb.hbm.transform.ComponentTypeInfo;
import org.hibernate.boot.jaxb.hbm.transform.EntityTypeInfo;
import org.hibernate.boot.jaxb.hbm.transform.HbmTransformationLogging;
import org.hibernate.boot.jaxb.hbm.transform.ManagedTypeInfo;
import org.hibernate.boot.jaxb.hbm.transform.PropertyInfo;
import org.hibernate.boot.jaxb.hbm.transform.SourceColumnAdapter;
import org.hibernate.boot.jaxb.hbm.transform.SourceColumnAdapterJaxbHbmColumnType;
import org.hibernate.boot.jaxb.hbm.transform.TargetColumnAdapter;
import org.hibernate.boot.jaxb.hbm.transform.TargetColumnAdapterJaxbColumn;
import org.hibernate.boot.jaxb.hbm.transform.TargetColumnAdapterJaxbJoinColumn;
import org.hibernate.boot.jaxb.hbm.transform.TransformationException;
import org.hibernate.boot.jaxb.hbm.transform.TransformationHelper;
import org.hibernate.boot.jaxb.hbm.transform.TransformationState;
import org.hibernate.boot.jaxb.hbm.transform.UnsupportedFeatureHandling;
import org.hibernate.boot.jaxb.hbm.transform.XmlPreprocessor;
import org.hibernate.boot.jaxb.mapping.spi.JaxbAnyDiscriminatorValueMappingImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbAnyMappingDiscriminatorImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbAnyMappingImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbAnyMappingKeyImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbAttributesContainer;
import org.hibernate.boot.jaxb.mapping.spi.JaxbAttributesContainerImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbBasicImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbBasicMapping;
import org.hibernate.boot.jaxb.mapping.spi.JaxbCachingImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbCascadeTypeImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbCheckConstraintImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbCollectionTableImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbCollectionUserTypeImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbColumnImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbColumnResultImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbConfigurationParameterImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbConvertImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbCustomSqlImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbDatabaseObjectImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbDatabaseObjectScopeImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbDiscriminatorColumnImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbDiscriminatorFormulaImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbElementCollectionImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEmbeddableAttributesContainerImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEmbeddableImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEmbeddedIdImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEmbeddedImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEmptyTypeImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityMappingsImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityResultImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbFetchProfileImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbFieldResultImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbFilterDefImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbFilterImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbForeignKeyImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbGeneratedValueImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbGenericIdGeneratorImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbHqlImportImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbIdImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbInheritanceImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbJoinTableImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbManyToManyImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbManyToOneImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbMapKeyColumnImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbNamedHqlQueryImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbNamedNativeQueryImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbNaturalIdImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbOneToManyImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbOneToOneImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbOrderColumnImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbPluralAnyMappingImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbPluralAttribute;
import org.hibernate.boot.jaxb.mapping.spi.JaxbPluralFetchModeImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbPrimaryKeyJoinColumnImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbPropertyRefImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbQueryParamTypeImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbSecondaryTableImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbSingularAssociationAttribute;
import org.hibernate.boot.jaxb.mapping.spi.JaxbSingularFetchModeImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbSqlResultSetMappingImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbSynchronizedTableImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbTableImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbTransientImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbUserTypeImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbVersionImpl;
import org.hibernate.boot.jaxb.mapping.spi.db.JaxbTableMapping;
import org.hibernate.boot.jaxb.spi.Binding;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.CheckConstraint;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Formula;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.BasicType;
import org.hibernate.type.ConvertedBasicType;
import org.hibernate.type.CustomType;
import org.hibernate.type.descriptor.converter.spi.BasicValueConverter;
import org.hibernate.type.descriptor.converter.spi.JpaAttributeConverter;
import org.hibernate.type.internal.BasicTypeImpl;

public class HbmXmlTransformer {
    private final Binding<JaxbHbmHibernateMapping> hbmXmlBinding;
    private final Binding<JaxbEntityMappingsImpl> mappingXmlBinding;
    private final TransformationState transformationState;
    private final UnsupportedFeatureHandling unsupportedFeatureHandling;
    private final Map<String, JaxbEmbeddableImpl> jaxbEmbeddableByClassName = new HashMap<String, JaxbEmbeddableImpl>();
    private Table currentBaseTable;
    private int counter = 1;

    public static List<Binding<JaxbEntityMappingsImpl>> transform(List<Binding<JaxbHbmHibernateMapping>> hbmXmlBindings, MetadataImplementor bootModel, ServiceRegistry serviceRegistry, UnsupportedFeatureHandling unsupportedFeatureHandling) {
        TransformationState transformationState = new TransformationState();
        List<Binding<JaxbEntityMappingsImpl>> transformations = XmlPreprocessor.preprocessHbmXml(hbmXmlBindings, transformationState);
        BootModelPreprocessor.preprocessBooModel(bootModel, transformationState);
        for (int i = 0; i < hbmXmlBindings.size(); ++i) {
            HbmXmlTransformer hbmXmlTransformer = new HbmXmlTransformer(hbmXmlBindings.get(i), transformations.get(i), transformationState, unsupportedFeatureHandling);
            hbmXmlTransformer.performTransformation();
        }
        return transformations;
    }

    private HbmXmlTransformer(Binding<JaxbHbmHibernateMapping> hbmXmlBinding, Binding<JaxbEntityMappingsImpl> mappingXmlBinding, TransformationState transformationState, UnsupportedFeatureHandling unsupportedFeatureHandling) {
        this.hbmXmlBinding = hbmXmlBinding;
        this.mappingXmlBinding = mappingXmlBinding;
        this.transformationState = transformationState;
        this.unsupportedFeatureHandling = unsupportedFeatureHandling;
    }

    private void performTransformation() {
        JaxbHbmHibernateMapping hbmXmlRoot = this.hbmXmlBinding.getRoot();
        JaxbEntityMappingsImpl mappingXmlRoot = this.mappingXmlBinding.getRoot();
        TransformationHelper.transfer(hbmXmlRoot::getPackage, mappingXmlRoot::setPackage);
        TransformationHelper.transfer(hbmXmlRoot::getCatalog, mappingXmlRoot::setCatalog);
        TransformationHelper.transfer(hbmXmlRoot::getSchema, mappingXmlRoot::setSchema);
        TransformationHelper.transfer(hbmXmlRoot::getDefaultAccess, mappingXmlRoot::setAttributeAccessor);
        TransformationHelper.transfer(hbmXmlRoot::getDefaultCascade, mappingXmlRoot::setDefaultCascade);
        TransformationHelper.transfer(hbmXmlRoot::isDefaultLazy, mappingXmlRoot::setDefaultLazy);
        this.transferFilterDefinitions();
        this.transferImports();
        this.transferResultSetMappings();
        this.transferNamedQueries();
        this.transferNamedNativeQueries();
        this.transferFetchProfiles();
        this.transferDatabaseObjects();
        hbmXmlRoot.getClazz().forEach(hbmEntity -> {
            String entityName = TransformationHelper.determineEntityName(hbmEntity, hbmXmlRoot);
            JaxbEntityImpl mappingEntity = this.transformationState.getMappingEntityByName().get(entityName);
            EntityTypeInfo bootEntityInfo = this.transformationState.getEntityInfoByName().get(entityName);
            assert (mappingEntity != null) : "Unable to locate JaxbEntityImpl for " + entityName;
            assert (bootEntityInfo != null) : "Unable to locate EntityTypeInfo for " + entityName;
            this.transferRootEntity((JaxbHbmRootEntityType)hbmEntity, mappingEntity, bootEntityInfo);
        });
        hbmXmlRoot.getSubclass().forEach(hbmSubclass -> {
            String entityName = TransformationHelper.determineEntityName(hbmSubclass, hbmXmlRoot);
            JaxbEntityImpl mappingEntity = this.transformationState.getMappingEntityByName().get(entityName);
            EntityTypeInfo bootEntityInfo = this.transformationState.getEntityInfoByName().get(entityName);
            assert (mappingEntity != null) : "Unable to locate JaxbEntityImpl for " + entityName;
            assert (bootEntityInfo != null) : "Unable to locate EntityTypeInfo for " + entityName;
            this.transferDiscriminatorSubclass((JaxbHbmDiscriminatorSubclassEntityType)hbmSubclass, mappingEntity, bootEntityInfo);
            String rootEntityName = bootEntityInfo.getPersistentClass().getRootClass().getEntityName();
            JaxbEntityImpl rootMappingEntity = this.transformationState.getMappingEntityByName().get(rootEntityName);
            this.defineInheritance(rootMappingEntity, InheritanceType.SINGLE_TABLE);
        });
        hbmXmlRoot.getJoinedSubclass().forEach(hbmSubclass -> {
            String entityName = TransformationHelper.determineEntityName(hbmSubclass, hbmXmlRoot);
            JaxbEntityImpl mappingEntity = this.transformationState.getMappingEntityByName().get(entityName);
            EntityTypeInfo bootEntityInfo = this.transformationState.getEntityInfoByName().get(entityName);
            assert (mappingEntity != null) : "Unable to locate JaxbEntityImpl for " + entityName;
            assert (bootEntityInfo != null) : "Unable to locate EntityTypeInfo for " + entityName;
            this.transferJoinedSubclass((JaxbHbmJoinedSubclassEntityType)hbmSubclass, mappingEntity, bootEntityInfo);
            String rootEntityName = bootEntityInfo.getPersistentClass().getRootClass().getEntityName();
            JaxbEntityImpl rootMappingEntity = this.transformationState.getMappingEntityByName().get(rootEntityName);
            this.defineInheritance(rootMappingEntity, InheritanceType.JOINED);
        });
        hbmXmlRoot.getUnionSubclass().forEach(hbmSubclass -> {
            String entityName = TransformationHelper.determineEntityName(hbmSubclass, hbmXmlRoot);
            JaxbEntityImpl mappingEntity = this.transformationState.getMappingEntityByName().get(entityName);
            EntityTypeInfo bootEntityInfo = this.transformationState.getEntityInfoByName().get(entityName);
            assert (mappingEntity != null) : "Unable to locate JaxbEntityImpl for " + entityName;
            assert (bootEntityInfo != null) : "Unable to locate EntityTypeInfo for " + entityName;
            this.transferUnionSubclass((JaxbHbmUnionSubclassEntityType)hbmSubclass, mappingEntity, bootEntityInfo);
            String rootEntityName = bootEntityInfo.getPersistentClass().getRootClass().getEntityName();
            JaxbEntityImpl rootMappingEntity = this.transformationState.getMappingEntityByName().get(rootEntityName);
            this.defineInheritance(rootMappingEntity, InheritanceType.TABLE_PER_CLASS);
        });
        if (HbmTransformationLogging.TRANSFORMATION_LOGGER.isDebugEnabled()) {
            HbmXmlTransformer.dumpTransformed(this.origin(), mappingXmlRoot);
        }
    }

    private static void dumpTransformed(Origin origin, JaxbEntityMappingsImpl ormRoot) {
        try {
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{JaxbEntityMappingsImpl.class});
            Marshaller marshaller = ctx.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            StringWriter stringWriter = new StringWriter();
            marshaller.marshal((Object)ormRoot, (Writer)stringWriter);
            HbmTransformationLogging.TRANSFORMATION_LOGGER.debugf("Transformed hbm.xml (%s):\n%s", (Object)origin, (Object)stringWriter.toString());
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    private void transferRootEntity(JaxbHbmRootEntityType hbmClass, JaxbEntityImpl mappingEntity, EntityTypeInfo entityInfo) {
        String name;
        EntityTypeInfo subclassEntityInfo;
        JaxbEntityImpl mappingSubclassEntity;
        String subclassEntityName;
        this.currentBaseTable = entityInfo.table();
        this.transferBaseEntityInformation(hbmClass, mappingEntity, entityInfo);
        mappingEntity.setMutable(hbmClass.isMutable());
        HbmXmlTransformer.applyTable(entityInfo.getPersistentClass(), mappingEntity);
        for (JaxbHbmSynchronizeType jaxbHbmSynchronizeType : hbmClass.getSynchronize()) {
            JaxbSynchronizedTableImpl sync = new JaxbSynchronizedTableImpl();
            sync.setTable(jaxbHbmSynchronizeType.getTable());
            mappingEntity.getSynchronizeTables().add(sync);
        }
        if (hbmClass.getLoader() != null) {
            this.handleUnsupported("<loader/> is not supported in mapping.xsd - use <sql-select/> or <hql-select/> instead", new Object[0]);
        }
        if (!hbmClass.getTuplizer().isEmpty()) {
            this.handleUnsupported("<tuplizer/> is not supported", new Object[0]);
        }
        if (hbmClass.getSqlInsert() != null) {
            mappingEntity.setSqlInsert(new JaxbCustomSqlImpl());
            mappingEntity.getSqlInsert().setValue(hbmClass.getSqlInsert().getValue());
            mappingEntity.getSqlInsert().setResultCheck(hbmClass.getSqlInsert().getCheck());
            mappingEntity.getSqlInsert().setValue(hbmClass.getSqlInsert().getValue());
        }
        if (hbmClass.getSqlUpdate() != null) {
            mappingEntity.setSqlUpdate(new JaxbCustomSqlImpl());
            mappingEntity.getSqlUpdate().setValue(hbmClass.getSqlUpdate().getValue());
            mappingEntity.getSqlUpdate().setResultCheck(hbmClass.getSqlUpdate().getCheck());
            mappingEntity.getSqlUpdate().setValue(hbmClass.getSqlUpdate().getValue());
        }
        if (hbmClass.getSqlDelete() != null) {
            mappingEntity.setSqlDelete(new JaxbCustomSqlImpl());
            mappingEntity.getSqlDelete().setValue(hbmClass.getSqlDelete().getValue());
            mappingEntity.getSqlDelete().setResultCheck(hbmClass.getSqlDelete().getCheck());
            mappingEntity.getSqlDelete().setValue(hbmClass.getSqlDelete().getValue());
        }
        mappingEntity.setRowid(hbmClass.getRowid());
        mappingEntity.setSqlRestriction(hbmClass.getWhere());
        mappingEntity.setOptimisticLocking(hbmClass.getOptimisticLock());
        mappingEntity.setDiscriminatorValue(hbmClass.getDiscriminatorValue());
        this.transferDiscriminator(hbmClass, mappingEntity, entityInfo);
        this.transferEntityAttributes(hbmClass, mappingEntity, entityInfo);
        if (hbmClass.getCache() != null) {
            this.transformEntityCaching(hbmClass, mappingEntity);
        }
        for (JaxbHbmNamedQueryType jaxbHbmNamedQueryType : hbmClass.getQuery()) {
            mappingEntity.getNamedQueries().add(HbmXmlTransformer.transformNamedQuery(jaxbHbmNamedQueryType, mappingEntity.getName() + "." + jaxbHbmNamedQueryType.getName()));
        }
        for (JaxbHbmNamedNativeQueryType jaxbHbmNamedNativeQueryType : hbmClass.getSqlQuery()) {
            mappingEntity.getNamedNativeQueries().add(this.transformNamedNativeQuery(jaxbHbmNamedNativeQueryType, mappingEntity.getName() + "." + jaxbHbmNamedNativeQueryType.getName()));
        }
        for (JaxbHbmFilterType jaxbHbmFilterType : hbmClass.getFilter()) {
            mappingEntity.getFilters().add(HbmXmlTransformer.convert(jaxbHbmFilterType));
        }
        for (JaxbHbmFetchProfileType jaxbHbmFetchProfileType : hbmClass.getFetchProfile()) {
            mappingEntity.getFetchProfiles().add(HbmXmlTransformer.transferFetchProfile(jaxbHbmFetchProfileType));
        }
        for (JaxbHbmDiscriminatorSubclassEntityType jaxbHbmDiscriminatorSubclassEntityType : hbmClass.getSubclass()) {
            subclassEntityName = TransformationHelper.determineEntityName(jaxbHbmDiscriminatorSubclassEntityType, this.hbmXmlBinding.getRoot());
            mappingSubclassEntity = this.transformationState.getMappingEntityByName().get(subclassEntityName);
            subclassEntityInfo = this.transformationState.getEntityInfoByName().get(subclassEntityName);
            this.transferDiscriminatorSubclass(jaxbHbmDiscriminatorSubclassEntityType, mappingSubclassEntity, subclassEntityInfo);
            this.defineInheritance(mappingEntity, InheritanceType.SINGLE_TABLE);
        }
        for (JaxbHbmJoinedSubclassEntityType jaxbHbmJoinedSubclassEntityType : hbmClass.getJoinedSubclass()) {
            subclassEntityName = TransformationHelper.determineEntityName(jaxbHbmJoinedSubclassEntityType, this.hbmXmlBinding.getRoot());
            mappingSubclassEntity = this.transformationState.getMappingEntityByName().get(subclassEntityName);
            subclassEntityInfo = this.transformationState.getEntityInfoByName().get(subclassEntityName);
            this.transferJoinedSubclass(jaxbHbmJoinedSubclassEntityType, mappingSubclassEntity, subclassEntityInfo);
            this.defineInheritance(mappingEntity, InheritanceType.TABLE_PER_CLASS);
        }
        for (JaxbHbmUnionSubclassEntityType jaxbHbmUnionSubclassEntityType : hbmClass.getUnionSubclass()) {
            subclassEntityName = TransformationHelper.determineEntityName(jaxbHbmUnionSubclassEntityType, this.hbmXmlBinding.getRoot());
            mappingSubclassEntity = this.transformationState.getMappingEntityByName().get(subclassEntityName);
            subclassEntityInfo = this.transformationState.getEntityInfoByName().get(subclassEntityName);
            this.transferUnionSubclass(jaxbHbmUnionSubclassEntityType, mappingSubclassEntity, subclassEntityInfo);
            this.defineInheritance(mappingEntity, InheritanceType.JOINED);
        }
        for (JaxbHbmNamedQueryType jaxbHbmNamedQueryType : hbmClass.getQuery()) {
            name = hbmClass.getName() + "." + jaxbHbmNamedQueryType.getName();
            this.mappingXmlBinding.getRoot().getNamedQueries().add(HbmXmlTransformer.transformNamedQuery(jaxbHbmNamedQueryType, name));
        }
        for (JaxbHbmNamedNativeQueryType jaxbHbmNamedNativeQueryType : hbmClass.getSqlQuery()) {
            name = hbmClass.getName() + "." + jaxbHbmNamedNativeQueryType.getName();
            this.mappingXmlBinding.getRoot().getNamedNativeQueries().add(this.transformNamedNativeQuery(jaxbHbmNamedNativeQueryType, name));
        }
    }

    private void defineInheritance(JaxbEntityImpl mappingEntity, InheritanceType strategy) {
        if (mappingEntity.getInheritance() != null && mappingEntity.getInheritance().getStrategy() != strategy) {
            throw new MappingException(String.format(Locale.ROOT, "Attempt to use multiple inheritance strategies : %s & %s", mappingEntity.getInheritance().getStrategy(), strategy), this.origin());
        }
        mappingEntity.setInheritance(new JaxbInheritanceImpl());
        mappingEntity.getInheritance().setStrategy(strategy);
    }

    private void transferDiscriminatorSubclass(JaxbHbmDiscriminatorSubclassEntityType hbmSubclass, JaxbEntityImpl subclassEntity, EntityTypeInfo subclassEntityInfo) {
        this.transferBaseEntityInformation(hbmSubclass, subclassEntity, subclassEntityInfo);
        this.transferBaseEntityAttributes(hbmSubclass, subclassEntity, subclassEntityInfo);
        if (!hbmSubclass.getSubclass().isEmpty()) {
            for (JaxbHbmDiscriminatorSubclassEntityType nestedHbmSubclass : hbmSubclass.getSubclass()) {
                String nestedSubclassEntityName = TransformationHelper.determineEntityName(nestedHbmSubclass, this.hbmXmlBinding.getRoot());
                JaxbEntityImpl nestedSubclassSubclassEntity = this.transformationState.getMappingEntityByName().get(nestedSubclassEntityName);
                EntityTypeInfo nestedSubclassInfo = this.transformationState.getEntityInfoByName().get(nestedSubclassEntityName);
                this.transferDiscriminatorSubclass(nestedHbmSubclass, nestedSubclassSubclassEntity, nestedSubclassInfo);
            }
        }
    }

    private void transferJoinedSubclass(JaxbHbmJoinedSubclassEntityType hbmSubclass, JaxbEntityImpl subclassEntity, EntityTypeInfo subclassEntityInfo) {
        this.currentBaseTable = subclassEntityInfo.table();
        this.transferBaseEntityInformation(hbmSubclass, subclassEntity, subclassEntityInfo);
        this.transferEntityAttributes(hbmSubclass, subclassEntity, subclassEntityInfo);
        HbmXmlTransformer.applyTable(subclassEntityInfo.getPersistentClass(), subclassEntity);
        JaxbHbmKeyType key = hbmSubclass.getKey();
        if (key != null) {
            JaxbPrimaryKeyJoinColumnImpl joinColumn = new JaxbPrimaryKeyJoinColumnImpl();
            joinColumn.setName(key.getColumnAttribute());
            subclassEntity.getPrimaryKeyJoinColumns().add(joinColumn);
            joinColumn.setForeignKey(this.transformForeignKey(key.getForeignKey()));
        }
        if (!hbmSubclass.getJoinedSubclass().isEmpty()) {
            for (JaxbHbmJoinedSubclassEntityType nestedHbmSubclass : hbmSubclass.getJoinedSubclass()) {
                String nestedSubclassEntityName = TransformationHelper.determineEntityName(nestedHbmSubclass, this.hbmXmlBinding.getRoot());
                JaxbEntityImpl nestedSubclassSubclassEntity = this.transformationState.getMappingEntityByName().get(nestedSubclassEntityName);
                EntityTypeInfo nestedSubclassInfo = this.transformationState.getEntityInfoByName().get(nestedSubclassEntityName);
                this.transferJoinedSubclass(nestedHbmSubclass, nestedSubclassSubclassEntity, nestedSubclassInfo);
            }
        }
    }

    private void transferUnionSubclass(JaxbHbmUnionSubclassEntityType hbmSubclass, JaxbEntityImpl subclassEntity, EntityTypeInfo subclassEntityInfo) {
        this.currentBaseTable = subclassEntityInfo.table();
        subclassEntity.setProxy(hbmSubclass.getProxy());
        this.transferBaseEntityInformation(hbmSubclass, subclassEntity, subclassEntityInfo);
        this.transferEntityAttributes(hbmSubclass, subclassEntity, subclassEntityInfo);
        HbmXmlTransformer.applyTable(subclassEntityInfo.getPersistentClass(), subclassEntity);
        if (!hbmSubclass.getUnionSubclass().isEmpty()) {
            for (JaxbHbmUnionSubclassEntityType nestedHbmSubclass : hbmSubclass.getUnionSubclass()) {
                String nestedSubclassEntityName = TransformationHelper.determineEntityName(nestedHbmSubclass, this.hbmXmlBinding.getRoot());
                JaxbEntityImpl nestedSubclassSubclassEntity = this.transformationState.getMappingEntityByName().get(nestedSubclassEntityName);
                EntityTypeInfo nestedSubclassInfo = this.transformationState.getEntityInfoByName().get(nestedSubclassEntityName);
                this.transferUnionSubclass(nestedHbmSubclass, nestedSubclassSubclassEntity, nestedSubclassInfo);
            }
        }
    }

    private void transferBaseEntityInformation(JaxbHbmEntityBaseDefinition hbmEntity, JaxbEntityImpl mappingEntity, EntityTypeInfo bootEntityInfo) {
        mappingEntity.setMetadataComplete(true);
        PersistentClass persistentClass = bootEntityInfo.getPersistentClass();
        if (persistentClass.getSuperclass() != null) {
            mappingEntity.setExtends(persistentClass.getSuperclass().getEntityName());
        }
        if (hbmEntity instanceof Discriminatable) {
            Discriminatable discriminatable = (Discriminatable)((Object)hbmEntity);
            TransformationHelper.transfer(discriminatable::getDiscriminatorValue, mappingEntity::setDiscriminatorValue);
        }
        if (hbmEntity.isAbstract() != null) {
            mappingEntity.setAbstract(hbmEntity.isAbstract());
        }
        if (hbmEntity.getPersister() != null) {
            this.handleUnsupported("<persister/> mappings are not supported", new Object[0]);
            return;
        }
        TransformationHelper.transfer(hbmEntity::isLazy, mappingEntity::setLazy);
        TransformationHelper.transfer(hbmEntity::getProxy, mappingEntity::setProxy);
        TransformationHelper.transfer(hbmEntity::getBatchSize, mappingEntity::setBatchSize);
        TransformationHelper.transfer(hbmEntity::isDynamicInsert, mappingEntity::setDynamicInsert);
        TransformationHelper.transfer(hbmEntity::isDynamicUpdate, mappingEntity::setDynamicUpdate);
        TransformationHelper.transfer(hbmEntity::isSelectBeforeUpdate, mappingEntity::setSelectBeforeUpdate);
        this.transferToolingHints(hbmEntity);
        this.transferResultSetMappings(mappingEntity.getName(), hbmEntity);
    }

    private void applyBasicTypeMapping(BasicValue basicValue, JaxbBasicMapping jaxbBasicMapping, String hbmTypeAttribute, JaxbHbmTypeSpecificationType hbmType, Consumer<EnumType> enumTypeConsumer, Consumer<BasicValueConverter<?, ?>> converterConsumer) {
        BasicType type = (BasicType)basicValue.getType();
        if (type instanceof BasicTypeImpl) {
            BasicTypeImpl standardBasicType = (BasicTypeImpl)type;
            if (enumTypeConsumer != null && type.getReturnedClass().isEnum()) {
                enumTypeConsumer.accept(standardBasicType.getJdbcType().isString() ? EnumType.STRING : EnumType.ORDINAL);
            } else {
                jaxbBasicMapping.setJavaType(standardBasicType.getMappedJavaType().getClass().getName());
                jaxbBasicMapping.setJdbcType(standardBasicType.getJdbcType().getClass().getName());
            }
        } else if (type instanceof CustomType) {
            JaxbUserTypeImpl typeNode;
            CustomType customType = (CustomType)type;
            if (StringHelper.isNotEmpty(hbmTypeAttribute)) {
                typeNode = this.interpretBasicType(hbmTypeAttribute, null, this.transformationState.getTypeDefMap().get(hbmTypeAttribute));
                jaxbBasicMapping.setType(typeNode);
            }
            if (hbmType != null) {
                typeNode = this.interpretBasicType(hbmType.getName(), hbmType, this.transformationState.getTypeDefMap().get(hbmType.getName()));
                jaxbBasicMapping.setType(typeNode);
            }
        } else if (type instanceof ConvertedBasicType) {
            ConvertedBasicType convertedType = (ConvertedBasicType)type;
            if (converterConsumer == null) {
                throw new AssertionFailure("Unexpected context for converted value");
            }
            jaxbBasicMapping.setJavaType(convertedType.getMappedJavaType().getClass().getName());
            jaxbBasicMapping.setJdbcTypeCode(convertedType.getJdbcType().getJdbcTypeCode());
            converterConsumer.accept(convertedType.getValueConverter());
        }
    }

    private static void applyTable(PersistentClass bootBinding, JaxbEntityImpl jaxbEntity) {
        Table table = bootBinding.getTable();
        if (table.isSubselect()) {
            jaxbEntity.setTableExpression(table.getSubselect());
        } else if (table.isView()) {
            jaxbEntity.setTableExpression(table.getViewQuery());
        } else {
            JaxbTableImpl jaxbTable = new JaxbTableImpl();
            jaxbEntity.setTable(jaxbTable);
            jaxbTable.setName(table.getName());
            jaxbTable.setComment(table.getComment());
            HbmXmlTransformer.transferBaseTableInfo(table, jaxbTable);
        }
    }

    private static void transferBaseTableInfo(Table table, JaxbTableMapping jaxbTableMapping) {
        jaxbTableMapping.setCatalog(table.getCatalog());
        jaxbTableMapping.setSchema(table.getSchema());
        for (CheckConstraint check : table.getChecks()) {
            JaxbCheckConstraintImpl jaxbCheckConstraint = new JaxbCheckConstraintImpl();
            jaxbTableMapping.getCheckConstraints().add(jaxbCheckConstraint);
            jaxbCheckConstraint.setName(check.getName());
            jaxbCheckConstraint.setConstraint(check.getConstraint());
            jaxbCheckConstraint.setOptions(check.getOptions());
        }
    }

    private void transferFilterDefinitions() {
        List<JaxbHbmFilterDefinitionType> filterDefs = this.hbmXmlBinding.getRoot().getFilterDef();
        JaxbEntityMappingsImpl ormRoot = this.mappingXmlBinding.getRoot();
        if (filterDefs.isEmpty()) {
            return;
        }
        for (JaxbHbmFilterDefinitionType hbmFilterDef : filterDefs) {
            JaxbFilterDefImpl filterDef = new JaxbFilterDefImpl();
            ormRoot.getFilterDefinitions().add(filterDef);
            filterDef.setName(hbmFilterDef.getName());
            boolean foundCondition = false;
            for (Serializable content : hbmFilterDef.getContent()) {
                if (content instanceof String) {
                    String condition = ((String)((Object)content)).trim();
                    if (StringHelper.isEmpty(condition)) continue;
                    foundCondition = true;
                    filterDef.setDefaultCondition(condition);
                    continue;
                }
                JaxbHbmFilterParameterType hbmFilterParam = (JaxbHbmFilterParameterType)((JAXBElement)content).getValue();
                JaxbFilterDefImpl.JaxbFilterParamImpl param = new JaxbFilterDefImpl.JaxbFilterParamImpl();
                filterDef.getFilterParams().add(param);
                param.setName(hbmFilterParam.getParameterName());
                param.setType(hbmFilterParam.getParameterValueTypeName());
            }
            if (foundCondition) continue;
            filterDef.setDefaultCondition(hbmFilterDef.getCondition());
        }
    }

    private void transferImports() {
        List<JaxbHbmClassRenameType> hbmImports = this.hbmXmlBinding.getRoot().getImport();
        if (hbmImports.isEmpty()) {
            return;
        }
        JaxbEntityMappingsImpl ormRoot = this.mappingXmlBinding.getRoot();
        for (JaxbHbmClassRenameType hbmImport : hbmImports) {
            JaxbHqlImportImpl ormImport = new JaxbHqlImportImpl();
            ormRoot.getHqlImports().add(ormImport);
            ormImport.setClazz(hbmImport.getClazz());
            ormImport.setRename(hbmImport.getRename());
        }
    }

    private void transferResultSetMappings() {
        List<JaxbHbmResultSetMappingType> hbmResultMappings = this.hbmXmlBinding.getRoot().getResultset();
        if (hbmResultMappings.isEmpty()) {
            return;
        }
        JaxbEntityMappingsImpl ormRoot = this.mappingXmlBinding.getRoot();
        for (JaxbHbmResultSetMappingType hbmResultSet : hbmResultMappings) {
            JaxbSqlResultSetMappingImpl mapping = this.transformResultSetMapping(null, hbmResultSet);
            ormRoot.getSqlResultSetMappings().add(mapping);
        }
    }

    private JaxbSqlResultSetMappingImpl transformResultSetMapping(String namePrefix, JaxbHbmResultSetMappingType hbmResultSet) {
        String resultMappingName = namePrefix == null ? hbmResultSet.getName() : namePrefix + "." + hbmResultSet.getName();
        JaxbSqlResultSetMappingImpl mapping = new JaxbSqlResultSetMappingImpl();
        mapping.setName(resultMappingName);
        mapping.setDescription("SQL ResultSet mapping - " + resultMappingName);
        for (Serializable hbmReturn : hbmResultSet.getValueMappingSources()) {
            if (hbmReturn instanceof JaxbHbmNativeQueryReturnType) {
                mapping.getEntityResult().add(this.transferEntityReturnElement(resultMappingName, (JaxbHbmNativeQueryReturnType)hbmReturn));
                continue;
            }
            if (hbmReturn instanceof JaxbHbmNativeQueryScalarReturnType) {
                mapping.getColumnResult().add(this.transferScalarReturnElement(resultMappingName, (JaxbHbmNativeQueryScalarReturnType)hbmReturn));
                continue;
            }
            if (hbmReturn instanceof JaxbHbmNativeQueryJoinReturnType) {
                this.handleUnsupportedContent(String.format("SQL ResultSet mapping [name=%s] contained a <return-join/> element, which is not supported for transformation", resultMappingName));
                continue;
            }
            if (hbmReturn instanceof JaxbHbmNativeQueryCollectionLoadReturnType) {
                this.handleUnsupportedContent(String.format("SQL ResultSet mapping [name=%s] contained a <collection-load/> element, which is not supported for transformation", resultMappingName));
                continue;
            }
            this.handleUnsupportedContent(String.format("SQL ResultSet mapping [name=%s] contained an unexpected element type", resultMappingName));
        }
        return mapping;
    }

    private JaxbEntityResultImpl transferEntityReturnElement(String resultMappingName, JaxbHbmNativeQueryReturnType hbmReturn) {
        JaxbEntityResultImpl entityResult = new JaxbEntityResultImpl();
        entityResult.setEntityClass(this.getFullyQualifiedClassName(hbmReturn.getClazz()));
        for (JaxbHbmNativeQueryPropertyReturnType propertyReturn : hbmReturn.getReturnProperty()) {
            JaxbFieldResultImpl field = new JaxbFieldResultImpl();
            ArrayList<String> columns = new ArrayList<String>();
            if (!StringHelper.isEmpty(propertyReturn.getColumn())) {
                columns.add(propertyReturn.getColumn());
            }
            for (JaxbHbmNativeQueryPropertyReturnType.JaxbHbmReturnColumn returnColumn : propertyReturn.getReturnColumn()) {
                columns.add(returnColumn.getName());
            }
            if (columns.size() > 1) {
                this.handleUnsupportedContent(String.format("SQL ResultSet mapping [name=%s] contained a <return-property name='%s'/> element declaring multiple 1 column mapping, which is not supported for transformation;skipping that return-property mapping", resultMappingName, propertyReturn.getName()));
                continue;
            }
            field.setColumn((String)columns.get(0));
            field.setName(propertyReturn.getName());
            entityResult.getFieldResult().add(field);
        }
        return entityResult;
    }

    private JaxbColumnResultImpl transferScalarReturnElement(String resultMappingName, JaxbHbmNativeQueryScalarReturnType hbmReturn) {
        JaxbColumnResultImpl columnResult = new JaxbColumnResultImpl();
        columnResult.setName(hbmReturn.getColumn());
        columnResult.setClazz(hbmReturn.getType());
        this.handleUnsupportedContent(String.format("SQL ResultSet mapping [name=%s] contained a <return-scalar column='%s'/> element; transforming type->class likely requires manual adjustment", resultMappingName, hbmReturn.getColumn()));
        return columnResult;
    }

    private void transferFetchProfiles() {
        List<JaxbHbmFetchProfileType> hbmFetchProfiles = this.hbmXmlBinding.getRoot().getFetchProfile();
        if (hbmFetchProfiles.isEmpty()) {
            return;
        }
        for (JaxbHbmFetchProfileType hbmFetchProfile : hbmFetchProfiles) {
            this.mappingXmlBinding.getRoot().getFetchProfiles().add(HbmXmlTransformer.transferFetchProfile(hbmFetchProfile));
        }
    }

    private static JaxbFetchProfileImpl transferFetchProfile(JaxbHbmFetchProfileType hbmFetchProfile) {
        JaxbFetchProfileImpl fetchProfile = new JaxbFetchProfileImpl();
        fetchProfile.setName(hbmFetchProfile.getName());
        for (JaxbHbmFetchProfileType.JaxbHbmFetch hbmFetch : hbmFetchProfile.getFetch()) {
            JaxbFetchProfileImpl.JaxbFetchImpl fetch = new JaxbFetchProfileImpl.JaxbFetchImpl();
            fetchProfile.getFetch().add(fetch);
            fetch.setEntity(hbmFetch.getEntity());
            fetch.setAssociation(hbmFetch.getAssociation());
            fetch.setStyle(hbmFetch.getStyle().value());
        }
        return fetchProfile;
    }

    private void transferNamedQueries() {
        List<JaxbHbmNamedQueryType> hbmHqlQueries = this.hbmXmlBinding.getRoot().getQuery();
        if (hbmHqlQueries.isEmpty()) {
            return;
        }
        for (JaxbHbmNamedQueryType hbmHqlQuery : hbmHqlQueries) {
            this.mappingXmlBinding.getRoot().getNamedQueries().add(HbmXmlTransformer.transformNamedQuery(hbmHqlQuery, hbmHqlQuery.getName()));
        }
    }

    private static JaxbNamedHqlQueryImpl transformNamedQuery(JaxbHbmNamedQueryType hbmQuery, String name) {
        JaxbNamedHqlQueryImpl query = new JaxbNamedHqlQueryImpl();
        query.setName(name);
        query.setCacheable(hbmQuery.isCacheable());
        query.setCacheMode(hbmQuery.getCacheMode());
        query.setCacheRegion(hbmQuery.getCacheRegion());
        query.setComment(hbmQuery.getComment());
        query.setFetchSize(hbmQuery.getFetchSize());
        query.setFlushMode(hbmQuery.getFlushMode());
        query.setFetchSize(hbmQuery.getFetchSize());
        query.setReadOnly(hbmQuery.isReadOnly());
        query.setTimeout(hbmQuery.getTimeout());
        for (Serializable content : hbmQuery.getContent()) {
            if (content instanceof String) {
                String qryString = (String)((Object)content);
                qryString = qryString.trim();
                query.setQuery(qryString);
                continue;
            }
            JAXBElement element = (JAXBElement)content;
            JaxbHbmQueryParamType hbmQueryParam = (JaxbHbmQueryParamType)element.getValue();
            JaxbQueryParamTypeImpl queryParam = new JaxbQueryParamTypeImpl();
            query.getQueryParam().add(queryParam);
            queryParam.setName(hbmQueryParam.getName());
            queryParam.setType(hbmQueryParam.getType());
        }
        return query;
    }

    private void transferNamedNativeQueries() {
        List<JaxbHbmNamedNativeQueryType> hbmNativeQueries = this.hbmXmlBinding.getRoot().getSqlQuery();
        if (hbmNativeQueries.isEmpty()) {
            return;
        }
        for (JaxbHbmNamedNativeQueryType hbmQuery : hbmNativeQueries) {
            this.mappingXmlBinding.getRoot().getNamedNativeQueries().add(this.transformNamedNativeQuery(hbmQuery, hbmQuery.getName()));
        }
    }

    private JaxbNamedNativeQueryImpl transformNamedNativeQuery(JaxbHbmNamedNativeQueryType hbmQuery, String queryName) {
        String implicitResultSetMappingName = queryName + "-implicitResultSetMapping";
        JaxbNamedNativeQueryImpl query = new JaxbNamedNativeQueryImpl();
        query.setName(queryName);
        query.setCacheable(hbmQuery.isCacheable());
        query.setCacheMode(hbmQuery.getCacheMode());
        query.setCacheRegion(hbmQuery.getCacheRegion());
        query.setComment(hbmQuery.getComment());
        query.setFetchSize(hbmQuery.getFetchSize());
        query.setFlushMode(hbmQuery.getFlushMode());
        query.setFetchSize(hbmQuery.getFetchSize());
        query.setReadOnly(hbmQuery.isReadOnly());
        query.setTimeout(hbmQuery.getTimeout());
        JaxbSqlResultSetMappingImpl implicitResultSetMapping = null;
        for (Serializable content : hbmQuery.getContent()) {
            if (content instanceof String) {
                String qryString = (String)((Object)content);
                qryString = qryString.trim();
                query.setQuery(qryString);
                continue;
            }
            if (!(content instanceof JAXBElement)) continue;
            Object element = ((JAXBElement)content).getValue();
            if (element instanceof JaxbHbmQueryParamType) {
                JaxbHbmQueryParamType hbmQueryParam = (JaxbHbmQueryParamType)element;
                JaxbQueryParamTypeImpl queryParam = new JaxbQueryParamTypeImpl();
                queryParam.setName(hbmQueryParam.getName());
                queryParam.setType(hbmQueryParam.getType());
                query.getQueryParam().add(queryParam);
                continue;
            }
            if (element instanceof JaxbHbmNativeQueryScalarReturnType) {
                if (implicitResultSetMapping == null) {
                    implicitResultSetMapping = new JaxbSqlResultSetMappingImpl();
                    implicitResultSetMapping.setName(implicitResultSetMappingName);
                    implicitResultSetMapping.setDescription(String.format(Locale.ROOT, "ResultSet mapping implicitly created for named native query `%s` during hbm.xml transformation", queryName));
                    this.mappingXmlBinding.getRoot().getSqlResultSetMappings().add(implicitResultSetMapping);
                }
                implicitResultSetMapping.getColumnResult().add(this.transferScalarReturnElement(implicitResultSetMappingName, (JaxbHbmNativeQueryScalarReturnType)element));
                continue;
            }
            if (element instanceof JaxbHbmNativeQueryReturnType) {
                if (implicitResultSetMapping == null) {
                    implicitResultSetMapping = new JaxbSqlResultSetMappingImpl();
                    implicitResultSetMapping.setName(implicitResultSetMappingName);
                    implicitResultSetMapping.setDescription(String.format(Locale.ROOT, "ResultSet mapping implicitly created for named native query `%s` during hbm.xml transformation", queryName));
                    this.mappingXmlBinding.getRoot().getSqlResultSetMappings().add(implicitResultSetMapping);
                }
                implicitResultSetMapping.getEntityResult().add(this.transferEntityReturnElement(implicitResultSetMappingName, (JaxbHbmNativeQueryReturnType)element));
                continue;
            }
            if (element instanceof JaxbHbmNativeQueryCollectionLoadReturnType) {
                this.handleUnsupportedContent(String.format("Named native query [name=%s] contained a <collection-load/> element, which is not supported for transformation", queryName));
                continue;
            }
            if (element instanceof JaxbHbmNativeQueryJoinReturnType) {
                this.handleUnsupportedContent(String.format("Named native query [name=%s] contained a <return-join/> element, which is not supported for transformation", queryName));
                continue;
            }
            if (element instanceof JaxbHbmSynchronizeType) {
                JaxbHbmSynchronizeType hbmSynchronize = (JaxbHbmSynchronizeType)element;
                JaxbSynchronizedTableImpl synchronize = new JaxbSynchronizedTableImpl();
                synchronize.setTable(hbmSynchronize.getTable());
                query.getSynchronizations().add(synchronize);
                continue;
            }
            this.handleUnsupportedContent(String.format("Named native query [name=%s] contained an unexpected element type", queryName));
        }
        return query;
    }

    private void transferDatabaseObjects() {
        List<JaxbHbmAuxiliaryDatabaseObjectType> hbmDatabaseObjects = this.hbmXmlBinding.getRoot().getDatabaseObject();
        if (hbmDatabaseObjects.isEmpty()) {
            return;
        }
        for (JaxbHbmAuxiliaryDatabaseObjectType hbmDatabaseObject : hbmDatabaseObjects) {
            JaxbDatabaseObjectImpl databaseObject = new JaxbDatabaseObjectImpl();
            this.mappingXmlBinding.getRoot().getDatabaseObjects().add(databaseObject);
            databaseObject.setCreate(hbmDatabaseObject.getCreate());
            databaseObject.setDrop(hbmDatabaseObject.getDrop());
            if (hbmDatabaseObject.getDialectScope().isEmpty()) continue;
            hbmDatabaseObject.getDialectScope().forEach(hbmScope -> {
                JaxbDatabaseObjectScopeImpl scope = new JaxbDatabaseObjectScopeImpl();
                databaseObject.getDialectScopes().add(scope);
                scope.setName(hbmScope.getName());
            });
        }
    }

    private void transformEntityCaching(JaxbHbmRootEntityType hbmClass, JaxbEntityImpl entity) {
        entity.setCaching(new JaxbCachingImpl());
        entity.getCaching().setRegion(hbmClass.getCache().getRegion());
        entity.getCaching().setAccess(hbmClass.getCache().getUsage());
        entity.getCaching().setIncludeLazy(this.convert(hbmClass.getCache().getInclude()));
    }

    private boolean convert(JaxbHbmCacheInclusionEnum hbmInclusion) {
        if (hbmInclusion == null) {
            return true;
        }
        if (hbmInclusion == JaxbHbmCacheInclusionEnum.NON_LAZY) {
            return false;
        }
        if (hbmInclusion == JaxbHbmCacheInclusionEnum.ALL) {
            return true;
        }
        throw new IllegalArgumentException("Unrecognized cache-inclusions value : " + hbmInclusion);
    }

    private void transferResultSetMappings(String namePrefix, ResultSetMappingContainer container) {
        List<JaxbHbmResultSetMappingType> resultSetMappings = container.getResultset();
        resultSetMappings.forEach(hbmMapping -> {
            JaxbSqlResultSetMappingImpl mapping = this.transformResultSetMapping(namePrefix, (JaxbHbmResultSetMappingType)hbmMapping);
            this.mappingXmlBinding.getRoot().getSqlResultSetMappings().add(mapping);
        });
    }

    private void transferToolingHints(ToolingHintContainer container) {
        if (CollectionHelper.isNotEmpty(container.getToolingHints())) {
            this.handleUnsupported("Transformation of <meta/> (tooling hint) is not supported - `%s`", this.hbmXmlBinding.getOrigin());
        }
    }

    private void transferColumnsAndFormulas(Value value, ColumnAndFormulaTarget target, ColumnDefaults columnDefaults, String table) {
        for (int i = 0; i < value.getSelectables().size(); ++i) {
            Selectable selectable = value.getSelectables().get(i);
            if (selectable instanceof Formula) {
                Formula formula = (Formula)selectable;
                target.addFormula(formula.getFormula());
                continue;
            }
            if (!(selectable instanceof Column)) continue;
            Column column = (Column)selectable;
            TargetColumnAdapter targetColumnAdapter = target.makeColumnAdapter(columnDefaults);
            targetColumnAdapter.setName(column.getQuotedName());
            targetColumnAdapter.setTable(table);
            targetColumnAdapter.setLength(this.convertColumnLength(column.getLength()));
            targetColumnAdapter.setPrecision(column.getPrecision());
            targetColumnAdapter.setScale(column.getScale());
            target.addColumn(targetColumnAdapter);
        }
    }

    private Integer convertColumnLength(Long length) {
        return length == null ? null : Integer.valueOf(length.intValue());
    }

    private void transferColumnsAndFormulas(ColumnAndFormulaSource source, ColumnAndFormulaTarget target, ColumnDefaults columnDefaults, String tableName) {
        if (tableName != null && this.currentBaseTable != null && this.currentBaseTable.isPhysicalTable() && this.currentBaseTable.getName().equals(tableName)) {
            tableName = null;
        }
        if (StringHelper.isNotEmpty(source.getFormulaAttribute())) {
            target.addFormula(source.getFormulaAttribute());
        } else if (StringHelper.isNotEmpty(source.getColumnAttribute())) {
            TargetColumnAdapter column = target.makeColumnAdapter(columnDefaults);
            column.setName(source.getColumnAttribute());
            column.setTable(tableName);
            target.addColumn(column);
        } else if (!source.getColumnOrFormula().isEmpty()) {
            for (Serializable columnOrFormula : source.getColumnOrFormula()) {
                if (columnOrFormula instanceof String) {
                    target.addFormula((String)((Object)columnOrFormula));
                    continue;
                }
                JaxbHbmColumnType hbmColumn = (JaxbHbmColumnType)columnOrFormula;
                TargetColumnAdapter column = target.makeColumnAdapter(columnDefaults);
                column.setTable(tableName);
                this.transferColumn(source.wrap(hbmColumn), column);
                target.addColumn(column);
            }
        } else if (StringHelper.isNotEmpty(tableName)) {
            TargetColumnAdapter column = target.makeColumnAdapter(columnDefaults);
            column.setTable(tableName);
            target.addColumn(column);
        }
    }

    private void transferColumn(SourceColumnAdapter source, TargetColumnAdapter target) {
        target.setName(source.getName());
        target.setNullable(this.invert(source.isNotNull()));
        target.setUnique(source.isUnique());
        target.setLength(source.getLength());
        target.setScale(source.getScale());
        target.setPrecision(source.getPrecision());
        target.setComment(source.getComment());
        target.setCheck(source.getCheck());
        target.setDefault(source.getDefault());
        target.setColumnDefinition(source.getSqlType());
        target.setRead(source.getRead());
        target.setWrite(source.getWrite());
    }

    private void transferColumn(Column source, TargetColumnAdapter target) {
        target.setName(source.getQuotedName());
        target.setNullable(source.isNullable());
        target.setUnique(source.isUnique());
        if (source.getLength() != null) {
            target.setLength(source.getLength().intValue());
        }
        target.setScale(source.getScale());
        target.setPrecision(source.getPrecision());
        target.setComment(source.getComment());
        if (source.hasCheckConstraint()) {
            if (source.getCheckConstraints().size() > 1) {
                this.handleUnsupported("Cannot transform multiple column-level check-constraints : " + source.getName(), new Object[0]);
            }
            target.setCheck(source.getCheckConstraints().get(0).getConstraint());
        }
        target.setDefault(source.getDefaultValue());
        target.setColumnDefinition(source.getSqlType());
        target.setRead(source.getCustomRead());
        target.setWrite(source.getCustomWrite());
    }

    private void transferDiscriminator(JaxbHbmRootEntityType hbmClass, JaxbEntityImpl mappingEntity, EntityTypeInfo bootEntityInfo) {
        if (hbmClass.getDiscriminator() == null) {
            return;
        }
        Value discriminatorValue = bootEntityInfo.getPersistentClass().getDiscriminator();
        assert (discriminatorValue.getSelectables().size() == 1);
        boolean forceDiscriminator = bootEntityInfo.getPersistentClass().isForceDiscriminator();
        DiscriminatorType discriminatorType = HbmXmlTransformer.determineDiscriminatorType(discriminatorValue);
        if (discriminatorValue.hasFormula()) {
            JaxbDiscriminatorFormulaImpl jaxbFormula = new JaxbDiscriminatorFormulaImpl();
            mappingEntity.setDiscriminatorFormula(jaxbFormula);
            jaxbFormula.setFragment(((Formula)discriminatorValue.getSelectables().get(0)).getFormula());
            jaxbFormula.setDiscriminatorType(discriminatorType);
            jaxbFormula.setForceSelection(forceDiscriminator);
        } else {
            assert (discriminatorValue.getColumns().size() == 1);
            Column column = discriminatorValue.getColumns().get(0);
            JaxbDiscriminatorColumnImpl jaxbColumn = new JaxbDiscriminatorColumnImpl();
            mappingEntity.setDiscriminatorColumn(jaxbColumn);
            jaxbColumn.setName(column.getName());
            jaxbColumn.setDiscriminatorType(discriminatorType);
            jaxbColumn.setForceSelection(forceDiscriminator);
            jaxbColumn.setOptions(column.getOptions());
            if (column.getLength() != null) {
                jaxbColumn.setLength(column.getLength().intValue());
            }
        }
    }

    private static DiscriminatorType determineDiscriminatorType(Value discriminatorBinding) {
        Class<?> returnedClass = discriminatorBinding.getType().getReturnedClass();
        if (Character.class.equals(returnedClass) || Character.TYPE.equals(returnedClass)) {
            return DiscriminatorType.CHAR;
        }
        if (Integer.class.equals(returnedClass) || Integer.TYPE.equals(returnedClass)) {
            return DiscriminatorType.INTEGER;
        }
        return DiscriminatorType.STRING;
    }

    private void transferEntityAttributes(JaxbHbmEntityBaseDefinition hbmEntity, JaxbEntityImpl mappingEntity, EntityTypeInfo bootEntityInfo) {
        this.transferBaseEntityAttributes(hbmEntity, mappingEntity, bootEntityInfo);
        PersistentClass persistentClass = bootEntityInfo.getPersistentClass();
        if (persistentClass instanceof RootClass) {
            RootClass rootClass = (RootClass)persistentClass;
            assert (hbmEntity instanceof JaxbHbmRootEntityType);
            this.transferIdentifier((JaxbHbmRootEntityType)hbmEntity, mappingEntity, bootEntityInfo, rootClass);
            this.transferNaturalIdentifiers((JaxbHbmRootEntityType)hbmEntity, mappingEntity, bootEntityInfo, rootClass);
            this.transferVersion((JaxbHbmRootEntityType)hbmEntity, mappingEntity, bootEntityInfo, rootClass);
            this.transferJoins((JaxbHbmRootEntityType)hbmEntity, mappingEntity, bootEntityInfo);
        }
    }

    private void transferBaseEntityAttributes(EntityInfo hbmEntity, JaxbEntityImpl mappingEntity, EntityTypeInfo entityTypeInfo) {
        try {
            mappingEntity.setAttributes(new JaxbAttributesContainerImpl());
            this.transferBaseAttributes(entityTypeInfo.getPersistentClass().getEntityName(), hbmEntity.getAttributes(), entityTypeInfo, mappingEntity.getAttributes());
        }
        catch (Exception e) {
            throw new TransformationException("Error processing entity attributes : " + entityTypeInfo.getPersistentClass().getEntityName(), e, this.origin());
        }
    }

    private void transferBaseAttributes(String roleBase, List<?> hbmAttributeMappings, ManagedTypeInfo managedTypeInfo, JaxbAttributesContainer attributes) {
        for (Object hbmAttributeMapping : hbmAttributeMappings) {
            PropertyInfo propertyInfo;
            if (hbmAttributeMapping instanceof JaxbHbmBasicAttributeType) {
                JaxbHbmBasicAttributeType basic = (JaxbHbmBasicAttributeType)hbmAttributeMapping;
                try {
                    propertyInfo = managedTypeInfo.propertyInfoMap().get(basic.getName());
                    attributes.getBasicAttributes().add(this.transformBasicAttribute(basic, propertyInfo));
                    continue;
                }
                catch (Exception e) {
                    throw new TransformationException("Error transforming <property/> : " + basic.getName(), e, this.origin());
                }
            }
            if (hbmAttributeMapping instanceof JaxbHbmCompositeAttributeType) {
                JaxbHbmCompositeAttributeType hbmComponent = (JaxbHbmCompositeAttributeType)hbmAttributeMapping;
                try {
                    String componentRole = roleBase + "." + hbmComponent.getName();
                    ComponentTypeInfo componentTypeInfo = this.transformationState.getEmbeddableInfoByRole().get(componentRole);
                    JaxbEmbeddableImpl jaxbEmbeddable = this.applyEmbeddable(roleBase, hbmComponent, componentTypeInfo);
                    attributes.getEmbeddedAttributes().add(this.transformEmbedded(jaxbEmbeddable, hbmComponent));
                    continue;
                }
                catch (Exception e) {
                    throw new TransformationException("Error transforming <component/> : " + hbmComponent.getName(), e, this.origin());
                }
            }
            if (hbmAttributeMapping instanceof JaxbHbmPropertiesType) {
                JaxbHbmPropertiesType hbmProperties = (JaxbHbmPropertiesType)hbmAttributeMapping;
                this.handleUnsupported("<properties/> mappings not supported for transformation [name=%s]", hbmProperties.getName());
                continue;
            }
            if (hbmAttributeMapping instanceof JaxbHbmDynamicComponentType) {
                String name = ((JaxbHbmDynamicComponentType)hbmAttributeMapping).getName();
                this.handleUnsupported("<dynamic-component/> mappings not supported for transformation [name=%s]", name);
                continue;
            }
            if (hbmAttributeMapping instanceof JaxbHbmOneToOneType) {
                JaxbHbmOneToOneType hbmOneToOne = (JaxbHbmOneToOneType)hbmAttributeMapping;
                try {
                    propertyInfo = managedTypeInfo.propertyInfoMap().get(hbmOneToOne.getName());
                    this.transferOneToOne(hbmOneToOne, propertyInfo, attributes);
                    continue;
                }
                catch (Exception e) {
                    throw new TransformationException("Error transforming <one-to-one/> : " + hbmOneToOne.getName(), e, this.origin());
                }
            }
            if (hbmAttributeMapping instanceof JaxbHbmManyToOneType) {
                JaxbHbmManyToOneType hbmManyToOne = (JaxbHbmManyToOneType)hbmAttributeMapping;
                try {
                    this.transferManyToOne(managedTypeInfo, attributes, hbmManyToOne);
                    continue;
                }
                catch (Exception e) {
                    throw new TransformationException("Error transforming <many-to-one/> : " + hbmManyToOne.getName(), e, this.origin());
                }
            }
            if (hbmAttributeMapping instanceof JaxbHbmAnyAssociationType) {
                JaxbHbmAnyAssociationType any = (JaxbHbmAnyAssociationType)hbmAttributeMapping;
                try {
                    propertyInfo = managedTypeInfo.propertyInfoMap().get(any.getName());
                    attributes.getAnyMappingAttributes().add(this.transformAnyAttribute(any, propertyInfo));
                    continue;
                }
                catch (Exception e) {
                    throw new TransformationException("Error transforming <any/> : " + any.getName(), e, this.origin());
                }
            }
            if (!(hbmAttributeMapping instanceof PluralAttributeInfo)) continue;
            PluralAttributeInfo hbmCollection = (PluralAttributeInfo)hbmAttributeMapping;
            propertyInfo = managedTypeInfo.propertyInfoMap().get(hbmCollection.getName());
            if (hbmCollection.getElement() != null || hbmCollection.getCompositeElement() != null) {
                try {
                    attributes.getElementCollectionAttributes().add(this.transformElementCollection(roleBase, hbmCollection, propertyInfo));
                    continue;
                }
                catch (Exception e) {
                    throw new TransformationException("Error transforming element-collection : " + hbmCollection.getName(), e, this.origin());
                }
            }
            if (hbmCollection.getOneToMany() != null) {
                try {
                    attributes.getOneToManyAttributes().add(this.transformOneToMany(hbmCollection, propertyInfo));
                    continue;
                }
                catch (Exception e) {
                    throw new TransformationException("Error transforming one-to-many : " + hbmCollection.getName(), e, this.origin());
                }
            }
            if (hbmCollection.getManyToMany() != null) {
                try {
                    attributes.getManyToManyAttributes().add(this.transformManyToMany(hbmCollection, propertyInfo));
                    continue;
                }
                catch (Exception e) {
                    throw new TransformationException("Error transforming many-to-many : " + hbmCollection.getName(), e, this.origin());
                }
            }
            if (hbmCollection.getManyToAny() != null) {
                try {
                    attributes.getPluralAnyMappingAttributes().add(this.transformPluralAny(hbmCollection));
                    continue;
                }
                catch (Exception e) {
                    throw new TransformationException("Error transforming many-to-any : " + hbmCollection.getName(), e, this.origin());
                }
            }
            throw new UnsupportedOperationException("Unexpected node type - " + hbmCollection);
        }
    }

    private JaxbBasicImpl transformBasicAttribute(JaxbHbmBasicAttributeType hbmProp, PropertyInfo propertyInfo) {
        JaxbBasicImpl basic = new JaxbBasicImpl();
        this.transferBasicAttribute(hbmProp, basic, propertyInfo);
        return basic;
    }

    private void transferBasicAttribute(final JaxbHbmBasicAttributeType hbmProp, final JaxbBasicImpl basic, final PropertyInfo propertyInfo) {
        basic.setName(hbmProp.getName());
        basic.setOptional(propertyInfo.bootModelProperty().isOptional());
        basic.setFetch(FetchType.EAGER);
        basic.setAttributeAccessor(hbmProp.getAccess());
        basic.setOptimisticLock(hbmProp.isOptimisticLock());
        this.applyBasicTypeMapping((BasicValue)propertyInfo.bootModelProperty().getValue(), basic, hbmProp.getTypeAttribute(), hbmProp.getType(), basic::setEnumerated, basicValueConverter -> {
            if (basicValueConverter instanceof AttributeConverter) {
                AttributeConverter jpaAttributeConverter = (AttributeConverter)basicValueConverter;
                JaxbConvertImpl jaxbConvert = new JaxbConvertImpl();
                jaxbConvert.setConverter(jpaAttributeConverter.getClass().getName());
                basic.setConvert(jaxbConvert);
            } else if (basicValueConverter instanceof JpaAttributeConverter) {
                JpaAttributeConverter jpaAttributeConverter = (JpaAttributeConverter)basicValueConverter;
                JaxbConvertImpl jaxbConvert = new JaxbConvertImpl();
                jaxbConvert.setConverter(jpaAttributeConverter.getConverterJavaType().getTypeName());
                basic.setConvert(jaxbConvert);
            }
        });
        this.transferColumnsAndFormulas(new ColumnAndFormulaSource(){

            @Override
            public String getColumnAttribute() {
                return hbmProp.getColumnAttribute();
            }

            @Override
            public String getFormulaAttribute() {
                return hbmProp.getFormulaAttribute();
            }

            @Override
            public List<Serializable> getColumnOrFormula() {
                return hbmProp.getColumnOrFormula();
            }

            @Override
            public SourceColumnAdapter wrap(Serializable column) {
                return new SourceColumnAdapterJaxbHbmColumnType((JaxbHbmColumnType)column);
            }
        }, new ColumnAndFormulaTarget(){

            @Override
            public TargetColumnAdapter makeColumnAdapter(ColumnDefaults columnDefaults) {
                return new TargetColumnAdapterJaxbColumn(columnDefaults);
            }

            @Override
            public void addColumn(TargetColumnAdapter column) {
                basic.setColumn(((TargetColumnAdapterJaxbColumn)column).getTargetColumn());
            }

            @Override
            public void addFormula(String formula) {
                basic.setFormula(formula);
            }
        }, new ColumnDefaults(){

            @Override
            public Boolean isNullable() {
                return propertyInfo.bootModelProperty().isOptional();
            }

            @Override
            public Integer getLength() {
                return hbmProp.getLength();
            }

            @Override
            public Integer getScale() {
                return StringHelper.isNotEmpty(hbmProp.getScale()) ? Integer.valueOf(Integer.parseInt(hbmProp.getScale())) : null;
            }

            @Override
            public Integer getPrecision() {
                return StringHelper.isNotEmpty(hbmProp.getPrecision()) ? Integer.valueOf(Integer.parseInt(hbmProp.getPrecision())) : null;
            }

            @Override
            public Boolean isUnique() {
                return hbmProp.isUnique();
            }

            @Override
            public Boolean isInsertable() {
                return hbmProp.isInsert();
            }

            @Override
            public Boolean isUpdateable() {
                return hbmProp.isUpdate();
            }
        }, propertyInfo.tableName());
    }

    private JaxbUserTypeImpl interpretBasicType(String typeName, JaxbHbmConfigParameterContainer typeLocalParams, JaxbHbmTypeDefinitionType typeDef) {
        JaxbConfigurationParameterImpl param;
        assert (StringHelper.isNotEmpty(typeName));
        JaxbUserTypeImpl typeNode = new JaxbUserTypeImpl();
        if (typeDef == null) {
            typeNode.setValue(typeName);
        } else {
            typeNode.setValue(typeDef.getClazz());
            for (JaxbHbmConfigParameterType hbmParam : typeDef.getConfigParameters()) {
                param = new JaxbConfigurationParameterImpl();
                param.setName(hbmParam.getName());
                param.setValue(hbmParam.getValue());
                typeNode.getParameters().add(param);
            }
        }
        if (typeLocalParams != null) {
            for (JaxbHbmConfigParameterType hbmParam : typeLocalParams.getConfigParameters()) {
                param = new JaxbConfigurationParameterImpl();
                param.setName(hbmParam.getName());
                param.setValue(hbmParam.getValue());
                typeNode.getParameters().add(param);
            }
        }
        return typeNode;
    }

    private JaxbEmbeddableImpl applyEmbeddable(String roleBase, JaxbHbmCompositeAttributeType hbmComponent, ComponentTypeInfo componentTypeInfo) {
        JaxbEmbeddableImpl existing;
        String embeddableClassName = componentTypeInfo.getComponent().getComponentClassName();
        if (StringHelper.isNotEmpty(embeddableClassName) && (existing = this.jaxbEmbeddableByClassName.get(embeddableClassName)) != null) {
            return existing;
        }
        String role = roleBase + "." + hbmComponent.getName();
        String embeddableName = this.determineEmbeddableName(embeddableClassName, hbmComponent.getName());
        JaxbEmbeddableImpl jaxbEmbeddable = this.convertEmbeddable(role, embeddableName, embeddableClassName, hbmComponent);
        this.mappingXmlBinding.getRoot().getEmbeddables().add(jaxbEmbeddable);
        if (StringHelper.isNotEmpty(embeddableClassName)) {
            this.jaxbEmbeddableByClassName.put(embeddableClassName, jaxbEmbeddable);
        }
        return jaxbEmbeddable;
    }

    private JaxbEmbeddableImpl convertEmbeddable(String role, String embeddableName, String embeddableClassName, JaxbHbmCompositeAttributeType hbmComponent) {
        ComponentTypeInfo componentTypeInfo = this.transformationState.getEmbeddableInfoByRole().get(role);
        JaxbEmbeddableImpl embeddable = new JaxbEmbeddableImpl();
        embeddable.setMetadataComplete(true);
        embeddable.setName(embeddableName);
        embeddable.setClazz(embeddableClassName);
        embeddable.setAttributes(new JaxbEmbeddableAttributesContainerImpl());
        this.transferBaseAttributes(role, hbmComponent.getAttributes(), componentTypeInfo, embeddable.getAttributes());
        return embeddable;
    }

    private String determineEmbeddableName(String componentClassName, String attributeName) {
        if (StringHelper.isNotEmpty(componentClassName)) {
            return componentClassName;
        }
        return attributeName + "_" + this.counter++;
    }

    private JaxbEmbeddedImpl transformEmbedded(JaxbEmbeddableImpl jaxbEmbeddable, JaxbHbmCompositeAttributeType hbmComponent) {
        JaxbEmbeddedImpl embedded = new JaxbEmbeddedImpl();
        embedded.setName(hbmComponent.getName());
        embedded.setAttributeAccessor(hbmComponent.getAccess());
        embedded.setTarget(jaxbEmbeddable.getName());
        return embedded;
    }

    private void transferOneToOne(JaxbHbmOneToOneType hbmOneToOne, PropertyInfo propertyInfo, JaxbAttributesContainer attributes) {
        JaxbOneToOneImpl oneToOne = new JaxbOneToOneImpl();
        oneToOne.setAttributeAccessor(hbmOneToOne.getAccess());
        oneToOne.setOptional(propertyInfo.bootModelProperty().isOptional());
        oneToOne.setCascade(HbmXmlTransformer.convertCascadeType(hbmOneToOne.getCascade()));
        oneToOne.setOrphanRemoval(this.isOrphanRemoval(hbmOneToOne.getCascade()));
        oneToOne.setForeignKey(new JaxbForeignKeyImpl());
        oneToOne.getForeignKey().setName(hbmOneToOne.getForeignKey());
        if (StringHelper.isNotEmpty(hbmOneToOne.getPropertyRef())) {
            oneToOne.setPropertyRef(new JaxbPropertyRefImpl());
            oneToOne.getPropertyRef().setName(hbmOneToOne.getPropertyRef());
        }
        for (String formula : hbmOneToOne.getFormula()) {
            oneToOne.getJoinColumnOrJoinFormula().add((Serializable)((Object)formula));
        }
        oneToOne.setName(hbmOneToOne.getName());
        if (StringHelper.isNotEmpty(hbmOneToOne.getEntityName())) {
            oneToOne.setTargetEntity(hbmOneToOne.getEntityName());
        } else {
            oneToOne.setTargetEntity(hbmOneToOne.getClazz());
        }
        this.transferFetchable(hbmOneToOne.getLazy(), hbmOneToOne.getFetch(), hbmOneToOne.getOuterJoin(), hbmOneToOne.isConstrained(), oneToOne);
        attributes.getOneToOneAttributes().add(oneToOne);
    }

    private void transferManyToOne(ManagedTypeInfo managedTypeInfo, JaxbAttributesContainer attributes, JaxbHbmManyToOneType hbmManyToOne) {
        PropertyInfo propertyInfo = managedTypeInfo.propertyInfoMap().get(hbmManyToOne.getName());
        JaxbManyToOneImpl jaxbManyToOne = this.transformManyToOne(hbmManyToOne, propertyInfo);
        attributes.getManyToOneAttributes().add(jaxbManyToOne);
    }

    private JaxbManyToOneImpl transformManyToOne(JaxbHbmManyToOneType hbmNode, PropertyInfo propertyInfo) {
        final JaxbManyToOneImpl jaxbManyToOne = new JaxbManyToOneImpl();
        jaxbManyToOne.setName(hbmNode.getName());
        jaxbManyToOne.setOptional(propertyInfo.bootModelProperty().isOptional());
        if (StringHelper.isNotEmpty(hbmNode.getEntityName())) {
            jaxbManyToOne.setTargetEntity(hbmNode.getEntityName());
        } else {
            jaxbManyToOne.setTargetEntity(hbmNode.getClazz());
        }
        this.transferFetchable(hbmNode.getLazy(), hbmNode.getFetch(), hbmNode.getOuterJoin(), null, jaxbManyToOne);
        jaxbManyToOne.setAttributeAccessor(hbmNode.getAccess());
        jaxbManyToOne.setCascade(HbmXmlTransformer.convertCascadeType(hbmNode.getCascade()));
        if (StringHelper.isNotEmpty(hbmNode.getPropertyRef())) {
            jaxbManyToOne.setPropertyRef(new JaxbPropertyRefImpl());
            jaxbManyToOne.getPropertyRef().setName(hbmNode.getPropertyRef());
        }
        Property manyToOneProperty = propertyInfo.bootModelProperty();
        ManyToOne manyToOne = (ManyToOne)manyToOneProperty.getValue();
        this.transferColumnsAndFormulas(manyToOne, new ColumnAndFormulaTarget(){

            @Override
            public TargetColumnAdapter makeColumnAdapter(ColumnDefaults columnDefaults) {
                return new TargetColumnAdapterJaxbJoinColumn(columnDefaults);
            }

            @Override
            public void addColumn(TargetColumnAdapter column) {
                jaxbManyToOne.getJoinColumnOrJoinFormula().add(((TargetColumnAdapterJaxbJoinColumn)column).getTargetColumn());
            }

            @Override
            public void addFormula(String formula) {
                jaxbManyToOne.getJoinColumnOrJoinFormula().add((Serializable)((Object)formula));
            }
        }, (ColumnDefaults)new ColumnDefaultsProperty(manyToOneProperty), propertyInfo.tableName());
        jaxbManyToOne.setForeignKey(this.transformForeignKey(hbmNode.getForeignKey()));
        if (hbmNode.getNotFound() != null) {
            jaxbManyToOne.setNotFound(this.interpretNotFoundAction(hbmNode.getNotFound()));
        }
        return jaxbManyToOne;
    }

    private NotFoundAction interpretNotFoundAction(JaxbHbmNotFoundEnum hbmNotFound) {
        return switch (hbmNotFound) {
            default -> throw new IncompatibleClassChangeError();
            case JaxbHbmNotFoundEnum.EXCEPTION -> NotFoundAction.EXCEPTION;
            case JaxbHbmNotFoundEnum.IGNORE -> NotFoundAction.IGNORE;
        };
    }

    private JaxbAnyMappingImpl transformAnyAttribute(JaxbHbmAnyAssociationType source, PropertyInfo propertyInfo) {
        JaxbAnyMappingImpl target = new JaxbAnyMappingImpl();
        target.setName(source.getName());
        target.setAttributeAccessor(source.getAccess());
        target.setOptimisticLock(source.isOptimisticLock());
        target.setOptional(propertyInfo.bootModelProperty().isOptional());
        target.setDiscriminator(new JaxbAnyMappingDiscriminatorImpl());
        source.getMetaValue().forEach(sourceMapping -> {
            JaxbAnyDiscriminatorValueMappingImpl mapping = new JaxbAnyDiscriminatorValueMappingImpl();
            mapping.setDiscriminatorValue(sourceMapping.getValue());
            mapping.setCorrespondingEntityName(sourceMapping.getClazz());
            target.getDiscriminator().getValueMappings().add(mapping);
        });
        target.setKey(new JaxbAnyMappingKeyImpl());
        return target;
    }

    private JaxbElementCollectionImpl transformElementCollection(String roleBase, PluralAttributeInfo source, PropertyInfo propertyInfo) {
        JaxbElementCollectionImpl target = new JaxbElementCollectionImpl();
        this.transferCollectionCommonInfo(source, target);
        this.transferCollectionTable(source, target);
        if (source.getElement() != null) {
            this.transferElementInfo(source, source.getElement(), propertyInfo, target);
        } else {
            target.setTargetClass(source.getCompositeElement().getClazz());
            this.transferElementInfo(roleBase, source, source.getCompositeElement(), target);
        }
        return target;
    }

    private void transferCollectionTable(PluralAttributeInfo source, JaxbElementCollectionImpl target) {
        JaxbHbmKeyType key;
        target.setCollectionTable(new JaxbCollectionTableImpl());
        final JaxbCollectionTableImpl collectionTable = target.getCollectionTable();
        if (StringHelper.isNotEmpty(source.getTable())) {
            collectionTable.setName(source.getTable());
            collectionTable.setCatalog(source.getCatalog());
            collectionTable.setSchema(source.getSchema());
        }
        if ((key = source.getKey()) != null) {
            collectionTable.setForeignKeys(this.transformForeignKey(key.getForeignKey()));
            this.transferColumnsAndFormulas(new ColumnAndFormulaSource(){

                @Override
                public String getColumnAttribute() {
                    return key.getColumnAttribute();
                }

                @Override
                public String getFormulaAttribute() {
                    return null;
                }

                @Override
                public List<Serializable> getColumnOrFormula() {
                    return new ArrayList<Serializable>(key.getColumn());
                }

                @Override
                public SourceColumnAdapter wrap(Serializable column) {
                    return new SourceColumnAdapterJaxbHbmColumnType((JaxbHbmColumnType)column);
                }
            }, new ColumnAndFormulaTarget(){

                @Override
                public TargetColumnAdapter makeColumnAdapter(ColumnDefaults columnDefaults) {
                    return new TargetColumnAdapterJaxbJoinColumn(columnDefaults);
                }

                @Override
                public void addColumn(TargetColumnAdapter column) {
                    collectionTable.getJoinColumns().add(((TargetColumnAdapterJaxbJoinColumn)column).getTargetColumn());
                }

                @Override
                public void addFormula(String formula) {
                    HbmXmlTransformer.this.handleUnsupportedContent("formula as part of element-collection key is not supported for transformation; skipping");
                }
            }, (ColumnDefaults)ColumnDefaultsBasicImpl.INSTANCE, null);
            if (StringHelper.isNotEmpty(key.getPropertyRef())) {
                this.handleUnsupportedContent("Foreign-key (<key/>) for persistent collection (name=" + source.getName() + ") specified property-ref which is not supported for transformation; transformed <join-column/> will need manual adjustment of referenced-column-name");
            }
        }
    }

    private void transferCollectionCommonInfo(PluralAttributeInfo source, JaxbPluralAttribute target) {
        target.setName(source.getName());
        target.setAttributeAccessor(source.getAccess());
        target.setFetchMode(this.convert(source.getFetch()));
        target.setFetch(this.convert(source.getLazy()));
        if (StringHelper.isNotEmpty(source.getCollectionType())) {
            JaxbCollectionUserTypeImpl jaxbCollectionUserType = new JaxbCollectionUserTypeImpl();
            target.setCollectionType(jaxbCollectionUserType);
            jaxbCollectionUserType.setType(source.getCollectionType());
        }
        if (source instanceof JaxbHbmSetType) {
            JaxbHbmSetType set = (JaxbHbmSetType)source;
            String sort = set.getSort();
            if (StringHelper.isNotEmpty(sort) && !"unsorted".equals(sort)) {
                target.setSort(sort);
            }
            target.setOrderBy(set.getOrderBy());
            target.setClassification(LimitedCollectionClassification.SET);
        } else if (source instanceof JaxbHbmMapType) {
            JaxbHbmMapType map = (JaxbHbmMapType)source;
            String sort = map.getSort();
            if (StringHelper.isNotEmpty(sort) && !"unsorted".equals(sort)) {
                target.setSort(sort);
            }
            target.setOrderBy(map.getOrderBy());
            this.transferMapKey((JaxbHbmMapType)source, target);
            target.setClassification(LimitedCollectionClassification.MAP);
        } else if (source instanceof JaxbHbmIdBagCollectionType) {
            this.handleUnsupported("collection-id is not supported for transformation", new Object[0]);
        } else if (source instanceof JaxbHbmBagCollectionType) {
            target.setClassification(LimitedCollectionClassification.BAG);
        } else if (source instanceof JaxbHbmListType) {
            this.transferListIndex(((JaxbHbmListType)source).getIndex(), ((JaxbHbmListType)source).getListIndex(), target);
            target.setClassification(LimitedCollectionClassification.LIST);
        } else if (source instanceof JaxbHbmArrayType) {
            this.transferListIndex(((JaxbHbmArrayType)source).getIndex(), ((JaxbHbmArrayType)source).getListIndex(), target);
            target.setClassification(LimitedCollectionClassification.LIST);
        } else if (source instanceof JaxbHbmPrimitiveArrayType) {
            this.transferListIndex(((JaxbHbmPrimitiveArrayType)source).getIndex(), ((JaxbHbmPrimitiveArrayType)source).getListIndex(), target);
            target.setClassification(LimitedCollectionClassification.LIST);
        }
    }

    private FetchType convert(JaxbHbmLazyWithExtraEnum lazy) {
        if (lazy == null || lazy == JaxbHbmLazyWithExtraEnum.TRUE) {
            return FetchType.LAZY;
        }
        return FetchType.EAGER;
    }

    private void transferListIndex(JaxbHbmIndexType index, JaxbHbmListIndexType listIndex, JaxbPluralAttribute target) {
        JaxbOrderColumnImpl orderColumn = new JaxbOrderColumnImpl();
        target.setOrderColumn(orderColumn);
        if (index != null) {
            if (StringHelper.isNotEmpty(index.getColumnAttribute())) {
                orderColumn.setName(index.getColumnAttribute());
            } else if (index.getColumn().size() == 1) {
                JaxbHbmColumnType hbmColumn = index.getColumn().get(0);
                orderColumn.setName(hbmColumn.getName());
                orderColumn.setNullable(this.invert(hbmColumn.isNotNull()));
                orderColumn.setColumnDefinition(hbmColumn.getSqlType());
            }
        } else if (listIndex != null) {
            if (StringHelper.isNotEmpty(listIndex.getColumnAttribute())) {
                orderColumn.setName(listIndex.getColumnAttribute());
            } else if (listIndex.getColumn() != null) {
                orderColumn.setName(listIndex.getColumn().getName());
                orderColumn.setNullable(this.invert(listIndex.getColumn().isNotNull()));
                orderColumn.setColumnDefinition(listIndex.getColumn().getSqlType());
            }
        }
    }

    private void transferMapKey(JaxbHbmMapType source, JaxbPluralAttribute target) {
        if (source.getIndex() != null) {
            JaxbMapKeyColumnImpl mapKey = new JaxbMapKeyColumnImpl();
            mapKey.setName(source.getIndex().getColumnAttribute());
            target.setMapKeyColumn(mapKey);
        } else if (source.getMapKey() != null) {
            if (!StringHelper.isEmpty(source.getMapKey().getFormulaAttribute())) {
                this.handleUnsupported("Transformation of formula attribute within map-keys is not supported - `%s`", this.origin());
                return;
            }
            if (CollectionHelper.isNotEmpty(source.getMapKey().getColumnOrFormula())) {
                this.handleUnsupported("Transformation of column/formula elements within map-keys is not supported - `%s`", this.origin());
                return;
            }
            if (StringHelper.isNotEmpty(source.getMapKey().getNode())) {
                this.handleUnsupported("Transformation of `node` attribute is not supported - %s", this.origin());
                return;
            }
            String mapKeyType = this.resolveMapKeyType(source.getMapKey());
            if (mapKeyType != null) {
                JaxbUserTypeImpl jaxbMapKeyType = new JaxbUserTypeImpl();
                target.setMapKeyType(jaxbMapKeyType);
                jaxbMapKeyType.setValue(mapKeyType);
            }
            if (StringHelper.isNotEmpty(source.getMapKey().getColumnAttribute())) {
                JaxbMapKeyColumnImpl mapKeyColumn = new JaxbMapKeyColumnImpl();
                mapKeyColumn.setName(source.getMapKey().getColumnAttribute());
                target.setMapKeyColumn(mapKeyColumn);
            }
        }
    }

    private String resolveMapKeyType(JaxbHbmMapKeyBasicType mapKey) {
        if (StringHelper.isNotEmpty(mapKey.getTypeAttribute())) {
            return mapKey.getTypeAttribute();
        }
        if (mapKey.getType() != null) {
            return StringHelper.nullIfEmpty(mapKey.getType().getName());
        }
        return null;
    }

    private Boolean invert(Boolean value) {
        return value == null ? null : Boolean.valueOf(value == false);
    }

    private JaxbPluralFetchModeImpl convert(JaxbHbmFetchStyleWithSubselectEnum fetch) {
        if (fetch == null) {
            return null;
        }
        return switch (fetch) {
            default -> throw new IncompatibleClassChangeError();
            case JaxbHbmFetchStyleWithSubselectEnum.SELECT -> JaxbPluralFetchModeImpl.SELECT;
            case JaxbHbmFetchStyleWithSubselectEnum.JOIN -> JaxbPluralFetchModeImpl.JOIN;
            case JaxbHbmFetchStyleWithSubselectEnum.SUBSELECT -> JaxbPluralFetchModeImpl.SUBSELECT;
        };
    }

    private void transferElementInfo(PluralAttributeInfo hbmCollection, final JaxbHbmBasicCollectionElementType element, PropertyInfo propertyInfo, final JaxbElementCollectionImpl target) {
        this.transferCollectionCommonInfo(hbmCollection, target);
        this.transferCollectionTable(hbmCollection, target);
        this.transferElementTypeInfo(hbmCollection, element, propertyInfo, target);
        this.transferColumnsAndFormulas(new ColumnAndFormulaSource(){

            @Override
            public String getColumnAttribute() {
                return element.getColumnAttribute();
            }

            @Override
            public String getFormulaAttribute() {
                return element.getFormulaAttribute();
            }

            @Override
            public List<Serializable> getColumnOrFormula() {
                return element.getColumnOrFormula();
            }

            @Override
            public SourceColumnAdapter wrap(Serializable column) {
                return new SourceColumnAdapterJaxbHbmColumnType((JaxbHbmColumnType)column);
            }
        }, new ColumnAndFormulaTarget(){

            @Override
            public TargetColumnAdapter makeColumnAdapter(ColumnDefaults columnDefaults) {
                return new TargetColumnAdapterJaxbColumn(columnDefaults);
            }

            @Override
            public void addColumn(TargetColumnAdapter column) {
                target.setColumn(((TargetColumnAdapterJaxbColumn)column).getTargetColumn());
            }

            @Override
            public void addFormula(String formula) {
                target.setFormula(formula);
            }
        }, (ColumnDefaults)ColumnDefaultsBasicImpl.INSTANCE, null);
    }

    private void transferElementTypeInfo(PluralAttributeInfo hbmCollection, JaxbHbmBasicCollectionElementType element, PropertyInfo propertyInfo, JaxbElementCollectionImpl target) {
        Collection collectionValue = (Collection)propertyInfo.bootModelProperty().getValue();
        BasicValue basicValue = (BasicValue)collectionValue.getElement();
        this.applyBasicTypeMapping(basicValue, target, element.getTypeAttribute(), element.getType(), target::setEnumerated, basicValueConverter -> {
            if (basicValueConverter instanceof AttributeConverter) {
                AttributeConverter jpaAttributeConverter = (AttributeConverter)basicValueConverter;
                JaxbConvertImpl jaxbConvert = new JaxbConvertImpl();
                jaxbConvert.setConverter(jpaAttributeConverter.getClass().getName());
                target.getConverts().add(jaxbConvert);
            } else if (basicValueConverter instanceof JpaAttributeConverter) {
                JpaAttributeConverter jpaAttributeConverter = (JpaAttributeConverter)basicValueConverter;
                JaxbConvertImpl jaxbConvert = new JaxbConvertImpl();
                jaxbConvert.setConverter(jpaAttributeConverter.getConverterJavaType().getTypeName());
                target.getConverts().add(jaxbConvert);
            }
        });
        target.setTargetClass(basicValue.resolve().getDomainJavaType().getTypeName());
    }

    private void transferElementInfo(String roleBase, PluralAttributeInfo hbmCollection, JaxbHbmCompositeCollectionElementType compositeElement, JaxbElementCollectionImpl target) {
        this.transferCollectionCommonInfo(hbmCollection, target);
        this.transferCollectionTable(hbmCollection, target);
        String embeddableClassName = compositeElement.getClazz();
        String embeddableName = this.determineEmbeddableName(embeddableClassName, hbmCollection.getName());
        String partRole = roleBase + "." + hbmCollection.getName() + ".value";
        ComponentTypeInfo componentTypeInfo = this.transformationState.getEmbeddableInfoByRole().get(partRole);
        target.setTarget(embeddableName);
        if (StringHelper.isNotEmpty(embeddableClassName)) {
            target.setTargetClass(embeddableClassName);
        }
        JaxbEmbeddableImpl embeddable = new JaxbEmbeddableImpl();
        embeddable.setClazz(embeddableClassName);
        embeddable.setName(embeddableName);
        embeddable.setAttributes(new JaxbEmbeddableAttributesContainerImpl());
        this.transferBaseAttributes(partRole, compositeElement.getAttributes(), componentTypeInfo, embeddable.getAttributes());
        this.mappingXmlBinding.getRoot().getEmbeddables().add(embeddable);
    }

    private JaxbOneToManyImpl transformOneToMany(PluralAttributeInfo hbmCollection, PropertyInfo propertyInfo) {
        JaxbOneToManyImpl target = new JaxbOneToManyImpl();
        this.transferOneToManyInfo(hbmCollection, hbmCollection.getOneToMany(), target, propertyInfo);
        return target;
    }

    private void transferOneToManyInfo(PluralAttributeInfo hbmAttributeInfo, JaxbHbmOneToManyCollectionElementType hbmOneToMany, final JaxbOneToManyImpl target, PropertyInfo propertyInfo) {
        JaxbCustomSqlImpl jaxbCustomSql;
        if (hbmOneToMany.isEmbedXml() != null) {
            this.handleUnsupported("`embed-xml` not supported", new Object[0]);
        }
        if (hbmOneToMany.getNode() != null && !hbmOneToMany.getNode().isBlank()) {
            this.handleUnsupported("`node` not supported", new Object[0]);
        }
        this.transferCollectionCommonInfo(hbmAttributeInfo, target);
        target.setTargetEntity(StringHelper.isNotEmpty(hbmOneToMany.getClazz()) ? hbmOneToMany.getClazz() : hbmOneToMany.getEntityName());
        Property bootModelProperty = propertyInfo.bootModelProperty();
        Collection bootModelValue = (Collection)bootModelProperty.getValue();
        final JaxbHbmKeyType key = hbmAttributeInfo.getKey();
        if (bootModelValue.isInverse()) {
            target.setMappedBy(this.resolveMappedBy(hbmAttributeInfo, bootModelProperty, bootModelValue));
        } else if (key != null) {
            target.setForeignKey(this.transformForeignKey(key.getForeignKey()));
            this.transferColumnsAndFormulas(new ColumnAndFormulaSource(){

                @Override
                public String getColumnAttribute() {
                    return key.getColumnAttribute();
                }

                @Override
                public String getFormulaAttribute() {
                    return null;
                }

                @Override
                public List<Serializable> getColumnOrFormula() {
                    return new ArrayList<Serializable>(key.getColumn());
                }

                @Override
                public SourceColumnAdapter wrap(Serializable column) {
                    return new SourceColumnAdapterJaxbHbmColumnType((JaxbHbmColumnType)column);
                }
            }, new ColumnAndFormulaTarget(){

                @Override
                public TargetColumnAdapter makeColumnAdapter(ColumnDefaults columnDefaults) {
                    return new TargetColumnAdapterJaxbJoinColumn(columnDefaults);
                }

                @Override
                public void addColumn(TargetColumnAdapter column) {
                    target.getJoinColumn().add(((TargetColumnAdapterJaxbJoinColumn)column).getTargetColumn());
                }

                @Override
                public void addFormula(String formula) {
                }
            }, (ColumnDefaults)ColumnDefaultsBasicImpl.INSTANCE, null);
        }
        if (hbmOneToMany.getNotFound() != null) {
            target.setNotFound(this.interpretNotFoundAction(hbmOneToMany.getNotFound()));
        }
        target.setOrphanRemoval(this.isOrphanRemoval(hbmAttributeInfo.getCascade()));
        target.setCascade(HbmXmlTransformer.convertCascadeType(hbmAttributeInfo.getCascade()));
        for (JaxbHbmFilterType hbmFilter : hbmAttributeInfo.getFilter()) {
            target.getFilters().add(HbmXmlTransformer.convert(hbmFilter));
        }
        if (StringHelper.isNotEmpty(hbmAttributeInfo.getWhere())) {
            target.setSqlRestriction(hbmAttributeInfo.getWhere());
        }
        if (hbmAttributeInfo.getSqlInsert() != null) {
            jaxbCustomSql = new JaxbCustomSqlImpl();
            target.setSqlInsert(jaxbCustomSql);
            this.transferCustomSql(hbmAttributeInfo.getSqlInsert(), jaxbCustomSql);
        }
        if (hbmAttributeInfo.getSqlUpdate() != null) {
            jaxbCustomSql = new JaxbCustomSqlImpl();
            target.setSqlUpdate(jaxbCustomSql);
            this.transferCustomSql(hbmAttributeInfo.getSqlUpdate(), jaxbCustomSql);
        }
        if (hbmAttributeInfo.getSqlDelete() != null) {
            jaxbCustomSql = new JaxbCustomSqlImpl();
            target.setSqlDelete(jaxbCustomSql);
            this.transferCustomSql(hbmAttributeInfo.getSqlDelete(), jaxbCustomSql);
        }
        if (hbmAttributeInfo.getSqlDeleteAll() != null) {
            jaxbCustomSql = new JaxbCustomSqlImpl();
            target.setSqlDeleteAll(jaxbCustomSql);
            this.transferCustomSql(hbmAttributeInfo.getSqlDeleteAll(), jaxbCustomSql);
        }
    }

    private String resolveMappedBy(PluralAttributeInfo hbmAttributeInfo, Property bootModelProperty, Collection bootModelValue) {
        if (StringHelper.isNotEmpty(bootModelValue.getMappedByProperty())) {
            return bootModelValue.getMappedByProperty();
        }
        OneToMany element = (OneToMany)bootModelValue.getElement();
        String referencedEntityName = element.getReferencedEntityName();
        Map<List<Selectable>, String> attributeMap = this.transformationState.getMappableAttributesByColumns(referencedEntityName);
        return this.resolveMappedBy(bootModelProperty, bootModelValue, attributeMap);
    }

    private String resolveMappedBy(Property bootModelProperty, Collection bootModelValue, Map<List<Selectable>, String> attributeMap) {
        if (attributeMap != null) {
            KeyValue collectionKey = bootModelValue.getKey();
            for (Map.Entry<List<Selectable>, String> attributeEntry : attributeMap.entrySet()) {
                if (!this.matches(collectionKey, attributeEntry.getKey())) continue;
                return attributeEntry.getValue();
            }
        }
        throw new AssertionFailure(String.format(Locale.ROOT, "Unable to determine mapped-by name for inverse one-to-many : %s.%s", bootModelProperty.getPersistentClass().getEntityName(), bootModelProperty.getName()));
    }

    private boolean matches(KeyValue collectionKey, List<Selectable> candidate) {
        List<Selectable> collectionKeySelectables = collectionKey.getSelectables();
        if (collectionKeySelectables.size() != candidate.size()) {
            return false;
        }
        for (int i = 0; i < collectionKeySelectables.size(); ++i) {
            Selectable collectionKeySelectable = collectionKeySelectables.get(i);
            Selectable candidateSelectable = candidate.get(i);
            if (collectionKeySelectable instanceof Formula || candidateSelectable instanceof Formula) continue;
            Column collectionKeyColumn = (Column)collectionKeySelectable;
            Column candidateColumn = (Column)candidateSelectable;
            assert (StringHelper.isNotEmpty(collectionKeyColumn.getCanonicalName()));
            assert (StringHelper.isNotEmpty(candidateColumn.getCanonicalName()));
            if (collectionKeyColumn.getCanonicalName().equals(candidateColumn.getCanonicalName())) continue;
            return false;
        }
        return true;
    }

    private void transferCustomSql(JaxbHbmCustomSqlDmlType hbmCustomSql, JaxbCustomSqlImpl mappingCustomSql) {
        mappingCustomSql.setValue(hbmCustomSql.getValue());
        mappingCustomSql.setCallable(hbmCustomSql.isCallable());
        mappingCustomSql.setResultCheck(hbmCustomSql.getCheck());
    }

    private JaxbManyToManyImpl transformManyToMany(PluralAttributeInfo hbmCollection, PropertyInfo propertyInfo) {
        JaxbManyToManyImpl target = new JaxbManyToManyImpl();
        this.transferManyToManyInfo(hbmCollection, hbmCollection.getManyToMany(), propertyInfo, target);
        return target;
    }

    private void transferManyToManyInfo(PluralAttributeInfo hbmCollection, final JaxbHbmManyToManyCollectionElementType manyToMany, PropertyInfo propertyInfo, JaxbManyToManyImpl target) {
        JaxbCustomSqlImpl jaxbCustomSql;
        if (manyToMany.isEmbedXml() != null) {
            this.handleUnsupported("`embed-xml` no longer supported", new Object[0]);
        }
        if (StringHelper.isNotEmpty(manyToMany.getNode())) {
            this.handleUnsupported("`node` no longer supported", new Object[0]);
        }
        Property bootModelProperty = propertyInfo.bootModelProperty();
        Collection bootValue = (Collection)bootModelProperty.getValue();
        final JaxbJoinTableImpl joinTable = new JaxbJoinTableImpl();
        String tableName = hbmCollection.getTable();
        if (StringHelper.isNotEmpty(tableName)) {
            joinTable.setName(tableName);
        }
        target.setJoinTable(joinTable);
        final JaxbHbmKeyType key = hbmCollection.getKey();
        if (key != null) {
            joinTable.setForeignKey(this.transformForeignKey(key.getForeignKey()));
            this.transferColumnsAndFormulas(new ColumnAndFormulaSource(){

                @Override
                public String getColumnAttribute() {
                    return key.getColumnAttribute();
                }

                @Override
                public String getFormulaAttribute() {
                    return "";
                }

                @Override
                public List<Serializable> getColumnOrFormula() {
                    return new ArrayList<Serializable>(key.getColumn());
                }

                @Override
                public SourceColumnAdapter wrap(Serializable column) {
                    return new SourceColumnAdapterJaxbHbmColumnType((JaxbHbmColumnType)column);
                }
            }, new ColumnAndFormulaTarget(){

                @Override
                public TargetColumnAdapter makeColumnAdapter(ColumnDefaults columnDefaults) {
                    return new TargetColumnAdapterJaxbJoinColumn(columnDefaults);
                }

                @Override
                public void addColumn(TargetColumnAdapter column) {
                    joinTable.getJoinColumn().add(((TargetColumnAdapterJaxbJoinColumn)column).getTargetColumn());
                }

                @Override
                public void addFormula(String formula) {
                }
            }, (ColumnDefaults)ColumnDefaultsBasicImpl.INSTANCE, bootValue.getKey().getTable().getName());
        }
        this.transferColumnsAndFormulas(new ColumnAndFormulaSource(){

            @Override
            public String getColumnAttribute() {
                return manyToMany.getColumnAttribute();
            }

            @Override
            public String getFormulaAttribute() {
                return manyToMany.getFormulaAttribute();
            }

            @Override
            public List<Serializable> getColumnOrFormula() {
                return manyToMany.getColumnOrFormula();
            }

            @Override
            public SourceColumnAdapter wrap(Serializable column) {
                return new SourceColumnAdapterJaxbHbmColumnType((JaxbHbmColumnType)column);
            }
        }, new ColumnAndFormulaTarget(){

            @Override
            public TargetColumnAdapter makeColumnAdapter(ColumnDefaults columnDefaults) {
                return new TargetColumnAdapterJaxbJoinColumn(columnDefaults);
            }

            @Override
            public void addColumn(TargetColumnAdapter column) {
                joinTable.getInverseJoinColumn().add(((TargetColumnAdapterJaxbJoinColumn)column).getTargetColumn());
            }

            @Override
            public void addFormula(String formula) {
                HbmXmlTransformer.this.handleUnsupported("<many-to-many formula> not supported skipping", new Object[0]);
            }
        }, (ColumnDefaults)ColumnDefaultsBasicImpl.INSTANCE, joinTable.getName());
        this.transferCollectionCommonInfo(hbmCollection, target);
        target.setTargetEntity(StringHelper.isNotEmpty(manyToMany.getClazz()) ? manyToMany.getClazz() : manyToMany.getEntityName());
        if (manyToMany.getNotFound() == JaxbHbmNotFoundEnum.IGNORE) {
            target.setNotFound(NotFoundAction.IGNORE);
        }
        for (JaxbHbmFilterType hbmFilter : hbmCollection.getFilter()) {
            target.getFilters().add(HbmXmlTransformer.convert(hbmFilter));
        }
        if (StringHelper.isNotEmpty(hbmCollection.getWhere())) {
            target.setSqlRestriction(hbmCollection.getWhere());
        }
        if (hbmCollection.getSqlInsert() != null) {
            jaxbCustomSql = new JaxbCustomSqlImpl();
            target.setSqlInsert(jaxbCustomSql);
            this.transferCustomSql(hbmCollection.getSqlInsert(), jaxbCustomSql);
        }
        if (hbmCollection.getSqlUpdate() != null) {
            jaxbCustomSql = new JaxbCustomSqlImpl();
            target.setSqlUpdate(jaxbCustomSql);
            this.transferCustomSql(hbmCollection.getSqlUpdate(), jaxbCustomSql);
        }
        if (hbmCollection.getSqlDelete() != null) {
            jaxbCustomSql = new JaxbCustomSqlImpl();
            target.setSqlDelete(jaxbCustomSql);
            this.transferCustomSql(hbmCollection.getSqlDelete(), jaxbCustomSql);
        }
        if (hbmCollection.getSqlDeleteAll() != null) {
            jaxbCustomSql = new JaxbCustomSqlImpl();
            target.setSqlDeleteAll(jaxbCustomSql);
            this.transferCustomSql(hbmCollection.getSqlDeleteAll(), jaxbCustomSql);
        }
    }

    private JaxbPluralAnyMappingImpl transformPluralAny(PluralAttributeInfo hbmCollection) {
        JaxbPluralAnyMappingImpl target = new JaxbPluralAnyMappingImpl();
        this.transferPluralAny(hbmCollection, hbmCollection.getManyToAny(), target);
        return target;
    }

    private void transferPluralAny(PluralAttributeInfo hbmCollection, JaxbHbmManyToAnyCollectionElementType manyToAny, JaxbPluralAnyMappingImpl target) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    private void transferIdentifier(JaxbHbmRootEntityType hbmEntity, JaxbEntityImpl mappingXmlEntity, EntityTypeInfo bootEntityInfo, RootClass rootClass) {
        Property identifierProperty = rootClass.getIdentifierProperty();
        if (identifierProperty != null) {
            this.transferSinglePropertyIdentifier(hbmEntity, mappingXmlEntity, bootEntityInfo, rootClass, identifierProperty);
        } else {
            this.transferNonAggregatedCompositeId(hbmEntity, mappingXmlEntity, bootEntityInfo, rootClass);
        }
    }

    private void transferSinglePropertyIdentifier(JaxbHbmRootEntityType hbmEntity, JaxbEntityImpl mappingXmlEntity, EntityTypeInfo bootEntityInfo, RootClass rootClass, Property identifierProperty) {
        Value value = identifierProperty.getValue();
        if (value instanceof BasicValue) {
            BasicValue basicValue = (BasicValue)value;
            JaxbIdImpl simpleId = new JaxbIdImpl();
            this.transferSimpleId(hbmEntity.getId(), simpleId, identifierProperty, basicValue);
            mappingXmlEntity.getAttributes().getIdAttributes().add(simpleId);
        } else {
            JaxbEmbeddedIdImpl embeddedId = new JaxbEmbeddedIdImpl();
            this.transferEmbeddedId(hbmEntity.getCompositeId(), embeddedId, bootEntityInfo, identifierProperty);
            mappingXmlEntity.getAttributes().setEmbeddedIdAttribute(embeddedId);
        }
    }

    private void transferSimpleId(JaxbHbmSimpleIdType source, JaxbIdImpl target, Property identifierProperty, BasicValue basicValue) {
        target.setName(source.getName());
        target.setAttributeAccessor(source.getAccess());
        this.applyBasicTypeMapping(basicValue, target, source.getTypeAttribute(), source.getType(), null, null);
        JaxbHbmGeneratorSpecificationType hbmGenerator = source.getGenerator();
        if (hbmGenerator != null && !"assigned".equals(hbmGenerator.getClazz())) {
            JaxbGeneratedValueImpl jaxbGeneratedValue = new JaxbGeneratedValueImpl();
            target.setGeneratedValue(jaxbGeneratedValue);
            JaxbGenericIdGeneratorImpl generator = new JaxbGenericIdGeneratorImpl();
            target.setGenericGenerator(generator);
            generator.setClazz(hbmGenerator.getClazz());
            List<JaxbHbmConfigParameterType> hbmConfigParameters = hbmGenerator.getConfigParameters();
            for (int i = 0; i < hbmConfigParameters.size(); ++i) {
                JaxbHbmConfigParameterType hbmConfigParameter = hbmConfigParameters.get(i);
                JaxbConfigurationParameterImpl jaxbParam = new JaxbConfigurationParameterImpl();
                generator.getParameters().add(jaxbParam);
                jaxbParam.setName(hbmConfigParameter.getName());
                jaxbParam.setValue(hbmConfigParameter.getValue());
            }
        }
        target.setUnsavedValue(source.getUnsavedValue());
        target.setColumn(new JaxbColumnImpl());
        this.transferColumn(identifierProperty.getColumns().get(0), (TargetColumnAdapter)new TargetColumnAdapterJaxbColumn(target.getColumn(), ColumnDefaultsInsertableNonUpdateableImpl.INSTANCE));
    }

    private void transferEmbeddedId(JaxbHbmCompositeIdType hbmCompositeId, JaxbEmbeddedIdImpl jaxbEmbeddedId, EntityTypeInfo bootEntityInfo, Property identifierProperty) {
        JaxbEmbeddableImpl jaxbEmbeddable = this.transformEmbeddedIdEmbeddable(hbmCompositeId, bootEntityInfo, identifierProperty);
        jaxbEmbeddedId.setName(identifierProperty.getName());
        this.transferAccess(hbmCompositeId.getAccess(), jaxbEmbeddedId::setAccess, jaxbEmbeddedId::setAttributeAccessor);
        jaxbEmbeddedId.setTarget(jaxbEmbeddable.getName());
    }

    private void transferAccess(String hbmAccess, Consumer<AccessType> accessTypeConsumer, Consumer<String> propertyAccessConsumer) {
        if (AccessType.PROPERTY.name().equalsIgnoreCase(hbmAccess)) {
            accessTypeConsumer.accept(AccessType.PROPERTY);
        } else if (AccessType.FIELD.name().equals(hbmAccess)) {
            accessTypeConsumer.accept(AccessType.FIELD);
        } else if (propertyAccessConsumer != null) {
            propertyAccessConsumer.accept(hbmAccess);
        }
    }

    private JaxbEmbeddableImpl transformEmbeddedIdEmbeddable(JaxbHbmCompositeIdType hbmCompositeId, EntityTypeInfo bootEntityInfo, Property idProperty) {
        JaxbEmbeddableImpl existing;
        String embeddableClassName = hbmCompositeId.getClazz();
        if (StringHelper.isNotEmpty(embeddableClassName) && (existing = this.jaxbEmbeddableByClassName.get(embeddableClassName)) != null) {
            return existing;
        }
        String role = bootEntityInfo.getPersistentClass().getEntityName() + "." + hbmCompositeId.getName();
        String embeddableName = this.determineEmbeddableName(embeddableClassName, hbmCompositeId.getName());
        ComponentTypeInfo componentTypeInfo = this.transformationState.getEmbeddableInfoByRole().get(role);
        JaxbEmbeddableImpl created = this.transferEmbeddedIdEmbeddable(role, embeddableName, embeddableClassName, componentTypeInfo, hbmCompositeId);
        this.mappingXmlBinding.getRoot().getEmbeddables().add(created);
        return created;
    }

    private JaxbEmbeddableImpl transferEmbeddedIdEmbeddable(String role, String embeddableName, String embeddableClassName, ComponentTypeInfo componentTypeInfo, JaxbHbmCompositeIdType hbmCompositeId) {
        JaxbEmbeddableImpl jaxbEmbeddable = new JaxbEmbeddableImpl();
        jaxbEmbeddable.setName(embeddableName);
        jaxbEmbeddable.setClazz(embeddableClassName);
        jaxbEmbeddable.setMetadataComplete(true);
        this.transferAccess(hbmCompositeId.getAccess(), jaxbEmbeddable::setAccess, null);
        if (jaxbEmbeddable.getAttributes() == null) {
            jaxbEmbeddable.setAttributes(new JaxbEmbeddableAttributesContainerImpl());
        }
        hbmCompositeId.getKeyPropertyOrKeyManyToOne().forEach(hbmIdProperty -> {
            if (hbmIdProperty instanceof JaxbHbmCompositeKeyBasicAttributeType) {
                JaxbHbmCompositeKeyBasicAttributeType hbmKeyProperty = (JaxbHbmCompositeKeyBasicAttributeType)hbmIdProperty;
                PropertyInfo keyPropertyInfo = componentTypeInfo.propertyInfoMap().get(hbmKeyProperty.getName());
                jaxbEmbeddable.getAttributes().getBasicAttributes().add(this.transformCompositeKeyProperty(hbmKeyProperty, keyPropertyInfo));
            } else if (hbmIdProperty instanceof JaxbHbmCompositeKeyManyToOneType) {
                JaxbHbmCompositeKeyManyToOneType hbmKeyManyToOne = (JaxbHbmCompositeKeyManyToOneType)hbmIdProperty;
                PropertyInfo keyPropertyInfo = componentTypeInfo.propertyInfoMap().get(hbmKeyManyToOne.getName());
                jaxbEmbeddable.getAttributes().getManyToOneAttributes().add(this.transformCompositeKeyManyToOne(hbmKeyManyToOne, keyPropertyInfo));
            } else {
                throw new AssertionFailure("Unexpected");
            }
        });
        return jaxbEmbeddable;
    }

    private JaxbBasicImpl transformCompositeKeyProperty(final JaxbHbmCompositeKeyBasicAttributeType hbmKeyProperty, PropertyInfo keyPropertyInfo) {
        final JaxbBasicImpl jaxbBasic = new JaxbBasicImpl();
        jaxbBasic.setName(hbmKeyProperty.getName());
        jaxbBasic.setOptional(false);
        jaxbBasic.setFetch(FetchType.EAGER);
        this.transferAccess(hbmKeyProperty.getAccess(), jaxbBasic::setAccess, jaxbBasic::setAttributeAccessor);
        this.applyBasicTypeMapping((BasicValue)keyPropertyInfo.bootModelProperty().getValue(), jaxbBasic, hbmKeyProperty.getTypeAttribute(), hbmKeyProperty.getType(), jaxbBasic::setEnumerated, basicValueConverter -> {
            if (basicValueConverter instanceof JpaAttributeConverter) {
                JpaAttributeConverter jpaAttributeConverter = (JpaAttributeConverter)basicValueConverter;
                JaxbConvertImpl jaxbConvert = new JaxbConvertImpl();
                jaxbConvert.setConverter(jpaAttributeConverter.getConverterJavaType().getTypeName());
                jaxbBasic.setConvert(jaxbConvert);
            }
        });
        this.transferColumnsAndFormulas(new ColumnAndFormulaSource(){

            @Override
            public String getColumnAttribute() {
                return hbmKeyProperty.getColumnAttribute();
            }

            @Override
            public String getFormulaAttribute() {
                return null;
            }

            @Override
            public List<Serializable> getColumnOrFormula() {
                return Collections.emptyList();
            }

            @Override
            public SourceColumnAdapter wrap(Serializable column) {
                return new SourceColumnAdapterJaxbHbmColumnType((JaxbHbmColumnType)column);
            }
        }, new ColumnAndFormulaTarget(){

            @Override
            public TargetColumnAdapter makeColumnAdapter(ColumnDefaults columnDefaults) {
                return new TargetColumnAdapterJaxbColumn(columnDefaults);
            }

            @Override
            public void addColumn(TargetColumnAdapter column) {
                jaxbBasic.setColumn(((TargetColumnAdapterJaxbColumn)column).getTargetColumn());
            }

            @Override
            public void addFormula(String formula) {
                jaxbBasic.setFormula(formula);
            }
        }, new ColumnDefaults(){

            @Override
            public Boolean isNullable() {
                return false;
            }

            @Override
            public Integer getLength() {
                return hbmKeyProperty.getLength();
            }

            @Override
            public Integer getScale() {
                return null;
            }

            @Override
            public Integer getPrecision() {
                return null;
            }

            @Override
            public Boolean isUnique() {
                return false;
            }

            @Override
            public Boolean isInsertable() {
                return true;
            }

            @Override
            public Boolean isUpdateable() {
                return true;
            }
        }, null);
        return jaxbBasic;
    }

    private JaxbManyToOneImpl transformCompositeKeyManyToOne(final JaxbHbmCompositeKeyManyToOneType hbmKeyManyToOne, PropertyInfo keyManyToOneInfo) {
        final JaxbManyToOneImpl jaxbKyManyToOne = new JaxbManyToOneImpl();
        jaxbKyManyToOne.setName(hbmKeyManyToOne.getName());
        if (StringHelper.isNotEmpty(hbmKeyManyToOne.getEntityName())) {
            jaxbKyManyToOne.setTargetEntity(hbmKeyManyToOne.getEntityName());
        } else {
            jaxbKyManyToOne.setTargetEntity(hbmKeyManyToOne.getClazz());
        }
        jaxbKyManyToOne.setOptional(false);
        jaxbKyManyToOne.setFetch(FetchType.EAGER);
        jaxbKyManyToOne.setFetchMode(JaxbSingularFetchModeImpl.SELECT);
        jaxbKyManyToOne.setNotFound(NotFoundAction.EXCEPTION);
        this.transferAccess(hbmKeyManyToOne.getAccess(), jaxbKyManyToOne::setAccess, jaxbKyManyToOne::setAttributeAccessor);
        this.transferColumnsAndFormulas(new ColumnAndFormulaSource(){

            @Override
            public String getColumnAttribute() {
                return hbmKeyManyToOne.getColumnAttribute();
            }

            @Override
            public String getFormulaAttribute() {
                return null;
            }

            @Override
            public List<Serializable> getColumnOrFormula() {
                return Collections.emptyList();
            }

            @Override
            public SourceColumnAdapter wrap(Serializable column) {
                return new SourceColumnAdapterJaxbHbmColumnType((JaxbHbmColumnType)column);
            }
        }, new ColumnAndFormulaTarget(){

            @Override
            public TargetColumnAdapter makeColumnAdapter(ColumnDefaults columnDefaults) {
                return new TargetColumnAdapterJaxbJoinColumn(columnDefaults);
            }

            @Override
            public void addColumn(TargetColumnAdapter column) {
                jaxbKyManyToOne.getJoinColumnOrJoinFormula().add(((TargetColumnAdapterJaxbJoinColumn)column).getTargetColumn());
            }

            @Override
            public void addFormula(String formula) {
                jaxbKyManyToOne.getJoinColumnOrJoinFormula().add((Serializable)((Object)formula));
            }
        }, (ColumnDefaults)ColumnDefaultsBasicImpl.INSTANCE, null);
        jaxbKyManyToOne.setForeignKey(this.transformForeignKey(hbmKeyManyToOne.getForeignKey()));
        return jaxbKyManyToOne;
    }

    private JaxbForeignKeyImpl transformForeignKey(String hbmForeignKeyName) {
        if (StringHelper.isEmpty(hbmForeignKeyName)) {
            return null;
        }
        JaxbForeignKeyImpl jaxbForeignKey = new JaxbForeignKeyImpl();
        if ("none".equalsIgnoreCase(hbmForeignKeyName)) {
            jaxbForeignKey.setConstraintMode(ConstraintMode.NO_CONSTRAINT);
        } else {
            jaxbForeignKey.setName(hbmForeignKeyName);
        }
        return jaxbForeignKey;
    }

    private void transferNonAggregatedCompositeId(JaxbHbmRootEntityType hbmEntity, JaxbEntityImpl mappingXmlEntity, EntityTypeInfo bootEntityInfo, RootClass rootClass) {
        JaxbHbmCompositeIdType hbmCompositeId = hbmEntity.getCompositeId();
        Component idClassMapping = rootClass.getIdentifierMapper();
        if (idClassMapping != null) {
            this.transferIdClass(hbmCompositeId, idClassMapping, mappingXmlEntity);
        }
        String idRole = rootClass.getEntityName() + ".id";
        ComponentTypeInfo componentTypeInfo = this.transformationState.getEmbeddableInfoByRole().get(idRole);
        assert (componentTypeInfo != null);
        hbmCompositeId.getKeyPropertyOrKeyManyToOne().forEach(hbmIdProperty -> {
            if (hbmIdProperty instanceof JaxbHbmCompositeKeyBasicAttributeType) {
                JaxbHbmCompositeKeyBasicAttributeType hbmKeyProperty = (JaxbHbmCompositeKeyBasicAttributeType)hbmIdProperty;
                PropertyInfo keyPropertyInfo = componentTypeInfo.propertyInfoMap().get(hbmKeyProperty.getName());
                mappingXmlEntity.getAttributes().getIdAttributes().add(this.transformNonAggregatedKeyProperty(hbmKeyProperty, keyPropertyInfo));
            } else if (hbmIdProperty instanceof JaxbHbmCompositeKeyManyToOneType) {
                JaxbHbmCompositeKeyManyToOneType hbmKeyManyToOne = (JaxbHbmCompositeKeyManyToOneType)hbmIdProperty;
                this.handleUnsupported("Transformation of <key-many-to-one/> not supported", new Object[0]);
            } else {
                throw new AssertionFailure("Unexpected non-aggregated composite id property kind : " + hbmIdProperty);
            }
        });
    }

    private void transferIdClass(JaxbHbmCompositeIdType hbmCompositeId, Component idClassMapping, JaxbEntityImpl mappingXmlEntity) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    private JaxbIdImpl transformNonAggregatedKeyProperty(final JaxbHbmCompositeKeyBasicAttributeType hbmIdProperty, PropertyInfo idPropertyInfo) {
        final JaxbIdImpl jaxbBasic = new JaxbIdImpl();
        jaxbBasic.setName(hbmIdProperty.getName());
        this.transferAccess(hbmIdProperty.getAccess(), jaxbBasic::setAccess, jaxbBasic::setAttributeAccessor);
        this.applyBasicTypeMapping((BasicValue)idPropertyInfo.bootModelProperty().getValue(), jaxbBasic, hbmIdProperty.getTypeAttribute(), hbmIdProperty.getType(), null, basicValueConverter -> {
            throw new UnsupportedOperationException("Conversion of id attributes not supported");
        });
        this.transferColumnsAndFormulas(new ColumnAndFormulaSource(){

            @Override
            public String getColumnAttribute() {
                return hbmIdProperty.getColumnAttribute();
            }

            @Override
            public String getFormulaAttribute() {
                return null;
            }

            @Override
            public List<Serializable> getColumnOrFormula() {
                return hbmIdProperty.getColumn();
            }

            @Override
            public SourceColumnAdapter wrap(Serializable column) {
                return new SourceColumnAdapterJaxbHbmColumnType((JaxbHbmColumnType)column);
            }
        }, new ColumnAndFormulaTarget(){

            @Override
            public TargetColumnAdapter makeColumnAdapter(ColumnDefaults columnDefaults) {
                return new TargetColumnAdapterJaxbColumn(columnDefaults);
            }

            @Override
            public void addColumn(TargetColumnAdapter column) {
                jaxbBasic.setColumn(((TargetColumnAdapterJaxbColumn)column).getTargetColumn());
            }

            @Override
            public void addFormula(String formula) {
                HbmXmlTransformer.this.handleUnsupported("formula not supported in id mappings", new Object[0]);
            }
        }, new ColumnDefaults(){

            @Override
            public Boolean isNullable() {
                return false;
            }

            @Override
            public Integer getLength() {
                return hbmIdProperty.getLength();
            }

            @Override
            public Integer getScale() {
                return null;
            }

            @Override
            public Integer getPrecision() {
                return null;
            }

            @Override
            public Boolean isUnique() {
                return true;
            }

            @Override
            public Boolean isInsertable() {
                return true;
            }

            @Override
            public Boolean isUpdateable() {
                return true;
            }
        }, null);
        return jaxbBasic;
    }

    private void transferNaturalIdentifiers(JaxbHbmRootEntityType source, JaxbEntityImpl target, EntityTypeInfo bootEntityInfo, RootClass rootClass) {
        if (source.getNaturalId() == null) {
            return;
        }
        final JaxbNaturalIdImpl naturalId = new JaxbNaturalIdImpl();
        this.transferBaseAttributes(rootClass.getEntityName(), source.getNaturalId().getAttributes(), bootEntityInfo, new JaxbAttributesContainer(){

            @Override
            public List<JaxbBasicImpl> getBasicAttributes() {
                return naturalId.getBasicAttributes();
            }

            @Override
            public List<JaxbEmbeddedImpl> getEmbeddedAttributes() {
                return naturalId.getEmbeddedAttributes();
            }

            @Override
            public List<JaxbOneToOneImpl> getOneToOneAttributes() {
                return null;
            }

            @Override
            public List<JaxbManyToOneImpl> getManyToOneAttributes() {
                return naturalId.getManyToOneAttributes();
            }

            @Override
            public List<JaxbAnyMappingImpl> getAnyMappingAttributes() {
                return naturalId.getAnyMappingAttributes();
            }

            @Override
            public List<JaxbElementCollectionImpl> getElementCollectionAttributes() {
                return null;
            }

            @Override
            public List<JaxbOneToManyImpl> getOneToManyAttributes() {
                return null;
            }

            @Override
            public List<JaxbManyToManyImpl> getManyToManyAttributes() {
                return null;
            }

            @Override
            public List<JaxbPluralAnyMappingImpl> getPluralAnyMappingAttributes() {
                return null;
            }

            @Override
            public List<JaxbTransientImpl> getTransients() {
                return null;
            }
        });
        naturalId.setMutable(source.getNaturalId().isMutable());
        target.getAttributes().setNaturalId(naturalId);
    }

    private void transferVersion(JaxbHbmRootEntityType source, JaxbEntityImpl target, EntityTypeInfo bootEntityInfo, RootClass rootClass) {
        JaxbHbmVersionAttributeType hbmVersion = source.getVersion();
        JaxbHbmTimestampAttributeType hbmTimestamp = source.getTimestamp();
        if (hbmVersion != null) {
            JaxbVersionImpl version = new JaxbVersionImpl();
            version.setName(hbmVersion.getName());
            if (StringHelper.isNotEmpty(hbmVersion.getColumnAttribute())) {
                version.setColumn(new JaxbColumnImpl());
                version.getColumn().setName(hbmVersion.getColumnAttribute());
            }
            target.getAttributes().setVersion(version);
        } else if (hbmTimestamp != null) {
            JaxbVersionImpl version = new JaxbVersionImpl();
            version.setName(hbmTimestamp.getName());
            if (StringHelper.isNotEmpty(hbmTimestamp.getColumnAttribute())) {
                version.setColumn(new JaxbColumnImpl());
                version.getColumn().setName(hbmTimestamp.getColumnAttribute());
            }
            version.setTemporal(TemporalType.TIMESTAMP);
            target.getAttributes().setVersion(version);
        }
    }

    private void transferJoins(JaxbHbmRootEntityType hbmEntity, JaxbEntityImpl mappingEntity, EntityTypeInfo bootEntityInfo) {
        for (JaxbHbmSecondaryTableType hbmJoin : hbmEntity.getJoin()) {
            this.transferSecondaryTable(hbmJoin, mappingEntity);
            for (Serializable hbmProperty : hbmJoin.getAttributes()) {
                PropertyInfo propertyInfo;
                if (hbmProperty instanceof JaxbHbmBasicAttributeType) {
                    JaxbHbmBasicAttributeType hbmBasicAttribute = (JaxbHbmBasicAttributeType)hbmProperty;
                    propertyInfo = bootEntityInfo.propertyInfoMap().get(hbmBasicAttribute.getName());
                    JaxbBasicImpl prop = this.transformBasicAttribute(hbmBasicAttribute, propertyInfo);
                    if (prop.getColumn() == null && prop.getFormula() == null) {
                        prop.setColumn(new JaxbColumnImpl());
                        prop.getColumn().setTable(propertyInfo.bootModelProperty().getValue().getTable().getName());
                    }
                    mappingEntity.getAttributes().getBasicAttributes().add(prop);
                    continue;
                }
                if (hbmProperty instanceof JaxbHbmCompositeAttributeType) {
                    JaxbHbmCompositeAttributeType hbmComponent = (JaxbHbmCompositeAttributeType)hbmProperty;
                    String componentRole = bootEntityInfo.getPersistentClass().getEntityName() + "." + hbmComponent.getName();
                    ComponentTypeInfo componentTypeInfo = this.transformationState.getEmbeddableInfoByRole().get(componentRole);
                    JaxbEmbeddableImpl jaxbEmbeddable = this.applyEmbeddable(bootEntityInfo.getPersistentClass().getEntityName(), hbmComponent, componentTypeInfo);
                    mappingEntity.getAttributes().getEmbeddedAttributes().add(this.transformEmbedded(jaxbEmbeddable, hbmComponent));
                    continue;
                }
                if (hbmProperty instanceof JaxbHbmManyToOneType) {
                    JaxbHbmManyToOneType hbmManyToOne = (JaxbHbmManyToOneType)hbmProperty;
                    propertyInfo = bootEntityInfo.propertyInfoMap().get(hbmManyToOne.getName());
                    JaxbManyToOneImpl jaxbManyToOne = this.transformManyToOne(hbmManyToOne, propertyInfo);
                    mappingEntity.getAttributes().getManyToOneAttributes().add(jaxbManyToOne);
                    continue;
                }
                if (hbmProperty instanceof JaxbHbmAnyAssociationType) {
                    throw new MappingException("transformation of <any/> as part of <join/> (secondary-table) not yet implemented", this.origin());
                }
                if (!(hbmProperty instanceof JaxbHbmDynamicComponentType)) continue;
                this.handleUnsupportedContent("<dynamic-component/> mappings not supported");
            }
        }
    }

    private void transferSecondaryTable(JaxbHbmSecondaryTableType hbmJoin, JaxbEntityImpl mappingEntity) {
        JaxbSecondaryTableImpl secondaryTable = new JaxbSecondaryTableImpl();
        secondaryTable.setCatalog(hbmJoin.getCatalog());
        secondaryTable.setComment(hbmJoin.getComment());
        secondaryTable.setName(hbmJoin.getTable());
        secondaryTable.setSchema(hbmJoin.getSchema());
        secondaryTable.setOptional(hbmJoin.isOptional());
        secondaryTable.setOwned(!hbmJoin.isInverse());
        JaxbHbmKeyType key = hbmJoin.getKey();
        if (key != null) {
            JaxbPrimaryKeyJoinColumnImpl joinColumn = new JaxbPrimaryKeyJoinColumnImpl();
            joinColumn.setName(key.getColumnAttribute());
            secondaryTable.getPrimaryKeyJoinColumn().add(joinColumn);
            joinColumn.setForeignKey(this.transformForeignKey(key.getForeignKey()));
        }
        mappingEntity.getSecondaryTables().add(secondaryTable);
    }

    private void transferFetchable(JaxbHbmLazyWithNoProxyEnum hbmLazy, JaxbHbmFetchStyleEnum hbmFetch, JaxbHbmOuterJoinEnum hbmOuterJoin, Boolean constrained, JaxbSingularAssociationAttribute fetchable) {
        FetchType laziness = FetchType.LAZY;
        JaxbSingularFetchModeImpl fetch = JaxbSingularFetchModeImpl.SELECT;
        if (hbmLazy != null) {
            if (hbmLazy.equals((Object)JaxbHbmLazyWithNoProxyEnum.FALSE)) {
                laziness = FetchType.EAGER;
            } else if (hbmLazy.equals((Object)JaxbHbmLazyWithNoProxyEnum.NO_PROXY)) {
                // empty if block
            }
        }
        if (constrained != null && !constrained.booleanValue()) {
            laziness = FetchType.EAGER;
            fetch = JaxbSingularFetchModeImpl.JOIN;
        } else if (hbmFetch == null) {
            if (hbmOuterJoin != null && hbmOuterJoin.equals((Object)JaxbHbmOuterJoinEnum.TRUE)) {
                laziness = FetchType.EAGER;
                fetch = JaxbSingularFetchModeImpl.JOIN;
            }
        } else if (hbmFetch.equals((Object)JaxbHbmFetchStyleEnum.JOIN)) {
            laziness = FetchType.EAGER;
            fetch = JaxbSingularFetchModeImpl.JOIN;
        }
        fetchable.setFetch(laziness);
        fetchable.setFetchMode(fetch);
    }

    private void transferFetchable(JaxbHbmLazyWithExtraEnum hbmLazy, JaxbHbmFetchStyleWithSubselectEnum hbmFetch, JaxbHbmOuterJoinEnum hbmOuterJoin, JaxbPluralAttribute fetchable) {
        FetchType laziness = FetchType.LAZY;
        JaxbPluralFetchModeImpl fetch = JaxbPluralFetchModeImpl.SELECT;
        if (hbmLazy != null) {
            if (hbmLazy.equals((Object)JaxbHbmLazyWithExtraEnum.EXTRA)) {
                throw new MappingException("HBM transformation: extra lazy not yet supported.", this.origin());
            }
            if (hbmLazy.equals((Object)JaxbHbmLazyWithExtraEnum.FALSE)) {
                laziness = FetchType.EAGER;
            }
        }
        if (hbmFetch == null) {
            if (hbmOuterJoin != null && hbmOuterJoin.equals((Object)JaxbHbmOuterJoinEnum.TRUE)) {
                laziness = FetchType.EAGER;
                fetch = JaxbPluralFetchModeImpl.JOIN;
            }
        } else if (hbmFetch.equals((Object)JaxbHbmFetchStyleWithSubselectEnum.JOIN)) {
            laziness = FetchType.EAGER;
            fetch = JaxbPluralFetchModeImpl.JOIN;
        } else if (hbmFetch.equals((Object)JaxbHbmFetchStyleWithSubselectEnum.SUBSELECT)) {
            fetch = JaxbPluralFetchModeImpl.SUBSELECT;
        }
        fetchable.setFetch(laziness);
        fetchable.setFetchMode(fetch);
    }

    private static FetchType convert(JaxbHbmLazyEnum hbmLazy) {
        if (hbmLazy != null && "false".equalsIgnoreCase(hbmLazy.value())) {
            return FetchType.EAGER;
        }
        return FetchType.LAZY;
    }

    private static OnDeleteAction convert(JaxbHbmOnDeleteEnum hbmOnDelete) {
        return hbmOnDelete == JaxbHbmOnDeleteEnum.CASCADE ? OnDeleteAction.CASCADE : OnDeleteAction.NO_ACTION;
    }

    private static JaxbFilterImpl convert(JaxbHbmFilterType hbmFilter) {
        JaxbFilterImpl filter = new JaxbFilterImpl();
        filter.setName(hbmFilter.getName());
        boolean shouldAutoInjectAliases = hbmFilter.getAutoAliasInjection() == null || hbmFilter.getAutoAliasInjection().equalsIgnoreCase("true");
        filter.setAutoAliasInjection(shouldAutoInjectAliases);
        filter.setCondition(hbmFilter.getCondition());
        for (Serializable content : hbmFilter.getContent()) {
            if (content instanceof String) {
                filter.setCondition((String)((Object)content));
                continue;
            }
            JaxbHbmFilterAliasMappingType hbmAliasMapping = (JaxbHbmFilterAliasMappingType)content;
            JaxbFilterImpl.JaxbAliasesImpl aliasMapping = new JaxbFilterImpl.JaxbAliasesImpl();
            aliasMapping.setAlias(hbmAliasMapping.getAlias());
            aliasMapping.setEntity(hbmAliasMapping.getEntity());
            aliasMapping.setTable(hbmAliasMapping.getTable());
            filter.getAliases().add(aliasMapping);
        }
        return filter;
    }

    private static JaxbCascadeTypeImpl convertCascadeType(String s) {
        JaxbCascadeTypeImpl cascadeType = new JaxbCascadeTypeImpl();
        if (StringHelper.isNotEmpty(s)) {
            String[] split;
            s = s.toLowerCase(Locale.ROOT).replaceAll(" ", "");
            for (String hbmCascade : split = StringHelper.split(",", s)) {
                if (hbmCascade.contains("all")) {
                    cascadeType.setCascadeAll(new JaxbEmptyTypeImpl());
                }
                if (hbmCascade.contains("persist")) {
                    cascadeType.setCascadePersist(new JaxbEmptyTypeImpl());
                }
                if (hbmCascade.contains("merge")) {
                    cascadeType.setCascadeMerge(new JaxbEmptyTypeImpl());
                }
                if (hbmCascade.contains("refresh")) {
                    cascadeType.setCascadeRefresh(new JaxbEmptyTypeImpl());
                }
                if (hbmCascade.contains("save-update")) {
                    cascadeType.setCascadeMerge(new JaxbEmptyTypeImpl());
                }
                if (hbmCascade.contains("evict") || hbmCascade.contains("detach")) {
                    cascadeType.setCascadeDetach(new JaxbEmptyTypeImpl());
                }
                if (hbmCascade.contains("replicate")) {
                    cascadeType.setCascadeReplicate(new JaxbEmptyTypeImpl());
                }
                if (hbmCascade.contains("lock")) {
                    cascadeType.setCascadeLock(new JaxbEmptyTypeImpl());
                }
                if (!hbmCascade.contains("delete")) continue;
                cascadeType.setCascadeRemove(new JaxbEmptyTypeImpl());
            }
        }
        return cascadeType;
    }

    private boolean isOrphanRemoval(String s) {
        return StringHelper.isNotEmpty(s) && s.toLowerCase(Locale.ROOT).contains("orphan");
    }

    private String getFullyQualifiedClassName(String className) {
        String defaultPackageName = this.mappingXmlBinding.getRoot().getPackage();
        if (StringHelper.isNotEmpty(className) && className.indexOf(46) < 0 && StringHelper.isNotEmpty(defaultPackageName)) {
            className = StringHelper.qualify(defaultPackageName, className);
        }
        return className;
    }

    private void handleUnsupportedContent(String description) {
        this.handleUnsupported("Transformation of hbm.xml `%s` encountered unsupported content : %s", this.origin().toString(), description);
    }

    private Origin origin() {
        return this.hbmXmlBinding.getOrigin();
    }

    private void handleUnsupported(String message, Object ... messageArgs) {
        this.handleUnsupported(null, message, messageArgs);
    }

    private void handleUnsupported(PickHandler pickHandler, String message, Object ... messageArgs) {
        switch (this.unsupportedFeatureHandling) {
            case ERROR: {
                throw new UnsupportedOperationException(String.format(Locale.ROOT, message, messageArgs) + " (" + this.origin().getName() + " [" + this.origin().getType() + "])");
            }
            case PICK: {
                if (pickHandler == null) break;
                pickHandler.handlePick(message, messageArgs);
                break;
            }
            case IGNORE: {
                HbmTransformationLogging.TRANSFORMATION_LOGGER.debugf(message, messageArgs);
                break;
            }
            case WARN: {
                HbmTransformationLogging.TRANSFORMATION_LOGGER.warnf(message, messageArgs);
            }
        }
    }

    @FunctionalInterface
    private static interface PickHandler {
        public void handlePick(String var1, Object ... var2);
    }
}

