/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.Table;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.AnnotationException;
import org.hibernate.MappingException;
import org.hibernate.annotations.CollectionTypeRegistration;
import org.hibernate.annotations.CompositeTypeRegistration;
import org.hibernate.annotations.ConverterRegistration;
import org.hibernate.annotations.EmbeddableInstantiatorRegistration;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.FetchProfile;
import org.hibernate.annotations.Imported;
import org.hibernate.annotations.JavaTypeRegistration;
import org.hibernate.annotations.JdbcTypeRegistration;
import org.hibernate.annotations.TypeRegistration;
import org.hibernate.boot.model.IdentifierGeneratorDefinition;
import org.hibernate.boot.model.convert.spi.RegisteredConversion;
import org.hibernate.boot.model.internal.AnnotatedClassType;
import org.hibernate.boot.model.internal.EntityBinder;
import org.hibernate.boot.model.internal.FetchOverrideSecondPass;
import org.hibernate.boot.model.internal.FilterDefBinder;
import org.hibernate.boot.model.internal.GeneratorBinder;
import org.hibernate.boot.model.internal.GeneratorParameters;
import org.hibernate.boot.model.internal.InheritanceState;
import org.hibernate.boot.model.internal.QueryBinder;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.spi.GlobalRegistrations;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.MetadataSource;
import org.hibernate.models.spi.AnnotationTarget;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.hibernate.resource.beans.internal.FallbackBeanInstanceProducer;
import org.hibernate.resource.beans.spi.ManagedBeanRegistry;
import org.hibernate.type.descriptor.java.BasicJavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public final class AnnotationBinder {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(AnnotationBinder.class);

    private AnnotationBinder() {
    }

    public static void bindDefaults(MetadataBuildingContext context) {
        GlobalRegistrations globalRegistrations = context.getMetadataCollector().getGlobalRegistrations();
        globalRegistrations.getSequenceGeneratorRegistrations().forEach((name, generatorRegistration) -> {
            IdentifierGeneratorDefinition.Builder definitionBuilder = new IdentifierGeneratorDefinition.Builder();
            GeneratorParameters.interpretSequenceGenerator(generatorRegistration.configuration(), definitionBuilder);
            IdentifierGeneratorDefinition idGenDef = definitionBuilder.build();
            if (LOG.isTraceEnabled()) {
                LOG.tracef("Adding global sequence generator with name: %s", name);
            }
            context.getMetadataCollector().addDefaultIdentifierGenerator(idGenDef);
        });
        globalRegistrations.getTableGeneratorRegistrations().forEach((name, generatorRegistration) -> {
            IdentifierGeneratorDefinition.Builder definitionBuilder = new IdentifierGeneratorDefinition.Builder();
            GeneratorParameters.interpretTableGenerator(generatorRegistration.configuration(), definitionBuilder);
            IdentifierGeneratorDefinition idGenDef = definitionBuilder.build();
            if (LOG.isTraceEnabled()) {
                LOG.tracef("Adding global table generator with name: %s", name);
            }
            context.getMetadataCollector().addDefaultIdentifierGenerator(idGenDef);
        });
        globalRegistrations.getSqlResultSetMappingRegistrations().forEach((name, mappingRegistration) -> QueryBinder.bindSqlResultSetMapping(mappingRegistration.configuration(), context, true));
        globalRegistrations.getNamedQueryRegistrations().forEach((name, queryRegistration) -> QueryBinder.bindQuery(queryRegistration.configuration(), context, true, null));
        globalRegistrations.getNamedNativeQueryRegistrations().forEach((name, queryRegistration) -> QueryBinder.bindNativeQuery(queryRegistration.configuration(), context, null, true));
        globalRegistrations.getNamedStoredProcedureQueryRegistrations().forEach((name, queryRegistration) -> QueryBinder.bindNamedStoredProcedureQuery(queryRegistration.configuration(), context, true));
    }

    private static SourceModelBuildingContext sourceContext(MetadataBuildingContext context) {
        return context.getMetadataCollector().getSourceModelBuildingContext();
    }

    public static void bindPackage(ClassLoaderService cls, String packageName, MetadataBuildingContext context) {
        Package pack = cls.packageForNameOrNull(packageName);
        if (pack == null) {
            return;
        }
        ClassDetails packageInfoClassDetails = AnnotationBinder.sourceContext(context).getClassDetailsRegistry().resolveClassDetails(pack.getName() + ".package-info");
        GeneratorBinder.registerGlobalGenerators((AnnotationTarget)packageInfoClassDetails, context);
        AnnotationBinder.bindTypeDescriptorRegistrations((AnnotationTarget)packageInfoClassDetails, context);
        AnnotationBinder.bindEmbeddableInstantiatorRegistrations((AnnotationTarget)packageInfoClassDetails, context);
        AnnotationBinder.bindUserTypeRegistrations((AnnotationTarget)packageInfoClassDetails, context);
        AnnotationBinder.bindCompositeUserTypeRegistrations((AnnotationTarget)packageInfoClassDetails, context);
        AnnotationBinder.bindConverterRegistrations((AnnotationTarget)packageInfoClassDetails, context);
        AnnotationBinder.bindQueries((AnnotationTarget)packageInfoClassDetails, context);
        FilterDefBinder.bindFilterDefs((AnnotationTarget)packageInfoClassDetails, context);
    }

    public static void bindQueries(AnnotationTarget annotationTarget, MetadataBuildingContext context) {
        AnnotationBinder.bindNamedJpaQueries(annotationTarget, context);
        AnnotationBinder.bindNamedHibernateQueries(annotationTarget, context);
    }

    private static void bindNamedHibernateQueries(AnnotationTarget annotationTarget, MetadataBuildingContext context) {
        SourceModelBuildingContext sourceModelContext = AnnotationBinder.sourceContext(context);
        annotationTarget.forEachRepeatedAnnotationUsages(HibernateAnnotations.NAMED_QUERY, sourceModelContext, usage -> QueryBinder.bindQuery(usage, context, annotationTarget));
        annotationTarget.forEachRepeatedAnnotationUsages(HibernateAnnotations.NAMED_NATIVE_QUERY, sourceModelContext, usage -> QueryBinder.bindNativeQuery(usage, context, annotationTarget));
    }

    private static void bindNamedJpaQueries(AnnotationTarget annotationTarget, MetadataBuildingContext context) {
        SourceModelBuildingContext sourceModelContext = AnnotationBinder.sourceContext(context);
        annotationTarget.forEachRepeatedAnnotationUsages(JpaAnnotations.SQL_RESULT_SET_MAPPING, sourceModelContext, usage -> QueryBinder.bindSqlResultSetMapping(usage, context, false));
        annotationTarget.forEachRepeatedAnnotationUsages(JpaAnnotations.NAMED_QUERY, sourceModelContext, usage -> QueryBinder.bindQuery(usage, context, false, annotationTarget));
        annotationTarget.forEachRepeatedAnnotationUsages(JpaAnnotations.NAMED_NATIVE_QUERY, sourceModelContext, usage -> QueryBinder.bindNativeQuery(usage, context, annotationTarget, false));
        annotationTarget.forEachRepeatedAnnotationUsages(JpaAnnotations.NAMED_STORED_PROCEDURE_QUERY, sourceModelContext, usage -> QueryBinder.bindNamedStoredProcedureQuery(usage, context, false));
    }

    public static void bindClass(ClassDetails classDetails, Map<ClassDetails, InheritanceState> inheritanceStatePerClass, MetadataBuildingContext context) throws MappingException {
        AnnotationBinder.detectMappedSuperclassProblems(classDetails);
        AnnotationBinder.bindQueries((AnnotationTarget)classDetails, context);
        AnnotationBinder.handleImport(classDetails, context);
        AnnotationBinder.bindTypeDescriptorRegistrations((AnnotationTarget)classDetails, context);
        AnnotationBinder.bindEmbeddableInstantiatorRegistrations((AnnotationTarget)classDetails, context);
        AnnotationBinder.bindUserTypeRegistrations((AnnotationTarget)classDetails, context);
        AnnotationBinder.bindCompositeUserTypeRegistrations((AnnotationTarget)classDetails, context);
        AnnotationBinder.bindConverterRegistrations((AnnotationTarget)classDetails, context);
        if (context.getMetadataCollector().getClassType(classDetails) == AnnotatedClassType.ENTITY) {
            EntityBinder.bindEntityClass(classDetails, inheritanceStatePerClass, context);
        }
    }

    private static void handleImport(ClassDetails annotatedClass, MetadataBuildingContext context) {
        if (annotatedClass.hasDirectAnnotationUsage(Imported.class)) {
            String qualifiedName = annotatedClass.getName();
            String name = StringHelper.unqualify(qualifiedName);
            String rename = ((Imported)annotatedClass.getDirectAnnotationUsage(Imported.class)).rename();
            context.getMetadataCollector().addImport(rename.isBlank() ? name : rename, qualifiedName);
        }
    }

    private static void detectMappedSuperclassProblems(ClassDetails annotatedClass) {
        if (annotatedClass.hasDirectAnnotationUsage(MappedSuperclass.class)) {
            if (annotatedClass.hasDirectAnnotationUsage(Entity.class)) {
                throw new AnnotationException("Type '" + annotatedClass.getName() + "' is annotated both '@Entity' and '@MappedSuperclass'");
            }
            if (annotatedClass.hasDirectAnnotationUsage(Table.class)) {
                throw new AnnotationException("Mapped superclass '" + annotatedClass.getName() + "' may not specify a '@Table'");
            }
            if (annotatedClass.hasDirectAnnotationUsage(Inheritance.class)) {
                throw new AnnotationException("Mapped superclass '" + annotatedClass.getName() + "' may not specify an '@Inheritance' mapping strategy");
            }
        }
    }

    private static void bindTypeDescriptorRegistrations(AnnotationTarget annotatedElement, MetadataBuildingContext context) {
        ManagedBeanRegistry managedBeanRegistry = context.getBootstrapContext().getServiceRegistry().getService(ManagedBeanRegistry.class);
        SourceModelBuildingContext sourceModelContext = AnnotationBinder.sourceContext(context);
        annotatedElement.forEachAnnotationUsage(JavaTypeRegistration.class, sourceModelContext, usage -> AnnotationBinder.handleJavaTypeRegistration(context, managedBeanRegistry, usage));
        annotatedElement.forEachAnnotationUsage(JdbcTypeRegistration.class, sourceModelContext, usage -> AnnotationBinder.handleJdbcTypeRegistration(context, managedBeanRegistry, usage));
        annotatedElement.forEachAnnotationUsage(CollectionTypeRegistration.class, sourceModelContext, usage -> context.getMetadataCollector().addCollectionTypeRegistration((CollectionTypeRegistration)usage));
    }

    private static void handleJdbcTypeRegistration(MetadataBuildingContext context, ManagedBeanRegistry managedBeanRegistry, JdbcTypeRegistration annotation) {
        Class<? extends JdbcType> jdbcTypeClass = annotation.value();
        JdbcType jdbcType = !context.getBuildingOptions().isAllowExtensionsInCdi() ? FallbackBeanInstanceProducer.INSTANCE.produceBeanInstance(jdbcTypeClass) : managedBeanRegistry.getBean(jdbcTypeClass).getBeanInstance();
        int registrationCode = annotation.registrationCode();
        int typeCode = registrationCode == Integer.MIN_VALUE ? jdbcType.getDefaultSqlTypeCode() : registrationCode;
        context.getMetadataCollector().addJdbcTypeRegistration(typeCode, jdbcType);
    }

    private static void handleJavaTypeRegistration(MetadataBuildingContext context, ManagedBeanRegistry managedBeanRegistry, JavaTypeRegistration annotation) {
        Class<? extends BasicJavaType<?>> javaTypeClass = annotation.descriptorClass();
        BasicJavaType<?> javaType = !context.getBuildingOptions().isAllowExtensionsInCdi() ? FallbackBeanInstanceProducer.INSTANCE.produceBeanInstance(javaTypeClass) : managedBeanRegistry.getBean(javaTypeClass).getBeanInstance();
        context.getMetadataCollector().addJavaTypeRegistration(annotation.javaType(), javaType);
    }

    private static void bindEmbeddableInstantiatorRegistrations(AnnotationTarget annotatedElement, MetadataBuildingContext context) {
        annotatedElement.forEachAnnotationUsage(EmbeddableInstantiatorRegistration.class, AnnotationBinder.sourceContext(context), usage -> AnnotationBinder.handleEmbeddableInstantiatorRegistration(context, usage));
    }

    private static void handleEmbeddableInstantiatorRegistration(MetadataBuildingContext context, EmbeddableInstantiatorRegistration annotation) {
        context.getMetadataCollector().registerEmbeddableInstantiator(annotation.embeddableClass(), annotation.instantiator());
    }

    private static void bindCompositeUserTypeRegistrations(AnnotationTarget annotatedElement, MetadataBuildingContext context) {
        annotatedElement.forEachAnnotationUsage(CompositeTypeRegistration.class, AnnotationBinder.sourceContext(context), usage -> AnnotationBinder.handleCompositeUserTypeRegistration(context, usage));
    }

    private static void bindUserTypeRegistrations(AnnotationTarget annotatedElement, MetadataBuildingContext context) {
        annotatedElement.forEachAnnotationUsage(TypeRegistration.class, AnnotationBinder.sourceContext(context), usage -> AnnotationBinder.handleUserTypeRegistration(context, usage));
    }

    private static void handleUserTypeRegistration(MetadataBuildingContext context, TypeRegistration compositeTypeRegistration) {
        context.getMetadataCollector().registerUserType(compositeTypeRegistration.basicClass(), compositeTypeRegistration.userType());
    }

    private static void handleCompositeUserTypeRegistration(MetadataBuildingContext context, CompositeTypeRegistration compositeTypeRegistration) {
        context.getMetadataCollector().registerCompositeUserType(compositeTypeRegistration.embeddableClass(), compositeTypeRegistration.userType());
    }

    private static void bindConverterRegistrations(AnnotationTarget container, MetadataBuildingContext context) {
        SourceModelBuildingContext sourceModelContext = AnnotationBinder.sourceContext(context);
        container.forEachAnnotationUsage(ConverterRegistration.class, sourceModelContext, usage -> AnnotationBinder.handleConverterRegistration(usage, context));
    }

    private static void handleConverterRegistration(ConverterRegistration registration, MetadataBuildingContext context) {
        context.getMetadataCollector().getConverterRegistry().addRegisteredConversion(new RegisteredConversion(registration.domainType(), registration.converter(), registration.autoApply(), context));
    }

    public static void bindFetchProfilesForClass(AnnotationTarget annotatedClass, MetadataBuildingContext context) {
        AnnotationBinder.bindFetchProfiles(annotatedClass, context);
    }

    public static void bindFetchProfilesForPackage(ClassLoaderService cls, String packageName, MetadataBuildingContext context) {
        ClassDetails packageInfoClassDetails = context.getMetadataCollector().getClassDetailsRegistry().findClassDetails(packageName + ".package-info");
        if (packageInfoClassDetails != null) {
            AnnotationBinder.bindFetchProfiles((AnnotationTarget)packageInfoClassDetails, context);
        }
    }

    private static void bindFetchProfiles(AnnotationTarget annotatedElement, MetadataBuildingContext context) {
        annotatedElement.forEachAnnotationUsage(FetchProfile.class, AnnotationBinder.sourceContext(context), usage -> AnnotationBinder.bindFetchProfile(usage, context));
    }

    private static void bindFetchProfile(FetchProfile fetchProfile, MetadataBuildingContext context) {
        String name = fetchProfile.name();
        if (AnnotationBinder.reuseOrCreateFetchProfile(context, name)) {
            FetchProfile.FetchOverride[] fetchOverrides;
            for (FetchProfile.FetchOverride fetchOverride : fetchOverrides = fetchProfile.fetchOverrides()) {
                FetchType type = fetchOverride.fetch();
                FetchMode mode = fetchOverride.mode();
                if (type == FetchType.LAZY && mode == FetchMode.JOIN) {
                    throw new AnnotationException("Fetch profile '" + name + "' has a '@FetchOverride' with 'fetch=LAZY' and 'mode=JOIN' (join fetching is eager by nature)");
                }
                context.getMetadataCollector().addSecondPass(new FetchOverrideSecondPass(name, fetchOverride, context));
            }
        }
    }

    private static boolean reuseOrCreateFetchProfile(MetadataBuildingContext context, String name) {
        org.hibernate.mapping.FetchProfile existing = context.getMetadataCollector().getFetchProfile(name);
        if (existing == null) {
            org.hibernate.mapping.FetchProfile profile = new org.hibernate.mapping.FetchProfile(name, MetadataSource.ANNOTATIONS);
            context.getMetadataCollector().addFetchProfile(profile);
            return true;
        }
        return existing.getSource() == MetadataSource.ANNOTATIONS;
    }

    public static Map<ClassDetails, InheritanceState> buildInheritanceStates(List<ClassDetails> orderedClasses, MetadataBuildingContext buildingContext) {
        HashMap<ClassDetails, InheritanceState> inheritanceStatePerClass = new HashMap<ClassDetails, InheritanceState>(orderedClasses.size());
        for (ClassDetails clazz : orderedClasses) {
            InheritanceState superclassState = InheritanceState.getSuperclassInheritanceState(clazz, inheritanceStatePerClass);
            InheritanceState state = new InheritanceState(clazz, inheritanceStatePerClass, buildingContext);
            AnnotatedClassType classType = buildingContext.getMetadataCollector().getClassType(clazz);
            if (classType == AnnotatedClassType.EMBEDDABLE && !clazz.hasDirectAnnotationUsage(Imported.class)) {
                String className = clazz.getName();
                buildingContext.getMetadataCollector().addImport(StringHelper.unqualify(className), className);
            }
            if (superclassState != null) {
                superclassState.setHasSiblings(true);
                InheritanceState superEntityState = InheritanceState.getInheritanceStateOfSuperEntity(clazz, inheritanceStatePerClass);
                if (superEntityState != null) {
                    state.setHasParents(true);
                    if (classType == AnnotatedClassType.EMBEDDABLE) {
                        buildingContext.getMetadataCollector().registerEmbeddableSubclass(superEntityState.getClassDetails(), clazz);
                    }
                }
                AnnotationBinder.logMixedInheritance(clazz, superclassState, state);
                if (superclassState.getType() != null) {
                    state.setType(superclassState.getType());
                }
            }
            switch (classType) {
                case ENTITY: 
                case MAPPED_SUPERCLASS: 
                case EMBEDDABLE: {
                    inheritanceStatePerClass.put(clazz, state);
                }
            }
        }
        return inheritanceStatePerClass;
    }

    private static void logMixedInheritance(ClassDetails classDetails, InheritanceState superclassState, InheritanceState state) {
        if (state.getType() != null && superclassState.getType() != null) {
            boolean mixingStrategy;
            boolean nonDefault = InheritanceType.SINGLE_TABLE != state.getType();
            boolean bl = mixingStrategy = state.getType() != superclassState.getType();
            if (nonDefault && mixingStrategy) {
                throw new AnnotationException("Entity '" + classDetails.getName() + "' may not override the inheritance mapping strategy '" + superclassState.getType() + "' of its hierarchy' (each entity hierarchy has a single inheritance mapping strategy)");
            }
        }
    }
}

