/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import org.hibernate.MappingException;
import org.hibernate.boot.spi.SecondPass;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.IndexedCollection;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Value;
import org.jboss.logging.Logger;

public abstract class CollectionSecondPass
implements SecondPass {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger((MethodHandles.Lookup)MethodHandles.lookup(), CoreMessageLogger.class, (String)CollectionSecondPass.class.getName());
    private final Collection collection;

    public CollectionSecondPass(Collection collection) {
        this.collection = collection;
    }

    @Override
    public void doSecondPass(Map<String, PersistentClass> persistentClasses) throws MappingException {
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Second pass for collection: %s", this.collection.getRole());
        }
        this.secondPass(persistentClasses);
        this.collection.createAllKeys();
        if (LOG.isDebugEnabled()) {
            String msg = "Mapped collection key: " + CollectionSecondPass.columns(this.collection.getKey());
            if (this.collection.isIndexed()) {
                msg = msg + ", index: " + CollectionSecondPass.columns(((IndexedCollection)this.collection).getIndex());
            }
            msg = this.collection.isOneToMany() ? msg + ", one-to-many: " + ((OneToMany)this.collection.getElement()).getReferencedEntityName() : msg + ", element: " + CollectionSecondPass.columns(this.collection.getElement());
            LOG.debug(msg);
        }
    }

    public abstract void secondPass(Map<String, PersistentClass> var1) throws MappingException;

    private static String columns(Value val) {
        StringBuilder columns = new StringBuilder();
        for (Selectable selectable : val.getSelectables()) {
            if (!columns.isEmpty()) {
                columns.append(", ");
            }
            columns.append(selectable.getText());
        }
        return columns.toString();
    }
}

