/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MapsId;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.PrimaryKeyJoinColumn;
import org.hibernate.AnnotationException;
import org.hibernate.annotations.Any;
import org.hibernate.annotations.Columns;
import org.hibernate.annotations.Formula;
import org.hibernate.annotations.FractionalSeconds;
import org.hibernate.annotations.JoinColumnOrFormula;
import org.hibernate.annotations.JoinFormula;
import org.hibernate.boot.model.internal.AnnotatedColumn;
import org.hibernate.boot.model.internal.AnnotatedColumns;
import org.hibernate.boot.model.internal.AnnotatedJoinColumns;
import org.hibernate.boot.model.internal.BinderHelper;
import org.hibernate.boot.model.internal.DialectOverridesAnnotationHelper;
import org.hibernate.boot.model.internal.EntityBinder;
import org.hibernate.boot.model.internal.Nullability;
import org.hibernate.boot.model.internal.PropertyHolder;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.annotations.internal.JoinColumnJpaAnnotation;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.PropertyData;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.models.spi.AnnotationTarget;
import org.hibernate.models.spi.MemberDetails;
import org.hibernate.models.spi.SourceModelBuildingContext;

class ColumnsBuilder {
    private final PropertyHolder propertyHolder;
    private final Nullability nullability;
    private final MemberDetails property;
    private final PropertyData inferredData;
    private final EntityBinder entityBinder;
    private final MetadataBuildingContext buildingContext;
    private AnnotatedColumns columns;
    private AnnotatedJoinColumns joinColumns;

    public ColumnsBuilder(PropertyHolder propertyHolder, Nullability nullability, MemberDetails property, PropertyData inferredData, EntityBinder entityBinder, MetadataBuildingContext buildingContext) {
        this.propertyHolder = propertyHolder;
        this.nullability = nullability;
        this.property = property;
        this.inferredData = inferredData;
        this.entityBinder = entityBinder;
        this.buildingContext = buildingContext;
    }

    public AnnotatedColumns getColumns() {
        return this.columns;
    }

    public AnnotatedJoinColumns getJoinColumns() {
        return this.joinColumns;
    }

    public ColumnsBuilder extractMetadata() {
        this.columns = null;
        this.joinColumns = this.buildExplicitJoinColumns(this.property, this.inferredData);
        Column columnAnn = (Column)this.property.getDirectAnnotationUsage(Column.class);
        Columns columnsAnn = (Columns)this.property.getDirectAnnotationUsage(Columns.class);
        Formula formulaAnn = (Formula)this.property.getDirectAnnotationUsage(Formula.class);
        if (columnAnn != null) {
            this.columns = AnnotatedColumn.buildColumnFromAnnotation(columnAnn, (FractionalSeconds)this.property.getDirectAnnotationUsage(FractionalSeconds.class), this.nullability, this.propertyHolder, this.inferredData, this.entityBinder.getSecondaryTables(), this.buildingContext);
        } else if (formulaAnn != null) {
            this.columns = AnnotatedColumn.buildFormulaFromAnnotation(DialectOverridesAnnotationHelper.getOverridableAnnotation((AnnotationTarget)this.property, Formula.class, this.buildingContext), this.nullability, this.propertyHolder, this.inferredData, this.entityBinder.getSecondaryTables(), this.buildingContext);
        } else if (columnsAnn != null) {
            this.columns = AnnotatedColumn.buildColumnsFromAnnotations(columnsAnn.columns(), null, this.nullability, this.propertyHolder, this.inferredData, this.entityBinder.getSecondaryTables(), this.buildingContext);
        }
        if (this.joinColumns == null && (this.property.hasDirectAnnotationUsage(ManyToOne.class) || this.property.hasDirectAnnotationUsage(OneToOne.class))) {
            this.joinColumns = this.buildDefaultJoinColumnsForToOne(this.property, this.inferredData);
        } else if (this.joinColumns == null && (this.property.hasDirectAnnotationUsage(OneToMany.class) || this.property.hasDirectAnnotationUsage(ElementCollection.class))) {
            OneToMany oneToMany = (OneToMany)this.property.getDirectAnnotationUsage(OneToMany.class);
            this.joinColumns = AnnotatedJoinColumns.buildJoinColumns(null, oneToMany == null ? null : StringHelper.nullIfEmpty(oneToMany.mappedBy()), this.entityBinder.getSecondaryTables(), this.propertyHolder, this.inferredData, this.buildingContext);
        } else if (this.joinColumns == null && this.property.hasDirectAnnotationUsage(Any.class)) {
            throw new AnnotationException("Property '" + BinderHelper.getPath(this.propertyHolder, this.inferredData) + "' is annotated '@Any' and must declare at least one '@JoinColumn'");
        }
        if (this.columns == null && !this.property.hasDirectAnnotationUsage(ManyToMany.class)) {
            this.columns = AnnotatedColumn.buildColumnFromNoAnnotation((FractionalSeconds)this.property.getDirectAnnotationUsage(FractionalSeconds.class), this.nullability, this.propertyHolder, this.inferredData, this.entityBinder.getSecondaryTables(), this.buildingContext);
        }
        if (this.nullability == Nullability.FORCED_NOT_NULL) {
            for (AnnotatedColumn column : this.columns.getColumns()) {
                column.forceNotNull();
            }
        }
        return this;
    }

    private AnnotatedJoinColumns buildDefaultJoinColumnsForToOne(MemberDetails property, PropertyData inferredData) {
        JoinTable joinTableAnn = this.propertyHolder.getJoinTable(property);
        if (joinTableAnn != null) {
            return AnnotatedJoinColumns.buildJoinColumns(joinTableAnn.inverseJoinColumns(), null, this.entityBinder.getSecondaryTables(), this.propertyHolder, inferredData, this.buildingContext);
        }
        OneToOne oneToOneAnn = (OneToOne)property.getDirectAnnotationUsage(OneToOne.class);
        return AnnotatedJoinColumns.buildJoinColumns(null, oneToOneAnn == null ? null : StringHelper.nullIfEmpty(oneToOneAnn.mappedBy()), this.entityBinder.getSecondaryTables(), this.propertyHolder, inferredData, this.buildingContext);
    }

    private AnnotatedJoinColumns buildExplicitJoinColumns(MemberDetails property, PropertyData inferredData) {
        JoinColumn[] joinColumnAnnotations = this.getJoinColumnAnnotations(property, inferredData);
        if (joinColumnAnnotations != null) {
            return AnnotatedJoinColumns.buildJoinColumns(joinColumnAnnotations, null, this.entityBinder.getSecondaryTables(), this.propertyHolder, inferredData, this.buildingContext);
        }
        JoinColumnOrFormula[] joinColumnOrFormulaAnnotations = this.joinColumnOrFormulaAnnotations(property, inferredData);
        if (joinColumnOrFormulaAnnotations != null) {
            return AnnotatedJoinColumns.buildJoinColumnsOrFormulas(joinColumnOrFormulaAnnotations, null, this.entityBinder.getSecondaryTables(), this.propertyHolder, inferredData, this.buildingContext);
        }
        if (property.hasDirectAnnotationUsage(JoinFormula.class)) {
            JoinFormula joinFormula = DialectOverridesAnnotationHelper.getOverridableAnnotation((AnnotationTarget)property, JoinFormula.class, this.buildingContext);
            return AnnotatedJoinColumns.buildJoinColumnsWithFormula(joinFormula, this.entityBinder.getSecondaryTables(), this.propertyHolder, inferredData, this.buildingContext);
        }
        return null;
    }

    private JoinColumnOrFormula[] joinColumnOrFormulaAnnotations(MemberDetails property, PropertyData inferredData) {
        SourceModelBuildingContext sourceModelContext = this.buildingContext.getMetadataCollector().getSourceModelBuildingContext();
        Object[] annotations = (JoinColumnOrFormula[])property.getRepeatedAnnotationUsages(HibernateAnnotations.JOIN_COLUMN_OR_FORMULA, sourceModelContext);
        if (CollectionHelper.isNotEmpty(annotations)) {
            return annotations;
        }
        return null;
    }

    private JoinColumn[] getJoinColumnAnnotations(MemberDetails property, PropertyData inferredData) {
        Object[] primaryKeyJoinColumns;
        SourceModelBuildingContext sourceModelContext = this.buildingContext.getMetadataCollector().getSourceModelBuildingContext();
        Object[] joinColumns = (JoinColumn[])property.getRepeatedAnnotationUsages(JpaAnnotations.JOIN_COLUMN, sourceModelContext);
        if (CollectionHelper.isNotEmpty(joinColumns)) {
            return joinColumns;
        }
        if (property.hasDirectAnnotationUsage(MapsId.class) && CollectionHelper.isNotEmpty(primaryKeyJoinColumns = (PrimaryKeyJoinColumn[])property.getRepeatedAnnotationUsages(JpaAnnotations.PRIMARY_KEY_JOIN_COLUMN, sourceModelContext))) {
            JoinColumn[] adapters = new JoinColumn[primaryKeyJoinColumns.length];
            for (int i = 0; i < primaryKeyJoinColumns.length; ++i) {
                Object primaryKeyJoinColumn = primaryKeyJoinColumns[i];
                adapters[i] = JoinColumnJpaAnnotation.toJoinColumn((PrimaryKeyJoinColumn)primaryKeyJoinColumn, sourceModelContext);
            }
            return adapters;
        }
        return null;
    }

    AnnotatedColumns overrideColumnFromMapperOrMapsIdProperty(boolean isId) {
        PropertyData override = BinderHelper.getPropertyOverriddenByMapperOrMapsId(isId, this.propertyHolder, this.property.resolveAttributeName(), this.buildingContext);
        if (override != null) {
            AnnotatedJoinColumns joinColumns = this.buildExplicitJoinColumns(override.getAttributeMember(), override);
            return joinColumns == null ? this.buildDefaultJoinColumnsForToOne(override.getAttributeMember(), override) : joinColumns;
        }
        return this.columns;
    }
}

