/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.hibernate.AnnotationException;
import org.hibernate.MappingException;
import org.hibernate.boot.model.internal.AnnotatedJoinColumn;
import org.hibernate.boot.model.internal.AnnotatedJoinColumns;
import org.hibernate.boot.model.internal.FkSecondPass;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.internal.util.MutableInteger;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.SimpleValue;
import org.jboss.logging.Logger;

public class CopyIdentifierComponentSecondPass
extends FkSecondPass {
    private static final Logger log = Logger.getLogger(CopyIdentifierComponentSecondPass.class);
    private final String referencedEntityName;
    private final String propertyName;
    private final Component component;
    private final MetadataBuildingContext buildingContext;
    private final AnnotatedJoinColumns joinColumns;

    public CopyIdentifierComponentSecondPass(Component comp, String referencedEntityName, String propertyName, AnnotatedJoinColumns joinColumns, MetadataBuildingContext buildingContext) {
        super(comp, joinColumns);
        this.component = comp;
        this.referencedEntityName = referencedEntityName;
        this.propertyName = propertyName;
        this.buildingContext = buildingContext;
        this.joinColumns = joinColumns;
    }

    @Override
    public String getReferencedEntityName() {
        return this.referencedEntityName;
    }

    @Override
    public boolean isInPrimaryKey() {
        return true;
    }

    @Override
    public void doSecondPass(Map<String, PersistentClass> persistentClasses) throws MappingException {
        PersistentClass referencedPersistentClass = persistentClasses.get(this.referencedEntityName);
        Component referencedComponent = this.getReferencedComponent(referencedPersistentClass);
        boolean isExplicitReference = true;
        List<AnnotatedJoinColumn> columns = this.joinColumns.getJoinColumns();
        HashMap<String, AnnotatedJoinColumn> columnByReferencedName = CollectionHelper.mapOfSize(columns.size());
        for (AnnotatedJoinColumn joinColumn : columns) {
            if (joinColumn.isReferenceImplicit()) continue;
            columnByReferencedName.put(joinColumn.getReferencedColumn().toLowerCase(Locale.ROOT), joinColumn);
        }
        if (columnByReferencedName.isEmpty()) {
            isExplicitReference = false;
            for (int i = 0; i < columns.size(); ++i) {
                columnByReferencedName.put(String.valueOf(i), columns.get(i));
            }
        }
        MutableInteger index = new MutableInteger();
        for (Property referencedProperty : referencedComponent.getProperties()) {
            Property property = referencedProperty.isComposite() ? this.createComponentProperty(isExplicitReference, columnByReferencedName, index, referencedProperty) : this.createSimpleProperty(referencedPersistentClass, isExplicitReference, columnByReferencedName, index, referencedProperty);
            this.component.addProperty(property);
        }
    }

    private Component getReferencedComponent(PersistentClass referencedPersistentClass) {
        if (referencedPersistentClass == null) {
            throw new AnnotationException("Unknown entity name '" + this.referencedEntityName + "'");
        }
        KeyValue keyValue = referencedPersistentClass.getIdentifier();
        if (keyValue instanceof Component) {
            Component id = (Component)keyValue;
            return id;
        }
        throw new AnnotationException("Missing 'value' in '@MapsId' annotation of association '" + this.propertyName + "' of entity '" + this.component.getOwner().getEntityName() + "' with composite identifier type ('@MapsId' must specify a property of the '@EmbeddedId' class which has the foreign key of '" + this.referencedEntityName + "')");
    }

    private Property createComponentProperty(boolean isExplicitReference, Map<String, AnnotatedJoinColumn> columnByReferencedName, MutableInteger index, Property referencedProperty) {
        Property property = new Property();
        property.setName(referencedProperty.getName());
        property.setPersistentClass(this.component.getOwner());
        property.setPropertyAccessorName(referencedProperty.getPropertyAccessorName());
        Component value = new Component(this.buildingContext, this.component.getOwner());
        property.setValue(value);
        Component referencedValue = (Component)referencedProperty.getValue();
        value.setTypeName(referencedValue.getTypeName());
        value.setTypeParameters(referencedValue.getTypeParameters());
        value.setComponentClassName(referencedValue.getComponentClassName());
        for (Property referencedComponentProperty : referencedValue.getProperties()) {
            if (referencedComponentProperty.isComposite()) {
                value.addProperty(this.createComponentProperty(isExplicitReference, columnByReferencedName, index, referencedComponentProperty));
                continue;
            }
            value.addProperty(this.createSimpleProperty(referencedValue.getOwner(), isExplicitReference, columnByReferencedName, index, referencedComponentProperty));
        }
        return property;
    }

    private Property createSimpleProperty(PersistentClass referencedPersistentClass, boolean isExplicitReference, Map<String, AnnotatedJoinColumn> columnByReferencedName, MutableInteger index, Property referencedProperty) {
        Property property = new Property();
        property.setName(referencedProperty.getName());
        property.setPersistentClass(this.component.getOwner());
        property.setPropertyAccessorName(referencedProperty.getPropertyAccessorName());
        BasicValue value = new BasicValue(this.buildingContext, this.component.getTable());
        property.setValue(value);
        SimpleValue referencedValue = (SimpleValue)referencedProperty.getValue();
        ((SimpleValue)value).copyTypeFrom(referencedValue);
        AnnotatedJoinColumn firstColumn = this.joinColumns.getJoinColumns().get(0);
        if (firstColumn.isNameDeferred()) {
            firstColumn.copyReferencedStructureAndCreateDefaultJoinColumns(referencedPersistentClass, referencedValue, value);
        } else {
            for (Selectable selectable : referencedValue.getSelectables()) {
                if (selectable instanceof Column) {
                    AnnotatedJoinColumn joinColumn;
                    String logicalColumnName;
                    Column column = (Column)selectable;
                    if (isExplicitReference) {
                        logicalColumnName = column.getName();
                        joinColumn = columnByReferencedName.get(logicalColumnName.toLowerCase(Locale.ROOT));
                    } else {
                        logicalColumnName = null;
                        joinColumn = columnByReferencedName.get(String.valueOf(index.get()));
                        index.getAndIncrement();
                    }
                    if (joinColumn == null && !firstColumn.isNameDeferred()) {
                        throw new AnnotationException("Property '" + this.propertyName + "' of entity '" + this.component.getOwner().getEntityName() + "' must have a '@JoinColumn' which references the foreign key column '" + logicalColumnName + "'");
                    }
                    Object columnName = joinColumn == null || joinColumn.isNameDeferred() ? "tata_" + column.getName() : joinColumn.getName();
                    Database database = this.buildingContext.getMetadataCollector().getDatabase();
                    String physicalName = this.buildingContext.getBuildingOptions().getPhysicalNamingStrategy().toPhysicalColumnName(database.toIdentifier((String)columnName), database.getJdbcEnvironment()).render(database.getDialect());
                    ((SimpleValue)value).addColumn(new Column(physicalName));
                    if (joinColumn != null) {
                        this.applyComponentColumnSizeValueToJoinColumn(column, joinColumn);
                        joinColumn.linkWithValue(value);
                    }
                    column.setValue(value);
                    continue;
                }
                log.debug((Object)"Encountered formula definition; skipping");
            }
        }
        return property;
    }

    private void applyComponentColumnSizeValueToJoinColumn(Column column, AnnotatedJoinColumn joinColumn) {
        Column mappingColumn = joinColumn.getMappingColumn();
        mappingColumn.setLength(column.getLength());
        mappingColumn.setPrecision(column.getPrecision());
        mappingColumn.setScale(column.getScale());
        mappingColumn.setArrayLength(column.getArrayLength());
    }
}

