/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.JoinTable;
import java.util.Map;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.boot.model.internal.AnnotatedJoinColumn;
import org.hibernate.boot.model.internal.AnnotatedJoinColumns;
import org.hibernate.boot.model.internal.PropertyHolder;
import org.hibernate.boot.model.internal.TableBinder;
import org.hibernate.boot.model.internal.ToOneBinder;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.PropertyData;
import org.hibernate.boot.spi.SecondPass;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Table;

public class ImplicitToOneJoinTableSecondPass
implements SecondPass {
    private final PropertyHolder propertyHolder;
    private final PropertyData inferredData;
    private final MetadataBuildingContext context;
    private final AnnotatedJoinColumns joinColumns;
    private final JoinTable joinTable;
    private final NotFoundAction notFoundAction;
    private final ManyToOne value;

    public ImplicitToOneJoinTableSecondPass(PropertyHolder propertyHolder, PropertyData inferredData, MetadataBuildingContext context, AnnotatedJoinColumns joinColumns, JoinTable joinTable, NotFoundAction notFoundAction, ManyToOne value) {
        this.propertyHolder = propertyHolder;
        this.inferredData = inferredData;
        this.context = context;
        this.joinColumns = joinColumns;
        this.joinTable = joinTable;
        this.notFoundAction = notFoundAction;
        this.value = value;
    }

    private void inferJoinTableName(TableBinder tableBinder, Map<String, PersistentClass> persistentClasses) {
        if (StringHelper.isEmpty(tableBinder.getName())) {
            PersistentClass owner = this.propertyHolder.getPersistentClass();
            InFlightMetadataCollector collector = this.context.getMetadataCollector();
            PersistentClass targetEntity = persistentClasses.get(ToOneBinder.getReferenceEntityName(this.inferredData, this.context));
            tableBinder.setDefaultName(owner.getClassName(), owner.getEntityName(), owner.getJpaEntityName(), collector.getLogicalTableName(owner.getTable()), targetEntity != null ? targetEntity.getClassName() : null, targetEntity != null ? targetEntity.getEntityName() : null, targetEntity != null ? targetEntity.getJpaEntityName() : null, targetEntity != null ? collector.getLogicalTableName(targetEntity.getTable()) : null, this.joinColumns.getPropertyName());
        }
    }

    private TableBinder createTableBinder() {
        String tableName;
        String catalog;
        TableBinder tableBinder = new TableBinder();
        tableBinder.setBuildingContext(this.context);
        String schema = this.joinTable.schema();
        if (StringHelper.isNotBlank(schema)) {
            tableBinder.setSchema(schema);
        }
        if (StringHelper.isNotBlank(catalog = this.joinTable.catalog())) {
            tableBinder.setCatalog(catalog);
        }
        if (StringHelper.isNotBlank(tableName = this.joinTable.name())) {
            tableBinder.setName(tableName);
        }
        tableBinder.setUniqueConstraints(this.joinTable.uniqueConstraints());
        tableBinder.setJpaIndex(this.joinTable.indexes());
        tableBinder.setOptions(this.joinTable.options());
        return tableBinder;
    }

    @Override
    public void doSecondPass(Map<String, PersistentClass> persistentClasses) {
        TableBinder tableBinder = this.createTableBinder();
        this.inferJoinTableName(tableBinder, persistentClasses);
        Table table = tableBinder.bind();
        this.value.setTable(table);
        Join join = this.propertyHolder.addJoin(this.joinTable, table, true);
        if (this.notFoundAction != null) {
            join.disableForeignKeyCreation();
        }
        for (AnnotatedJoinColumn joinColumn : this.joinColumns.getJoinColumns()) {
            joinColumn.setExplicitTableName(join.getTable().getName());
        }
    }
}

