/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.Access;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.IdClass;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.MappedSuperclass;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.AnnotationException;
import org.hibernate.boot.model.internal.EntityBinder;
import org.hibernate.boot.model.internal.PropertyBinder;
import org.hibernate.boot.model.internal.PropertyContainer;
import org.hibernate.boot.spi.AccessType;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.PropertyData;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Table;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.FieldDetails;
import org.hibernate.models.spi.MethodDetails;
import org.hibernate.models.spi.TypeVariableScope;

public class InheritanceState {
    private ClassDetails classDetails;
    private boolean hasSiblings = false;
    private boolean hasParents = false;
    private InheritanceType type;
    private boolean isEmbeddableSuperclass = false;
    private final Map<ClassDetails, InheritanceState> inheritanceStatePerClass;
    private final List<ClassDetails> classesToProcessForMappedSuperclass = new ArrayList<ClassDetails>();
    private final MetadataBuildingContext buildingContext;
    private AccessType accessType;
    private ElementsToProcess elementsToProcess;
    private Boolean hasIdClassOrEmbeddedId;

    public InheritanceState(ClassDetails classDetails, Map<ClassDetails, InheritanceState> inheritanceStatePerClass, MetadataBuildingContext buildingContext) {
        this.setClassDetails(classDetails);
        this.buildingContext = buildingContext;
        this.inheritanceStatePerClass = inheritanceStatePerClass;
        this.extractInheritanceType(classDetails);
    }

    private void extractInheritanceType(ClassDetails classDetails) {
        Inheritance inheritanceAnn = (Inheritance)classDetails.getDirectAnnotationUsage(Inheritance.class);
        MappedSuperclass mappedSuperAnn = (MappedSuperclass)classDetails.getDirectAnnotationUsage(MappedSuperclass.class);
        if (mappedSuperAnn != null) {
            this.setEmbeddableSuperclass(true);
            this.setType(inheritanceAnn == null ? null : inheritanceAnn.strategy());
        } else {
            this.setType(inheritanceAnn == null ? InheritanceType.SINGLE_TABLE : inheritanceAnn.strategy());
        }
    }

    public boolean hasTable() {
        return !this.hasParents() || InheritanceType.SINGLE_TABLE != this.getType();
    }

    public boolean hasDenormalizedTable() {
        return this.hasParents() && InheritanceType.TABLE_PER_CLASS == this.getType();
    }

    public static InheritanceState getInheritanceStateOfSuperEntity(ClassDetails classDetails, Map<ClassDetails, InheritanceState> states) {
        ClassDetails candidate = classDetails;
        do {
            InheritanceState currentState;
            if ((currentState = states.get(candidate = candidate.getSuperClass())) == null || currentState.isEmbeddableSuperclass()) continue;
            return currentState;
        } while (candidate != null && !Object.class.getName().equals(candidate.getName()));
        return null;
    }

    public static InheritanceState getSuperclassInheritanceState(ClassDetails classDetails, Map<ClassDetails, InheritanceState> states) {
        ClassDetails superclass = classDetails;
        do {
            InheritanceState currentState;
            if ((currentState = states.get(superclass = superclass.getSuperClass())) == null) continue;
            return currentState;
        } while (superclass != null && !Object.class.getName().equals(superclass.getName()));
        return null;
    }

    public ClassDetails getClassDetails() {
        return this.classDetails;
    }

    public void setClassDetails(ClassDetails classDetails) {
        this.classDetails = classDetails;
    }

    public boolean hasSiblings() {
        return this.hasSiblings;
    }

    public void setHasSiblings(boolean hasSiblings) {
        this.hasSiblings = hasSiblings;
    }

    public boolean hasParents() {
        return this.hasParents;
    }

    public void setHasParents(boolean hasParents) {
        this.hasParents = hasParents;
    }

    public InheritanceType getType() {
        return this.type;
    }

    public void setType(InheritanceType type) {
        this.type = type;
    }

    public boolean isEmbeddableSuperclass() {
        return this.isEmbeddableSuperclass;
    }

    public void setEmbeddableSuperclass(boolean embeddableSuperclass) {
        this.isEmbeddableSuperclass = embeddableSuperclass;
    }

    public ElementsToProcess postProcess(PersistentClass persistenceClass, EntityBinder entityBinder) {
        this.getElementsToProcess();
        this.addMappedSuperClassInMetadata(persistenceClass);
        entityBinder.setPropertyAccessType(this.accessType);
        return this.elementsToProcess;
    }

    public void postProcess(Component component) {
        if (this.classesToProcessForMappedSuperclass.isEmpty()) {
            this.getMappedSuperclassesTillNextEntityOrdered();
        }
        this.addMappedSuperClassInMetadata(component);
    }

    public ClassDetails getClassWithIdClass(boolean evenIfSubclass) {
        if (!evenIfSubclass && this.hasParents()) {
            return null;
        }
        if (this.classDetails.hasDirectAnnotationUsage(IdClass.class)) {
            return this.classDetails;
        }
        InheritanceState state = InheritanceState.getSuperclassInheritanceState(this.classDetails, this.inheritanceStatePerClass);
        if (state != null) {
            return state.getClassWithIdClass(true);
        }
        return null;
    }

    public Boolean hasIdClassOrEmbeddedId() {
        if (this.hasIdClassOrEmbeddedId == null) {
            this.hasIdClassOrEmbeddedId = false;
            if (this.getClassWithIdClass(true) != null) {
                this.hasIdClassOrEmbeddedId = true;
            } else {
                ElementsToProcess process = this.getElementsToProcess();
                for (PropertyData property : process.getElements()) {
                    if (!property.getAttributeMember().hasDirectAnnotationUsage(EmbeddedId.class)) continue;
                    this.hasIdClassOrEmbeddedId = true;
                    break;
                }
            }
        }
        return this.hasIdClassOrEmbeddedId;
    }

    private ElementsToProcess getElementsToProcess() {
        if (this.elementsToProcess == null) {
            InheritanceState inheritanceState = this.inheritanceStatePerClass.get(this.classDetails);
            assert (!inheritanceState.isEmbeddableSuperclass());
            this.getMappedSuperclassesTillNextEntityOrdered();
            this.accessType = this.determineDefaultAccessType();
            ArrayList<PropertyData> elements = new ArrayList<PropertyData>();
            int idPropertyCount = 0;
            for (ClassDetails classToProcessForMappedSuperclass : this.classesToProcessForMappedSuperclass) {
                PropertyContainer propertyContainer = new PropertyContainer(classToProcessForMappedSuperclass, (TypeVariableScope)this.classDetails, this.accessType);
                idPropertyCount = PropertyBinder.addElementsOfClass(elements, propertyContainer, this.buildingContext, idPropertyCount);
            }
            if (idPropertyCount == 0 && !inheritanceState.hasParents()) {
                throw new AnnotationException("Entity '" + this.classDetails.getName() + "' has no identifier (every '@Entity' class must declare or inherit at least one '@Id' or '@EmbeddedId' property)");
            }
            elements.trimToSize();
            this.elementsToProcess = new ElementsToProcess(elements, idPropertyCount);
        }
        return this.elementsToProcess;
    }

    private AccessType determineDefaultAccessType() {
        ClassDetails candidate;
        for (candidate = this.classDetails; candidate != null; candidate = candidate.getSuperClass()) {
            if (candidate.getSuperClass() != null && !Object.class.getName().equals(candidate.getSuperClass().getName()) || !candidate.hasDirectAnnotationUsage(Entity.class) && !candidate.hasDirectAnnotationUsage(MappedSuperclass.class) || !candidate.hasDirectAnnotationUsage(Access.class)) continue;
            return AccessType.getAccessStrategy(((Access)candidate.getDirectAnnotationUsage(Access.class)).value());
        }
        for (candidate = this.classDetails; candidate != null && !Object.class.getName().equals(candidate.getName()); candidate = candidate.getSuperClass()) {
            if (!candidate.hasDirectAnnotationUsage(Entity.class) && !candidate.hasDirectAnnotationUsage(MappedSuperclass.class)) continue;
            for (MethodDetails method : candidate.getMethods()) {
                if (method.getMethodKind() != MethodDetails.MethodKind.GETTER || !method.hasDirectAnnotationUsage(Id.class) && !method.hasDirectAnnotationUsage(EmbeddedId.class)) continue;
                return AccessType.PROPERTY;
            }
            for (FieldDetails field : candidate.getFields()) {
                if (!field.hasDirectAnnotationUsage(Id.class) && !field.hasDirectAnnotationUsage(EmbeddedId.class)) continue;
                return AccessType.FIELD;
            }
        }
        throw new AnnotationException("Entity '" + this.classDetails.getName() + "' has no identifier (every '@Entity' class must declare or inherit at least one '@Id' or '@EmbeddedId' property)");
    }

    private void getMappedSuperclassesTillNextEntityOrdered() {
        InheritanceState superclassState;
        ClassDetails currentClassInHierarchy = this.classDetails;
        do {
            this.classesToProcessForMappedSuperclass.add(0, currentClassInHierarchy);
            ClassDetails superClass = currentClassInHierarchy;
            do {
                superClass = superClass.getSuperClass();
                superclassState = this.inheritanceStatePerClass.get(superClass);
            } while (superClass != null && !Object.class.getName().equals(superClass.getClassName()) && superclassState == null);
            currentClassInHierarchy = superClass;
        } while (superclassState != null && superclassState.isEmbeddableSuperclass());
    }

    private void addMappedSuperClassInMetadata(Component component) {
        org.hibernate.mapping.MappedSuperclass mappedSuperclass = this.processMappedSuperclass(component.getTable());
        if (mappedSuperclass != null) {
            component.setMappedSuperclass(mappedSuperclass);
        }
    }

    private void addMappedSuperClassInMetadata(PersistentClass persistentClass) {
        org.hibernate.mapping.MappedSuperclass mappedSuperclass = this.processMappedSuperclass(persistentClass.getImplicitTable());
        if (mappedSuperclass != null) {
            persistentClass.setSuperMappedSuperclass(mappedSuperclass);
        }
    }

    private org.hibernate.mapping.MappedSuperclass processMappedSuperclass(Table implicitTable) {
        InheritanceState superEntityState = InheritanceState.getInheritanceStateOfSuperEntity(this.classDetails, this.inheritanceStatePerClass);
        PersistentClass superEntity = superEntityState != null ? this.buildingContext.getMetadataCollector().getEntityBinding(superEntityState.getClassDetails().getName()) : null;
        int lastMappedSuperclass = this.classesToProcessForMappedSuperclass.size() - 1;
        org.hibernate.mapping.MappedSuperclass mappedSuperclass = null;
        for (int index = 0; index < lastMappedSuperclass; ++index) {
            org.hibernate.mapping.MappedSuperclass parentSuperclass = mappedSuperclass;
            ClassDetails mappedSuperclassDetails = this.classesToProcessForMappedSuperclass.get(index);
            Class mappedSuperclassJavaType = mappedSuperclassDetails.toJavaClass();
            mappedSuperclass = this.buildingContext.getMetadataCollector().getMappedSuperclass(mappedSuperclassJavaType);
            if (mappedSuperclass != null) continue;
            mappedSuperclass = new org.hibernate.mapping.MappedSuperclass(parentSuperclass, superEntity, implicitTable);
            mappedSuperclass.setMappedClass(mappedSuperclassJavaType);
            this.buildingContext.getMetadataCollector().addMappedSuperclass(mappedSuperclassJavaType, mappedSuperclass);
        }
        return mappedSuperclass;
    }

    public static final class ElementsToProcess {
        private final List<PropertyData> properties;
        private final int idPropertyCount;

        public List<PropertyData> getElements() {
            return this.properties;
        }

        public int getIdPropertyCount() {
            return this.idPropertyCount;
        }

        private ElementsToProcess(List<PropertyData> properties, int idPropertyCount) {
            this.properties = properties;
            this.idPropertyCount = idPropertyCount;
        }
    }
}

