/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import org.hibernate.annotations.SoftDelete;
import org.hibernate.boot.model.convert.internal.ClassBasedConverterDescriptor;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.naming.PhysicalNamingStrategy;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.SoftDeletable;
import org.hibernate.mapping.Table;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.SoftDeletableModelPart;
import org.hibernate.metamodel.mapping.SoftDeleteMapping;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.metamodel.mapping.internal.SoftDeleteMappingImpl;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.JdbcLiteral;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.update.Assignment;
import org.hibernate.type.descriptor.converter.spi.BasicValueConverter;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;

public class SoftDeleteHelper {
    public static void bindSoftDeleteIndicator(SoftDelete softDeleteConfig, SoftDeletable target, Table table, MetadataBuildingContext context) {
        assert (softDeleteConfig != null);
        BasicValue softDeleteIndicatorValue = SoftDeleteHelper.createSoftDeleteIndicatorValue(softDeleteConfig, table, context);
        Column softDeleteIndicatorColumn = SoftDeleteHelper.createSoftDeleteIndicatorColumn(softDeleteConfig, softDeleteIndicatorValue, context);
        table.addColumn(softDeleteIndicatorColumn);
        target.enableSoftDelete(softDeleteIndicatorColumn);
    }

    private static BasicValue createSoftDeleteIndicatorValue(SoftDelete softDeleteConfig, Table table, MetadataBuildingContext context) {
        ClassBasedConverterDescriptor converterDescriptor = new ClassBasedConverterDescriptor(softDeleteConfig.converter(), context.getBootstrapContext().getClassmateContext());
        BasicValue softDeleteIndicatorValue = new BasicValue(context, table);
        softDeleteIndicatorValue.makeSoftDelete(softDeleteConfig.strategy());
        softDeleteIndicatorValue.setJpaAttributeConverterDescriptor(converterDescriptor);
        softDeleteIndicatorValue.setImplicitJavaTypeAccess(typeConfiguration -> converterDescriptor.getRelationalValueResolvedType().getErasedType());
        return softDeleteIndicatorValue;
    }

    private static Column createSoftDeleteIndicatorColumn(SoftDelete softDeleteConfig, BasicValue softDeleteIndicatorValue, MetadataBuildingContext context) {
        Column softDeleteColumn = new Column();
        SoftDeleteHelper.applyColumnName(softDeleteColumn, softDeleteConfig, context);
        softDeleteColumn.setLength(1);
        softDeleteColumn.setNullable(false);
        softDeleteColumn.setUnique(false);
        softDeleteColumn.setOptions(softDeleteConfig.options());
        if (StringHelper.isBlank(softDeleteConfig.comment())) {
            softDeleteColumn.setComment("Soft-delete indicator");
        } else {
            softDeleteColumn.setComment(softDeleteConfig.comment());
        }
        softDeleteColumn.setValue(softDeleteIndicatorValue);
        softDeleteIndicatorValue.addColumn(softDeleteColumn);
        return softDeleteColumn;
    }

    private static void applyColumnName(Column softDeleteColumn, SoftDelete softDeleteConfig, MetadataBuildingContext context) {
        Database database = context.getMetadataCollector().getDatabase();
        PhysicalNamingStrategy namingStrategy = context.getBuildingOptions().getPhysicalNamingStrategy();
        String logicalColumnName = StringHelper.coalesce(softDeleteConfig.strategy().getDefaultColumnName(), softDeleteConfig.columnName());
        Identifier physicalColumnName = namingStrategy.toPhysicalColumnName(database.toIdentifier(logicalColumnName), database.getJdbcEnvironment());
        softDeleteColumn.setName(physicalColumnName.render(database.getDialect()));
    }

    public static SoftDeleteMappingImpl resolveSoftDeleteMapping(SoftDeletableModelPart softDeletableModelPart, SoftDeletable bootMapping, String tableName, MappingModelCreationProcess creationProcess) {
        return SoftDeleteHelper.resolveSoftDeleteMapping(softDeletableModelPart, bootMapping, tableName, creationProcess.getCreationContext().getDialect());
    }

    public static SoftDeleteMappingImpl resolveSoftDeleteMapping(SoftDeletableModelPart softDeletableModelPart, SoftDeletable bootMapping, String tableName, Dialect dialect) {
        Boolean nonDeletedLiteralValue;
        Boolean deletedLiteralValue;
        Column softDeleteColumn = bootMapping.getSoftDeleteColumn();
        if (softDeleteColumn == null) {
            return null;
        }
        BasicValue columnValue = (BasicValue)softDeleteColumn.getValue();
        BasicValue.Resolution<?> resolution = columnValue.resolve();
        BasicValueConverter<?, ?> converter = resolution.getValueConverter();
        JdbcLiteralFormatter literalFormatter = resolution.getJdbcMapping().getJdbcLiteralFormatter();
        if (converter == null) {
            deletedLiteralValue = true;
            nonDeletedLiteralValue = false;
        } else {
            deletedLiteralValue = converter.toRelationalValue(true);
            nonDeletedLiteralValue = converter.toRelationalValue(false);
        }
        return new SoftDeleteMappingImpl(softDeletableModelPart, softDeleteColumn.getName(), tableName, deletedLiteralValue, literalFormatter.toJdbcLiteral(deletedLiteralValue, dialect, null), nonDeletedLiteralValue, literalFormatter.toJdbcLiteral(nonDeletedLiteralValue, dialect, null), resolution.getJdbcMapping());
    }

    public static Predicate createNonSoftDeletedRestriction(TableReference tableReference, SoftDeleteMapping softDeleteMapping) {
        ColumnReference softDeleteColumn = new ColumnReference(tableReference, (SelectableMapping)softDeleteMapping);
        JdbcLiteral<Object> notDeletedLiteral = new JdbcLiteral<Object>(softDeleteMapping.getNonDeletedLiteralValue(), softDeleteMapping.getJdbcMapping());
        return new ComparisonPredicate(softDeleteColumn, ComparisonOperator.EQUAL, notDeletedLiteral);
    }

    public static Predicate createNonSoftDeletedRestriction(TableReference tableReference, SoftDeleteMapping softDeleteMapping, SqlExpressionResolver expressionResolver) {
        Expression softDeleteColumn = expressionResolver.resolveSqlExpression(tableReference, softDeleteMapping);
        JdbcLiteral<Object> notDeletedLiteral = new JdbcLiteral<Object>(softDeleteMapping.getNonDeletedLiteralValue(), softDeleteMapping.getJdbcMapping());
        return new ComparisonPredicate(softDeleteColumn, ComparisonOperator.EQUAL, notDeletedLiteral);
    }

    public static Assignment createSoftDeleteAssignment(TableReference tableReference, SoftDeleteMapping softDeleteMapping) {
        ColumnReference softDeleteColumn = new ColumnReference(tableReference, (SelectableMapping)softDeleteMapping);
        JdbcLiteral<Object> softDeleteIndicator = new JdbcLiteral<Object>(softDeleteMapping.getDeletedLiteralValue(), softDeleteMapping.getJdbcMapping());
        return new Assignment(softDeleteColumn, softDeleteIndicator);
    }
}

