/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.AccessType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.AnnotationException;
import org.hibernate.boot.jaxb.mapping.spi.JaxbConverterImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityListenerContainerImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityListenerImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityMappingsImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbManagedType;
import org.hibernate.boot.jaxb.mapping.spi.JaxbMappedSuperclassImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbPersistenceUnitDefaultsImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbPersistenceUnitMetadataImpl;
import org.hibernate.boot.model.convert.internal.ClassBasedConverterDescriptor;
import org.hibernate.boot.model.convert.spi.ConverterDescriptor;
import org.hibernate.boot.model.convert.spi.ConverterRegistry;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.ClassLoaderAccess;
import org.hibernate.boot.spi.ClassmateContext;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;

public class XMLContext
implements Serializable {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(XMLContext.class);
    private final ClassLoaderAccess classLoaderAccess;
    private final ClassmateContext classmateContext;
    private Default globalDefaults;
    private final Map<String, JaxbManagedType> managedTypeOverride = new HashMap<String, JaxbManagedType>();
    private final Map<String, JaxbEntityListenerImpl> entityListenerOverride = new HashMap<String, JaxbEntityListenerImpl>();
    private final Map<String, Default> defaultsOverride = new HashMap<String, Default>();
    private final List<JaxbEntityMappingsImpl> defaultElements = new ArrayList<JaxbEntityMappingsImpl>();
    private final List<String> defaultEntityListeners = new ArrayList<String>();
    private boolean hasContext = false;
    private final List<ConverterDescriptor> converterDescriptors = new ArrayList<ConverterDescriptor>();

    public XMLContext(BootstrapContext bootstrapContext) {
        this(bootstrapContext.getClassLoaderAccess(), bootstrapContext.getClassmateContext());
    }

    public XMLContext(ClassLoaderAccess classLoaderAccess, ClassmateContext classmateContext) {
        this.classLoaderAccess = classLoaderAccess;
        this.classmateContext = classmateContext;
    }

    public List<String> addDocument(JaxbEntityMappingsImpl entityMappings) {
        this.hasContext = true;
        ArrayList<String> addedClasses = new ArrayList<String>();
        JaxbPersistenceUnitMetadataImpl metadata = entityMappings.getPersistenceUnitMetadata();
        if (metadata != null) {
            if (this.globalDefaults == null) {
                this.globalDefaults = new Default();
                this.globalDefaults.setMetadataComplete(metadata.getXmlMappingMetadataComplete() != null ? Boolean.TRUE : null);
                JaxbPersistenceUnitDefaultsImpl defaultElement = metadata.getPersistenceUnitDefaults();
                if (defaultElement != null) {
                    this.globalDefaults.setSchema(defaultElement.getSchema());
                    this.globalDefaults.setCatalog(defaultElement.getCatalog());
                    this.globalDefaults.setAccess(defaultElement.getAccess());
                    this.globalDefaults.setCascadePersist(defaultElement.getCascadePersist() != null ? Boolean.TRUE : null);
                    this.globalDefaults.setDelimitedIdentifiers(defaultElement.getDelimitedIdentifiers() != null ? Boolean.TRUE : null);
                    this.defaultEntityListeners.addAll(this.addEntityListenerClasses(defaultElement.getEntityListenerContainer(), null, addedClasses));
                }
            } else {
                LOG.duplicateMetadata();
            }
        }
        Default entityMappingDefault = new Default();
        String packageName = entityMappings.getPackage();
        entityMappingDefault.setPackageName(packageName);
        entityMappingDefault.setSchema(entityMappings.getSchema());
        entityMappingDefault.setCatalog(entityMappings.getCatalog());
        entityMappingDefault.setAccess(entityMappings.getAccess());
        this.defaultElements.add(entityMappings);
        this.setLocalAttributeConverterDefinitions(entityMappings.getConverters(), packageName);
        this.addClass(entityMappings.getEntities(), packageName, entityMappingDefault, addedClasses);
        this.addClass(entityMappings.getMappedSuperclasses(), packageName, entityMappingDefault, addedClasses);
        this.addClass(entityMappings.getEmbeddables(), packageName, entityMappingDefault, addedClasses);
        return addedClasses;
    }

    private void addClass(List<? extends JaxbManagedType> managedTypes, String packageName, Default defaults, List<String> addedClasses) {
        for (JaxbManagedType jaxbManagedType : managedTypes) {
            String className = XMLContext.buildSafeClassName(jaxbManagedType.getClazz(), packageName);
            if (this.managedTypeOverride.containsKey(className)) {
                throw new IllegalStateException("Duplicate XML entry for " + className);
            }
            addedClasses.add(className);
            this.managedTypeOverride.put(className, jaxbManagedType);
            Default mergedDefaults = new Default();
            mergedDefaults.overrideWithCatalogAndSchema(defaults);
            Default fileDefaults = new Default();
            fileDefaults.setMetadataComplete(jaxbManagedType.isMetadataComplete());
            fileDefaults.setAccess(jaxbManagedType.getAccess());
            mergedDefaults.overrideWithCatalogAndSchema(fileDefaults);
            this.defaultsOverride.put(className, mergedDefaults);
            LOG.debugf("Adding XML overriding information for %s", className);
            if (jaxbManagedType instanceof JaxbEntityImpl) {
                this.addEntityListenerClasses(((JaxbEntityImpl)jaxbManagedType).getEntityListenerContainer(), packageName, addedClasses);
                continue;
            }
            if (!(jaxbManagedType instanceof JaxbMappedSuperclassImpl)) continue;
            this.addEntityListenerClasses(((JaxbMappedSuperclassImpl)jaxbManagedType).getEntityListenerContainer(), packageName, addedClasses);
        }
    }

    private List<String> addEntityListenerClasses(JaxbEntityListenerContainerImpl listeners, String packageName, List<String> addedClasses) {
        ArrayList<String> localAddedClasses = new ArrayList<String>();
        if (listeners != null) {
            List<JaxbEntityListenerImpl> elements = listeners.getEntityListeners();
            for (JaxbEntityListenerImpl listener : elements) {
                String listenerClassName = XMLContext.buildSafeClassName(listener.getClazz(), packageName);
                if (this.entityListenerOverride.containsKey(listenerClassName)) {
                    LOG.duplicateListener(listenerClassName);
                    continue;
                }
                localAddedClasses.add(listenerClassName);
                this.entityListenerOverride.put(listenerClassName, listener);
            }
        }
        LOG.debugf("Adding XML overriding information for listeners: %s", localAddedClasses);
        addedClasses.addAll(localAddedClasses);
        return localAddedClasses;
    }

    private void setLocalAttributeConverterDefinitions(List<JaxbConverterImpl> converterElements, String packageName) {
        for (JaxbConverterImpl converterElement : converterElements) {
            String className = converterElement.getClazz();
            boolean autoApply = Boolean.TRUE.equals(converterElement.isAutoApply());
            try {
                Class attributeConverterClass = this.classLoaderAccess.classForName(XMLContext.buildSafeClassName(className, packageName));
                this.converterDescriptors.add(new ClassBasedConverterDescriptor(attributeConverterClass, autoApply, this.classmateContext));
            }
            catch (ClassLoadingException e) {
                throw new AnnotationException("Unable to locate specified AttributeConverter implementation class : " + className, (Throwable)((Object)e));
            }
            catch (Exception e) {
                throw new AnnotationException("Unable to instantiate specified AttributeConverter implementation class : " + className, e);
            }
        }
    }

    public static String buildSafeClassName(String className, String defaultPackageName) {
        return className.indexOf(46) < 0 && StringHelper.isNotEmpty(defaultPackageName) ? StringHelper.qualify(defaultPackageName, className) : className;
    }

    public static String buildSafeClassName(String className, Default defaults) {
        return XMLContext.buildSafeClassName(className, defaults.getPackageName());
    }

    public Default getDefaultWithoutGlobalCatalogAndSchema(String className) {
        Default xmlDefault = new Default();
        xmlDefault.overrideWithoutCatalogAndSchema(this.globalDefaults);
        if (className != null) {
            Default entityMappingOverriding = this.defaultsOverride.get(className);
            xmlDefault.overrideWithCatalogAndSchema(entityMappingOverriding);
        }
        return xmlDefault;
    }

    public Default getDefaultWithGlobalCatalogAndSchema() {
        Default xmlDefault = new Default();
        xmlDefault.overrideWithCatalogAndSchema(this.globalDefaults);
        return xmlDefault;
    }

    public JaxbManagedType getManagedTypeOverride(String className) {
        return this.managedTypeOverride.get(className);
    }

    public JaxbEntityListenerImpl getEntityListenerOverride(String className) {
        return this.entityListenerOverride.get(className);
    }

    public List<JaxbEntityMappingsImpl> getAllDocuments() {
        return this.defaultElements;
    }

    public boolean hasContext() {
        return this.hasContext;
    }

    public void applyDiscoveredAttributeConverters(ConverterRegistry converterRegistry) {
        for (ConverterDescriptor descriptor : this.converterDescriptors) {
            converterRegistry.addAttributeConverter(descriptor);
        }
        this.converterDescriptors.clear();
    }

    public List<String> getDefaultEntityListeners() {
        return this.defaultEntityListeners;
    }

    public static class Default
    implements Serializable {
        private AccessType access;
        private String packageName;
        private String schema;
        private String catalog;
        private Boolean metadataComplete;
        private Boolean cascadePersist;
        private Boolean delimitedIdentifier;

        public AccessType getAccess() {
            return this.access;
        }

        protected void setAccess(AccessType access) {
            this.access = access;
        }

        public String getCatalog() {
            return this.catalog;
        }

        protected void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        public String getPackageName() {
            return this.packageName;
        }

        protected void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        public String getSchema() {
            return this.schema;
        }

        protected void setSchema(String schema) {
            this.schema = schema;
        }

        public Boolean getMetadataComplete() {
            return this.metadataComplete;
        }

        public boolean canUseJavaAnnotations() {
            return this.metadataComplete == null || this.metadataComplete == false;
        }

        protected void setMetadataComplete(Boolean metadataComplete) {
            this.metadataComplete = metadataComplete;
        }

        public Boolean getCascadePersist() {
            return this.cascadePersist;
        }

        void setCascadePersist(Boolean cascadePersist) {
            this.cascadePersist = cascadePersist;
        }

        public void overrideWithCatalogAndSchema(Default override) {
            this.overrideWithoutCatalogAndSchema(override);
            if (override != null) {
                if (override.getSchema() != null) {
                    this.schema = override.getSchema();
                }
                if (override.getCatalog() != null) {
                    this.catalog = override.getCatalog();
                }
            }
        }

        public void overrideWithoutCatalogAndSchema(Default globalDefault) {
            if (globalDefault != null) {
                if (globalDefault.getAccess() != null) {
                    this.access = globalDefault.getAccess();
                }
                if (globalDefault.getPackageName() != null) {
                    this.packageName = globalDefault.getPackageName();
                }
                if (globalDefault.getDelimitedIdentifier() != null) {
                    this.delimitedIdentifier = globalDefault.getDelimitedIdentifier();
                }
                if (globalDefault.getMetadataComplete() != null) {
                    this.metadataComplete = globalDefault.getMetadataComplete();
                }
                if (globalDefault.getCascadePersist() != null) {
                    this.cascadePersist = globalDefault.getCascadePersist();
                }
            }
        }

        public void setDelimitedIdentifiers(Boolean delimitedIdentifier) {
            this.delimitedIdentifier = delimitedIdentifier;
        }

        public Boolean getDelimitedIdentifier() {
            return this.delimitedIdentifier;
        }
    }
}

