/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.process.internal;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.type.descriptor.converter.spi.BasicValueConverter;
import org.hibernate.type.descriptor.java.EnumJavaType;
import org.hibernate.type.descriptor.java.JavaType;

public class EnumeratedValueConverter<E extends Enum<E>, R>
implements BasicValueConverter<E, R> {
    private final EnumJavaType<E> enumJavaType;
    private final JavaType<R> relationalJavaType;
    private final Map<R, E> relationalToEnumMap;
    private final Map<E, R> enumToRelationalMap;

    public EnumeratedValueConverter(EnumJavaType<E> enumJavaType, JavaType<R> relationalJavaType, Field valueField) {
        this.enumJavaType = enumJavaType;
        this.relationalJavaType = relationalJavaType;
        ReflectHelper.ensureAccessibility(valueField);
        Class enumJavaTypeClass = enumJavaType.getJavaTypeClass();
        Enum[] enumConstants = (Enum[])enumJavaTypeClass.getEnumConstants();
        this.relationalToEnumMap = CollectionHelper.mapOfSize(enumConstants.length);
        this.enumToRelationalMap = CollectionHelper.mapOfSize(enumConstants.length);
        for (int i = 0; i < enumConstants.length; ++i) {
            Enum enumConstant = enumConstants[i];
            try {
                Object relationalValue = valueField.get(enumConstant);
                this.relationalToEnumMap.put(relationalValue, enumConstant);
                this.enumToRelationalMap.put(enumConstant, relationalValue);
                continue;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public Set<R> getRelationalValueSet() {
        return this.relationalToEnumMap.keySet();
    }

    @Override
    public @Nullable E toDomainValue(@Nullable R relationalForm) {
        if (relationalForm == null) {
            return null;
        }
        return (E)((Enum)this.relationalToEnumMap.get(relationalForm));
    }

    @Override
    public @Nullable R toRelationalValue(@Nullable E domainForm) {
        if (domainForm == null) {
            return null;
        }
        return this.enumToRelationalMap.get(domainForm);
    }

    @Override
    public JavaType<E> getDomainJavaType() {
        return this.enumJavaType;
    }

    @Override
    public JavaType<R> getRelationalJavaType() {
        return this.relationalJavaType;
    }
}

