/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.source.spi;

import org.hibernate.boot.CacheRegionDefinition;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.internal.util.StringHelper;

public class Caching {
    private Boolean requested;
    private String region;
    private AccessType accessType;
    private boolean cacheLazyProperties;

    public Caching() {
    }

    public Caching(String region, AccessType accessType, boolean cacheLazyProperties) {
        this.region = region;
        this.accessType = accessType;
        this.cacheLazyProperties = cacheLazyProperties;
    }

    public Caching(String region, AccessType accessType, boolean cacheLazyProperties, boolean requested) {
        this.requested = requested;
        this.region = region;
        this.accessType = accessType;
        this.cacheLazyProperties = cacheLazyProperties;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public AccessType getAccessType() {
        return this.accessType;
    }

    public void setAccessType(AccessType accessType) {
        this.accessType = accessType;
    }

    public boolean isCacheLazyProperties() {
        return this.cacheLazyProperties;
    }

    public void setCacheLazyProperties(boolean cacheLazyProperties) {
        this.cacheLazyProperties = cacheLazyProperties;
    }

    public boolean isRequested() {
        return this.requested == Boolean.TRUE;
    }

    public boolean isRequested(boolean defaultValue) {
        return this.requested == null ? defaultValue : this.isRequested();
    }

    public void setRequested(boolean requested) {
        this.requested = requested;
    }

    public void overlay(CacheRegionDefinition overrides) {
        if (overrides != null) {
            this.requested = true;
            this.accessType = AccessType.fromExternalName(overrides.getUsage());
            if (StringHelper.isEmpty(overrides.getRegion())) {
                this.region = overrides.getRegion();
            }
            this.cacheLazyProperties = overrides.isCacheLazy();
        }
    }

    public void overlay(Caching overrides) {
        if (overrides != null) {
            this.requested = overrides.requested;
            this.accessType = overrides.accessType;
            this.region = overrides.region;
            this.cacheLazyProperties = overrides.cacheLazyProperties;
        }
    }

    public String toString() {
        return "Caching{region='" + this.region + "', accessType=" + this.accessType + ", cacheLazyProperties=" + this.cacheLazyProperties + ", requested=" + this.requested + "}";
    }
}

