/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import jakarta.persistence.JoinColumn;
import java.lang.annotation.Annotation;
import java.util.Map;
import org.hibernate.annotations.JoinColumnOrFormula;
import org.hibernate.annotations.JoinFormula;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.models.spi.SourceModelBuildingContext;

public class JoinColumnOrFormulaAnnotation
implements JoinColumnOrFormula {
    private JoinFormula formula;
    private JoinColumn column;

    public JoinColumnOrFormulaAnnotation(SourceModelBuildingContext modelContext) {
        this.formula = (JoinFormula)HibernateAnnotations.JOIN_FORMULA.createUsage(modelContext);
        this.column = (JoinColumn)JpaAnnotations.JOIN_COLUMN.createUsage(modelContext);
    }

    public JoinColumnOrFormulaAnnotation(JoinColumnOrFormula annotation, SourceModelBuildingContext modelContext) {
        this.formula = (JoinFormula)OrmAnnotationHelper.extractJdkValue(annotation, HibernateAnnotations.JOIN_COLUMN_OR_FORMULA, "formula", modelContext);
        this.column = (JoinColumn)OrmAnnotationHelper.extractJdkValue(annotation, HibernateAnnotations.JOIN_COLUMN_OR_FORMULA, "column", modelContext);
    }

    public JoinColumnOrFormulaAnnotation(Map<String, Object> attributeValues, SourceModelBuildingContext modelContext) {
        this.formula = (JoinFormula)attributeValues.get("formula");
        this.column = (JoinColumn)attributeValues.get("column");
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return JoinColumnOrFormula.class;
    }

    @Override
    public JoinFormula formula() {
        return this.formula;
    }

    public void formula(JoinFormula value) {
        this.formula = value;
    }

    @Override
    public JoinColumn column() {
        return this.column;
    }

    public void column(JoinColumn value) {
        this.column = value;
    }
}

